/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.filepreview.start.util;

import com.jxdinfo.filepreview.start.enums.AcceptFileType;
import com.jxdinfo.filepreview.start.util.LibreOfficePDFConvert;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.jodconverter.office.OfficeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public class ResponseFileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseFileUtil.class);
    public static final String TEMP_FILE_DIR = "/temp";
    public static final String TEMP_FILE_PREFIX = "/temp.";
    public static final String FILE_LENGTH_HEADER = "Content-Length";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String REGEX_FILETYPE = "\\.[a-zA-Z]*$";
    public static final String PDF_FILETYPE = ".pdf";
    private static final long cacheTime = 604800000L;
    private static MessageDigest mMessageDigest = null;

    public static void transferResponse(ClientHttpResponse clientHttpResponse, HttpServletResponse response) {
        try {
            StreamUtils.copy((InputStream)Objects.requireNonNull(clientHttpResponse.getBody()), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                clientHttpResponse.getBody().close();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static void transferOrConvertResponse(ClientHttpResponse clientHttpResponse, HttpServletResponse response, AcceptFileType acceptFileType) {
        if (!acceptFileType.getConvertFlag().booleanValue()) {
            ResponseFileUtil.transferResponse(clientHttpResponse, response);
            return;
        }
        FileOutputStream outtemp = null;
        String dirFilePaths = System.getProperty("user.dir") + TEMP_FILE_DIR + File.separator + UUID.randomUUID();
        File dirFiletemp = new File(dirFilePaths);
        if (!dirFiletemp.exists() && dirFiletemp.mkdirs()) {
            LOGGER.info("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5939\u6210\u529f");
        }
        File filetemp = new File(dirFiletemp + TEMP_FILE_PREFIX + acceptFileType.getType());
        try {
            outtemp = new FileOutputStream(filetemp);
            StreamUtils.copy((InputStream)clientHttpResponse.getBody(), (OutputStream)outtemp);
        }
        catch (IOException e) {
            LOGGER.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (outtemp != null) {
                    outtemp.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
        String md5 = ResponseFileUtil.getFileMD5String(filetemp);
        String dirFilePath = System.getProperty("user.dir") + TEMP_FILE_DIR + File.separator + md5;
        File dirFile = new File(dirFilePath);
        if (dirFile.exists()) {
            File result = new File(dirFilePath + TEMP_FILE_PREFIX + AcceptFileType.PDF.getType());
            FileInputStream inresult = null;
            try {
                LOGGER.info("\u8f6c\u6362\u540e\u7684\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)result.getPath());
                response.setContentType("application/pdf");
                if (response.getHeader(CONTENT_DISPOSITION) != null) {
                    response.setHeader(CONTENT_DISPOSITION, response.getHeader(CONTENT_DISPOSITION).replaceAll(REGEX_FILETYPE, PDF_FILETYPE));
                }
                response.setHeader(FILE_LENGTH_HEADER, String.valueOf(result.length()));
                inresult = new FileInputStream(result);
                StreamUtils.copy((InputStream)inresult, (OutputStream)response.getOutputStream());
                return;
            }
            catch (IOException e) {
                LOGGER.error("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (inresult != null) {
                        inresult.close();
                    }
                    clientHttpResponse.getBody().close();
                    if (response.getOutputStream() != null) {
                        response.getOutputStream().close();
                    }
                    LOGGER.info("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5939");
                    FileUtils.deleteDirectory((File)dirFiletemp);
                }
                catch (IOException e) {
                    LOGGER.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
        }
        if (!dirFile.exists() && dirFile.mkdirs()) {
            LOGGER.info("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5939\u6210\u529f");
        }
        File pdfFile = new File(dirFilePath + TEMP_FILE_PREFIX + AcceptFileType.PDF.getType());
        FileInputStream in = null;
        try {
            String path = LibreOfficePDFConvert.doDocToFdpLibre(filetemp, pdfFile);
            LOGGER.info("\u8f6c\u6362\u540e\u7684\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)path);
            response.setContentType("application/pdf");
            if (response.getHeader(CONTENT_DISPOSITION) != null) {
                response.setHeader(CONTENT_DISPOSITION, response.getHeader(CONTENT_DISPOSITION).replaceAll(REGEX_FILETYPE, PDF_FILETYPE));
            }
            response.setHeader(FILE_LENGTH_HEADER, String.valueOf(pdfFile.length()));
            in = new FileInputStream(path);
            StreamUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
        }
        catch (IOException | OfficeException e) {
            LOGGER.error("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25", e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                clientHttpResponse.getBody().close();
                if (response.getOutputStream() != null) {
                    response.getOutputStream().close();
                }
                LOGGER.info("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5939");
                FileUtils.deleteDirectory((File)dirFiletemp);
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static String getFileMD5String(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int length = -1;
            while ((length = ((InputStream)fis).read(buffer, 0, 1024)) > 0) {
                mMessageDigest.update(buffer, 0, length);
            }
            ((InputStream)fis).close();
            return new BigInteger(1, mMessageDigest.digest()).toString(16);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void deleteCache() {
        String path = System.getProperty("user.dir") + TEMP_FILE_DIR;
        File file = new File(path);
        long tiemmillis = System.currentTimeMillis() - 604800000L;
        for (File f : file.listFiles()) {
            if (!file.isDirectory()) continue;
            try {
                Path filePath = file.toPath();
                BasicFileAttributes attributes = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                if (attributes.creationTime().toMillis() >= tiemmillis) continue;
                Files.delete(filePath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        try {
            mMessageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

