/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.filepreview.start.util;

import com.jxdinfo.filepreview.start.util.SpringContextUtil;
import java.io.File;
import java.util.regex.Pattern;
import org.jodconverter.OfficeDocumentConverter;
import org.jodconverter.office.DefaultOfficeManagerBuilder;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class LibreOfficePDFConvert {
    private static ApplicationContext appCtx = SpringContextUtil.getApplicationContext();
    private static final Logger logger = LoggerFactory.getLogger(LibreOfficePDFConvert.class);
    private static String officeHomeDir = null;
    private static Environment environment = (Environment)appCtx.getBean(Environment.class);

    public static synchronized String doDocToFdpLibre(File sourceFile, File tarPdfFile) throws OfficeException {
        File inputFile = sourceFile;
        officeHomeDir = environment.getProperty("docbase.officeHomeDir");
        String libreOfficePath = LibreOfficePDFConvert.getOfficeHome();
        DefaultOfficeManagerBuilder builder = new DefaultOfficeManagerBuilder();
        builder.setOfficeHome(new File(libreOfficePath));
        builder.setPortNumbers(new int[]{8100});
        builder.setTaskExecutionTimeout(3000000L);
        builder.setTaskQueueTimeout(864000000L);
        OfficeManager officeManager = builder.build();
        File outputFile = null;
        try {
            LibreOfficePDFConvert.startService(officeManager);
            OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
            outputFile = tarPdfFile;
            converter.convert(inputFile, outputFile);
            LibreOfficePDFConvert.stopService(officeManager);
        }
        catch (Exception e) {
            if (officeManager.isRunning()) {
                LibreOfficePDFConvert.stopService(officeManager);
            }
            logger.error("office\u8f6c\u6362\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f:{}", (Throwable)e);
        }
        String pdfPath = outputFile.getPath();
        return pdfPath;
    }

    private static String getOfficeHome() {
        if (null != officeHomeDir) {
            return officeHomeDir;
        }
        String osName = System.getProperty("os.name");
        if (Pattern.matches("Windows.*", osName)) {
            officeHomeDir = "C:\\Program Files\\LibreOffice";
            return officeHomeDir;
        }
        if (Pattern.matches("Linux.*", osName)) {
            officeHomeDir = "/opt/libreoffice6.0";
            return officeHomeDir;
        }
        if (Pattern.matches("Mac.*", osName)) {
            officeHomeDir = "/Application/openOfficeSoft";
            return officeHomeDir;
        }
        return null;
    }

    private static void stopService(OfficeManager officeManager) throws OfficeException {
        if (null != officeManager) {
            officeManager.stop();
        }
        logger.info("\u5173\u95edoffice\u8f6c\u6362\u6210\u529f!");
    }

    private static void startService(OfficeManager officeManager) {
        try {
            officeManager.start();
            logger.info("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u6210\u529f");
        }
        catch (Exception ce) {
            logger.error("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f:{}", (Throwable)ce);
        }
    }

    public static void setOfficeHome(String officeHome) {
        officeHomeDir = officeHome;
    }
}

