/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.filepreview.start.enums;

import org.springframework.http.ContentDisposition;

public enum AcceptFileType {
    DOC("application/msword", "doc", true),
    DOCX("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx", true),
    XLS("application/vnd.ms-excel", "xls", false),
    XLSX("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx", false),
    PPT("application/vnd.ms-powerpoint", "ppt", true),
    PPTX("application/vnd.openxmlformats-officedocument.presentationml.presentation", "pptx", true),
    PDF("application/pdf", "pdf", false);

    private final String contentType;
    private final String type;
    private final Boolean convertFlag;

    public String getContentType() {
        return this.contentType;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getConvertFlag() {
        return this.convertFlag;
    }

    private AcceptFileType(String contentType, String type, Boolean convertFlag) {
        this.contentType = contentType;
        this.type = type;
        this.convertFlag = convertFlag;
    }

    public static AcceptFileType getAcceptFileType(String contentType, ContentDisposition contentDisposition) {
        String fileName;
        AcceptFileType result = null;
        for (AcceptFileType acceptFileType : AcceptFileType.values()) {
            if (!acceptFileType.getContentType().equals(contentType)) continue;
            result = acceptFileType;
            break;
        }
        if (result == null && contentDisposition != null && (fileName = contentDisposition.getFilename()) != null) {
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            for (AcceptFileType acceptFileType : AcceptFileType.values()) {
                if (!acceptFileType.getType().equalsIgnoreCase(suffix)) continue;
                result = acceptFileType;
                break;
            }
        }
        return result;
    }
}

