/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.oscar.util;

import com.jxdinfo.engine.metadata.enums.ConnectEnum;
import com.jxdinfo.engine.metadata.enums.SqlConnectEnum;
import com.jxdinfo.engine.metadata.model.InputColumnVO;
import com.jxdinfo.engine.metadata.util.StringUtils;
import com.jxdinfo.engine.oscar.util.OscarQueryConditionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class OscarQuerySingleConditionUtil {
    private static Logger logger = LoggerFactory.getLogger(OscarQueryConditionUtil.class);

    public static String renderQueryCon(List<InputColumnVO> queryConditionFieldBases, boolean flow, String lastConnect, Map<String, Object> params, String childConnectFlag) {
        if (CollectionUtils.isEmpty(params)) {
            return "";
        }
        if (CollectionUtils.isEmpty(queryConditionFieldBases)) {
            return "";
        }
        StringBuilder whereResult = new StringBuilder(128);
        if (!flow) {
            whereResult.append("WHERE ");
        } else {
            whereResult.append("(");
        }
        for (InputColumnVO queryConditionFieldBase : queryConditionFieldBases) {
            if (ConnectEnum._ROW.getType().equals(queryConditionFieldBase.getType())) {
                String columnName = queryConditionFieldBase.getColumnName();
                String queryAttrName = queryConditionFieldBase.getColumnAliasDefined();
                String columnType = queryConditionFieldBase.getInColumnType();
                String symbol = queryConditionFieldBase.getWhereFlag();
                lastConnect = queryConditionFieldBase.getInConnectFlag();
                if (!params.containsKey(queryAttrName) || !Objects.nonNull(params.get(queryAttrName)) || "".equals(params.get(queryAttrName).toString().trim())) continue;
                if (SqlConnectEnum._LEFT_LIKE.getKey().equalsIgnoreCase(symbol) || SqlConnectEnum._RIGHT_LIKE.getKey().equalsIgnoreCase(symbol) || SqlConnectEnum._FULL_LIKE.getKey().equalsIgnoreCase(symbol)) {
                    if (symbol.toUpperCase().contains("LEFT")) {
                        whereResult.append("\"").append(columnName).append("\" ").append("LIKE CONCAT ('%',#{").append(queryAttrName).append("})").append(" ").append(lastConnect.toUpperCase()).append(" ");
                        continue;
                    }
                    if (symbol.toUpperCase().contains("RIGHT")) {
                        whereResult.append("\"").append(columnName).append("\" ").append("LIKE CONCAT (#{").append(queryAttrName).append("},'%')").append(" ").append(lastConnect.toUpperCase()).append(" ");
                        continue;
                    }
                    whereResult.append("\"").append(columnName).append("\" ").append("LIKE CONCAT ('%',#{").append(queryAttrName).append("},'%')").append(" ").append(lastConnect.toUpperCase()).append(" ");
                    continue;
                }
                if (SqlConnectEnum._EQUAL.getKey().equalsIgnoreCase(symbol) || SqlConnectEnum._GREAT_THAN.getKey().equalsIgnoreCase(symbol) || SqlConnectEnum._LESS_THAN.getKey().equalsIgnoreCase(symbol) || SqlConnectEnum._GREAT_AND_THAN.getKey().equalsIgnoreCase(symbol) || SqlConnectEnum._LESS_AND_THAN.getKey().equalsIgnoreCase(symbol) || SqlConnectEnum._NOT_EQUAL.getKey().equalsIgnoreCase(symbol)) {
                    whereResult.append("\"").append(columnName).append("\"").append(" ").append(symbol.toUpperCase()).append(" #{").append(queryAttrName).append("}").append(" ").append(lastConnect.toUpperCase()).append(" ");
                    continue;
                }
                whereResult.append("\"").append(columnName).append("\"").append(" ").append(symbol.toUpperCase()).append(" (#{foreach_").append(queryAttrName).append("})").append(" ").append(lastConnect.toUpperCase()).append(" ");
                continue;
            }
            if (!ConnectEnum._CHILD.getType().equals(queryConditionFieldBase.getType())) continue;
            childConnectFlag = queryConditionFieldBase.getInConnectFlag();
            List children = queryConditionFieldBase.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            whereResult.append(OscarQuerySingleConditionUtil.renderQueryCon(children, true, lastConnect, params, childConnectFlag));
        }
        if (!flow) {
            whereResult.append("WHERE");
        } else if (StringUtils.isEmpty((String)childConnectFlag)) {
            whereResult.append(")");
        } else {
            whereResult.append(")").append(" ").append(childConnectFlag.toUpperCase()).append(" ");
        }
        return whereResult.toString();
    }

    public static String cleanEmptyBrackets(String wheresql) {
        String wheresqlresult = wheresql;
        if (wheresql.contains("()")) {
            wheresqlresult = wheresql.replace("() ", "");
            wheresqlresult = OscarQuerySingleConditionUtil.cleanEmptyBrackets(wheresqlresult);
        }
        return wheresqlresult;
    }

    public static String cleanNoAvailConnect(String whereSql) {
        String whereSqlResult = whereSql;
        if (whereSql.toLowerCase().contains(ConnectEnum._ANDNO.getType())) {
            whereSqlResult = whereSql.replace(ConnectEnum._ANDNO.getType().toUpperCase(), ")");
            whereSqlResult = OscarQuerySingleConditionUtil.cleanNoAvailConnect(whereSqlResult);
        }
        if (whereSql.toLowerCase().contains(ConnectEnum._ORNO.getType())) {
            whereSqlResult = whereSqlResult.replace(ConnectEnum._ORNO.getType().toUpperCase(), ")");
            whereSqlResult = OscarQuerySingleConditionUtil.cleanNoAvailConnect(whereSqlResult);
        }
        if (whereSql.toLowerCase().contains(ConnectEnum._ANDAND.getType())) {
            whereSqlResult = whereSql.replace(ConnectEnum._ANDAND.getType().toUpperCase(), "AND");
            whereSqlResult = OscarQuerySingleConditionUtil.cleanNoAvailConnect(whereSqlResult);
        }
        if (whereSql.toLowerCase().contains(ConnectEnum._ANDOR.getType())) {
            whereSqlResult = whereSqlResult.replace(ConnectEnum._ANDOR.getType().toUpperCase(), "OR");
            whereSqlResult = OscarQuerySingleConditionUtil.cleanNoAvailConnect(whereSqlResult);
        }
        if (whereSql.toLowerCase().contains(ConnectEnum._OROR.getType())) {
            whereSqlResult = whereSqlResult.replace(ConnectEnum._OROR.getType().toUpperCase(), "OR");
            whereSqlResult = OscarQuerySingleConditionUtil.cleanNoAvailConnect(whereSqlResult);
        }
        if (whereSql.toLowerCase().contains(ConnectEnum._ORAND.getType())) {
            whereSqlResult = whereSqlResult.replace(ConnectEnum._ORAND.getType().toUpperCase(), "AND");
            whereSqlResult = OscarQuerySingleConditionUtil.cleanNoAvailConnect(whereSqlResult);
        }
        if (whereSql.toLowerCase().contains(ConnectEnum._WHEREAND.getType())) {
            whereSqlResult = whereSqlResult.replace(ConnectEnum._WHEREAND.getType().toUpperCase(), "WHERE");
            whereSqlResult = OscarQuerySingleConditionUtil.cleanNoAvailConnect(whereSqlResult);
        }
        if (whereSql.toLowerCase().contains(ConnectEnum._WHEREOR.getType())) {
            whereSqlResult = whereSqlResult.replace(ConnectEnum._WHEREOR.getType().toUpperCase(), "WHERE");
            whereSqlResult = OscarQuerySingleConditionUtil.cleanNoAvailConnect(whereSqlResult);
        }
        if (whereSql.toLowerCase().contains(ConnectEnum._SIGNAND.getType())) {
            whereSqlResult = whereSqlResult.replace(ConnectEnum._SIGNAND.getType().toUpperCase(), "(");
            whereSqlResult = OscarQuerySingleConditionUtil.cleanNoAvailConnect(whereSqlResult);
        }
        if (whereSql.toLowerCase().contains(ConnectEnum._SIGNOR.getType())) {
            whereSqlResult = whereSqlResult.replace(ConnectEnum._SIGNOR.getType().toUpperCase(), "(");
            whereSqlResult = OscarQuerySingleConditionUtil.cleanNoAvailConnect(whereSqlResult);
        }
        return whereSqlResult;
    }

    public static String dynamicWhereSql(List<InputColumnVO> queryConditionFieldBases, Map<String, Object> params) {
        String childConnectFlag = null;
        String sqlStr = OscarQuerySingleConditionUtil.renderQueryCon(queryConditionFieldBases, false, "", params, childConnectFlag);
        if (StringUtils.isEmpty((String)sqlStr) || sqlStr.length() <= 5) {
            return "";
        }
        String resultSql = sqlStr.substring(0, sqlStr.length() - 5);
        String sql = OscarQuerySingleConditionUtil.cleanSql(resultSql);
        if (StringUtils.isEmpty((String)sql.split("WHERE")[1].trim())) {
            return "";
        }
        return sql;
    }

    public static String cleanSql(String sql) {
        String andEnd;
        String resultSql1 = OscarQuerySingleConditionUtil.cleanEmptyBrackets(sql);
        String resultSql2 = OscarQuerySingleConditionUtil.cleanNoAvailConnect(resultSql1);
        String orEnd = resultSql2.substring(resultSql2.length() - 3, resultSql2.length());
        if (orEnd.toLowerCase().equals(ConnectEnum._OR.getType())) {
            resultSql2 = resultSql2.substring(0, resultSql2.length() - 3);
        }
        if ((andEnd = resultSql2.substring(resultSql2.length() - 4, resultSql2.length())).toLowerCase().equals(ConnectEnum._AND.getType())) {
            resultSql2 = resultSql2.substring(0, resultSql2.length() - 4);
        }
        orEnd = resultSql2.substring(resultSql2.length() - 3, resultSql2.length());
        andEnd = resultSql2.substring(resultSql2.length() - 4, resultSql2.length());
        if (resultSql2.toLowerCase().contains(ConnectEnum._ANDNO.getType()) || resultSql2.toLowerCase().contains(ConnectEnum._ORNO.getType()) || resultSql2.toLowerCase().contains(ConnectEnum._ANDAND.getType()) || resultSql2.toLowerCase().contains(ConnectEnum._ANDOR.getType()) || resultSql2.toLowerCase().contains(ConnectEnum._ORAND.getType()) || resultSql2.toLowerCase().contains(ConnectEnum._OROR.getType()) || resultSql2.toLowerCase().contains(ConnectEnum._WHEREAND.getType()) || resultSql2.toLowerCase().contains(ConnectEnum._WHEREOR.getType()) || resultSql2.toLowerCase().contains(ConnectEnum._SIGNAND.getType()) || resultSql2.toLowerCase().contains(ConnectEnum._SIGNOR.getType()) || resultSql2.contains("()") || orEnd.equalsIgnoreCase(ConnectEnum._OR.getType()) || andEnd.equalsIgnoreCase(ConnectEnum._AND.getType())) {
            resultSql2 = OscarQuerySingleConditionUtil.cleanSql(resultSql2);
        }
        return resultSql2;
    }
}

