/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.oscar.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.engine.common.service.LrCacheService;
import com.jxdinfo.engine.common.util.SpringUtils;
import com.jxdinfo.engine.metadata.constant.LRConstants;
import com.jxdinfo.engine.metadata.dao.TLrBaseMapper;
import com.jxdinfo.engine.metadata.dao.TLrDataServiceSqlMapper;
import com.jxdinfo.engine.metadata.dao.TLrDataserviceAutoconfigMapper;
import com.jxdinfo.engine.metadata.dao.TLrDataserviceConfigrationTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrDatasourceTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrMetadataDetailMapper;
import com.jxdinfo.engine.metadata.dao.TLrMetadataManageTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrServiceDetailMapper;
import com.jxdinfo.engine.metadata.dao.TLrTableRelationshipMapper;
import com.jxdinfo.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.engine.metadata.model.InputColumnVO;
import com.jxdinfo.engine.metadata.model.InvokeResponse;
import com.jxdinfo.engine.metadata.model.TLrDataServiceSql;
import com.jxdinfo.engine.metadata.model.TLrDataserviceAutoConfig;
import com.jxdinfo.engine.metadata.model.TLrDataserviceConfigurationTable;
import com.jxdinfo.engine.metadata.model.TLrDatasourceTable;
import com.jxdinfo.engine.metadata.model.TLrMetadataDetail;
import com.jxdinfo.engine.metadata.model.TLrServiceDetailTable;
import com.jxdinfo.engine.metadata.model.TLrTableRelationship;
import com.jxdinfo.engine.metadata.service.DynamicDataSourceService;
import com.jxdinfo.engine.metadata.util.CommonUtils;
import com.jxdinfo.engine.metadata.util.DateUtils;
import com.jxdinfo.engine.metadata.util.IdAcquisitionUtil;
import com.jxdinfo.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.engine.metadata.util.StringUtils;
import com.jxdinfo.engine.oscar.service.IOscarLrMasterSlaveInvokeService;
import com.jxdinfo.engine.oscar.service.OscarTransactionalExecuteService;
import com.jxdinfo.engine.oscar.service.OscarValidateParamService;
import com.jxdinfo.engine.oscar.util.OscarQueryConditionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@DS(value="master")
public class OscarLrMasterSlaveInvokeServiceImpl
implements IOscarLrMasterSlaveInvokeService {
    private static final long IN_DIC_CODE = 124L;
    private static final long NOT_IN_DIC_CODE = 125L;
    private static final String FOREACH_COLUMN = "foreach_column";
    private static final String FOREACH_PREFIX = "foreach_";
    @Autowired
    private OscarValidateParamService validateParamService;
    @Autowired
    private TLrDataserviceAutoconfigMapper lrDataServiceAutoconfigMapper;
    @Autowired
    private TLrDataserviceConfigrationTableMapper lrDataServiceMapper;
    @Autowired
    private TLrDatasourceTableMapper lrDataSourceMapper;
    @Autowired
    private DynamicDataSourceService dynamicDataSourceService;
    @Autowired
    private OscarTransactionalExecuteService transactionalExecuteService;
    @Autowired
    private TLrMetadataDetailMapper lrMetadataDetailMapper;
    @Autowired
    private TLrMetadataManageTableMapper lrMetadataManageMapper;
    @Autowired
    private TLrTableRelationshipMapper relationshipMapper;
    @Autowired
    private TLrBaseMapper lrBaseMapper;
    @Autowired
    private TLrDataServiceSqlMapper serviceSqlMapper;
    @Autowired
    private LrCacheService cacheService;

    @Override
    public InvokeResponse queryMasterSlaveInfoById(Map<String, Object> params, String serviceId) throws EngineException {
        Map resultMap = Maps.newHashMap();
        List<TLrServiceDetailTable> details = this.getServiceDetailByServiceId(serviceId);
        Set<String> dataServiceIds = details.stream().map(TLrServiceDetailTable::getDataserviceId).collect(Collectors.toSet());
        List<TLrDataserviceAutoConfig> autoConfigs = this.getDataServiceAutoConfigs(serviceId, dataServiceIds);
        TLrServiceDetailTable detail = details.get(0);
        String masterTabeldataServiceId = detail.getDataserviceId();
        HashMap tableIdDsIdMap = Maps.newHashMapWithExpectedSize((int)details.size());
        this.validateInfoParams(params, detail, autoConfigs, tableIdDsIdMap);
        TLrDataserviceConfigurationTable dataService = this.lrDataServiceMapper.selectTLrDataserviceConfigrationTableById(masterTabeldataServiceId);
        String modelId = dataService.getModelId();
        List relationships = this.relationshipMapper.selectTLrTableRelationshipListByModelId(modelId);
        List relationshipsmult = relationships.stream().filter(r -> r.getRelationType() == 2L).collect(Collectors.toList());
        HashMap dataserviceIdSlaveTableNameAlias = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(relationshipsmult)) {
            Map slaveTableIdShipMap = relationshipsmult.stream().collect(Collectors.toMap(TLrTableRelationship::getSlaveTableId, Function.identity()));
            tableIdDsIdMap.forEach((key, value) -> {
                if (slaveTableIdShipMap.containsKey(key)) {
                    dataserviceIdSlaveTableNameAlias.put(value, ((TLrTableRelationship)slaveTableIdShipMap.get(key)).getTableNamesAlias());
                }
            });
        }
        HashMap<String, String> dsIdsqlMap = new HashMap<String, String>();
        for (TLrServiceDetailTable d : details) {
            String dataserviceId = d.getDataserviceId();
            String sql = this.getSqlByDetailId(dataserviceId);
            dsIdsqlMap.put(dataserviceId, sql);
        }
        Map<String, TLrDatasourceTable> dataSourceMap = this.getDataSources();
        TLrDatasourceTable dataSource = dataSourceMap.get(dataService.getDatasourceId());
        try {
            this.dynamicDataSourceService.switchDataSource(dataSource);
            for (TLrServiceDetailTable temp : details) {
                String dataServiceIdTemp = temp.getDataserviceId();
                String sql = (String)dsIdsqlMap.get(dataServiceIdTemp);
                if (masterTabeldataServiceId.equals(dataServiceIdTemp)) {
                    params.put("selectOneSql", sql);
                    resultMap = this.lrBaseMapper.masterSelectOne(params);
                    if (CollectionUtils.isEmpty((Map)resultMap)) {
                        InvokeResponse invokeResponse = new InvokeResponse(true, resultMap);
                        return invokeResponse;
                    }
                    params.putAll(resultMap);
                    continue;
                }
                params.put("selectListSql", sql);
                List resultMulti = this.lrBaseMapper.masterSelectList(params);
                resultMap.put(dataserviceIdSlaveTableNameAlias.get(dataServiceIdTemp), resultMulti);
            }
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
        return new InvokeResponse(true, (Object)resultMap);
    }

    @Override
    public InvokeResponse add(Map<String, Object> params, String serviceId) throws EngineException {
        List<TLrServiceDetailTable> details = this.getServiceDetailByServiceId(serviceId);
        Set<String> dataServiceIds = details.stream().map(TLrServiceDetailTable::getDataserviceId).collect(Collectors.toSet());
        List<TLrDataserviceAutoConfig> autoConfigs = this.getDataServiceAutoConfigs(serviceId, dataServiceIds);
        TLrServiceDetailTable detail = details.get(0);
        String masterTabeldataServiceId = detail.getDataserviceId();
        HashMap tableIdDsIdMap = Maps.newHashMapWithExpectedSize((int)details.size());
        HashMap dsAutoConfMap = Maps.newHashMapWithExpectedSize((int)details.size());
        Map<String, TLrMetadataDetail> detailMap = this.getMetadataDetails(serviceId, autoConfigs, tableIdDsIdMap, dsAutoConfMap);
        Map<String, String> dsIdTableIdMap = this.getdsIdTableIdMap(tableIdDsIdMap);
        HashMap columnIdNameMap = Maps.newHashMapWithExpectedSize((int)2);
        OscarLrMasterSlaveInvokeServiceImpl.validateaddMasterParams(params, (List)dsAutoConfMap.get(masterTabeldataServiceId), detailMap, columnIdNameMap);
        TLrDataserviceConfigurationTable dataService = this.lrDataServiceMapper.selectTLrDataserviceConfigrationTableById(masterTabeldataServiceId);
        String modelId = dataService.getModelId();
        List relationships = this.relationshipMapper.selectTLrTableRelationshipListByModelId(modelId);
        Map<String, Map<String, String>> relMap = this.getTableRelMap(serviceId, dataService.getModelId(), relationships);
        List relationshipsSingle = relationships.stream().filter(r -> r.getRelationType() == 1L).collect(Collectors.toList());
        HashSet dataserviceIdsSingle = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(relationshipsSingle)) {
            Set slavetableIdSingle = relationshipsSingle.stream().map(TLrTableRelationship::getSlaveTableId).collect(Collectors.toSet());
            tableIdDsIdMap.forEach((key, value) -> {
                if (slavetableIdSingle.contains(key)) {
                    dataserviceIdsSingle.add(value);
                }
            });
            for (String dsid : dataserviceIdsSingle) {
                String tableId = dsIdTableIdMap.get(dsid);
                this.validateSingleSlaveParams((List)dsAutoConfMap.get(dsid), detailMap, params, columnIdNameMap, relMap.get(tableId));
            }
        }
        List relationshipsmult = relationships.stream().filter(r -> r.getRelationType() == 2L).collect(Collectors.toList());
        HashMap columnParamNameMap = Maps.newHashMap();
        HashMap dataserviceIdSlaveTableNameAlias = Maps.newHashMap();
        HashSet dataserviceIdsSlave = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(relationshipsmult)) {
            Map slaveTableIdShipMap = relationshipsmult.stream().collect(Collectors.toMap(TLrTableRelationship::getSlaveTableId, Function.identity()));
            tableIdDsIdMap.forEach((key, value) -> {
                if (slaveTableIdShipMap.containsKey(key)) {
                    dataserviceIdSlaveTableNameAlias.put(value, ((TLrTableRelationship)slaveTableIdShipMap.get(key)).getTableNamesAlias());
                }
            });
            for (String dataServiceId : dataserviceIdSlaveTableNameAlias.keySet()) {
                dataserviceIdsSlave.add(dataServiceId);
                String tableId = dsIdTableIdMap.get(dataServiceId);
                String slaveTableNameAlias = (String)dataserviceIdSlaveTableNameAlias.get(dataServiceId);
                List dataList = (List)params.get(slaveTableNameAlias);
                this.validateaddSlaveMutlParams(dataList, (List)dsAutoConfMap.get(dataServiceId), detailMap, columnParamNameMap, params, columnIdNameMap, relMap.get(tableId));
                params.put(slaveTableNameAlias, dataList);
            }
        }
        HashMap<String, String> dsIdsqlMap = new HashMap<String, String>();
        for (TLrServiceDetailTable d : details) {
            String dataserviceId = d.getDataserviceId();
            String sql = this.getSqlByDetailId(dataserviceId);
            dsIdsqlMap.put(dataserviceId, sql);
        }
        Map<String, TLrDatasourceTable> dataSourceMap = this.getDataSources();
        TLrDatasourceTable dataSource = dataSourceMap.get(dataService.getDatasourceId());
        try {
            this.dynamicDataSourceService.switchDataSource(dataSource);
            this.transactionalExecuteService.executeAddMasterSlave(masterTabeldataServiceId, params, dataserviceIdsSingle, dataserviceIdSlaveTableNameAlias, dsIdsqlMap);
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
        return new InvokeResponse(true, (Object)"true");
    }

    private Map<String, String> getcolumnIdColumnTypeMapBydataserviceIds(String serviceId, Set<String> dataserviceIds, Map<String, List<TLrDataserviceAutoConfig>> dsAutoConfMap) {
        Map<Object, Object> columnIdColumnTypeMap = Maps.newHashMap();
        if (dataserviceIds.size() > 0) {
            String key = "LR:CORE:BUSINESS:COLUNMSTYPE:COLUMNS:" + serviceId;
            Object obj = this.cacheService.get("lr-core-runtime", key);
            if (obj != null) {
                return (Map)obj;
            }
            ArrayList autoConfigListAllSlave = Lists.newArrayList();
            for (String dataServiceIdId : dataserviceIds) {
                List<TLrDataserviceAutoConfig> autoConfigList = dsAutoConfMap.get(dataServiceIdId);
                autoConfigListAllSlave.addAll(autoConfigList);
            }
            List columnIds = autoConfigListAllSlave.stream().map(TLrDataserviceAutoConfig::getColumnId).collect(Collectors.toList());
            List detailList = this.lrMetadataDetailMapper.selectByIds(columnIds);
            columnIdColumnTypeMap = detailList.stream().filter(t -> t.getColumnId() != null).collect(Collectors.toMap(TLrMetadataDetail::getColumnId, TLrMetadataDetail::getColumnType, (k1, k2) -> k1));
            this.cacheService.put("lr-core-runtime", key, (Object)columnIdColumnTypeMap);
        }
        return columnIdColumnTypeMap;
    }

    private String getSqlByDetailId(String dataServiceId) throws EngineException {
        Map detailSqlMap = (Map)this.cacheService.get("lr-core", "LR:CORE:DATA:SERVICE:SQL");
        if (CollectionUtils.isEmpty((Map)detailSqlMap) || !detailSqlMap.containsKey(dataServiceId)) {
            TLrDataServiceSqlMapper lrDataServiceSqlMapper = (TLrDataServiceSqlMapper)SpringUtils.getBean((String)"lrDataServiceSqlMapper");
            TLrDataServiceSql dataServiceSql = lrDataServiceSqlMapper.selectByDataServiceId(dataServiceId);
            if (dataServiceSql == null) {
                throw new EngineException(EngineExceptionEnum.MISSING_SQL_CONFIGURATION_INFORMATION);
            }
            if (CollectionUtils.isEmpty((Map)detailSqlMap)) {
                detailSqlMap = Maps.newHashMapWithExpectedSize((int)1);
            }
            detailSqlMap.put(dataServiceId, dataServiceSql.getDataServiceSql());
            return dataServiceSql.getDataServiceSql();
        }
        return (String)detailSqlMap.get(dataServiceId);
    }

    private void validateaddSlaveMutlParams(List<Map<String, Object>> paramList, List<TLrDataserviceAutoConfig> autoConfList, Map<String, TLrMetadataDetail> detailMap, Map<String, String> columnParamNameMap, Map<String, Object> masterParams, Map<String, String> masterParamNameMap, Map<String, String> slaveColsMap) throws EngineException {
        for (TLrDataserviceAutoConfig autoConf : autoConfList) {
            if (!"00".equals(autoConf.getPutType())) {
                return;
            }
            String columnId = autoConf.getColumnId();
            TLrMetadataDetail detail = detailMap.get(columnId);
            String userDefinedParam = autoConf.getColumnAliasDefined();
            columnParamNameMap.put(autoConf.getColumnAlias(), detail.getColumnName());
            for (Map<String, Object> params : paramList) {
                if (!params.containsKey(userDefinedParam)) {
                    params.put(userDefinedParam, null);
                }
                OscarLrMasterSlaveInvokeServiceImpl.preHandleDate(detail, userDefinedParam, params);
                if (null != detail.getIsPk() && detail.getIsPk() == 1) {
                    Object customIdslave = IdGenerateUtils.getId();
                    if (null != params.get(userDefinedParam) && !"".equals(String.valueOf(params.get(userDefinedParam)).trim())) {
                        customIdslave = params.get(userDefinedParam);
                    }
                    params.put(userDefinedParam, customIdslave.toString());
                }
                if (!slaveColsMap.containsKey(columnId)) continue;
                String masterColId = slaveColsMap.get(columnId);
                String masterParamName = masterParamNameMap.get(masterColId);
                params.put(autoConf.getColumnAlias(), masterParams.get(masterParamName));
            }
        }
    }

    private void validateSingleSlaveParams(List<TLrDataserviceAutoConfig> autoConfList, Map<String, TLrMetadataDetail> detailMap, Map<String, Object> params, Map<String, String> masterParamNameMap, Map<String, String> slaveColsMap) throws EngineException {
        for (TLrDataserviceAutoConfig autoConf : autoConfList) {
            if (!"00".equals(autoConf.getPutType())) {
                return;
            }
            String columnId = autoConf.getColumnId();
            TLrMetadataDetail detail = detailMap.get(columnId);
            String userDefinedParam = autoConf.getColumnAliasDefined();
            if (!params.containsKey(userDefinedParam)) {
                params.put(userDefinedParam, null);
            }
            OscarLrMasterSlaveInvokeServiceImpl.preHandleDate(detail, userDefinedParam, params);
            for (String param : params.keySet()) {
                if (null != detail.getIsPk() && detail.getIsPk() == 1) {
                    Object customIdslave = IdGenerateUtils.getId();
                    if (null != params.get(userDefinedParam) && !"".equals(String.valueOf(params.get(userDefinedParam)).trim())) {
                        customIdslave = params.get(userDefinedParam);
                    }
                    params.put(userDefinedParam, customIdslave.toString());
                }
                if (!slaveColsMap.containsKey(columnId)) continue;
                String masterColId = slaveColsMap.get(columnId);
                String masterParamName = masterParamNameMap.get(masterColId);
                params.put(userDefinedParam, params.get(masterParamName));
            }
        }
    }

    private void validateEditSingleSlaveParams(List<TLrDataserviceAutoConfig> autoConfList, Map<String, TLrMetadataDetail> detailMap, Map<String, Object> params, Map<String, String> masterParamNameMap, Map<String, String> slaveColsMap, String dsId, Map<String, TLrMetadataDetail> dsIdMetadetail, String tableNamesingle) throws EngineException {
        TLrMetadataDetail d = new TLrMetadataDetail();
        d.setTableName(tableNamesingle);
        for (TLrDataserviceAutoConfig autoConf : autoConfList) {
            if (!"00".equals(autoConf.getPutType())) {
                return;
            }
            String columnId = autoConf.getColumnId();
            TLrMetadataDetail detail = detailMap.get(columnId);
            String userDefinedParam = autoConf.getColumnAliasDefined();
            if (!params.containsKey(userDefinedParam) || null == params.get(userDefinedParam) || "".equals(params.get(userDefinedParam).toString().trim())) {
                params.put(userDefinedParam, null);
            }
            OscarLrMasterSlaveInvokeServiceImpl.preHandleDate(detail, userDefinedParam, params);
            for (String param : params.keySet()) {
                if (null != detail.getIsPk() && detail.getIsPk() == 1) {
                    Object customIdslave = IdGenerateUtils.getId();
                    if (null != params.get(userDefinedParam) && !"".equals(String.valueOf(params.get(userDefinedParam)).trim())) {
                        customIdslave = params.get(userDefinedParam);
                    }
                    params.put(userDefinedParam, customIdslave);
                }
                if (!slaveColsMap.containsKey(columnId)) continue;
                String masterColId = slaveColsMap.get(columnId);
                String masterParamName = masterParamNameMap.get(masterColId);
                params.put(userDefinedParam, params.get(masterParamName));
                d.setColumnName(detail.getColumnName());
                d.setColumnNameAlias(masterParamName);
            }
        }
        dsIdMetadetail.put(dsId, d);
    }

    private Map<String, String> getdsIdTableIdMap(Map<String, String> tableIdDsIdMap) {
        HashMap dsIdTableIdMap = Maps.newHashMapWithExpectedSize((int)tableIdDsIdMap.size());
        tableIdDsIdMap.forEach((key, value) -> dsIdTableIdMap.put(value, key));
        return dsIdTableIdMap;
    }

    private Map<String, Map<String, String>> getTableRelMap(String serviceId, String modelId, List<TLrTableRelationship> tableRelationships) {
        String key = "LR:TABLE:RELATIONSHIP:" + serviceId;
        Object obj = this.cacheService.get("lr-core-runtime", key);
        if (obj != null) {
            return (Map)obj;
        }
        if (CollectionUtils.isEmpty(tableRelationships)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap tableRelMap = Maps.newHashMapWithExpectedSize((int)5);
        for (TLrTableRelationship relationship : tableRelationships) {
            Map<String, String> slaveColsMap;
            String slaveTableId = relationship.getSlaveTableId();
            if (tableRelMap.containsKey(slaveTableId)) {
                slaveColsMap = (Map)tableRelMap.get(slaveTableId);
            } else {
                slaveColsMap = Maps.newHashMapWithExpectedSize((int)2);
                tableRelMap.put(slaveTableId, slaveColsMap);
            }
            slaveColsMap.put(relationship.getSlaveColumnId(), relationship.getMasterColumnId());
        }
        this.cacheService.put("lr-core-runtime", key, (Object)tableRelMap);
        return tableRelMap;
    }

    @Override
    public InvokeResponse deleteByKey(Map<String, Object> params, String serviceId) throws EngineException {
        List<TLrServiceDetailTable> details = this.getServiceDetailByServiceId(serviceId);
        Set<String> dataServiceIds = details.stream().map(TLrServiceDetailTable::getDataserviceId).collect(Collectors.toSet());
        List<TLrDataserviceAutoConfig> autoConfigs = this.getDataServiceAutoConfigs(serviceId, dataServiceIds);
        TLrServiceDetailTable serviceDetail = details.get(0);
        String masterDsId = serviceDetail.getDataserviceId();
        OscarLrMasterSlaveInvokeServiceImpl.validateDeleteParams(params, masterDsId, autoConfigs);
        TLrDataserviceConfigurationTable dataService = this.lrDataServiceMapper.selectTLrDataserviceConfigrationTableById(masterDsId);
        Map<String, TLrDatasourceTable> dataSourceMap = this.getDataSources();
        String datasourceId = dataService.getDatasourceId();
        HashMap<String, String> dsIdsqlMap = new HashMap<String, String>();
        for (TLrServiceDetailTable d : details) {
            String dataserviceId = d.getDataserviceId();
            String sql = this.getSqlByDetailId(dataserviceId);
            dsIdsqlMap.put(dataserviceId, sql);
        }
        try {
            this.dynamicDataSourceService.switchDataSource(dataSourceMap.get(datasourceId));
            this.transactionalExecuteService.executeDeleteMasterSlave(details, params, dsIdsqlMap);
            InvokeResponse invokeResponse = new InvokeResponse(true, (Object)"true");
            return invokeResponse;
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
    }

    @Override
    public InvokeResponse edit(Map<String, Object> params, String serviceId) throws EngineException {
        List<TLrServiceDetailTable> details = this.getServiceDetailByServiceId(serviceId);
        Set<String> dataServiceIds = details.stream().map(TLrServiceDetailTable::getDataserviceId).collect(Collectors.toSet());
        List<TLrDataserviceAutoConfig> autoConfigs = this.getDataServiceAutoConfigs(serviceId, dataServiceIds);
        TLrServiceDetailTable detail = details.get(0);
        String masterTabeldataServiceId = detail.getDataserviceId();
        HashMap tableIdDsIdMap = Maps.newHashMapWithExpectedSize((int)details.size());
        HashMap dsAutoConfMap = Maps.newHashMapWithExpectedSize((int)details.size());
        Set<String> dataserviceIdAll = dsAutoConfMap.keySet();
        Map<String, TLrMetadataDetail> detailMap = this.getMetadataDetails(serviceId, autoConfigs, tableIdDsIdMap, dsAutoConfMap);
        Map<String, String> dsTableNameMap = this.getDetailMetadataMap(serviceId, tableIdDsIdMap);
        Map<String, String> dsIdTableIdMap = this.getdsIdTableIdMap(tableIdDsIdMap);
        String tableName = dsTableNameMap.get(masterTabeldataServiceId);
        HashMap setsColumnMap = Maps.newHashMap();
        HashMap conditionsColumnMap = Maps.newHashMap();
        HashMap columnIdNameMap = Maps.newHashMapWithExpectedSize((int)2);
        this.validateEditMasterParams(params, (List)dsAutoConfMap.get(masterTabeldataServiceId), detailMap, conditionsColumnMap, setsColumnMap, columnIdNameMap);
        TLrDataserviceConfigurationTable dataService = this.lrDataServiceMapper.selectTLrDataserviceConfigrationTableById(masterTabeldataServiceId);
        String modelId = dataService.getModelId();
        List relationships = this.relationshipMapper.selectTLrTableRelationshipListByModelId(modelId);
        Map<String, Map<String, String>> relMap = this.getTableRelMap(serviceId, dataService.getModelId(), relationships);
        List relationshipsSingle = relationships.stream().filter(r -> r.getRelationType() == 1L).collect(Collectors.toList());
        HashMap dsIdMetadetailSingle = Maps.newHashMap();
        HashSet dataserviceIdsSingle = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(relationshipsSingle)) {
            Set slavetableIdSingle = relationshipsSingle.stream().map(TLrTableRelationship::getSlaveTableId).collect(Collectors.toSet());
            tableIdDsIdMap.forEach((key, value) -> {
                if (slavetableIdSingle.contains(key)) {
                    dataserviceIdsSingle.add(value);
                }
            });
            for (String dsid : dataserviceIdsSingle) {
                String tableId = dsIdTableIdMap.get(dsid);
                String tableNamesingle = dsTableNameMap.get(dsid);
                this.validateEditSingleSlaveParams((List)dsAutoConfMap.get(dsid), detailMap, params, columnIdNameMap, relMap.get(tableId), dsid, dsIdMetadetailSingle, tableNamesingle);
            }
        }
        List relationshipsmult = relationships.stream().filter(r -> r.getRelationType() == 2L).collect(Collectors.toList());
        HashMap columnParamNameMap = Maps.newHashMap();
        HashMap dataserviceIdSlaveTableNameAlias = Maps.newHashMap();
        HashSet dataserviceIdsSlave = Sets.newHashSet();
        HashMap dsIdMetadetailMutl = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(relationshipsmult)) {
            Map slaveTableIdShipMap = relationshipsmult.stream().collect(Collectors.toMap(TLrTableRelationship::getSlaveTableId, Function.identity()));
            tableIdDsIdMap.forEach((key, value) -> {
                if (slaveTableIdShipMap.containsKey(key)) {
                    dataserviceIdSlaveTableNameAlias.put(value, ((TLrTableRelationship)slaveTableIdShipMap.get(key)).getTableNamesAlias());
                }
            });
            for (Object dsIdmult : dataserviceIdSlaveTableNameAlias.keySet()) {
                dataserviceIdsSlave.add(dsIdmult);
                String tableId = dsIdTableIdMap.get(dsIdmult);
                String tableNamemult = dsTableNameMap.get(dsIdmult);
                String slaveTableNameAlias = (String)dataserviceIdSlaveTableNameAlias.get(dsIdmult);
                List dataList = (List)params.get(slaveTableNameAlias);
                this.validateEditSlaveMutlParams(dataList, (List)dsAutoConfMap.get(dsIdmult), detailMap, columnParamNameMap, params, columnIdNameMap, relMap.get(tableId), (String)dsIdmult, tableNamemult, dsIdMetadetailMutl);
                params.put(slaveTableNameAlias, dataList);
            }
        }
        Map<String, String> columnIdColumnTypeMap = this.getcolumnIdColumnTypeMapBydataserviceIds(serviceId, dataserviceIdAll, dsAutoConfMap);
        HashMap<String, String> dsIdsqlMap = new HashMap<String, String>();
        for (TLrServiceDetailTable d : details) {
            String dataserviceId = d.getDataserviceId();
            String sql = this.getSqlByDetailId(dataserviceId);
            dsIdsqlMap.put(dataserviceId, sql);
        }
        Map<String, TLrDatasourceTable> dataSourceMap = this.getDataSources();
        TLrDatasourceTable dataSource = dataSourceMap.get(dataService.getDatasourceId());
        try {
            this.dynamicDataSourceService.switchDataSource(dataSource);
            this.transactionalExecuteService.executeUpdateMasterSlave(masterTabeldataServiceId, tableName, params, dataserviceIdsSingle, dataserviceIdSlaveTableNameAlias, dsAutoConfMap, columnIdColumnTypeMap, setsColumnMap, conditionsColumnMap, dsIdMetadetailSingle, dsIdMetadetailMutl, dsIdsqlMap);
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
        return new InvokeResponse(true, (Object)"true");
    }

    @Override
    public InvokeResponse masterSlavePageList(Map<String, Object> params, String serviceId) throws EngineException {
        HashMap resultData = Maps.newHashMap();
        List masterResultList = Lists.newArrayList();
        List masterResultListSize = Lists.newArrayList();
        List<TLrServiceDetailTable> details = this.getServiceDetailByServiceId(serviceId);
        Set<String> dataServiceIds = details.stream().map(TLrServiceDetailTable::getDataserviceId).collect(Collectors.toSet());
        List<TLrDataserviceAutoConfig> autoConfigs = this.getDataServiceAutoConfigs(serviceId, dataServiceIds);
        HashMap dsAutoConfMap = Maps.newHashMapWithExpectedSize((int)details.size());
        HashMap tableIdDsIdMap = Maps.newHashMapWithExpectedSize((int)details.size());
        Map<String, TLrMetadataDetail> detailMap = this.getMetadataDetails(serviceId, autoConfigs, tableIdDsIdMap, dsAutoConfMap);
        for (TLrDataserviceAutoConfig auto : autoConfigs) {
            if (!"00".equals(auto.getPutType())) continue;
            TLrMetadataDetail detailTemp = detailMap.get(auto.getColumnId());
            String userDefinedParam = auto.getColumnAliasDefined();
            OscarLrMasterSlaveInvokeServiceImpl.preHandleDate(detailTemp, userDefinedParam, params);
        }
        Map<String, String> dsIdTableIdMap = this.getdsIdTableIdMap(tableIdDsIdMap);
        TLrServiceDetailTable detail = details.get(0);
        String masterTabeldataServiceId = detail.getDataserviceId();
        HashMap masterColumnIdNameAliasMap = Maps.newHashMapWithExpectedSize((int)2);
        this.masterOutColumnIdName((List)dsAutoConfMap.get(masterTabeldataServiceId), masterColumnIdNameAliasMap);
        TLrDataserviceConfigurationTable dataService = this.lrDataServiceMapper.selectTLrDataserviceConfigrationTableById(masterTabeldataServiceId);
        TLrDataServiceSql masterSql = this.serviceSqlMapper.selectByDataServiceId(masterTabeldataServiceId);
        String configSql = masterSql.getDataServiceSql();
        String whereSql = "";
        String constraintSql = "";
        if (configSql.toLowerCase().contains("group by")) {
            constraintSql = configSql.substring(configSql.toLowerCase().indexOf("group by"));
            configSql = configSql.substring(0, configSql.toLowerCase().indexOf("group by"));
        } else if (configSql.toLowerCase().contains("order by")) {
            constraintSql = configSql.substring(configSql.toLowerCase().indexOf("order by"));
            configSql = configSql.substring(0, configSql.toLowerCase().indexOf("order by"));
        }
        if (configSql.contains(" WHERE ")) {
            configSql = configSql.substring(0, configSql.lastIndexOf(" WHERE "));
        }
        if (!StringUtils.isEmpty((String)masterSql.getWhereChildren())) {
            List inputColumnVOList = JSONArray.parseArray((String)masterSql.getWhereChildren(), InputColumnVO.class);
            whereSql = OscarQueryConditionUtil.dynamicWhereSql(inputColumnVOList, params);
        }
        String querySql = configSql + " " + whereSql + " " + constraintSql;
        this.executeQueryPage(params, autoConfigs, Sets.newHashSet((Object[])new String[]{masterTabeldataServiceId}));
        String modelId = dataService.getModelId();
        List relationships = this.relationshipMapper.selectTLrTableRelationshipListByModelId(modelId);
        Map<String, Map<String, String>> relMap = this.getTableRelMap(serviceId, dataService.getModelId(), relationships);
        List relationshipsmult = relationships.stream().filter(r -> r.getRelationType() == 2L).collect(Collectors.toList());
        HashMap dataserviceIdSlaveTableNameAlias = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(relationshipsmult)) {
            Map slaveTableIdShipMap = relationshipsmult.stream().collect(Collectors.toMap(TLrTableRelationship::getSlaveTableId, Function.identity()));
            tableIdDsIdMap.forEach((key, value) -> {
                if (slaveTableIdShipMap.containsKey(key)) {
                    dataserviceIdSlaveTableNameAlias.put(value, ((TLrTableRelationship)slaveTableIdShipMap.get(key)).getTableNamesAlias());
                }
            });
        }
        HashMap slaveDsIdsqlMap = Maps.newHashMap();
        HashMap dsIdMasterColumnAliasName = Maps.newHashMap();
        for (TLrServiceDetailTable d : details) {
            String dataserviceId = d.getDataserviceId();
            String sql = this.getSqlByDetailId(dataserviceId);
            if (!dataserviceIdSlaveTableNameAlias.containsKey(dataserviceId)) continue;
            slaveDsIdsqlMap.put(dataserviceId, sql);
            String tableId = dsIdTableIdMap.get(dataserviceId);
            this.dsIdMasterColumnAliasName((List)dsAutoConfMap.get(dataserviceId), relMap.get(tableId), dsIdMasterColumnAliasName, masterColumnIdNameAliasMap);
        }
        Page page = new Page();
        long pages = params.get("current") != null ? (long)((Integer)params.get("current")).intValue() : 1L;
        long size = params.get("size") != null ? (long)((Integer)params.get("size")).intValue() : 50L;
        page.setCurrent(pages);
        page.setSize(size);
        Map<String, TLrDatasourceTable> dataSourceMap = this.getDataSources();
        TLrDatasourceTable dataSource = dataSourceMap.get(dataService.getDatasourceId());
        try {
            this.dynamicDataSourceService.switchDataSource(dataSource);
            querySql = OscarLrMasterSlaveInvokeServiceImpl.perfectSql(querySql, params);
            params.put("selectListPage", querySql);
            masterResultList = this.lrBaseMapper.selectListPage(page, params);
            masterResultListSize = this.lrBaseMapper.selectList(params);
            if (slaveDsIdsqlMap.size() > 0 && masterResultList.size() > 0) {
                for (Map masterResult : masterResultList) {
                    HashMap slaveWhereParams = Maps.newHashMap();
                    List childMap = Lists.newArrayList();
                    for (String dsIdTemp : slaveDsIdsqlMap.keySet()) {
                        String masterColumnAliasName = (String)dsIdMasterColumnAliasName.get(dsIdTemp);
                        Object masterColumnValue = masterResult.get(masterColumnAliasName);
                        slaveWhereParams.put(masterColumnAliasName, masterColumnValue);
                        slaveWhereParams.put("selectListSql", slaveDsIdsqlMap.get(dsIdTemp));
                        childMap = this.lrBaseMapper.masterSelectList((Map)slaveWhereParams);
                        masterResult.put(dataserviceIdSlaveTableNameAlias.get(dsIdTemp), childMap);
                    }
                }
            }
            resultData.put("data", masterResultList);
            resultData.put("current", pages);
            resultData.put("count", masterResultListSize.size());
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
        return new InvokeResponse(true, (Object)resultData);
    }

    private void masterOutColumnIdName(List<TLrDataserviceAutoConfig> autoConfList, Map<String, String> columnIdNameMap) throws EngineException {
        for (TLrDataserviceAutoConfig autoConf : autoConfList) {
            if (!"01".equals(autoConf.getPutType())) continue;
            String columnId = autoConf.getColumnId();
            String userDefinedParam = autoConf.getColumnAliasDefined();
            columnIdNameMap.put(columnId, userDefinedParam);
        }
        if (columnIdNameMap.size() <= 0) {
            throw new EngineException(EngineExceptionEnum.OUTPUT_COLUMN_EMPTY);
        }
    }

    private void dsIdMasterColumnAliasName(List<TLrDataserviceAutoConfig> autoConfList, Map<String, String> slaveColsMap, Map<String, String> dsIdMasterColumnAliasName, Map<String, String> masterParamNameMap) {
        for (TLrDataserviceAutoConfig autoConf : autoConfList) {
            if (!"00".equals(autoConf.getPutType())) continue;
            String columnId = autoConf.getColumnId();
            String dataServiceId = autoConf.getDataserviceId();
            if (!slaveColsMap.containsKey(columnId)) continue;
            String masterColId = slaveColsMap.get(columnId);
            String masterParamName = masterParamNameMap.get(masterColId);
            dsIdMasterColumnAliasName.put(dataServiceId, masterParamName);
        }
    }

    @Override
    public InvokeResponse masterSlaveList(Map<String, Object> params, String serviceId) throws EngineException {
        HashMap dataResult = Maps.newHashMap();
        List masterResultList = Lists.newArrayList();
        List<TLrServiceDetailTable> details = this.getServiceDetailByServiceId(serviceId);
        Set<String> dataServiceIds = details.stream().map(TLrServiceDetailTable::getDataserviceId).collect(Collectors.toSet());
        List<TLrDataserviceAutoConfig> autoConfigs = this.getDataServiceAutoConfigs(serviceId, dataServiceIds);
        HashMap dsAutoConfMap = Maps.newHashMapWithExpectedSize((int)details.size());
        HashMap tableIdDsIdMap = Maps.newHashMapWithExpectedSize((int)details.size());
        Map<String, TLrMetadataDetail> detailMap = this.getMetadataDetails(serviceId, autoConfigs, tableIdDsIdMap, dsAutoConfMap);
        for (TLrDataserviceAutoConfig auto : autoConfigs) {
            if (!"00".equals(auto.getPutType())) continue;
            TLrMetadataDetail detailTemp = detailMap.get(auto.getColumnId());
            String userDefinedParam = auto.getColumnAliasDefined();
            OscarLrMasterSlaveInvokeServiceImpl.preHandleDate(detailTemp, userDefinedParam, params);
        }
        Map<String, String> dsIdTableIdMap = this.getdsIdTableIdMap(tableIdDsIdMap);
        TLrServiceDetailTable detail = details.get(0);
        String masterTabeldataServiceId = detail.getDataserviceId();
        HashMap masterColumnIdNameAliasMap = Maps.newHashMapWithExpectedSize((int)2);
        this.masterOutColumnIdName((List)dsAutoConfMap.get(masterTabeldataServiceId), masterColumnIdNameAliasMap);
        TLrDataserviceConfigurationTable dataService = this.lrDataServiceMapper.selectTLrDataserviceConfigrationTableById(masterTabeldataServiceId);
        TLrDataServiceSql masterSql = this.serviceSqlMapper.selectByDataServiceId(masterTabeldataServiceId);
        String configSql = masterSql.getDataServiceSql();
        String whereSql = "";
        String constraintSql = "";
        if (configSql.toLowerCase().contains("group by")) {
            constraintSql = configSql.substring(configSql.toLowerCase().indexOf("group by"));
            configSql = configSql.substring(0, configSql.toLowerCase().indexOf("group by"));
        } else if (configSql.toLowerCase().contains("order by")) {
            constraintSql = configSql.substring(configSql.toLowerCase().indexOf("order by"));
            configSql = configSql.substring(0, configSql.toLowerCase().indexOf("order by"));
        }
        if (configSql.contains(" WHERE ")) {
            configSql = configSql.substring(0, configSql.lastIndexOf(" WHERE "));
        }
        if (!StringUtils.isEmpty((String)masterSql.getWhereChildren())) {
            List inputColumnVOList = JSONArray.parseArray((String)masterSql.getWhereChildren(), InputColumnVO.class);
            whereSql = OscarQueryConditionUtil.dynamicWhereSql(inputColumnVOList, params);
        }
        String querySql = configSql + " " + whereSql + " " + constraintSql;
        this.executeQuery(params, autoConfigs);
        String modelId = dataService.getModelId();
        List relationships = this.relationshipMapper.selectTLrTableRelationshipListByModelId(modelId);
        Map<String, Map<String, String>> relMap = this.getTableRelMap(serviceId, dataService.getModelId(), relationships);
        List relationshipsmult = relationships.stream().filter(r -> r.getRelationType() == 2L).collect(Collectors.toList());
        HashMap dataserviceIdSlaveTableNameAlias = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(relationshipsmult)) {
            Map slaveTableIdShipMap = relationshipsmult.stream().collect(Collectors.toMap(TLrTableRelationship::getSlaveTableId, Function.identity()));
            tableIdDsIdMap.forEach((key, value) -> {
                if (slaveTableIdShipMap.containsKey(key)) {
                    dataserviceIdSlaveTableNameAlias.put(value, ((TLrTableRelationship)slaveTableIdShipMap.get(key)).getTableNamesAlias());
                }
            });
        }
        HashMap slaveDsIdsqlMap = Maps.newHashMap();
        HashMap dsIdMasterColumnAliasName = Maps.newHashMap();
        for (TLrServiceDetailTable d : details) {
            String dataserviceId = d.getDataserviceId();
            String sql = this.getSqlByDetailId(dataserviceId);
            if (!dataserviceIdSlaveTableNameAlias.containsKey(dataserviceId)) continue;
            slaveDsIdsqlMap.put(dataserviceId, sql);
            String tableId = dsIdTableIdMap.get(dataserviceId);
            this.dsIdMasterColumnAliasName((List)dsAutoConfMap.get(dataserviceId), relMap.get(tableId), dsIdMasterColumnAliasName, masterColumnIdNameAliasMap);
        }
        Map<String, TLrDatasourceTable> dataSourceMap = this.getDataSources();
        TLrDatasourceTable dataSource = dataSourceMap.get(dataService.getDatasourceId());
        try {
            this.dynamicDataSourceService.switchDataSource(dataSource);
            querySql = OscarLrMasterSlaveInvokeServiceImpl.perfectSqlList(querySql, params);
            params.put("selectListSql", querySql);
            masterResultList = this.lrBaseMapper.masterSelectList(params);
            if (slaveDsIdsqlMap.size() > 0 && masterResultList.size() > 0) {
                for (Map masterResult : masterResultList) {
                    HashMap slaveWhereParams = Maps.newHashMap();
                    List childMap = Lists.newArrayList();
                    for (String dsIdTemp : slaveDsIdsqlMap.keySet()) {
                        String masterColumnAliasName = (String)dsIdMasterColumnAliasName.get(dsIdTemp);
                        Object masterColumnValue = masterResult.get(masterColumnAliasName);
                        slaveWhereParams.put(masterColumnAliasName, masterColumnValue);
                        slaveWhereParams.put("selectListSql", slaveDsIdsqlMap.get(dsIdTemp));
                        childMap = this.lrBaseMapper.masterSelectList((Map)slaveWhereParams);
                        masterResult.put(dataserviceIdSlaveTableNameAlias.get(dsIdTemp), childMap);
                    }
                }
            }
            dataResult.put("data", masterResultList);
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
        return new InvokeResponse(true, (Object)dataResult);
    }

    @Override
    public InvokeResponse masterSlavePageProceList(Map<String, Object> params, String serviceId) throws EngineException {
        params.put("userIdLR", IdAcquisitionUtil.getCurrentUserId());
        HashMap resultData = Maps.newHashMap();
        List masterResultList = Lists.newArrayList();
        List<TLrServiceDetailTable> details = this.getServiceDetailByServiceId(serviceId);
        Set<String> dataServiceIds = details.stream().map(TLrServiceDetailTable::getDataserviceId).collect(Collectors.toSet());
        List<TLrDataserviceAutoConfig> autoConfigs = this.getDataServiceAutoConfigs(serviceId, dataServiceIds);
        HashMap dsAutoConfMap = Maps.newHashMapWithExpectedSize((int)details.size());
        HashMap tableIdDsIdMap = Maps.newHashMapWithExpectedSize((int)details.size());
        Map<String, TLrMetadataDetail> detailMap = this.getMetadataDetails(serviceId, autoConfigs, tableIdDsIdMap, dsAutoConfMap);
        for (TLrDataserviceAutoConfig auto : autoConfigs) {
            if (!"00".equals(auto.getPutType())) continue;
            TLrMetadataDetail detailTemp = detailMap.get(auto.getColumnId());
            String userDefinedParam = auto.getColumnAliasDefined();
            OscarLrMasterSlaveInvokeServiceImpl.preHandleDate(detailTemp, userDefinedParam, params);
        }
        Map<String, String> dsIdTableIdMap = this.getdsIdTableIdMap(tableIdDsIdMap);
        TLrServiceDetailTable detail = details.get(0);
        String masterTabeldataServiceId = detail.getDataserviceId();
        HashMap masterColumnIdNameAliasMap = Maps.newHashMapWithExpectedSize((int)2);
        this.masterOutColumnIdName((List)dsAutoConfMap.get(masterTabeldataServiceId), masterColumnIdNameAliasMap);
        TLrDataserviceConfigurationTable dataService = this.lrDataServiceMapper.selectTLrDataserviceConfigrationTableById(masterTabeldataServiceId);
        TLrDataServiceSql masterSql = this.serviceSqlMapper.selectByDataServiceId(masterTabeldataServiceId);
        String configSql = masterSql.getDataServiceSql();
        String whereSql = "";
        if (!StringUtils.isEmpty((String)masterSql.getWhereChildren())) {
            List inputColumnVOList = JSONArray.parseArray((String)masterSql.getWhereChildren(), InputColumnVO.class);
            whereSql = OscarQueryConditionUtil.dynamicWhereSql(inputColumnVOList, params);
        }
        String querySql = "".equalsIgnoreCase(whereSql.trim()) ? configSql.replace("${WHERE}", "WHERE") : configSql.replace("${WHERE}", whereSql + " AND ");
        this.executeQueryPage(params, autoConfigs, Sets.newHashSet((Object[])new String[]{masterTabeldataServiceId}));
        String modelId = dataService.getModelId();
        List relationships = this.relationshipMapper.selectTLrTableRelationshipListByModelId(modelId);
        Map<String, Map<String, String>> relMap = this.getTableRelMap(serviceId, dataService.getModelId(), relationships);
        List relationshipsmult = relationships.stream().filter(r -> r.getRelationType() == 2L).collect(Collectors.toList());
        HashMap dataserviceIdSlaveTableNameAlias = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(relationshipsmult)) {
            Map slaveTableIdShipMap = relationshipsmult.stream().collect(Collectors.toMap(TLrTableRelationship::getSlaveTableId, Function.identity()));
            tableIdDsIdMap.forEach((key, value) -> {
                if (slaveTableIdShipMap.containsKey(key)) {
                    dataserviceIdSlaveTableNameAlias.put(value, ((TLrTableRelationship)slaveTableIdShipMap.get(key)).getTableNamesAlias());
                }
            });
        }
        HashMap slaveDsIdsqlMap = Maps.newHashMap();
        HashMap dsIdMasterColumnAliasName = Maps.newHashMap();
        for (TLrServiceDetailTable d : details) {
            String dataserviceId = d.getDataserviceId();
            String sql = this.getSqlByDetailId(dataserviceId);
            if (!dataserviceIdSlaveTableNameAlias.containsKey(dataserviceId)) continue;
            slaveDsIdsqlMap.put(dataserviceId, sql);
            String tableId = dsIdTableIdMap.get(dataserviceId);
            this.dsIdMasterColumnAliasName((List)dsAutoConfMap.get(dataserviceId), relMap.get(tableId), dsIdMasterColumnAliasName, masterColumnIdNameAliasMap);
        }
        Page page = new Page();
        long pages = params.get("current") != null ? (long)((Integer)params.get("current")).intValue() : 1L;
        long size = params.get("size") != null ? (long)((Integer)params.get("size")).intValue() : 50L;
        page.setCurrent(pages);
        page.setSize(size);
        Map<String, TLrDatasourceTable> dataSourceMap = this.getDataSources();
        TLrDatasourceTable dataSource = dataSourceMap.get(dataService.getDatasourceId());
        try {
            this.dynamicDataSourceService.switchDataSource(dataSource);
            querySql = OscarLrMasterSlaveInvokeServiceImpl.perfectSql(querySql, params);
            params.put("selectListPage", querySql);
            masterResultList = this.lrBaseMapper.selectListPage(page, params);
            if (slaveDsIdsqlMap.size() > 0 && masterResultList.size() > 0) {
                for (Map masterResult : masterResultList) {
                    HashMap slaveWhereParams = Maps.newHashMap();
                    List childMap = Lists.newArrayList();
                    for (String dsIdTemp : slaveDsIdsqlMap.keySet()) {
                        String masterColumnAliasName = (String)dsIdMasterColumnAliasName.get(dsIdTemp);
                        Object masterColumnValue = masterResult.get(masterColumnAliasName);
                        slaveWhereParams.put(masterColumnAliasName, masterColumnValue);
                        slaveWhereParams.put("selectListSql", slaveDsIdsqlMap.get(dsIdTemp));
                        childMap = this.lrBaseMapper.masterSelectList((Map)slaveWhereParams);
                        masterResult.put(dataserviceIdSlaveTableNameAlias.get(dsIdTemp), childMap);
                    }
                }
            }
            resultData.put("data", masterResultList);
            resultData.put("current", pages);
            resultData.put("count", masterResultList.size());
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
        return new InvokeResponse(true, (Object)resultData);
    }

    @Override
    public InvokeResponse masterSlaveProceList(Map<String, Object> params, String serviceId) throws EngineException {
        params.put("userIdLR", IdAcquisitionUtil.getCurrentUserId());
        HashMap dataResult = Maps.newHashMap();
        List masterResultList = Lists.newArrayList();
        List<TLrServiceDetailTable> details = this.getServiceDetailByServiceId(serviceId);
        Set<String> dataServiceIds = details.stream().map(TLrServiceDetailTable::getDataserviceId).collect(Collectors.toSet());
        List<TLrDataserviceAutoConfig> autoConfigs = this.getDataServiceAutoConfigs(serviceId, dataServiceIds);
        HashMap dsAutoConfMap = Maps.newHashMapWithExpectedSize((int)details.size());
        HashMap tableIdDsIdMap = Maps.newHashMapWithExpectedSize((int)details.size());
        Map<String, TLrMetadataDetail> detailMap = this.getMetadataDetails(serviceId, autoConfigs, tableIdDsIdMap, dsAutoConfMap);
        for (TLrDataserviceAutoConfig auto : autoConfigs) {
            if (!"00".equals(auto.getPutType())) continue;
            TLrMetadataDetail detailTemp = detailMap.get(auto.getColumnId());
            String userDefinedParam = auto.getColumnAliasDefined();
            OscarLrMasterSlaveInvokeServiceImpl.preHandleDate(detailTemp, userDefinedParam, params);
        }
        Map<String, String> dsIdTableIdMap = this.getdsIdTableIdMap(tableIdDsIdMap);
        TLrServiceDetailTable detail = details.get(0);
        String masterTabeldataServiceId = detail.getDataserviceId();
        HashMap masterColumnIdNameAliasMap = Maps.newHashMapWithExpectedSize((int)2);
        this.masterOutColumnIdName((List)dsAutoConfMap.get(masterTabeldataServiceId), masterColumnIdNameAliasMap);
        TLrDataserviceConfigurationTable dataService = this.lrDataServiceMapper.selectTLrDataserviceConfigrationTableById(masterTabeldataServiceId);
        TLrDataServiceSql masterSql = this.serviceSqlMapper.selectByDataServiceId(masterTabeldataServiceId);
        String configSql = masterSql.getDataServiceSql();
        String whereSql = "";
        if (!StringUtils.isEmpty((String)masterSql.getWhereChildren())) {
            List inputColumnVOList = JSONArray.parseArray((String)masterSql.getWhereChildren(), InputColumnVO.class);
            whereSql = OscarQueryConditionUtil.dynamicWhereSql(inputColumnVOList, params);
        }
        String querySql = "".equalsIgnoreCase(whereSql.trim()) ? configSql.replace("${WHERE}", "WHERE") : configSql.replace("${WHERE}", whereSql + " AND ");
        this.executeQuery(params, autoConfigs);
        String modelId = dataService.getModelId();
        List relationships = this.relationshipMapper.selectTLrTableRelationshipListByModelId(modelId);
        Map<String, Map<String, String>> relMap = this.getTableRelMap(serviceId, dataService.getModelId(), relationships);
        List relationshipsmult = relationships.stream().filter(r -> r.getRelationType() == 2L).collect(Collectors.toList());
        HashMap dataserviceIdSlaveTableNameAlias = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(relationshipsmult)) {
            Map slaveTableIdShipMap = relationshipsmult.stream().collect(Collectors.toMap(TLrTableRelationship::getSlaveTableId, Function.identity()));
            tableIdDsIdMap.forEach((key, value) -> {
                if (slaveTableIdShipMap.containsKey(key)) {
                    dataserviceIdSlaveTableNameAlias.put(value, ((TLrTableRelationship)slaveTableIdShipMap.get(key)).getTableNamesAlias());
                }
            });
        }
        HashMap slaveDsIdsqlMap = Maps.newHashMap();
        HashMap dsIdMasterColumnAliasName = Maps.newHashMap();
        for (TLrServiceDetailTable d : details) {
            String dataserviceId = d.getDataserviceId();
            String sql = this.getSqlByDetailId(dataserviceId);
            if (!dataserviceIdSlaveTableNameAlias.containsKey(dataserviceId)) continue;
            slaveDsIdsqlMap.put(dataserviceId, sql);
            String tableId = dsIdTableIdMap.get(dataserviceId);
            this.dsIdMasterColumnAliasName((List)dsAutoConfMap.get(dataserviceId), relMap.get(tableId), dsIdMasterColumnAliasName, masterColumnIdNameAliasMap);
        }
        Map<String, TLrDatasourceTable> dataSourceMap = this.getDataSources();
        TLrDatasourceTable dataSource = dataSourceMap.get(dataService.getDatasourceId());
        try {
            this.dynamicDataSourceService.switchDataSource(dataSource);
            querySql = OscarLrMasterSlaveInvokeServiceImpl.perfectSqlList(querySql, params);
            params.put("selectListSql", querySql);
            masterResultList = this.lrBaseMapper.masterSelectList(params);
            if (slaveDsIdsqlMap.size() > 0 && masterResultList.size() > 0) {
                for (Map masterResult : masterResultList) {
                    HashMap slaveWhereParams = Maps.newHashMap();
                    List childMap = Lists.newArrayList();
                    for (String dsIdTemp : slaveDsIdsqlMap.keySet()) {
                        String masterColumnAliasName = (String)dsIdMasterColumnAliasName.get(dsIdTemp);
                        Object masterColumnValue = masterResult.get(masterColumnAliasName);
                        slaveWhereParams.put(masterColumnAliasName, masterColumnValue);
                        slaveWhereParams.put("selectListSql", slaveDsIdsqlMap.get(dsIdTemp));
                        childMap = this.lrBaseMapper.masterSelectList((Map)slaveWhereParams);
                        masterResult.put(dataserviceIdSlaveTableNameAlias.get(dsIdTemp), childMap);
                    }
                }
            }
            dataResult.put("data", masterResultList);
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
        return new InvokeResponse(true, (Object)dataResult);
    }

    @Override
    public InvokeResponse saveOrUpdateMasterSlave(Map<String, Object> params, String serviceId) throws EngineException {
        List<TLrServiceDetailTable> details = this.getServiceDetailByServiceId(serviceId);
        Set<String> dataServiceIds = details.stream().map(TLrServiceDetailTable::getDataserviceId).collect(Collectors.toSet());
        List<TLrDataserviceAutoConfig> autoConfigs = this.getDataServiceAutoConfigs(serviceId, dataServiceIds);
        TLrServiceDetailTable detail = details.get(0);
        String masterTabeldataServiceId = detail.getDataserviceId();
        HashMap tableIdDsIdMap = Maps.newHashMapWithExpectedSize((int)details.size());
        HashMap dsAutoConfMap = Maps.newHashMapWithExpectedSize((int)details.size());
        Set<String> dataserviceIdAll = dsAutoConfMap.keySet();
        Map<String, TLrMetadataDetail> detailMap = this.getMetadataDetails(serviceId, autoConfigs, tableIdDsIdMap, dsAutoConfMap);
        Map<String, String> dsTableNameMap = this.getDetailMetadataMap(serviceId, tableIdDsIdMap);
        Map<String, String> dsIdTableIdMap = this.getdsIdTableIdMap(tableIdDsIdMap);
        String tableName = dsTableNameMap.get(masterTabeldataServiceId);
        HashMap setsColumnMap = Maps.newHashMap();
        HashMap conditionsColumnMap = Maps.newHashMap();
        HashMap columnIdNameMap = Maps.newHashMapWithExpectedSize((int)2);
        this.validateSaveOrUpdateMasterParams(params, (List)dsAutoConfMap.get(masterTabeldataServiceId), detailMap, conditionsColumnMap, setsColumnMap, columnIdNameMap);
        TLrDataserviceConfigurationTable dataService = this.lrDataServiceMapper.selectTLrDataserviceConfigrationTableById(masterTabeldataServiceId);
        String modelId = dataService.getModelId();
        List relationships = this.relationshipMapper.selectTLrTableRelationshipListByModelId(modelId);
        Map<String, Map<String, String>> relMap = this.getTableRelMap(serviceId, dataService.getModelId(), relationships);
        List relationshipsSingle = relationships.stream().filter(r -> r.getRelationType() == 1L).collect(Collectors.toList());
        HashMap dsIdMetadetailSingle = Maps.newHashMap();
        HashSet dataserviceIdsSingle = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(relationshipsSingle)) {
            Set slavetableIdSingle = relationshipsSingle.stream().map(TLrTableRelationship::getSlaveTableId).collect(Collectors.toSet());
            tableIdDsIdMap.forEach((key, value) -> {
                if (slavetableIdSingle.contains(key)) {
                    dataserviceIdsSingle.add(value);
                }
            });
            for (String dsid : dataserviceIdsSingle) {
                String tableId = dsIdTableIdMap.get(dsid);
                String tableNamesingle = dsTableNameMap.get(dsid);
                this.validateEditSingleSlaveParams((List)dsAutoConfMap.get(dsid), detailMap, params, columnIdNameMap, relMap.get(tableId), dsid, dsIdMetadetailSingle, tableNamesingle);
            }
        }
        List relationshipsmult = relationships.stream().filter(r -> r.getRelationType() == 2L).collect(Collectors.toList());
        HashMap columnParamNameMap = Maps.newHashMap();
        HashMap dataserviceIdSlaveTableNameAlias = Maps.newHashMap();
        HashSet dataserviceIdsSlave = Sets.newHashSet();
        HashMap dsIdMetadetailMutl = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(relationshipsmult)) {
            Map slaveTableIdShipMap = relationshipsmult.stream().collect(Collectors.toMap(TLrTableRelationship::getSlaveTableId, Function.identity()));
            tableIdDsIdMap.forEach((key, value) -> {
                if (slaveTableIdShipMap.containsKey(key)) {
                    dataserviceIdSlaveTableNameAlias.put(value, ((TLrTableRelationship)slaveTableIdShipMap.get(key)).getTableNamesAlias());
                }
            });
            for (Object dsIdmult : dataserviceIdSlaveTableNameAlias.keySet()) {
                dataserviceIdsSlave.add(dsIdmult);
                String tableId = dsIdTableIdMap.get(dsIdmult);
                String tableNamemult = dsTableNameMap.get(dsIdmult);
                String slaveTableNameAlias = (String)dataserviceIdSlaveTableNameAlias.get(dsIdmult);
                List dataList = (List)params.get(slaveTableNameAlias);
                this.validateEditSlaveMutlParams(dataList, (List)dsAutoConfMap.get(dsIdmult), detailMap, columnParamNameMap, params, columnIdNameMap, relMap.get(tableId), (String)dsIdmult, tableNamemult, dsIdMetadetailMutl);
                params.put(slaveTableNameAlias, dataList);
            }
        }
        Map<String, String> columnIdColumnTypeMap = this.getcolumnIdColumnTypeMapBydataserviceIds(serviceId, dataserviceIdAll, dsAutoConfMap);
        HashMap<String, String> dsIdsqlMap = new HashMap<String, String>();
        for (TLrServiceDetailTable d : details) {
            String dataserviceId = d.getDataserviceId();
            String sql = this.getSqlByDetailId(dataserviceId);
            dsIdsqlMap.put(dataserviceId, sql);
        }
        Map<String, TLrDatasourceTable> dataSourceMap = this.getDataSources();
        TLrDatasourceTable dataSource = dataSourceMap.get(dataService.getDatasourceId());
        Object masterID = null;
        try {
            this.dynamicDataSourceService.switchDataSource(dataSource);
            masterID = this.transactionalExecuteService.executeSaveOrUpdateMasterSlave(masterTabeldataServiceId, tableName, params, dataserviceIdsSingle, dataserviceIdSlaveTableNameAlias, dsAutoConfMap, columnIdColumnTypeMap, setsColumnMap, conditionsColumnMap, dsIdMetadetailSingle, dsIdMetadetailMutl, dsIdsqlMap);
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
        return new InvokeResponse(true, masterID);
    }

    private void validateEditSlaveMutlParams(List<Map<String, Object>> paramList, List<TLrDataserviceAutoConfig> autoConfList, Map<String, TLrMetadataDetail> detailMap, Map<String, String> columnParamNameMap, Map<String, Object> masterParams, Map<String, String> masterParamNameMap, Map<String, String> slaveColsMap, String dsId, String tableName, Map<String, TLrMetadataDetail> dsIdMetadetailMutl) throws EngineException {
        TLrMetadataDetail demutl = new TLrMetadataDetail();
        demutl.setTableName(tableName);
        for (TLrDataserviceAutoConfig autoConf : autoConfList) {
            if (!"00".equals(autoConf.getPutType())) {
                return;
            }
            String columnId = autoConf.getColumnId();
            TLrMetadataDetail detail = detailMap.get(columnId);
            String userDefinedParam = autoConf.getColumnAliasDefined();
            columnParamNameMap.put(autoConf.getColumnAlias(), detail.getColumnName());
            String masterColId = slaveColsMap.get(columnId);
            String masterParamName = masterParamNameMap.get(masterColId);
            if (masterParamName != null && !"".equals(masterParamName.trim())) {
                demutl.setColumnName(detail.getColumnName());
                demutl.setColumnNameAlias(masterParamName);
            }
            dsIdMetadetailMutl.put(dsId, demutl);
            if (CollectionUtils.isEmpty(paramList)) continue;
            for (Map<String, Object> params : paramList) {
                if (!params.containsKey(userDefinedParam) || null == params.get(userDefinedParam) || "".equals(params.get(userDefinedParam).toString().trim())) {
                    params.put(userDefinedParam, null);
                }
                OscarLrMasterSlaveInvokeServiceImpl.preHandleDate(detail, userDefinedParam, params);
                if (null != detail.getIsPk() && detail.getIsPk() == 1) {
                    Object customIdslave = IdGenerateUtils.getId();
                    if (null != params.get(userDefinedParam) && !"".equals(String.valueOf(params.get(userDefinedParam)).trim())) {
                        customIdslave = params.get(userDefinedParam);
                    }
                    params.put(userDefinedParam, customIdslave);
                }
                if (!slaveColsMap.containsKey(columnId)) continue;
                params.put(autoConf.getColumnAlias(), masterParams.get(masterParamName));
            }
        }
    }

    private static void preHandleDate(TLrMetadataDetail detail, String userDefinedParam, Map<String, Object> params) throws EngineException {
        String paramValue;
        if ((detail.getColumnType().toUpperCase().contains("DATE") || detail.getColumnType().toUpperCase().contains("TIME")) && params.containsKey(userDefinedParam) && StringUtils.isNotEmpty((String)(paramValue = params.get(userDefinedParam).toString()))) {
            Date date = DateUtils.convertStringToDate((String)paramValue);
            params.put(userDefinedParam, date);
        }
        if (LRConstants.detail_type.contains(detail.getColumnType().toUpperCase()) && params.containsKey(userDefinedParam) && params.get(userDefinedParam) instanceof String && "".equals(String.valueOf(params.get(userDefinedParam)).trim())) {
            params.put(userDefinedParam, null);
        }
    }

    private void validateEditMasterParams(Map<String, Object> params, List<TLrDataserviceAutoConfig> autoConfigs, Map<String, TLrMetadataDetail> detailMap, Map<String, TLrMetadataDetail> conditionsMap, Map<String, TLrMetadataDetail> setsColumnMap, Map<String, String> columnIdNameMap) throws EngineException {
        Sets.SetView intersects;
        if (CollectionUtils.isEmpty(params)) {
            int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
            String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
            throw new EngineException(code, message);
        }
        if (params.size() == 1) {
            int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
            String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + "\u53c2\u6570\u4e0d\u80fd\u53ea\u6709\u4e00\u4e2a";
            throw new EngineException(code, message);
        }
        HashSet otherParams = Sets.newHashSet();
        HashMap paramColumnMap = Maps.newHashMap();
        for (TLrDataserviceAutoConfig autoConf : autoConfigs) {
            String userDefinedName = autoConf.getColumnAliasDefined();
            if ("00".equals(autoConf.getInputWhere())) {
                if (!params.containsKey(userDefinedName)) {
                    int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
                    String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + userDefinedName + "\u4e0d\u80fd\u4e3a\u7a7a";
                    throw new EngineException(code, message);
                }
                conditionsMap.put(userDefinedName, detailMap.get(autoConf.getColumnId()));
            } else {
                TLrMetadataDetail detail = detailMap.get(autoConf.getColumnId());
                OscarLrMasterSlaveInvokeServiceImpl.preHandleDate(detail, userDefinedName, params);
                otherParams.add(userDefinedName);
                paramColumnMap.put(userDefinedName, autoConf.getColumnId());
            }
            columnIdNameMap.put(autoConf.getColumnId(), userDefinedName);
        }
        Set<String> paramKeys = params.keySet();
        if (CollectionUtils.isEmpty((Collection)otherParams) || (intersects = Sets.intersection((Set)otherParams, paramKeys)).isEmpty()) {
            int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
            String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + "\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u975e\u6761\u4ef6\u53c2\u6570";
            throw new EngineException(code, message);
        }
        intersects.forEach(p -> {
            String columnId = (String)paramColumnMap.get(p);
            setsColumnMap.put((String)p, (TLrMetadataDetail)detailMap.get(columnId));
        });
    }

    private static void validateaddMasterParams(Map<String, Object> params, List<TLrDataserviceAutoConfig> autoConfList, Map<String, TLrMetadataDetail> detailMap, Map<String, String> columnIdNameMap) throws EngineException {
        if (CollectionUtils.isEmpty(params)) {
            int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
            String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
            throw new EngineException(code, message);
        }
        if (CollectionUtils.isEmpty(autoConfList)) {
            throw new EngineException(EngineExceptionEnum.PARAMS_CONFIGURATION_INFORMATION_EMPTY);
        }
        for (TLrDataserviceAutoConfig autoConf : autoConfList) {
            if (!"00".equals(autoConf.getPutType())) continue;
            String columnId = autoConf.getColumnId();
            TLrMetadataDetail detail = detailMap.get(columnId);
            String userDefinedParam = autoConf.getColumnAliasDefined();
            if (!params.containsKey(userDefinedParam) || null == params.get(userDefinedParam) || "".equals(params.get(userDefinedParam).toString().trim())) {
                params.put(userDefinedParam, null);
            }
            if (null != detail.getIsPk() && detail.getIsPk() == 1) {
                Object customId = IdGenerateUtils.getId();
                if (null != params.get(userDefinedParam) && !"".equals(String.valueOf(params.get(userDefinedParam)).trim())) {
                    customId = params.get(userDefinedParam);
                }
                params.put(userDefinedParam, customId);
            }
            OscarLrMasterSlaveInvokeServiceImpl.preHandleDate(detail, userDefinedParam, params);
            columnIdNameMap.put(columnId, userDefinedParam);
        }
    }

    private Map<String, String> getDetailMetadataMap(String serviceId, Map<String, String> tableIdDsIdMap) {
        String key = "LR:METADATA:TABLE:" + serviceId;
        Object obj = this.cacheService.get("lr-core-runtime", key);
        if (obj != null) {
            return (Map)obj;
        }
        HashMap dsTableNameMap = Maps.newHashMapWithExpectedSize((int)tableIdDsIdMap.size());
        ArrayList ids = Lists.newArrayList(tableIdDsIdMap.keySet());
        List tables = this.lrMetadataManageMapper.selectByIds((List)ids);
        if (CollectionUtils.isEmpty((Collection)tables)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        tables.forEach(c -> {
            String tableId = c.getTableId();
            dsTableNameMap.put(tableIdDsIdMap.get(tableId), c.getTableName());
        });
        this.cacheService.put("lr-core-runtime", key, (Object)dsTableNameMap);
        return dsTableNameMap;
    }

    private Map<String, TLrMetadataDetail> getMetadataDetails(String serviceId, List<TLrDataserviceAutoConfig> autoConfigs, Map<String, String> tableIdDsIdMap, Map<String, List<TLrDataserviceAutoConfig>> dsAutoConfMap) {
        ArrayList columnIds = Lists.newArrayListWithCapacity((int)5);
        for (TLrDataserviceAutoConfig autoConf : autoConfigs) {
            List<Object> subAutoConfigs;
            String dsId = autoConf.getDataserviceId();
            if ("00".equals(autoConf.getPutType())) {
                columnIds.add(autoConf.getColumnId());
            }
            tableIdDsIdMap.put(autoConf.getTableId(), dsId);
            if (dsAutoConfMap.containsKey(dsId)) {
                subAutoConfigs = dsAutoConfMap.get(dsId);
            } else {
                subAutoConfigs = Lists.newArrayList();
                dsAutoConfMap.put(dsId, (List<TLrDataserviceAutoConfig>)subAutoConfigs);
            }
            subAutoConfigs.add(autoConf);
        }
        String key = "LR:CORE:BUSINESS:INPUT:COLUMNS:" + serviceId;
        Object obj = this.cacheService.get("lr-core-runtime", key);
        if (obj != null) {
            return (Map)obj;
        }
        if (CollectionUtils.isEmpty((Collection)columnIds)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        List columns = this.lrMetadataDetailMapper.selectByIds((List)columnIds);
        if (CollectionUtils.isEmpty((Collection)columns)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Map<String, TLrMetadataDetail> detailMap = columns.stream().collect(Collectors.toMap(TLrMetadataDetail::getColumnId, Function.identity()));
        this.cacheService.put("lr-core-runtime", key, detailMap);
        return detailMap;
    }

    private Map<String, TLrDatasourceTable> getDataSources() {
        Object obj = this.cacheService.get("lr-core", "LR:CORE:DATASOURCE");
        if (obj != null) {
            return (Map)obj;
        }
        TLrDatasourceTable t = new TLrDatasourceTable();
        t.setStatus(Integer.valueOf(1));
        List dataSources = this.lrDataSourceMapper.selectTLrDatasourceTableList(t);
        if (CollectionUtils.isEmpty((Collection)dataSources)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Map<String, TLrDatasourceTable> dataSourceIdMap = dataSources.stream().collect(Collectors.toMap(TLrDatasourceTable::getDatasourceId, Function.identity()));
        this.cacheService.put("lr-core", "LR:CORE:DATASOURCE", dataSourceIdMap);
        return dataSourceIdMap;
    }

    private static void validateDeleteParams(Map<String, Object> params, String dataServiceId, List<TLrDataserviceAutoConfig> autoConfigs) throws EngineException {
        for (TLrDataserviceAutoConfig autoConf : autoConfigs) {
            String dsId = autoConf.getDataserviceId();
            String sqlParamName = autoConf.getColumnAliasDefined();
            if (!dsId.equals(dataServiceId) || !"00".equals(autoConf.getPutType())) continue;
            if (!params.containsKey(sqlParamName)) {
                int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
                String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + sqlParamName + "\u4e0d\u80fd\u4e3a\u7a7a";
                throw new EngineException(code, message);
            }
            OscarLrMasterSlaveInvokeServiceImpl.handleEachParamsDelete(sqlParamName, params.get(sqlParamName), params);
        }
    }

    private List<TLrDataserviceAutoConfig> getDataServiceAutoConfigs(String serviceId, Set<String> dataServiceIds) {
        String key = "LR:DATA:SERVICE:AUTOCONFIG:" + serviceId;
        Object obj = this.cacheService.get("lr-core-runtime", key);
        if (obj != null) {
            return (List)obj;
        }
        List autoConfigs = this.lrDataServiceAutoconfigMapper.selectByDataServiceIds(dataServiceIds);
        if (CollectionUtils.isEmpty((Collection)autoConfigs)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        this.cacheService.put("lr-core-runtime", key, (Object)autoConfigs);
        return autoConfigs;
    }

    private List<TLrServiceDetailTable> getServiceDetailByServiceId(String serviceId) {
        Map serviceDetailMap = (Map)this.cacheService.get("lr-core", "LR:CORE:BUSINESS:SERVICE:DETAILS");
        if (CollectionUtils.isEmpty((Map)serviceDetailMap) || !serviceDetailMap.containsKey(serviceId)) {
            TLrServiceDetailMapper lrServiceDetailMapper = (TLrServiceDetailMapper)SpringUtils.getBean((String)"lrServiceDetailMapper");
            List details = lrServiceDetailMapper.selectByServiceIds((List)Lists.newArrayList((Object[])new String[]{serviceId}));
            if (CollectionUtils.isEmpty((Map)serviceDetailMap)) {
                serviceDetailMap = Maps.newHashMapWithExpectedSize((int)1);
            }
            HashMap subServiceDetailMap = Maps.newHashMapWithExpectedSize((int)1);
            subServiceDetailMap.put((byte)1, details);
            serviceDetailMap.put(serviceId, subServiceDetailMap);
            this.cacheService.put("lr-core", "LR:CORE:BUSINESS:SERVICE:DETAILS", (Object)serviceDetailMap);
            return details;
        }
        Map treeSortDetailMap = (Map)serviceDetailMap.get(serviceId);
        if (CollectionUtils.isEmpty((Map)treeSortDetailMap)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList details = Lists.newArrayList();
        for (Map.Entry entry : treeSortDetailMap.entrySet()) {
            details.addAll((Collection)entry.getValue());
        }
        return details;
    }

    private void validateInfoParams(Map<String, Object> params, TLrServiceDetailTable detail, List<TLrDataserviceAutoConfig> autoConfigs, Map<String, String> tableIdDsIdMap) throws EngineException {
        String dataServiceId = detail.getDataserviceId();
        for (TLrDataserviceAutoConfig autoConf : autoConfigs) {
            String dsId = autoConf.getDataserviceId();
            String paramName = autoConf.getColumnAliasDefined();
            if (dsId.equals(dataServiceId) && "00".equals(autoConf.getPutType()) && !params.containsKey(paramName)) {
                int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
                String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + paramName + "\u4e0d\u80fd\u4e3a\u7a7a";
                throw new EngineException(code, message);
            }
            tableIdDsIdMap.put(autoConf.getTableId(), dsId);
        }
    }

    private void getTableIdDsIdMap(List<TLrDataserviceAutoConfig> autoConfigs, Map<String, String> tableIdDsIdMap, Map<String, List<TLrDataserviceAutoConfig>> dsAutoConfMap) {
        for (TLrDataserviceAutoConfig autoConf : autoConfigs) {
            List<Object> subAutoConfigs;
            String dsId = autoConf.getDataserviceId();
            tableIdDsIdMap.put(autoConf.getTableId(), dsId);
            if (dsAutoConfMap.containsKey(dsId)) {
                subAutoConfigs = dsAutoConfMap.get(dsId);
            } else {
                subAutoConfigs = Lists.newArrayList();
                dsAutoConfMap.put(dsId, (List<TLrDataserviceAutoConfig>)subAutoConfigs);
            }
            subAutoConfigs.add(autoConf);
        }
    }

    private void executeQuery(Map<String, Object> params, List<TLrDataserviceAutoConfig> autoConfList) {
        if (null == params) {
            params = Maps.newHashMapWithExpectedSize((int)1);
        }
        for (TLrDataserviceAutoConfig autoConf : autoConfList) {
            String columnNameAlias = autoConf.getColumnAliasDefined();
            if (!params.containsKey(columnNameAlias)) continue;
            OscarLrMasterSlaveInvokeServiceImpl.handleEachParamsList(columnNameAlias, params.get(columnNameAlias), params, autoConf.getDictCode());
        }
    }

    private static void handleEachParamsList(String columnAlias, Object obj, Map<String, Object> params, Long dictCode) {
        long[] multiCodes = new long[]{124L, 125L};
        if (dictCode == null || !ArrayUtils.contains((long[])multiCodes, (long)dictCode)) {
            params.put(columnAlias, obj);
            return;
        }
        String val = obj.toString();
        if (obj.getClass().isArray()) {
            Object[] objs = (String[])obj;
            val = Joiner.on((String)",").skipNulls().join(objs);
        }
        params.put(FOREACH_COLUMN, Joiner.on((String)",").skipNulls().join(params.get(FOREACH_COLUMN), (Object)columnAlias, new Object[0]));
        int i = 1;
        Iterable values = Splitter.on((String)",").trimResults().split((CharSequence)val);
        String foreachStr = null;
        for (String value : values) {
            String key = columnAlias + i;
            params.put(key, CommonUtils.executeDataStr((Object)value));
            foreachStr = Joiner.on((String)",").skipNulls().join(foreachStr, (Object)("#{" + key + "}"), new Object[0]);
            ++i;
        }
        params.put(FOREACH_PREFIX + columnAlias, foreachStr);
    }

    private static String perfectSql(String sql, Map<String, Object> params) {
        if (sql == null) {
            return sql;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (!sql.contains("#{" + entry.getKey() + "}")) continue;
            sql = sql.replace("#{" + entry.getKey() + "}", "#{lr." + entry.getKey() + "}");
        }
        if (params.containsKey(FOREACH_COLUMN)) {
            String columnStr = (String)params.get(FOREACH_COLUMN);
            Iterable columns = Splitter.on((String)",").trimResults().split((CharSequence)columnStr);
            for (String column : columns) {
                String key = FOREACH_PREFIX + column;
                sql = sql.replace("#{lr." + key + "}", (String)params.get(key));
            }
        }
        return sql;
    }

    private void executeQueryPage(Map<String, Object> params, List<TLrDataserviceAutoConfig> autoConfList, Set<String> dataServiceIds) {
        if (null == params) {
            params = Maps.newHashMapWithExpectedSize((int)1);
        }
        for (TLrDataserviceAutoConfig autoConf : autoConfList) {
            String columnNameAlias;
            if (!"00".equals(autoConf.getPutType()) || !params.containsKey(columnNameAlias = autoConf.getColumnAliasDefined())) continue;
            OscarLrMasterSlaveInvokeServiceImpl.handleEachParamsPage(columnNameAlias, params.get(columnNameAlias), params, autoConf.getDictCode());
        }
    }

    private static void handleEachParamsPage(String columnAlias, Object obj, Map<String, Object> params, Long dictCode) {
        long[] multiCodes = new long[]{124L, 125L};
        if (dictCode == null || !ArrayUtils.contains((long[])multiCodes, (long)dictCode)) {
            params.put(columnAlias, obj);
            return;
        }
        String val = obj.toString();
        if (obj.getClass().isArray()) {
            Object[] objs = (String[])obj;
            val = Joiner.on((String)",").skipNulls().join(objs);
        }
        params.put(FOREACH_COLUMN, Joiner.on((String)",").skipNulls().join(params.get(FOREACH_COLUMN), (Object)columnAlias, new Object[0]));
        int i = 1;
        Iterable values = Splitter.on((String)",").trimResults().split((CharSequence)val);
        String foreachStr = null;
        for (String value : values) {
            String key = columnAlias + i;
            params.put(key, CommonUtils.executeDataStr((Object)value));
            foreachStr = Joiner.on((String)",").skipNulls().join(foreachStr, (Object)("#{lr." + key + "}"), new Object[0]);
            ++i;
        }
        params.put(FOREACH_PREFIX + columnAlias, foreachStr);
    }

    private static String perfectSqlList(String sql, Map<String, Object> params) {
        if (sql == null) {
            return sql;
        }
        if (params.containsKey(FOREACH_COLUMN)) {
            String columnStr = (String)params.get(FOREACH_COLUMN);
            Iterable columns = Splitter.on((String)",").trimResults().split((CharSequence)columnStr);
            for (String column : columns) {
                String key = FOREACH_PREFIX + column;
                sql = sql.replace("#{" + key + "}", (String)params.get(key));
            }
        }
        return sql;
    }

    private static void handleEachParamsDelete(String columnAlias, Object obj, Map<String, Object> params) {
        if (!obj.toString().contains(",")) {
            params.put(columnAlias, obj);
            return;
        }
        Object[] objs = obj.toString().split(",");
        String val = Joiner.on((String)",").skipNulls().join(objs);
        params.put(FOREACH_COLUMN, Joiner.on((String)",").skipNulls().join(params.get(FOREACH_COLUMN), (Object)columnAlias, new Object[0]));
        int i = 1;
        Iterable values = Splitter.on((String)",").trimResults().split((CharSequence)val);
        String foreachStr = null;
        for (String value : values) {
            String key = columnAlias + i;
            params.put(key, CommonUtils.executeDataStr((Object)value));
            foreachStr = Joiner.on((String)",").skipNulls().join(foreachStr, (Object)("#{" + key + "}"), new Object[0]);
            ++i;
        }
        params.put(FOREACH_PREFIX + columnAlias, foreachStr);
    }

    private void validateSaveOrUpdateMasterParams(Map<String, Object> params, List<TLrDataserviceAutoConfig> autoConfigs, Map<String, TLrMetadataDetail> detailMap, Map<String, TLrMetadataDetail> conditionsMap, Map<String, TLrMetadataDetail> setsColumnMap, Map<String, String> columnIdNameMap) throws EngineException {
        if (CollectionUtils.isEmpty(params)) {
            int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
            String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
            throw new EngineException(code, message);
        }
        HashSet otherParams = Sets.newHashSet();
        HashMap paramColumnMap = Maps.newHashMap();
        for (TLrDataserviceAutoConfig autoConf : autoConfigs) {
            String userDefinedName = autoConf.getColumnAliasDefined();
            if ("00".equals(autoConf.getInputWhere())) {
                TLrMetadataDetail tLrMetadataDetail = this.lrMetadataDetailMapper.selectMetadataDetailBycolumnId(autoConf.getColumnId());
                tLrMetadataDetail.setTableName(this.lrMetadataManageMapper.getTableNameById(tLrMetadataDetail.getTableId()));
                conditionsMap.put(userDefinedName, tLrMetadataDetail);
            } else {
                TLrMetadataDetail detail = detailMap.get(autoConf.getColumnId());
                OscarLrMasterSlaveInvokeServiceImpl.preHandleDate(detail, userDefinedName, params);
                if (!params.containsKey(userDefinedName) || null == params.get(userDefinedName) || "".equals(params.get(userDefinedName).toString().trim())) {
                    params.put(userDefinedName, null);
                }
                otherParams.add(userDefinedName);
                paramColumnMap.put(userDefinedName, autoConf.getColumnId());
            }
            columnIdNameMap.put(autoConf.getColumnId(), userDefinedName);
        }
        Set<String> paramKeys = params.keySet();
        Sets.SetView intersects = Sets.intersection((Set)otherParams, paramKeys);
        intersects.forEach(p -> {
            String columnId = (String)paramColumnMap.get(p);
            setsColumnMap.put((String)p, (TLrMetadataDetail)detailMap.get(columnId));
        });
    }
}

