/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.oscar.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.engine.metadata.dao.TLrMetadataManageTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrPlatformTableMapper;
import com.jxdinfo.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.engine.metadata.model.TLrMetadataDetail;
import com.jxdinfo.engine.metadata.model.TLrMetadataManageTable;
import com.jxdinfo.engine.metadata.service.DynamicDataSourceService;
import com.jxdinfo.engine.metadata.strategy.TLrPlatformTableFactory;
import com.jxdinfo.engine.metadata.util.DateUtils;
import com.jxdinfo.engine.metadata.util.IdAcquisitionUtil;
import com.jxdinfo.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.engine.metadata.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DS(value="master")
public class OscarLrImportTable2DbService {
    @Autowired
    private TLrMetadataManageTableMapper tLrMetadataManageTableMapper;
    @Autowired
    private DynamicDataSourceService dynamicDataSourceService;
    private static final Map<String, TLrPlatformTableMapper> METADATA_DETAIL_MAPPERS = TLrPlatformTableFactory.getMappers((String)"metadataDetail");

    public void saveTableInfo(List<TLrMetadataManageTable> tables, List<TLrMetadataDetail> columns, String datasourceId, String userId) throws EngineException {
        List<TLrMetadataDetail> tabCols;
        String tableName;
        HashMap tabColMap = Maps.newHashMapWithExpectedSize((int)tables.size());
        for (TLrMetadataDetail col : columns) {
            tableName = col.getTableName();
            if (tabColMap.containsKey(tableName)) {
                tabCols = (List)tabColMap.get(tableName);
            } else {
                tabCols = Lists.newArrayListWithCapacity((int)columns.size());
                tabColMap.put(tableName, tabCols);
            }
            tabCols.add(col);
        }
        String datasourceType = this.dynamicDataSourceService.getDatasourceType();
        for (TLrMetadataManageTable tab : tables) {
            tableName = tab.getTableName();
            tabCols = (List)tabColMap.get(tableName);
            tab.setTableId(IdGenerateUtils.getId().toString());
            tab.setCountColumn(Long.valueOf(tabCols.size()));
            tab.setDatasourceId(datasourceId);
            tab.setUserId(userId);
            tab.setCreateTime(DateUtils.getNowDate());
            String characterSet = tab.getCharacterSet();
            if (StringUtils.isEmpty((String)characterSet)) {
                tab.setCharacterSet("utf8");
            } else {
                tab.setCharacterSet(characterSet.contains("_") ? characterSet.split("_")[0] : characterSet);
            }
            tab.setStatus(Integer.valueOf(1));
            tab.setVersion(Long.valueOf(1L));
            tab.setRemark(tab.getTableComment());
            tab.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            if (StringUtils.isEmpty((String)tab.getTableChname())) {
                tab.setTableChname(tab.getTableName());
            }
            if (StringUtils.isEmpty((String)tab.getTableComment())) {
                tab.setTableComment(tab.getTableName());
            }
            if (StringUtils.isEmpty((String)tab.getRemark())) {
                tab.setRemark(tab.getTableName());
            }
            try {
                this.tLrMetadataManageTableMapper.insertTLrMetadataManageTable(tab);
            }
            catch (Exception e) {
                throw new EngineException(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED);
            }
            for (TLrMetadataDetail col : tabCols) {
                col.setColumnId(IdGenerateUtils.getId().toString());
                col.setTableId(tab.getTableId());
                col.setCreateTime(DateUtils.getNowDate());
                col.setStatus(Integer.valueOf(1));
                col.setColumnType(col.getColumnType().toUpperCase());
                col.setDefaultValue(StringUtils.isEmpty((String)col.getDefaultValue()) ? "" : col.getDefaultValue());
                col.setPointLength(Integer.valueOf(col.getPointLength() == null ? 0 : col.getPointLength()));
                if (StringUtils.isEmpty((String)col.getColumnChname())) {
                    col.setColumnChname(col.getColumnName());
                }
                if (StringUtils.isEmpty((String)col.getColumnComment())) {
                    col.setColumnComment(col.getColumnName());
                }
                col.setUserId(userId);
                col.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            }
            try {
                METADATA_DETAIL_MAPPERS.get(datasourceType).batchInsert(tabCols);
            }
            catch (Exception e) {
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
    }
}

