/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.oscar.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.engine.common.util.LrTenantUtil;
import com.jxdinfo.engine.metadata.constant.LRConstants;
import com.jxdinfo.engine.metadata.dao.TLrDataServiceSqlMapper;
import com.jxdinfo.engine.metadata.dao.TLrDataserviceConfigrationTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrDatasourceTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrImplementsMapper;
import com.jxdinfo.engine.metadata.dao.TLrMetadataDetailMapper;
import com.jxdinfo.engine.metadata.dao.TLrMetadataManageTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrPlatformTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrServiceDetailMapper;
import com.jxdinfo.engine.metadata.dao.TLrServiceTableMapper;
import com.jxdinfo.engine.metadata.enums.ConnectEnum;
import com.jxdinfo.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.engine.metadata.model.ConstraintionVO;
import com.jxdinfo.engine.metadata.model.DbMetadataImportParam;
import com.jxdinfo.engine.metadata.model.InputColumnVO;
import com.jxdinfo.engine.metadata.model.OutputColumnVO;
import com.jxdinfo.engine.metadata.model.TLrDataServiceSql;
import com.jxdinfo.engine.metadata.model.TLrDataserviceAutoConfig;
import com.jxdinfo.engine.metadata.model.TLrDataserviceConfigurationTable;
import com.jxdinfo.engine.metadata.model.TLrDatasourceTable;
import com.jxdinfo.engine.metadata.model.TLrImplements;
import com.jxdinfo.engine.metadata.model.TLrMetadataDetail;
import com.jxdinfo.engine.metadata.model.TLrMetadataManageTable;
import com.jxdinfo.engine.metadata.model.TLrMetadataParam;
import com.jxdinfo.engine.metadata.model.TLrServiceDetailTable;
import com.jxdinfo.engine.metadata.model.TLrServiceTable;
import com.jxdinfo.engine.metadata.service.DynamicDataSourceService;
import com.jxdinfo.engine.metadata.strategy.TLrPlatformTableFactory;
import com.jxdinfo.engine.metadata.util.DateUtils;
import com.jxdinfo.engine.metadata.util.IdAcquisitionUtil;
import com.jxdinfo.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.engine.metadata.util.StringUtils;
import com.jxdinfo.engine.oscar.dao.OscarlTargetDataBaseMapper;
import com.jxdinfo.engine.oscar.service.IOscarLrCacheSyncService;
import com.jxdinfo.engine.oscar.service.IOscarLrMetadataManageTableService;
import com.jxdinfo.engine.oscar.service.impl.OscarLrImportTable2DbService;
import com.jxdinfo.engine.oscar.service.impl.OscarLrMasterSlaveModelServiceImpl;
import com.jxdinfo.engine.oscar.service.impl.OscarLrMetadataTableServiceImpl;
import com.jxdinfo.speedcode.datasource.FormDesignDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@DS(value="master")
public class OscarLrMetadataManageTableServiceImpl
implements IOscarLrMetadataManageTableService {
    private static final Logger log = LoggerFactory.getLogger(OscarLrMasterSlaveModelServiceImpl.class);
    private static final List<String> PROCESS_TABLENAMES = Arrays.asList("ACT_RU_IDENTITYLINK", "ACT_RU_TASK", "ACT_HI_PROCINST", "ACT_HI_TASKINST");
    @Autowired
    private TLrDataserviceConfigrationTableMapper tLrDataserviceConfigrationTableMapper;
    @Autowired
    private TLrDataServiceSqlMapper tLrDataServiceSqlMapper;
    @Autowired
    private TLrServiceTableMapper tLrServiceTableMapper;
    @Autowired
    private TLrServiceDetailMapper serviceDetailMapper;
    @Autowired
    private TLrImplementsMapper implementsMapper;
    @Autowired
    private TLrMetadataManageTableMapper tLrMetadataManageTableMapper;
    @Autowired
    private OscarlTargetDataBaseMapper targetDataBaseOscarMapper;
    @Autowired
    private TLrMetadataDetailMapper tLrMetadataDetailMapper;
    @Autowired
    private OscarLrMetadataTableServiceImpl lrMetadataTableServiceForOscar;
    @Autowired
    private TLrDatasourceTableMapper tLrDatasourceTableMapper;
    @Autowired
    private DynamicDataSourceService dynamicDataSourceService;
    @Autowired
    private IOscarLrCacheSyncService oscarLrCacheSyncService;
    @Autowired
    private OscarLrImportTable2DbService importTable2DbService;

    @Override
    public List<TLrMetadataManageTable> selectTLrMetadataManageTableList(TLrMetadataManageTable tLrMetadataManageTable) {
        if (StringUtils.isNotEmpty((String)tLrMetadataManageTable.getTableName())) {
            tLrMetadataManageTable.setTableName("%" + tLrMetadataManageTable.getTableName() + "%");
        }
        if (StringUtils.isNotEmpty((String)tLrMetadataManageTable.getTableChname())) {
            tLrMetadataManageTable.setTableChname("%" + tLrMetadataManageTable.getTableChname() + "%");
        }
        if (StringUtils.isNotEmpty((String)tLrMetadataManageTable.getTableComment())) {
            tLrMetadataManageTable.setTableChname("%" + tLrMetadataManageTable.getTableChname() + "%");
        }
        tLrMetadataManageTable.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        return this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableList(tLrMetadataManageTable);
    }

    @Override
    public TLrMetadataManageTable selectTLrMetadataManageTableByTableName(TLrMetadataManageTable tLrMetadataManageTable) {
        tLrMetadataManageTable.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        TLrMetadataManageTable tLrMetadataManageTableFound = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableByTableName(tLrMetadataManageTable);
        if (StringUtils.isNotNull((Object)tLrMetadataManageTableFound)) {
            tLrMetadataManageTableFound.setTableDetailList(this.tLrMetadataDetailMapper.selectColumnInfo(tLrMetadataManageTableFound.getTableId()));
        }
        return tLrMetadataManageTableFound;
    }

    @Override
    public TLrMetadataDetail selectColumnInfoByColumnName(TLrMetadataDetail tLrMetadataDetail) {
        tLrMetadataDetail.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        return this.tLrMetadataDetailMapper.selectColumnInfoByColumnName(tLrMetadataDetail);
    }

    @Override
    public boolean insertTLrMetadataManageTable(TLrMetadataParam paramData) throws EngineException {
        return this.lrMetadataTableServiceForOscar.insertTLrMetadataManageTable(paramData);
    }

    @Override
    public boolean import2LrDb(DbMetadataImportParam importParam) throws EngineException {
        List<TLrMetadataDetail> columns;
        List<TLrMetadataManageTable> tables;
        List tableNames = importParam.getTableNames();
        String datasourceId = importParam.getDatasourceId();
        String userId = IdAcquisitionUtil.getCurrentUserId();
        String tenantId = IdAcquisitionUtil.getCurrentTenantId();
        TLrDatasourceTable datasourceTable = this.tLrDatasourceTableMapper.selectTLrDatasourceTableByDatasourceId(datasourceId);
        if (Objects.isNull(datasourceTable)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        if (!tenantId.equalsIgnoreCase(datasourceTable.getTenantId())) {
            int code = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getCode();
            String message = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getMessage() + datasourceTable.getDatasourceName() + "\u7684\u8868";
            throw new EngineException(code, message);
        }
        List exists = this.tLrMetadataManageTableMapper.selectByTableNamesAndDsId(tableNames, datasourceId);
        if (!CollectionUtils.isEmpty((Collection)exists)) {
            List names = exists.stream().map(TLrMetadataManageTable::getTableName).collect(Collectors.toList());
            int code = EngineExceptionEnum.DUPLICATE_TABLE_NAME.getCode();
            String message = "\u5f53\u524d\u8868\u540d" + names + "\u5df2\u7ecf\u5b58\u5728";
            throw new EngineException(code, message);
        }
        try {
            this.dynamicDataSourceService.switchDataSource(datasourceTable);
            tables = this.targetDataBaseOscarMapper.selectTablesByTableNames(tableNames, datasourceTable.getDatasourceUsername());
            columns = this.targetDataBaseOscarMapper.selectColumnsByTableNames(tableNames, datasourceTable.getDatasourceUsername());
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.TABLE_INFORMATION_NOT_OBTAINED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
        if (CollectionUtils.isEmpty(tables)) {
            throw new EngineException(EngineExceptionEnum.TABLE_INFORMATION_NOT_OBTAINED);
        }
        if (CollectionUtils.isEmpty(columns)) {
            throw new EngineException(EngineExceptionEnum.COLUMN_INFORMATION_NOT_OBTAINED);
        }
        this.importTable2DbService.saveTableInfo(tables, columns, datasourceId, userId);
        return true;
    }

    @Override
    public boolean synchronizedUpdate(DbMetadataImportParam importParam) throws EngineException {
        List<TLrMetadataDetail> columns;
        List<TLrMetadataManageTable> tables;
        TLrDatasourceTable datasourceTable;
        List tableNames = importParam.getTableNames();
        String datasourceId = importParam.getDatasourceId();
        String tenantId = IdAcquisitionUtil.getCurrentTenantId();
        if (!tenantId.equalsIgnoreCase((datasourceTable = this.tLrDatasourceTableMapper.selectTLrDatasourceTableByDatasourceId(datasourceId)).getTenantId())) {
            int code = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getCode();
            String message = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getMessage() + datasourceTable.getDatasourceName() + "\u7684\u8868";
            throw new EngineException(code, message);
        }
        List exists = this.tLrMetadataManageTableMapper.selectByTableNamesAndDsId(tableNames, datasourceId);
        List names = exists.stream().map(TLrMetadataManageTable::getTableName).collect(Collectors.toList());
        names.retainAll(tableNames);
        if (CollectionUtils.isEmpty((Collection)exists) || names.size() != tableNames.size()) {
            int code = EngineExceptionEnum.TABLE_NOT_EXIST.getCode();
            tableNames.removeAll(names);
            String message = "\u5f53\u524d\u8868\u540d" + tableNames + "\u5e73\u53f0\u4e2d\u4e0d\u5b58\u5728";
            throw new EngineException(code, message);
        }
        try {
            this.dynamicDataSourceService.switchDataSource(datasourceTable);
            tables = this.targetDataBaseOscarMapper.selectTablesByTableNames(tableNames, datasourceTable.getDatasourceUsername());
            columns = this.targetDataBaseOscarMapper.selectColumnsByTableNames(tableNames, datasourceTable.getDatasourceUsername());
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.TABLE_INFORMATION_NOT_OBTAINED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
        if (CollectionUtils.isEmpty(tables)) {
            throw new EngineException(EngineExceptionEnum.TABLE_INFORMATION_NOT_OBTAINED);
        }
        if (CollectionUtils.isEmpty(columns)) {
            throw new EngineException(EngineExceptionEnum.COLUMN_INFORMATION_NOT_OBTAINED);
        }
        List tablesOld = this.tLrMetadataManageTableMapper.selectByTableNamesAndDsId(tableNames, datasourceId);
        tablesOld.forEach(table -> table.setTableDetailList(this.tLrMetadataDetailMapper.selectByTableId(table.getTableId())));
        List<TLrMetadataParam> metadataParams = this.prepareBeforeUpdate(tables, columns, datasourceId, tablesOld);
        metadataParams.forEach(item -> {
            try {
                this.lrMetadataTableServiceForOscar.updateTableInfo((TLrMetadataParam)item);
            }
            catch (EngineException e) {
                e.printStackTrace();
            }
        });
        return true;
    }

    @Override
    public boolean updateTLrMetadataManageTable(TLrMetadataParam paramData) throws EngineException {
        return this.lrMetadataTableServiceForOscar.updateTLrMetadataManageTable(paramData);
    }

    @Override
    public String saveSingleTableService(TLrDataserviceConfigurationTable tLrDataserviceConfigurationTable) throws EngineException {
        TLrDatasourceTable datasourceTable = this.tLrDatasourceTableMapper.selectTLrDatasourceTableByDatasourceId(tLrDataserviceConfigurationTable.getDatasourceId());
        String tenantId = IdAcquisitionUtil.getCurrentTenantId();
        if (Objects.isNull(datasourceTable)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        if (!tenantId.equalsIgnoreCase(datasourceTable.getTenantId())) {
            int code = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getCode();
            String message = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getMessage() + datasourceTable.getDatasourceName();
            throw new EngineException(code, message);
        }
        TLrMetadataManageTable baseInfo = StringUtils.isNotEmpty((Collection)tLrDataserviceConfigurationTable.getInputColumnVOList()) ? this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(((InputColumnVO)tLrDataserviceConfigurationTable.getInputColumnVOList().get(0)).getInTableId()) : this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(((OutputColumnVO)tLrDataserviceConfigurationTable.getOutputColumnVOList().get(0)).getOutTableId());
        if (Objects.isNull(baseInfo)) {
            throw new EngineException(EngineExceptionEnum.TABLE_NOT_EXIST);
        }
        this.getReleaseVersion(baseInfo);
        TLrImplements tLrImplements = this.getCreateUrl(tLrDataserviceConfigurationTable);
        baseInfo.setUpdateByUserid(IdAcquisitionUtil.getCurrentUserId());
        baseInfo.setUpdateTime(DateUtils.getNowDate());
        this.tLrMetadataManageTableMapper.updateTLrMetadataManageTable(baseInfo);
        return tLrImplements.getServiceId();
    }

    @Override
    public boolean insertView(TLrMetadataParam paramData) throws EngineException {
        return this.lrMetadataTableServiceForOscar.insertView(paramData);
    }

    void getReleaseVersion(TLrMetadataManageTable metadata) {
        if (null == metadata.getReleaseVersion()) {
            metadata.setReleaseVersion(Integer.valueOf(1));
        } else {
            metadata.setReleaseVersion(Integer.valueOf(metadata.getReleaseVersion() + 1));
        }
    }

    private String insertDataServiceTable(TLrDataserviceConfigurationTable tLrDataserviceConfigurationTable) throws EngineException {
        String dataServiceId = IdGenerateUtils.getId().toString();
        tLrDataserviceConfigurationTable.setDataserviceId(dataServiceId);
        tLrDataserviceConfigurationTable.setDataserviceChname(dataServiceId + System.currentTimeMillis());
        tLrDataserviceConfigurationTable.setDataserviceName(dataServiceId + System.currentTimeMillis());
        tLrDataserviceConfigurationTable.setCreateTime(DateUtils.getNowDate());
        tLrDataserviceConfigurationTable.setDataserviceStatus(LRConstants.data_statuts_release);
        tLrDataserviceConfigurationTable.setUserId(IdAcquisitionUtil.getCurrentUserId());
        tLrDataserviceConfigurationTable.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        tLrDataserviceConfigurationTable.setStatus(Integer.valueOf(1));
        tLrDataserviceConfigurationTable.setRemark(this.getRemarkDetail(tLrDataserviceConfigurationTable.getMapperType()));
        try {
            this.tLrDataserviceConfigrationTableMapper.insertTLrDataServiceConfigurationTable(tLrDataserviceConfigurationTable);
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.INSERT_DATA_SERVICE_FAILED, (Throwable)e);
        }
        return dataServiceId;
    }

    private void getDataServiceConfigSql(TLrDataserviceConfigurationTable d) {
        List outputColumnVOList = d.getOutputColumnVOList();
        TLrMetadataManageTable metadataManageTable = new TLrMetadataManageTable();
        if ("SELECT".equals(d.getMapperType())) {
            String tableId = ((OutputColumnVO)outputColumnVOList.get(0)).getOutTableId();
            metadataManageTable = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(tableId);
        }
        if (null != metadataManageTable.getViewFlag() && metadataManageTable.getViewFlag() == 1) {
            if ("SELECT".equals(d.getMapperType())) {
                ArrayList<TLrDataserviceAutoConfig> autoList = new ArrayList<TLrDataserviceAutoConfig>();
                List in = d.getInputColumnVOList();
                List out = d.getOutputColumnVOList();
                StringBuilder outBuilder = new StringBuilder();
                outBuilder.append("SELECT ");
                for (OutputColumnVO o : out) {
                    TLrDataserviceAutoConfig autoOut = new TLrDataserviceAutoConfig();
                    autoOut.setId(IdGenerateUtils.getId().toString());
                    autoOut.setDataserviceId(d.getDataserviceId());
                    autoOut.setColumnId(o.getOutColumnId());
                    autoOut.setTableId(o.getOutTableId());
                    autoOut.setPutType("01");
                    autoOut.setDictCode(o.getOutDictCode());
                    autoOut.setColumnAlias(o.getColumnAliasDefined());
                    autoOut.setColumnAliasDefined(o.getColumnAliasDefined());
                    autoOut.setStatus(Integer.valueOf(1));
                    autoOut.setUserId(IdAcquisitionUtil.getCurrentUserId());
                    autoOut.setCreateTime(DateUtils.getNowDate());
                    autoOut.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
                    autoList.add(autoOut);
                    if (StringUtils.isNotNull((Object)o.getFunctionFlag())) {
                        outBuilder.append(o.getFunctionFlag()).append("(").append("\"").append(o.getColumnName()).append("\"").append(")").append("  \"").append(o.getColumnAliasDefined()).append("\"  ").append(" ,");
                        continue;
                    }
                    outBuilder.append("\"").append(o.getColumnName()).append("\"").append("  \"").append(o.getColumnAliasDefined()).append("\"  ").append(" ,");
                }
                StringBuilder groupByBuilder = new StringBuilder();
                groupByBuilder.append(" ").append(" GROUP BY ");
                boolean groupBy = false;
                StringBuilder sortBuilder = new StringBuilder();
                sortBuilder.append(" ORDER BY  ");
                boolean sortFlag = false;
                List constraintionVoList = d.getConList();
                if (StringUtils.isNotEmpty((Collection)constraintionVoList)) {
                    List groupByCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(1)).collect(Collectors.toList());
                    List sortCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(2)).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(groupByCon)) {
                        for (ConstraintionVO c2 : groupByCon) {
                            groupBy = true;
                            groupByBuilder.append("\"").append(c2.getColumnName()).append("\" ").append(",");
                        }
                    }
                    if (!CollectionUtils.isEmpty(sortCon)) {
                        for (ConstraintionVO c2 : sortCon) {
                            sortFlag = true;
                            String columnNameSort = "\"" + c2.getColumnName() + "\"";
                            if (c2.getConstraintOper().equals(21)) {
                                sortBuilder.append(columnNameSort).append(" ASC,");
                                continue;
                            }
                            if (!c2.getConstraintOper().equals(22)) continue;
                            sortBuilder.append(columnNameSort).append(" DESC,");
                        }
                    }
                }
                String outStr = outBuilder.toString().substring(0, outBuilder.length() - 1);
                String groupStr = groupByBuilder.toString().substring(0, groupByBuilder.length() - 1);
                String sortStr = sortBuilder.toString().substring(0, sortBuilder.length() - 1);
                StringBuilder selectBuilder = new StringBuilder();
                selectBuilder.append(outStr).append(" FROM ").append(" (").append(metadataManageTable.getViewSql()).append(") ");
                if (StringUtils.isNotEmpty((Collection)in)) {
                    StringBuilder whereBuilder = new StringBuilder();
                    whereBuilder.append(" WHERE ");
                    this.getSqlPart(in, d, whereBuilder, autoList);
                    String whereStr = this.getWhereSql(whereBuilder);
                    selectBuilder.append(whereStr);
                } else {
                    selectBuilder.append(" WHERE ");
                }
                if (groupBy) {
                    selectBuilder.append(groupStr);
                }
                if (sortFlag) {
                    selectBuilder.append(sortStr);
                }
                String selectSql = selectBuilder.toString();
                log.info("selectSql====={}", (Object)selectSql);
                d.setSql(selectSql);
                d.setAutoConfigList(autoList);
            }
            return;
        }
        ArrayList<TLrDataserviceAutoConfig> autoList = new ArrayList<TLrDataserviceAutoConfig>();
        if ("INSERT".equals(d.getMapperType()) || "SAVEORUPDATE".equalsIgnoreCase(d.getMapperType()) || "SAVEORUPDATEBATCH".equalsIgnoreCase(d.getMapperType()) || "EDITSAVEORUPDATEBATCH".equalsIgnoreCase(d.getMapperType())) {
            List in = d.getInputColumnVOList();
            StringBuffer insertBuffer = new StringBuffer();
            insertBuffer.append("INSERT").append(" INTO ").append(" \"").append(((InputColumnVO)in.get(0)).getTableName()).append("\" ").append(" (");
            StringBuilder valueBuffer = new StringBuilder();
            valueBuffer.append(" VALUES  (");
            for (InputColumnVO i : in) {
                TLrDataserviceAutoConfig auto = new TLrDataserviceAutoConfig();
                this.getInAutoConfig(auto, i, d);
                insertBuffer.append("  \"" + i.getColumnName() + "\",");
                valueBuffer.append(" #{").append(i.getColumnAliasDefined()).append("},");
                autoList.add(auto);
            }
            String insertStr = insertBuffer.toString().substring(0, insertBuffer.toString().length() - 1);
            String valueStr = valueBuffer.toString().substring(0, valueBuffer.toString().length() - 1);
            insertBuffer.delete(0, insertBuffer.length());
            insertBuffer.append(insertStr).append(")").append(valueStr).append(")");
            String insertSql = insertBuffer.toString();
            log.info("insertSql==={}", (Object)insertSql);
            d.setSql(insertSql);
            d.setAutoConfigList(autoList);
        } else if ("UPDATE".equals(d.getMapperType())) {
            List in = d.getInputColumnVOList();
            StringBuffer updateBuffer = new StringBuffer();
            updateBuffer.append("UPDATE").append(" \"").append(((InputColumnVO)in.get(0)).getTableName()).append("\" ").append(" SET ");
            StringBuilder whereBuilder = new StringBuilder();
            ArrayList<InputColumnVO> inWhere = new ArrayList<InputColumnVO>();
            ArrayList<InputColumnVO> inSet = new ArrayList<InputColumnVO>();
            for (InputColumnVO i : in) {
                if (null != i.getInputWhere() && i.getInputWhere().equals("00")) {
                    inWhere.add(i);
                    continue;
                }
                inSet.add(i);
            }
            for (InputColumnVO i : inSet) {
                TLrDataserviceAutoConfig auto = new TLrDataserviceAutoConfig();
                this.getInAutoConfig(auto, i, d);
                auto.setInputWhere(i.getInputWhere());
                autoList.add(auto);
                updateBuffer.append("\"").append(i.getColumnName()).append("\"= #{").append(i.getColumnAliasDefined()).append("},");
            }
            String updateSql = updateBuffer.toString().substring(0, updateBuffer.length() - 1);
            if (StringUtils.isNotEmpty(inWhere)) {
                whereBuilder.append(" WHERE ");
                this.getSqlPart(inWhere, d, whereBuilder, autoList);
                String whereStr = this.getWhereSql(whereBuilder);
                updateSql = updateSql + whereStr;
            }
            log.info("updateSql==={}", (Object)updateSql);
            d.setSql(updateSql);
            d.setAutoConfigList(autoList);
        } else if ("DELETE".equals(d.getMapperType())) {
            List in = d.getInputColumnVOList();
            StringBuilder deleteBuilder = new StringBuilder();
            deleteBuilder.append("DELETE FROM ").append(" \"").append(((InputColumnVO)in.get(0)).getTableName()).append("\"  ");
            String deleteSql = deleteBuilder.toString().substring(0, deleteBuilder.length() - 1);
            if (StringUtils.isNotEmpty((Collection)in)) {
                StringBuilder whereBuilder = new StringBuilder();
                whereBuilder.append(" WHERE ");
                this.getSqlPart(in, d, whereBuilder, autoList);
                String whereStr = this.getWhereSql(whereBuilder);
                deleteSql = deleteSql + whereStr;
            }
            log.info("deleteSql==={}", (Object)deleteSql);
            d.setSql(deleteSql);
            d.setAutoConfigList(autoList);
        } else if ("SELECT".equals(d.getMapperType())) {
            List in = d.getInputColumnVOList();
            List out = d.getOutputColumnVOList();
            StringBuilder outBuilder = new StringBuilder();
            outBuilder.append("SELECT ");
            for (OutputColumnVO o : out) {
                TLrDataserviceAutoConfig autoOut = new TLrDataserviceAutoConfig();
                autoOut.setId(IdGenerateUtils.getId().toString());
                autoOut.setDataserviceId(d.getDataserviceId());
                autoOut.setColumnId(o.getOutColumnId());
                autoOut.setTableId(o.getOutTableId());
                autoOut.setPutType("01");
                autoOut.setDictCode(o.getOutDictCode());
                autoOut.setColumnAlias(o.getColumnAliasDefined());
                autoOut.setColumnAliasDefined(o.getColumnAliasDefined());
                autoOut.setStatus(Integer.valueOf(1));
                autoOut.setUserId(IdAcquisitionUtil.getCurrentUserId());
                autoOut.setCreateTime(DateUtils.getNowDate());
                autoOut.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
                autoList.add(autoOut);
                if (StringUtils.isNotNull((Object)o.getFunctionFlag())) {
                    outBuilder.append(o.getFunctionFlag()).append("(").append("\"").append(o.getColumnName()).append("\"").append(")").append("  \"").append(o.getColumnAliasDefined()).append("\"  ").append(" ,");
                    continue;
                }
                outBuilder.append("\"").append(o.getColumnName()).append("\"").append("  \"").append(o.getColumnAliasDefined()).append("\"  ").append(" ,");
            }
            StringBuilder groupByBuilder = new StringBuilder();
            groupByBuilder.append(" ").append(" GROUP BY ");
            boolean groupBy = false;
            StringBuilder sortBuilder = new StringBuilder();
            sortBuilder.append(" ORDER BY  ");
            boolean sortFlag = false;
            List constraintionVoList = d.getConList();
            if (StringUtils.isNotEmpty((Collection)constraintionVoList)) {
                List groupByCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(1)).collect(Collectors.toList());
                List sortCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(2)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(groupByCon)) {
                    for (ConstraintionVO c3 : groupByCon) {
                        groupBy = true;
                        groupByBuilder.append("\"").append(c3.getColumnName()).append("\" ").append(",");
                    }
                }
                if (!CollectionUtils.isEmpty(sortCon)) {
                    for (ConstraintionVO c3 : sortCon) {
                        sortFlag = true;
                        String columnNameSort = "\"" + c3.getColumnName() + "\"";
                        if (c3.getConstraintOper().equals(21)) {
                            sortBuilder.append(columnNameSort).append(" ASC,");
                            continue;
                        }
                        if (!c3.getConstraintOper().equals(22)) continue;
                        sortBuilder.append(columnNameSort).append(" DESC,");
                    }
                }
            }
            String outStr = outBuilder.toString().substring(0, outBuilder.length() - 1);
            String groupStr = groupByBuilder.toString().substring(0, groupByBuilder.length() - 1);
            String sortStr = sortBuilder.toString().substring(0, sortBuilder.length() - 1);
            StringBuilder selectBuilder = new StringBuilder();
            selectBuilder.append(outStr).append(" FROM ").append(" \"").append(((OutputColumnVO)out.get(0)).getTableName()).append("\"  ");
            if (StringUtils.isNotEmpty((Collection)in)) {
                StringBuilder whereBuilder = new StringBuilder();
                whereBuilder.append(" WHERE ");
                this.getSqlPart(in, d, whereBuilder, autoList);
                String whereStr = this.getWhereSql(whereBuilder);
                selectBuilder.append(whereStr);
            }
            if (groupBy) {
                selectBuilder.append(groupStr);
            }
            if (sortFlag) {
                selectBuilder.append(sortStr);
            }
            String selectSql = selectBuilder.toString();
            log.info("selectSql====={}", (Object)selectSql);
            d.setSql(selectSql);
            d.setAutoConfigList(autoList);
        } else if ("PROCESELECT".equals(d.getMapperType())) {
            List in = d.getInputColumnVOList();
            List out = d.getOutputColumnVOList();
            StringBuilder outBuilder = new StringBuilder();
            StringBuilder outBuilderFirst = new StringBuilder();
            StringBuilder outBuilderSecond = new StringBuilder();
            outBuilder.append("SELECT ");
            for (OutputColumnVO o : out) {
                TLrDataserviceAutoConfig autoOut = new TLrDataserviceAutoConfig();
                autoOut.setId(IdGenerateUtils.getId().toString());
                autoOut.setDataserviceId(d.getDataserviceId());
                autoOut.setColumnId(o.getOutColumnId());
                autoOut.setTableId(o.getOutTableId());
                autoOut.setPutType("01");
                autoOut.setDictCode(o.getOutDictCode());
                autoOut.setColumnAlias(o.getColumnAliasDefined());
                autoOut.setColumnAliasDefined(o.getColumnAliasDefined());
                autoOut.setStatus(Integer.valueOf(1));
                autoOut.setUserId(IdAcquisitionUtil.getCurrentUserId());
                autoOut.setCreateTime(DateUtils.getNowDate());
                autoOut.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
                autoList.add(autoOut);
                String tableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, o.getTableName());
                if (StringUtils.isNotEmpty((String)o.getFunctionFlag())) {
                    if (o.getTableName().equals("ACT_RU_TASK") || o.getTableName().equals("ACT_RU_IDENTITYLINK")) {
                        outBuilderFirst.append(o.getFunctionFlag()).append("(").append("\"").append(tableNameAlias).append("\".").append("\"").append(o.getColumnName()).append("\"").append(")").append("  \"").append(o.getColumnAliasDefined()).append("\"  ").append(" ,");
                        continue;
                    }
                    if (o.getTableName().equals("ACT_HI_TASKINST")) {
                        outBuilderSecond.append(o.getFunctionFlag()).append("(").append("\"").append(tableNameAlias).append("\".").append("\"").append(o.getColumnName()).append("\"").append(")").append("  \"").append(o.getColumnAliasDefined()).append("\"  ").append(" ,");
                        continue;
                    }
                    outBuilder.append(o.getFunctionFlag()).append("(").append("\"").append(tableNameAlias).append("\".").append("\"").append(o.getColumnName()).append("\"").append(")").append("  \"").append(o.getColumnAliasDefined()).append("\"  ").append(" ,");
                    continue;
                }
                if (o.getTableName().equals("ACT_RU_TASK") || o.getTableName().equals("ACT_RU_IDENTITYLINK")) {
                    outBuilderFirst.append("\"").append(tableNameAlias).append("\".").append("\"").append(o.getColumnName()).append("\"").append("  \"").append(o.getColumnAliasDefined()).append("\"  ").append(" ,");
                    continue;
                }
                if (o.getTableName().equals("ACT_HI_TASKINST")) {
                    outBuilderSecond.append("\"").append(tableNameAlias).append("\".").append("\"").append(o.getColumnName()).append("\"").append("  \"").append(o.getColumnAliasDefined()).append("\"  ").append(" ,");
                    continue;
                }
                outBuilder.append("\"").append(tableNameAlias).append("\".").append("\"").append(o.getColumnName()).append("\"").append("  \"").append(o.getColumnAliasDefined()).append("\"  ").append(" ,");
            }
            StringBuilder groupByBuilder = new StringBuilder();
            boolean groupBy = false;
            StringBuilder sortBuilder = new StringBuilder();
            boolean sortFlag = false;
            List constraintionVoList = d.getConList();
            if (StringUtils.isNotEmpty((Collection)constraintionVoList)) {
                List groupByCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(1)).collect(Collectors.toList());
                List sortCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(2)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(groupByCon)) {
                    for (ConstraintionVO c4 : groupByCon) {
                        groupBy = true;
                        String tableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, c4.getTableName());
                        groupByBuilder.append(" ").append(" GROUP BY ");
                        groupByBuilder.append("\"").append(tableNameAlias).append("\".").append("\"").append(c4.getColumnName()).append("\" ").append(",");
                    }
                }
                if (!CollectionUtils.isEmpty(sortCon)) {
                    for (ConstraintionVO c4 : sortCon) {
                        sortFlag = true;
                        sortBuilder.append(" ORDER BY  ");
                        String columnNameSort = "\"" + c4.getColumnAliasDefined() + "\"";
                        if (c4.getConstraintOper().equals(21)) {
                            sortBuilder.append(columnNameSort).append(" ASC,");
                            continue;
                        }
                        if (!c4.getConstraintOper().equals(22)) continue;
                        sortBuilder.append(columnNameSort).append(" DESC,");
                    }
                }
            }
            String outStrFirst = outBuilder.toString() + outBuilderFirst.toString() + "null AS \"taskEndTime\" , 0 \"procStatus\" ";
            String outStrSecond = outBuilder.toString() + outBuilderSecond.append("\"actHiTaskinst\".\"END_TIME_\" AS \"taskEndTime\" , CASE WHEN \"actHiTaskinst\".\"END_TIME_\" IS NULL THEN 1 ELSE 2 END AS \"procStatus\" ").toString();
            String groupStr = groupByBuilder.length() > 0 ? groupByBuilder.toString().substring(0, groupByBuilder.length() - 1) : groupByBuilder.toString();
            String sortStr = sortBuilder.length() > 0 ? sortBuilder.toString().substring(0, sortBuilder.length() - 1) : sortBuilder.toString();
            StringBuilder selectBuilder = new StringBuilder();
            Map<String, String> outTable = out.stream().collect(Collectors.toMap(OutputColumnVO::getTableName, OutputColumnVO::getOutTableId, (key1, key2) -> key2));
            TLrMetadataManageTable table = new TLrMetadataManageTable();
            for (Map.Entry<String, String> entry : outTable.entrySet()) {
                if ("ACT_RU_TASK".equals(entry.getKey()) || "ACT_RU_IDENTITYLINK".equals(entry.getKey()) || "ACT_HI_PROCINST".equals(entry.getKey()) || "ACT_HI_TASKINST".equals(entry.getKey())) continue;
                table = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(entry.getValue());
                table.setTableDetailList(this.tLrMetadataDetailMapper.selectColumnInfo(table.getTableId()));
            }
            List columns = table.getTableDetailList();
            TLrMetadataDetail tablePk = new TLrMetadataDetail();
            for (TLrMetadataDetail column : columns) {
                if (column.getIsPk() != 1) continue;
                tablePk = column;
                break;
            }
            String tableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, table.getTableName());
            StringBuilder connectBuilderFirst = new StringBuilder();
            connectBuilderFirst.append(" FROM ").append("\"").append(table.getTableName()).append("\"").append(" \"").append(tableNameAlias).append("\" ");
            connectBuilderFirst.append("LEFT JOIN \"ACT_HI_PROCINST\"").append(" \"actHiProcinst\"").append(" ON ");
            connectBuilderFirst.append("\"").append(tableNameAlias).append("\"").append(".\"").append(tablePk.getColumnName()).append("\" = \"actHiProcinst\".\"BUSINESS_KEY_\"");
            connectBuilderFirst.append("LEFT JOIN \"ACT_RU_TASK\" \"actRuTask\"  ON \"actRuTask\".\"PROC_INST_ID_\" = \"actHiProcinst\".\"ID_\" LEFT JOIN  \"ACT_RU_IDENTITYLINK\" \"actRuIdentitylink\" ON \"actRuIdentitylink\".\"TASK_ID_\" = \"actRuTask\".\"ID_\" ");
            StringBuilder connectBuilderSecond = new StringBuilder();
            connectBuilderSecond.append(" FROM ").append("\"").append(table.getTableName()).append("\"").append(" \"").append(tableNameAlias).append("\" ");
            connectBuilderSecond.append("LEFT JOIN \"ACT_HI_PROCINST\"").append(" \"actHiProcinst\"").append(" ON ");
            connectBuilderSecond.append("\"").append(tableNameAlias).append("\"").append(".\"").append(tablePk.getColumnName()).append("\" = \"actHiProcinst\".\"BUSINESS_KEY_\"");
            connectBuilderSecond.append("LEFT JOIN \"ACT_HI_TASKINST\" \"actHiTaskinst\" ON \"actHiTaskinst\".\"PROC_INST_ID_\" = \"actHiProcinst\".\"ID_\"");
            StringBuilder whereBuilderFirst = new StringBuilder();
            StringBuilder whereBuilderSecond = new StringBuilder();
            StringBuilder whereBuilder = new StringBuilder();
            whereBuilder.append(" ${WHERE} ");
            whereBuilderFirst.append((CharSequence)whereBuilder).append("(\"actRuIdentitylink\".\"TYPE_\" = 'candidate' AND \"actRuIdentitylink\".\"USER_ID_\" = #{userIdLR} ) OR \"actRuTask\".\"ASSIGNEE_\" = #{userIdLR}");
            whereBuilderSecond.append((CharSequence)whereBuilder).append("\"actHiTaskinst\".\"END_TIME_\" IS NOT NULL AND \"actHiTaskinst\".\"ASSIGNEE_\" = #{userIdLR}");
            if (StringUtils.isNotEmpty((Collection)in)) {
                for (InputColumnVO i : in) {
                    TLrDataserviceAutoConfig auto = new TLrDataserviceAutoConfig();
                    this.getInAutoConfig(auto, i, d);
                    autoList.add(auto);
                }
            }
            StringBuilder sqlFinal = new StringBuilder();
            if (groupBy) {
                selectBuilder.append(groupStr);
            }
            sqlFinal.append("(").append(outStrFirst).append((CharSequence)connectBuilderFirst).append((CharSequence)whereBuilderFirst).append(groupStr).append(")").append(" UNION ALL ");
            sqlFinal.append("(").append(outStrSecond).append((CharSequence)connectBuilderSecond).append((CharSequence)whereBuilderSecond).append(groupStr).append(")");
            if (sortFlag) {
                sqlFinal.append(sortStr);
            }
            String selectSql = sqlFinal.toString();
            log.info("processSelectSql====={}", (Object)selectSql);
            d.setSql(selectSql);
            d.setAutoConfigList(autoList);
        }
    }

    private void getInAutoConfig(TLrDataserviceAutoConfig auto, InputColumnVO i, TLrDataserviceConfigurationTable d) {
        auto.setId(IdGenerateUtils.getId().toString());
        auto.setDataserviceId(d.getDataserviceId());
        auto.setColumnId(i.getInColumnId());
        auto.setTableId(i.getInTableId());
        auto.setPutType("00");
        auto.setDictCode(i.getInDictCode());
        auto.setInputWhere(i.getInputWhere());
        auto.setConnectFlag(i.getInConnectFlag());
        auto.setSort(i.getInsort());
        auto.setColumnAlias(i.getColumnAliasDefined());
        auto.setColumnAliasDefined(i.getColumnAliasDefined());
        auto.setStatus(Integer.valueOf(1));
        auto.setUserId(IdAcquisitionUtil.getCurrentUserId());
        auto.setCreateTime(DateUtils.getNowDate());
        auto.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
    }

    private void getSqlPart(List<InputColumnVO> in, TLrDataserviceConfigurationTable d, StringBuilder whereBuilder, List<TLrDataserviceAutoConfig> autoList) {
        for (InputColumnVO i : in) {
            if (ConnectEnum._ROW.getType().equals(i.getType())) {
                if (i.getWhereFlag().toUpperCase().contains("LIKE")) {
                    if (i.getWhereFlag().toUpperCase().contains("LEFT")) {
                        whereBuilder.append("  ").append("\"").append(i.getColumnName()).append("\" ").append(" LIKE CONCAT ('%',#{").append(i.getColumnAliasDefined()).append("})   ").append(" ").append(i.getInConnectFlag());
                    } else if (i.getWhereFlag().toUpperCase().contains("RIGHT")) {
                        whereBuilder.append("  ").append("\"").append(i.getColumnName()).append("\" ").append(" LIKE CONCAT (#{").append(i.getColumnAliasDefined()).append("},'%')   ").append(" ").append(i.getInConnectFlag());
                    } else {
                        whereBuilder.append("  ").append("\"").append(i.getColumnName()).append("\" ").append(" LIKE CONCAT ('%',#{").append(i.getColumnAliasDefined()).append("},'%')   ").append(" ").append(i.getInConnectFlag());
                    }
                } else if (i.getWhereFlag().toUpperCase().contains("IN")) {
                    whereBuilder.append("  ").append("\"").append(i.getColumnName()).append("\" ").append(" ").append(i.getWhereFlag()).append(" (#{foreach_").append(i.getColumnAliasDefined()).append("}) ").append(" ").append(i.getInConnectFlag());
                } else {
                    whereBuilder.append("  ").append("\"").append(i.getColumnName()).append("\" ").append(" ").append(i.getWhereFlag()).append(" #{").append(i.getColumnAliasDefined()).append("}").append(" ").append(i.getInConnectFlag());
                }
                TLrDataserviceAutoConfig auto = new TLrDataserviceAutoConfig();
                this.getInAutoConfig(auto, i, d);
                autoList.add(auto);
                continue;
            }
            whereBuilder.append(" (");
            this.getSqlPart(i.getChildren(), d, whereBuilder, autoList);
            whereBuilder.append(" )");
        }
    }

    private TLrImplements getCreateUrl(TLrDataserviceConfigurationTable tLrDataserviceConfigurationTable) throws EngineException {
        String mapperType = tLrDataserviceConfigurationTable.getMapperType();
        String dataServiceId = this.insertDataServiceTable(tLrDataserviceConfigurationTable);
        this.insertDataServiceDetail(tLrDataserviceConfigurationTable, this.dynamicDataSourceService.getDatasourceType());
        TLrServiceTable serviceTable = this.insertServiceTable(dataServiceId, mapperType);
        TLrImplements lrImplements = this.insertImplement(dataServiceId, serviceTable.getServiceId(), mapperType);
        this.oscarLrCacheSyncService.syncInterfaceCache("ADD", lrImplements.getServiceId());
        return lrImplements;
    }

    private void insertDataServiceDetail(TLrDataserviceConfigurationTable d, String dsType) throws EngineException {
        this.getDataServiceConfigSql(d);
        try {
            this.batchInsertAutoconfig(dsType, d.getAutoConfigList());
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.INSERT_AUTO_CONFIGURATION_FAILED, (Throwable)e);
        }
        try {
            this.insertTLrDataServiceSql(d);
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.INSERT_DATA_SERVICE_SQL_FAILED, (Throwable)e);
        }
    }

    private void batchInsertAutoconfig(String dsType, List<TLrDataserviceAutoConfig> autoList) {
        Map dataServiceAutoConfigMappers = TLrPlatformTableFactory.getMappers((String)"dataServiceAutoConfig");
        ((TLrPlatformTableMapper)dataServiceAutoConfigMappers.get(dsType)).batchInsertDataserviceAutoconfig(autoList);
    }

    private void insertTLrDataServiceSql(TLrDataserviceConfigurationTable configurationTable) {
        TLrDataServiceSql serviceSql = new TLrDataServiceSql();
        serviceSql.setId(IdGenerateUtils.getId().toString());
        serviceSql.setDataServiceId(configurationTable.getDataserviceId());
        if (!configurationTable.getMapperType().equals("INSERT")) {
            String whereChildren = JSONObject.toJSONString((Object)configurationTable.getInputColumnVOList());
            serviceSql.setWhereChildren(whereChildren);
        }
        serviceSql.setDataServiceSql(configurationTable.getSql());
        serviceSql.setStatus(Integer.valueOf(1));
        serviceSql.setUserId(IdAcquisitionUtil.getCurrentUserId());
        serviceSql.setCreateTime(DateUtils.getNowDate());
        serviceSql.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        this.tLrDataServiceSqlMapper.insertTLrDataServiceSqlMapper(serviceSql);
    }

    private TLrServiceTable insertServiceTable(String dataServiceId, String mapperType) throws EngineException {
        String userId = IdAcquisitionUtil.getCurrentUserId();
        String tenantId = IdAcquisitionUtil.getCurrentTenantId();
        String nameFlag = mapperType + dataServiceId + System.currentTimeMillis();
        String serviceId = IdGenerateUtils.getId().toString();
        TLrServiceTable serviceTable = new TLrServiceTable();
        serviceTable.setServiceId(serviceId);
        serviceTable.setServiceName(nameFlag);
        serviceTable.setServiceVersion(Long.valueOf(1L));
        serviceTable.setServiceChname(nameFlag);
        serviceTable.setServiceType("01");
        serviceTable.setServiceStatuts(LRConstants.service_statuts_release);
        serviceTable.setUserId(userId);
        serviceTable.setCreateTime(DateUtils.getNowDate());
        serviceTable.setStatus(Integer.valueOf(1));
        serviceTable.setTenantId(tenantId);
        try {
            this.tLrServiceTableMapper.insertTLrServiceTable(serviceTable);
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.CREATE_BUSINESS_CONFIGURATION_FAILED, (Throwable)e);
        }
        TLrServiceDetailTable serviceDetailTable = new TLrServiceDetailTable();
        serviceDetailTable.setDetailId(IdGenerateUtils.getId().toString());
        serviceDetailTable.setServiceId(serviceId);
        serviceDetailTable.setDataserviceId(dataServiceId);
        serviceDetailTable.setSortNumber(Integer.valueOf(1));
        serviceDetailTable.setUserId(userId);
        serviceDetailTable.setCreateTime(DateUtils.getNowDate());
        serviceDetailTable.setStatus(Integer.valueOf(1));
        serviceDetailTable.setTenantId(tenantId);
        try {
            this.serviceDetailMapper.insertTlrServiceDeatilTable(serviceDetailTable);
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.CREATE_BUSINESS_SERVICE_DETAIL_FAILED, (Throwable)e);
        }
        return serviceTable;
    }

    private TLrImplements insertImplement(String dataServiceId, String serviceId, String mapperType) throws EngineException {
        String remark = this.getRemarkDetail(mapperType);
        String nameFlag = mapperType + dataServiceId + System.currentTimeMillis();
        TLrImplements lrImplements = new TLrImplements();
        lrImplements.setId(IdGenerateUtils.getId().toString());
        lrImplements.setImpFlag(nameFlag);
        lrImplements.setImpName(nameFlag);
        lrImplements.setServiceId(serviceId);
        lrImplements.setUrl("/T_LR/" + nameFlag);
        if (mapperType.equals("DELETE")) {
            lrImplements.setRequestType("GET");
        } else {
            lrImplements.setRequestType("POST");
        }
        lrImplements.setImpVersion(Long.valueOf(1L));
        lrImplements.setImpStatus(Integer.valueOf(1));
        lrImplements.setUserId(IdAcquisitionUtil.getCurrentUserId());
        lrImplements.setCreateTime(DateUtils.getNowDate());
        lrImplements.setStatus(Integer.valueOf(1));
        lrImplements.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        lrImplements.setVersion(Long.valueOf(1L));
        lrImplements.setReleaseSource(Integer.valueOf(1));
        lrImplements.setRemark("\u8868\u7ba1\u7406\u4e00\u952e\u53d1\u5e03\u63a5\u53e3:" + remark);
        try {
            this.implementsMapper.insertTLrImplements(lrImplements);
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.CREATE_INTERFACE_FAILED, (Throwable)e);
        }
        return lrImplements;
    }

    private String getRemarkDetail(String mapperType) {
        String remark = null;
        switch (mapperType) {
            case "INSERT": {
                remark = "\u5355\u6761\u63d2\u5165";
                break;
            }
            case "SELECT": {
                remark = "\u67e5\u8be2";
                break;
            }
            case "DELETE": {
                remark = "\u5220\u9664";
                break;
            }
            case "UPDATE": {
                remark = "\u66f4\u65b0";
                break;
            }
            case "SAVEORUPDATE": {
                remark = "\u65b0\u589e\u6216\u66f4\u65b0";
                break;
            }
            case "SAVEORUPDATEBATCH": {
                remark = "\u8868\u683c\u5bfc\u5165";
                break;
            }
            case "EDITSAVEORUPDATEBATCH": {
                remark = "\u53ef\u7f16\u8f91\u8868\u683c\u5bfc\u5165";
                break;
            }
            case "PAGESELECT": {
                remark = "\u6d41\u7a0b\u67e5\u8be2";
            }
        }
        return remark;
    }

    private String getWhereSql(StringBuilder whereBuilder) {
        int or_start1;
        int and_start1 = whereBuilder.lastIndexOf(" AND");
        if (and_start1 < (or_start1 = whereBuilder.lastIndexOf(" OR"))) {
            whereBuilder.replace(or_start1, or_start1 + 3, "");
        } else if (and_start1 > or_start1) {
            whereBuilder.replace(and_start1, and_start1 + 4, "");
        }
        String whereStr = whereBuilder.toString();
        while (whereStr.contains("AND )") || whereStr.contains("OR )")) {
            if (whereStr.contains("AND )")) {
                whereStr = whereStr.replace("AND )", ") AND");
            }
            if (!whereStr.contains("OR )")) continue;
            whereStr = whereStr.replace("OR )", ") OR");
        }
        return whereStr;
    }

    private List<TLrMetadataParam> prepareBeforeUpdate(List<TLrMetadataManageTable> tables, List<TLrMetadataDetail> columns, String datasourceId, List<TLrMetadataManageTable> tablesOld) {
        List<TLrMetadataDetail> tabCols;
        ArrayList<TLrMetadataParam> metadataParams = new ArrayList<TLrMetadataParam>();
        HashMap tabColMap = Maps.newHashMapWithExpectedSize((int)tables.size());
        for (TLrMetadataDetail col : columns) {
            String tableName = col.getTableName();
            if (tabColMap.containsKey(tableName)) {
                tabCols = (List)tabColMap.get(tableName);
            } else {
                tabCols = Lists.newArrayListWithCapacity((int)20);
                tabColMap.put(tableName, tabCols);
            }
            tabCols.add(col);
        }
        Map tablesMap = tables.stream().collect(Collectors.toMap(TLrMetadataManageTable::getTableName, Function.identity(), (key1, key2) -> key2));
        Map tablesOldMap = tablesOld.stream().collect(Collectors.toMap(TLrMetadataManageTable::getTableName, Function.identity(), (key1, key2) -> key2));
        for (Map.Entry entry : tablesOldMap.entrySet()) {
            TLrMetadataDetail column;
            TLrMetadataManageTable table = (TLrMetadataManageTable)tablesMap.get(entry.getKey());
            table.setTableId(((TLrMetadataManageTable)entry.getValue()).getTableId());
            table.setUserId(((TLrMetadataManageTable)entry.getValue()).getUserId());
            table.setCreateTime(((TLrMetadataManageTable)entry.getValue()).getCreateTime());
            tabCols = (List)tabColMap.get(table.getTableName());
            table.setTableDetailList(tabCols);
            table.setCountColumn(Long.valueOf(tabCols.size()));
            table.setDatasourceId(datasourceId);
            table.setUpdateByUserid(IdAcquisitionUtil.getCurrentUserId());
            table.setUpdateTime(DateUtils.getNowDate());
            table.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            String characterSet = table.getCharacterSet();
            if (StringUtils.isEmpty((String)characterSet)) {
                table.setCharacterSet("utf8");
            } else {
                table.setCharacterSet(characterSet.contains("_") ? characterSet.split("_")[0] : characterSet);
            }
            table.setStatus(Integer.valueOf(1));
            table.setVersion(((TLrMetadataManageTable)entry.getValue()).getVersion());
            table.setRemark(table.getTableComment());
            table.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            if (StringUtils.isEmpty((String)table.getTableChname())) {
                table.setTableChname(table.getTableName());
                table.setTableComment(table.getTableName());
                table.setRemark(table.getTableName());
            }
            TLrMetadataParam paramData = new TLrMetadataParam();
            ArrayList<TLrMetadataDetail> columnInfo = new ArrayList<TLrMetadataDetail>();
            ArrayList<TLrMetadataDetail> delColumns = new ArrayList<TLrMetadataDetail>();
            Map columnsOldMap = ((TLrMetadataManageTable)entry.getValue()).getTableDetailList().stream().collect(Collectors.toMap(TLrMetadataDetail::getColumnName, Function.identity(), (key1, key2) -> key2));
            Map columnsMap = ((TLrMetadataManageTable)tablesMap.get(entry.getKey())).getTableDetailList().stream().collect(Collectors.toMap(TLrMetadataDetail::getColumnName, Function.identity(), (key1, key2) -> key2));
            for (Map.Entry columnOldEntry : columnsOldMap.entrySet()) {
                TLrMetadataDetail columnOld = (TLrMetadataDetail)columnOldEntry.getValue();
                column = (TLrMetadataDetail)columnsMap.get(columnOldEntry.getKey());
                if (Objects.isNull(column)) {
                    columnOld.setOperation("delete");
                    delColumns.add(columnOld);
                    continue;
                }
                column.setCreateTime(columnOld.getCreateTime());
                column.setUserId(columnOld.getUserId());
                column.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
                column.setColumnId(columnOld.getColumnId());
                column.setTableId(columnOld.getTableId());
                column.setTableName(columnOld.getTableName());
                column.setStatus(Integer.valueOf(1));
                column.setColumnType(column.getColumnType().toUpperCase());
                column.setDefaultValue(StringUtils.isEmpty((String)column.getDefaultValue()) ? "" : column.getDefaultValue());
                column.setPointLength(Integer.valueOf(column.getPointLength() == null ? 0 : column.getPointLength()));
                if (StringUtils.isEmpty((String)column.getColumnChname())) {
                    column.setColumnComment(column.getColumnName());
                    column.setColumnChname(column.getColumnName());
                }
                if (column.equals((Object)columnOld)) continue;
                column.setOperation("edit");
                column.setUpdateTime(DateUtils.getNowDate());
                column.setUpdateByUserid(IdAcquisitionUtil.getCurrentUserId());
                columnInfo.add(column);
            }
            for (Map.Entry columnEntry : columnsMap.entrySet()) {
                column = (TLrMetadataDetail)columnEntry.getValue();
                TLrMetadataDetail columnOld = (TLrMetadataDetail)columnsOldMap.get(columnEntry.getKey());
                if (!Objects.isNull(columnOld)) continue;
                column.setCreateTime(DateUtils.getNowDate());
                column.setUserId(IdAcquisitionUtil.getCurrentUserId());
                column.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
                column.setColumnId(IdGenerateUtils.getId().toString());
                column.setTableId(((TLrMetadataManageTable)entry.getValue()).getTableId());
                column.setTableName(entry.getKey());
                column.setStatus(Integer.valueOf(1));
                column.setColumnType(column.getColumnType().toUpperCase());
                column.setDefaultValue(StringUtils.isEmpty((String)column.getDefaultValue()) ? "" : column.getDefaultValue());
                column.setPointLength(Integer.valueOf(column.getPointLength() == null ? 0 : column.getPointLength()));
                if (StringUtils.isEmpty((String)column.getColumnChname())) {
                    column.setColumnComment(column.getColumnName());
                    column.setColumnChname(column.getColumnName());
                }
                column.setOperation("add");
                columnInfo.add(column);
            }
            paramData.setBaseInfo(table);
            paramData.setDeletedCols(delColumns);
            paramData.setColumnInfo(columnInfo);
            metadataParams.add(paramData);
        }
        return metadataParams;
    }

    @Override
    public boolean import2LrDbForProceTable() throws EngineException {
        List<TLrMetadataDetail> columns;
        List<TLrMetadataManageTable> tables;
        List<String> tableNames = PROCESS_TABLENAMES;
        FormDesignDataSource formDesignDataSource = LrTenantUtil.getDefaultDataSource();
        if (null == formDesignDataSource || "".equals(formDesignDataSource.getDbName())) {
            throw new EngineException(EngineExceptionEnum.CREATE_DEFALUT_TENANT_DRIVERNAME_FAILED);
        }
        String userId = IdAcquisitionUtil.getCurrentUserId();
        String tenantId = IdAcquisitionUtil.getCurrentTenantId();
        TLrDatasourceTable dTemp = new TLrDatasourceTable();
        dTemp.setDatasourceName(formDesignDataSource.getDbName());
        dTemp.setTenantId(tenantId);
        TLrDatasourceTable d = this.tLrDatasourceTableMapper.selectTLrDatasourceTableByDatasourceName(dTemp);
        List exists = this.tLrMetadataManageTableMapper.selectByTableNamesAndDsId(tableNames, d.getDatasourceId());
        if (!CollectionUtils.isEmpty((Collection)exists)) {
            log.info("\u6d41\u7a0b\u8868\u5df2\u7ecf\u5bfc\u5165\u5230\u5e73\u53f0\u5e93\uff0c\u65e0\u9700\u5728\u64cd\u4f5c");
            return true;
        }
        try {
            this.dynamicDataSourceService.switchDataSource(d);
            tables = this.targetDataBaseOscarMapper.selectTablesByTableNames(tableNames, d.getDatasourceUsername());
            columns = this.targetDataBaseOscarMapper.selectColumnsByTableNames(tableNames, d.getDatasourceUsername());
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.TABLE_INFORMATION_NOT_OBTAINED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
        if (CollectionUtils.isEmpty(tables)) {
            throw new EngineException(EngineExceptionEnum.TABLE_INFORMATION_NOT_OBTAINED);
        }
        if (CollectionUtils.isEmpty(columns)) {
            throw new EngineException(EngineExceptionEnum.COLUMN_INFORMATION_NOT_OBTAINED);
        }
        this.importTable2DbService.saveTableInfo(tables, columns, d.getDatasourceId(), userId);
        return true;
    }
}

