/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.oscar.service;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.jxdinfo.engine.common.service.LrCacheService;
import com.jxdinfo.engine.metadata.dao.TLrServiceTableMapper;
import com.jxdinfo.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.engine.metadata.enums.MappingMethodEnum;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.engine.metadata.model.InvokeResponse;
import com.jxdinfo.engine.metadata.model.TLrServiceTable;
import com.jxdinfo.engine.metadata.service.MetadataInvokeService;
import com.jxdinfo.engine.metadata.util.IdAcquisitionUtil;
import com.jxdinfo.engine.metadata.util.StringUtils;
import com.jxdinfo.engine.oscar.service.IOscarLrBaseInvokeService;
import com.jxdinfo.engine.oscar.service.IOscarLrCacheSyncService;
import com.jxdinfo.engine.oscar.service.IOscarLrMasterSlaveInvokeService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="engine.oscar.OscarMetadataInvokeServiceImpl")
@DS(value="master")
public class OscarMetadataInvokeServiceImpl
implements MetadataInvokeService {
    private static final Logger logger = LoggerFactory.getLogger(OscarMetadataInvokeServiceImpl.class);
    @Autowired
    private IOscarLrBaseInvokeService lrBaseService;
    @Autowired
    private IOscarLrMasterSlaveInvokeService masterSlaveService;
    @Autowired
    private TLrServiceTableMapper serviceTableMapper;
    @Autowired
    private IOscarLrCacheSyncService cacheSyncService;
    @Autowired
    private LrCacheService cacheService;

    public InvokeResponse invokeMethod(Map<String, Object> params, String serviceId) throws EngineException {
        TLrServiceTable serviceTable = this.serviceTableMapper.selectTLrServiceTableById(serviceId);
        if (serviceTable == null) {
            throw new EngineException(EngineExceptionEnum.BUSINESS_SERVICEID_INFORMATION_NOT_OBTAINED.getCode(), EngineExceptionEnum.BUSINESS_SERVICEID_INFORMATION_NOT_OBTAINED.getMessage() + ":" + serviceId);
        }
        if (!IdAcquisitionUtil.getCurrentTenantId().equals(serviceTable.getTenantId())) {
            throw new EngineException(EngineExceptionEnum.OPERATION_METHOD_FAILED.getCode(), EngineExceptionEnum.OPERATION_METHOD_FAILED.getMessage() + ":" + serviceId);
        }
        Map serviceIdMethodMap = (Map)this.cacheService.get("lr-core", "LR:CORE:URL:METHOD:MAPPINGS");
        if (CollectionUtils.isEmpty((Map)serviceIdMethodMap) || !serviceIdMethodMap.containsKey(serviceId)) {
            this.cacheSyncService.syncInterfaceCache("ADD", serviceId);
            serviceIdMethodMap = (Map)this.cacheService.get("lr-core", "LR:CORE:URL:METHOD:MAPPINGS");
        }
        String methodName = (String)serviceIdMethodMap.get(serviceId);
        logger.info("\u4e1a\u52a1\u670d\u52a1\u6807\u8bc6:{},\u5bf9\u5e94\u7684\u6267\u884c\u65b9\u6cd5{}", (Object)serviceId, (Object)methodName);
        if (StringUtils.isEmpty((String)methodName)) {
            throw new EngineException(EngineExceptionEnum.BUSINESS_SERVICEIDCACHE_INFORMATION_NOT_OBTAINED.getCode(), EngineExceptionEnum.BUSINESS_SERVICEIDCACHE_INFORMATION_NOT_OBTAINED.getMessage() + ":" + serviceId);
        }
        if (MappingMethodEnum.INFO_BY_ID.getMethodName().equals(methodName)) {
            return this.lrBaseService.queryInfoById(params, serviceId);
        }
        if (MappingMethodEnum.LIST.getMethodName().equals(methodName)) {
            return this.lrBaseService.queryDataList(params, serviceId);
        }
        if (MappingMethodEnum.PAGE_LIST.getMethodName().equals(methodName)) {
            return this.lrBaseService.queryDataPageList(params, serviceId);
        }
        if (MappingMethodEnum.PROCESELECT_LIST.getMethodName().equals(methodName)) {
            return this.lrBaseService.queryProceList(params, serviceId);
        }
        if (MappingMethodEnum.PAGE_PROCESELECT_LIST.getMethodName().equals(methodName)) {
            return this.lrBaseService.queryPageProceList(params, serviceId);
        }
        if (MappingMethodEnum.ADD.getMethodName().equals(methodName)) {
            return this.lrBaseService.add(params, serviceId);
        }
        if (MappingMethodEnum.EDIT.getMethodName().equals(methodName)) {
            return this.lrBaseService.edit(params, serviceId);
        }
        if (MappingMethodEnum.REMOVE.getMethodName().equals(methodName)) {
            return this.lrBaseService.remove(params, serviceId);
        }
        if (MappingMethodEnum.SAVEORUPDATE.getMethodName().equals(methodName)) {
            return this.lrBaseService.saveOrUpdate(params, serviceId);
        }
        if (MappingMethodEnum.SAVEORUPDATEBATCH.getMethodName().equals(methodName)) {
            return this.lrBaseService.saveOrUpdateBatch(params, serviceId);
        }
        if (MappingMethodEnum.EDITSAVEORUPDATEBATCH.getMethodName().equals(methodName)) {
            return this.lrBaseService.editSaveOrUpdateBatch(params, serviceId);
        }
        if (MappingMethodEnum.MASTER_SLAVE_INFO.getMethodName().equals(methodName)) {
            return this.masterSlaveService.queryMasterSlaveInfoById(params, serviceId);
        }
        if (MappingMethodEnum.MASTER_PAGE_SLAVE_LIST.getMethodName().equals(methodName)) {
            return this.masterSlaveService.masterSlavePageList(params, serviceId);
        }
        if (MappingMethodEnum.MASTER_SLAVE_LIST.getMethodName().equals(methodName)) {
            return this.masterSlaveService.masterSlaveList(params, serviceId);
        }
        if (MappingMethodEnum.MASTER_PAGE_PROCESELECT_LIST.getMethodName().equals(methodName)) {
            return this.masterSlaveService.masterSlavePageProceList(params, serviceId);
        }
        if (MappingMethodEnum.MASTER_PROCESELECT_LIST.getMethodName().equals(methodName)) {
            return this.masterSlaveService.masterSlaveProceList(params, serviceId);
        }
        if (MappingMethodEnum.MASTER_SLAVE_ADD.getMethodName().equals(methodName)) {
            return this.masterSlaveService.add(params, serviceId);
        }
        if (MappingMethodEnum.MASTER_SLAVE_DELETE.getMethodName().equals(methodName)) {
            return this.masterSlaveService.deleteByKey(params, serviceId);
        }
        if (MappingMethodEnum.MASTER_SLAVE_EDIT.getMethodName().equals(methodName)) {
            return this.masterSlaveService.edit(params, serviceId);
        }
        if (MappingMethodEnum.MASTER_SAVEORUPDATE.getMethodName().equals(methodName)) {
            return this.masterSlaveService.saveOrUpdateMasterSlave(params, serviceId);
        }
        throw new EngineException(EngineExceptionEnum.OPERATION_SERVICEMETHOD_FAILED.getCode(), EngineExceptionEnum.OPERATION_SERVICEMETHOD_FAILED.getMessage() + ":" + serviceId);
    }
}

