/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.oracle.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.google.common.collect.Maps;
import com.jxdinfo.engine.common.service.LrCacheService;
import com.jxdinfo.engine.metadata.dao.TLrDatasourceTableMapper;
import com.jxdinfo.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.engine.metadata.model.TLrDatasourceTable;
import com.jxdinfo.engine.metadata.service.DynamicDataSourceService;
import com.jxdinfo.engine.metadata.util.DateUtils;
import com.jxdinfo.engine.metadata.util.IdAcquisitionUtil;
import com.jxdinfo.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.engine.metadata.util.StringUtils;
import com.jxdinfo.engine.oracle.service.IOracleLrDatasourceTableService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@DS(value="master")
public class OracleLrDatasourceTableServiceImpl
implements IOracleLrDatasourceTableService {
    @Autowired
    private TLrDatasourceTableMapper tLrDatasourceTableMapper;
    @Autowired
    private DynamicDataSourceService dynamicDataSourceService;
    @Autowired
    private LrCacheService cacheService;

    @Override
    public void putDataSource(TLrDatasourceTable tLrDatasourceTable) {
        tLrDatasourceTable.setDatasourceDrive("oracle.jdbc.driver.OracleDriver");
        String datasourceUrl = "jdbc:oracle:thin:@" + tLrDatasourceTable.getDatasourceIp() + ":" + tLrDatasourceTable.getDatasourcePort() + ":" + tLrDatasourceTable.getDatasourceInstantname();
        tLrDatasourceTable.setDatasourceUrl(datasourceUrl);
    }

    @Override
    public List<TLrDatasourceTable> selectTLrDatasourceTableList(TLrDatasourceTable tLrDatasourceTable) {
        if (!StringUtils.isEmpty((String)tLrDatasourceTable.getDatasourceName())) {
            tLrDatasourceTable.setDatasourceName("%" + tLrDatasourceTable.getDatasourceName() + "%");
        }
        if (!StringUtils.isEmpty((String)tLrDatasourceTable.getDatasorceChname())) {
            tLrDatasourceTable.setDatasorceChname("%" + tLrDatasourceTable.getDatasorceChname() + "%");
        }
        if (!StringUtils.isEmpty((String)tLrDatasourceTable.getRemark())) {
            tLrDatasourceTable.setRemark("%" + tLrDatasourceTable.getRemark() + "%");
        }
        if (!StringUtils.isEmpty((String)tLrDatasourceTable.getDatasourceUsername())) {
            tLrDatasourceTable.setDatasourceUsername("%" + tLrDatasourceTable.getDatasourceUsername() + "%");
        }
        tLrDatasourceTable.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        return this.tLrDatasourceTableMapper.selectTLrDatasourceTableList(tLrDatasourceTable);
    }

    @Override
    public TLrDatasourceTable selectTLrDatasourceTableByDatasourceName(TLrDatasourceTable tLrDatasourceTable) {
        tLrDatasourceTable.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        return this.tLrDatasourceTableMapper.selectTLrDatasourceTableByDatasourceName(tLrDatasourceTable);
    }

    private String checkDatasourceNameUnique(TLrDatasourceTable tLrDatasourceTable) {
        tLrDatasourceTable.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        TLrDatasourceTable tLrDatasourceTableExist = this.tLrDatasourceTableMapper.checkdatasourceNameUnique(tLrDatasourceTable);
        if (StringUtils.isNotNull((Object)tLrDatasourceTableExist)) {
            return "1";
        }
        return "0";
    }

    @Override
    public boolean insertTLrDatasourceTable(TLrDatasourceTable tLrDatasourceTable) throws EngineException {
        if (!this.checkDatasourceNameUnique(tLrDatasourceTable).equals("0")) {
            throw new EngineException(EngineExceptionEnum.DUPLICATE_DATE_SOURCE_NAME);
        }
        this.putDataSource(tLrDatasourceTable);
        tLrDatasourceTable.setStatus(Integer.valueOf(1));
        tLrDatasourceTable.setCreateTime(DateUtils.getNowDate());
        tLrDatasourceTable.setDatasourceId(IdGenerateUtils.getId().toString());
        tLrDatasourceTable.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        tLrDatasourceTable.setUserId(IdAcquisitionUtil.getCurrentUserId());
        return this.tLrDatasourceTableMapper.insertTLrDatasourceTable(tLrDatasourceTable);
    }

    @Override
    public boolean updateTLrDatasourceTable(TLrDatasourceTable tLrDatasourceTable) throws EngineException {
        TLrDatasourceTable datasourceTable1 = this.tLrDatasourceTableMapper.selectTLrDatasourceTableByDatasourceId(tLrDatasourceTable.getDatasourceId());
        if (Objects.isNull(datasourceTable1)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        String tenantId = datasourceTable1.getTenantId();
        if (!IdAcquisitionUtil.getCurrentTenantId().equalsIgnoreCase(tenantId)) {
            throw new EngineException(EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED);
        }
        if (!this.checkDatasourceNameUnique(tLrDatasourceTable).equals("0")) {
            throw new EngineException(EngineExceptionEnum.DUPLICATE_DATE_SOURCE_NAME);
        }
        this.putDataSource(tLrDatasourceTable);
        tLrDatasourceTable.setStatus(Integer.valueOf(1));
        tLrDatasourceTable.setUpdateByUserid(IdAcquisitionUtil.getCurrentUserId());
        tLrDatasourceTable.setUpdateTime(DateUtils.getNowDate());
        TLrDatasourceTable tLrDatasourceTableExit = this.tLrDatasourceTableMapper.selectTLrDatasourceTableByDatasourceId(tLrDatasourceTable.getDatasourceId());
        try {
            boolean result = this.tLrDatasourceTableMapper.updateTLrDatasourceTable(tLrDatasourceTable);
            this.updateDataSourceEhcache();
            return result;
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.EDIT_DATE_SOURCE_FAILED, (Throwable)e);
        }
    }

    private Map<String, TLrDatasourceTable> updateDataSourceEhcache() {
        TLrDatasourceTable t = new TLrDatasourceTable();
        t.setStatus(Integer.valueOf(1));
        List dataSources = this.tLrDatasourceTableMapper.selectTLrDatasourceTableList(t);
        if (CollectionUtils.isEmpty((Collection)dataSources)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Map<String, TLrDatasourceTable> dataSourceIdMap = dataSources.stream().collect(Collectors.toMap(TLrDatasourceTable::getDatasourceId, Function.identity()));
        this.cacheService.put("lr-core", "LR:CORE:DATASOURCE", dataSourceIdMap);
        return dataSourceIdMap;
    }
}

