/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.oracle.service;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.engine.common.service.LrCacheService;
import com.jxdinfo.engine.metadata.dao.TLrBaseMapper;
import com.jxdinfo.engine.metadata.model.TLrDataserviceAutoConfig;
import com.jxdinfo.engine.metadata.model.TLrMetadataDetail;
import com.jxdinfo.engine.metadata.model.TLrServiceDetailTable;
import com.jxdinfo.engine.metadata.util.IdGenerateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OracleTransactionalExecuteService {
    private static final String FOREACH_COLUMN = "foreach_column";
    private static final String FOREACH_PREFIX = "foreach_";
    @Autowired
    private TLrBaseMapper lrBaseMapper;
    @Autowired
    private LrCacheService cacheService;

    public void executeDeleteMasterSlave(List<TLrServiceDetailTable> details, Map<String, Object> params, Map<String, String> dsIdsqlMap) {
        for (TLrServiceDetailTable detail : details) {
            String dataServiceId = detail.getDataserviceId();
            String sql = dsIdsqlMap.get(dataServiceId);
            if (params.containsKey(FOREACH_COLUMN)) {
                sql = sql.substring(0, sql.indexOf("=")) + "IN (";
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    if (!entry.getKey().contains(FOREACH_PREFIX) || entry.getKey().contains(FOREACH_COLUMN)) continue;
                    sql = sql + "#{" + entry.getKey() + "},";
                }
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    if (!entry.getKey().contains(FOREACH_PREFIX) || entry.getKey().contains(FOREACH_COLUMN)) continue;
                    String columnStr = (String)params.get(FOREACH_COLUMN);
                    Iterable columns = Splitter.on((String)",").trimResults().split((CharSequence)columnStr);
                    for (String column : columns) {
                        String key = FOREACH_PREFIX + column;
                        sql = sql.replace("#{" + key + "}", (String)params.get(key));
                    }
                }
                sql = sql.substring(0, sql.length() - 1) + ")";
            }
            params.put("deleteSql", sql);
            this.lrBaseMapper.delete(params);
        }
    }

    public void executeAddMasterSlave(String masterTableDataServiceId, Map<String, Object> params, Set<String> dataServiceIdsSingle, Map<String, String> dataServiceIdSlaveTableNameAlias, Map<String, String> dsIdsqlMap) {
        String masterSql = dsIdsqlMap.get(masterTableDataServiceId);
        params.put("insertSql", masterSql);
        this.lrBaseMapper.insert(params);
        if (dataServiceIdsSingle.size() > 0) {
            for (String slavedsid : dataServiceIdsSingle) {
                String slaveSingleSql = dsIdsqlMap.get(slavedsid);
                params.put("insertSql", slaveSingleSql);
                this.lrBaseMapper.insert(params);
            }
        }
        if (dataServiceIdSlaveTableNameAlias.size() > 0) {
            for (String dataServiceIdslavemult : dataServiceIdSlaveTableNameAlias.keySet()) {
                String slaveTableNameAlias = dataServiceIdSlaveTableNameAlias.get(dataServiceIdslavemult);
                List dataList = (List)params.get(slaveTableNameAlias);
                String slaveSql = dsIdsqlMap.get(dataServiceIdslavemult);
                for (Map dataParamMap : dataList) {
                    dataParamMap.put("insertSql", slaveSql);
                    this.lrBaseMapper.insert(dataParamMap);
                }
            }
        }
    }

    private static String getBatchInsertSql(Map<String, String> paramColumnNameMap, String dsType, List<Map<String, Object>> dataList, String tableName, List<Map<String, Object>> columnList) {
        StringBuilder batchInsertSql = new StringBuilder(255);
        batchInsertSql.append(" INSERT INTO \"").append(tableName).append("\"(");
        for (Map.Entry<String, String> entry : paramColumnNameMap.entrySet()) {
            String columnName = entry.getValue();
            batchInsertSql.append("\"").append(columnName).append("\",");
        }
        batchInsertSql.deleteCharAt(batchInsertSql.lastIndexOf(","));
        batchInsertSql.append(") VALUES");
        for (Map map : dataList) {
            batchInsertSql.append("(");
            for (Map.Entry<String, String> entry : paramColumnNameMap.entrySet()) {
                String paramName = entry.getKey();
                batchInsertSql.append(OracleTransactionalExecuteService.insertBindParam(map.getOrDefault(paramName, "null"), columnList, paramName));
                batchInsertSql.append(",");
            }
            batchInsertSql.deleteCharAt(batchInsertSql.lastIndexOf(","));
            batchInsertSql.append(")").append(",");
        }
        batchInsertSql.deleteCharAt(batchInsertSql.lastIndexOf(","));
        return batchInsertSql.toString();
    }

    private static String insertBindParam(Object param, List<Map<String, Object>> columnList, String paramName) {
        String paramInSql = param instanceof String ? "'" + param + "'" : String.valueOf(param);
        return paramInSql;
    }

    public void executeUpdateMasterSlave(String masterTabeldataServiceId, String tableName, Map<String, Object> params, Set<String> dataServiceIdsSingle, Map<String, String> dataserviceIdSlaveTableNameAlias, Map<String, List<TLrDataserviceAutoConfig>> dsAutoConfMap, Map<String, String> columnIdColumnTypeMap, Map<String, TLrMetadataDetail> setsColumnMap, Map<String, TLrMetadataDetail> conditionsColumnMap, Map<String, TLrMetadataDetail> dsIdMetadetailSingle, Map<String, TLrMetadataDetail> dsIdMetadetailMutl, Map<String, String> dsIdsqlMap) {
        List<Map<String, Object>> masterColumnAliasType = this.getcolumnAliasType(dsAutoConfMap.get(masterTabeldataServiceId), columnIdColumnTypeMap);
        String masterSql = this.buildUpdateSql(tableName, setsColumnMap, conditionsColumnMap, masterColumnAliasType);
        params.put("updateSql", masterSql);
        this.lrBaseMapper.masterUpdate(params);
        if (dataServiceIdsSingle.size() > 0) {
            for (String slaversId : dataServiceIdsSingle) {
                String slavesqldetele = this.getslavesqldetele(dsIdMetadetailSingle.get(slaversId));
                params.put("deleteSql", slavesqldetele);
                this.lrBaseMapper.masterDelete(params);
                String slavesql = dsIdsqlMap.get(slaversId);
                params.put("insertSql", slavesql);
                this.lrBaseMapper.insert(params);
            }
        }
        if (dataserviceIdSlaveTableNameAlias.size() > 0) {
            for (String dataServiceIdslavemult : dataserviceIdSlaveTableNameAlias.keySet()) {
                String slaveTableNameAlias = dataserviceIdSlaveTableNameAlias.get(dataServiceIdslavemult);
                List dataList = (List)params.get(slaveTableNameAlias);
                String slavesqlmutldetele = this.getslavesqldetele(dsIdMetadetailMutl.get(dataServiceIdslavemult));
                params.put("deleteSql", slavesqlmutldetele);
                this.lrBaseMapper.masterDelete(params);
                String slaveMutlSql = dsIdsqlMap.get(dataServiceIdslavemult);
                for (Map dataParam : dataList) {
                    dataParam.put("insertSql", slaveMutlSql);
                    this.lrBaseMapper.insert(dataParam);
                }
            }
        }
    }

    private List<Map<String, Object>> getcolumnAliasType(List<TLrDataserviceAutoConfig> autoConfList, Map<String, String> columnIdColumnTypeMap) {
        return null;
    }

    private String getslavesqldetele(TLrMetadataDetail de) {
        return "DELETE FROM \"" + de.getTableName() + "\" WHERE \"" + de.getColumnName() + "\" =#{" + de.getColumnNameAlias() + "}";
    }

    public String buildUpdateSql(String tableName, Map<String, TLrMetadataDetail> setsColumnMap, Map<String, TLrMetadataDetail> conditionsColumnMap, List<Map<String, Object>> masterColumnAliasType) {
        TLrMetadataDetail v;
        String k;
        StringBuilder updateSql = new StringBuilder(100);
        updateSql.append("UPDATE \"").append(tableName).append("\" SET ");
        for (Map.Entry<String, TLrMetadataDetail> entry : setsColumnMap.entrySet()) {
            k = entry.getKey();
            v = entry.getValue();
            updateSql.append("\"").append(v.getColumnName()).append("\"=");
            updateSql.append("#{").append(k).append("}");
            updateSql.append(",");
        }
        updateSql.deleteCharAt(updateSql.lastIndexOf(","));
        updateSql.append(" WHERE ");
        for (Map.Entry<String, TLrMetadataDetail> entry : conditionsColumnMap.entrySet()) {
            k = entry.getKey();
            v = entry.getValue();
            updateSql.append("\"").append(v.getColumnName()).append("\"");
            updateSql.append("=#{").append(k).append("}").append(" AND ");
        }
        String sql = updateSql.toString();
        return sql.substring(0, sql.length() - 4);
    }

    public Map<String, Object> handleResultMap(String dataServiceId, Map<String, Object> resultMap) {
        if (CollectionUtils.isEmpty(resultMap)) {
            return resultMap;
        }
        List autoConfigs = Lists.newArrayList();
        String key = "LR:CORE:BUSINESS:INPUT:AUTOCONFIG:" + dataServiceId;
        Object obj = this.cacheService.get("lr-core-runtime", key);
        if (obj != null) {
            autoConfigs = (List)obj;
        }
        if (CollectionUtils.isEmpty((Collection)autoConfigs)) {
            return resultMap;
        }
        Map<String, String> nameMap = autoConfigs.stream().filter(v -> "01".equals(v.getPutType())).collect(Collectors.toMap(TLrDataserviceAutoConfig::getColumnAlias, TLrDataserviceAutoConfig::getColumnAliasDefined));
        return OracleTransactionalExecuteService.handleResultMap(nameMap, resultMap);
    }

    private static Map<String, Object> handleResultMap(Map<String, String> nameMap, Map<String, Object> resultMap) {
        HashMap resMap = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
            String key = entry.getKey();
            if (!nameMap.containsKey(key)) continue;
            resMap.put(nameMap.get(key), entry.getValue());
        }
        return resMap;
    }

    public List<Map<String, Object>> handleResultList(String dataServiceId, List<Map<String, Object>> resultList) {
        if (CollectionUtils.isEmpty(resultList)) {
            return resultList;
        }
        List autoConfigs = Lists.newArrayList();
        String key = "LR:CORE:BUSINESS:INPUT:AUTOCONFIG:" + dataServiceId;
        Object obj = this.cacheService.get("lr-core-runtime", key);
        if (obj != null) {
            autoConfigs = (List)obj;
        }
        if (CollectionUtils.isEmpty((Collection)autoConfigs)) {
            return resultList;
        }
        Map<String, String> nameMap = autoConfigs.stream().filter(v -> "01".equals(v.getPutType())).collect(Collectors.toMap(TLrDataserviceAutoConfig::getColumnAlias, TLrDataserviceAutoConfig::getColumnAliasDefined));
        ArrayList resList = Lists.newArrayListWithCapacity((int)resultList.size());
        for (Map<String, Object> resultMap : resultList) {
            resList.add(OracleTransactionalExecuteService.handleResultMap(nameMap, resultMap));
        }
        return resList;
    }

    public Object executeSaveOrUpdateMasterSlave(String masterTabeldataServiceId, String tableName, Map<String, Object> params, Set<String> dataServiceIdsSingle, Map<String, String> dataserviceIdSlaveTableNameAlias, Map<String, List<TLrDataserviceAutoConfig>> dsAutoConfMap, Map<String, String> columnIdColumnTypeMap, Map<String, TLrMetadataDetail> setsColumnMap, Map<String, TLrMetadataDetail> conditionsColumnMap, Map<String, TLrMetadataDetail> dsIdMetadetailSingle, Map<String, TLrMetadataDetail> dsIdMetadetailMutl, Map<String, String> dsIdsqlMap) {
        Object masterId = null;
        for (Map.Entry<String, TLrMetadataDetail> entry : conditionsColumnMap.entrySet()) {
            Object ID;
            if (!params.containsKey(entry.getKey())) {
                String ID2 = String.valueOf(IdGenerateUtils.getId());
                masterId = ID2;
                this.saveMasterSlave(entry, params, ID2, dsIdsqlMap, masterTabeldataServiceId, dataServiceIdsSingle, dataserviceIdSlaveTableNameAlias);
                continue;
            }
            int result = 0;
            if (params.get(entry.getKey()) != null && !"".equals(String.valueOf(params.get(entry.getKey())).trim())) {
                String selectByPk = "SELECT COUNT(*) FROM \"" + entry.getValue().getTableName() + "\" WHERE \"" + entry.getValue().getColumnName() + "\" = #{" + entry.getKey() + "}";
                params.put("selectByPk", selectByPk);
                result = this.lrBaseMapper.selectByPk(params);
            }
            if (result > 0) {
                masterId = ID = params.get(entry.getKey());
                List<Map<String, Object>> masterColumnAliasType = this.getcolumnAliasType(dsAutoConfMap.get(masterTabeldataServiceId), columnIdColumnTypeMap);
                String masterSql = this.buildUpdateSql(tableName, setsColumnMap, conditionsColumnMap, masterColumnAliasType);
                params.put("updateSql", masterSql);
                this.lrBaseMapper.masterUpdate(params);
                if (dataServiceIdsSingle.size() > 0) {
                    for (String slaversId : dataServiceIdsSingle) {
                        String slavesqldetele = this.getslavesqldetele(dsIdMetadetailSingle.get(slaversId));
                        params.put("deleteSql", slavesqldetele);
                        this.lrBaseMapper.masterDelete(params);
                        String slavesql = dsIdsqlMap.get(slaversId);
                        params.put("insertSql", slavesql);
                        this.lrBaseMapper.insert(params);
                    }
                }
                if (dataserviceIdSlaveTableNameAlias.size() <= 0) continue;
                for (String dataServiceIdslavemult : dataserviceIdSlaveTableNameAlias.keySet()) {
                    String slaveTableNameAlias = dataserviceIdSlaveTableNameAlias.get(dataServiceIdslavemult);
                    List dataList = (List)params.get(slaveTableNameAlias);
                    if (dsIdMetadetailMutl.size() > 0) {
                        String slavesqlmutldetele = this.getslavesqldetele(dsIdMetadetailMutl.get(dataServiceIdslavemult));
                        params.put("deleteSql", slavesqlmutldetele);
                        this.lrBaseMapper.masterDelete(params);
                    }
                    String slaveMutlSql = dsIdsqlMap.get(dataServiceIdslavemult);
                    if (dataList == null) continue;
                    for (Map dataParam : dataList) {
                        dataParam.put(entry.getKey(), ID);
                        dataParam.put("insertSql", slaveMutlSql);
                        this.lrBaseMapper.insert(dataParam);
                    }
                }
                continue;
            }
            ID = params.get(entry.getKey());
            if (ID == null || "".equals(String.valueOf(ID).trim())) {
                ID = String.valueOf(IdGenerateUtils.getId());
            }
            masterId = ID;
            this.saveMasterSlave(entry, params, ID, dsIdsqlMap, masterTabeldataServiceId, dataServiceIdsSingle, dataserviceIdSlaveTableNameAlias);
        }
        return masterId;
    }

    private void saveMasterSlave(Map.Entry<String, TLrMetadataDetail> entry, Map<String, Object> params, Object ID, Map<String, String> dsIdsqlMap, String masterTabeldataServiceId, Set<String> dataServiceIdsSingle, Map<String, String> dataserviceIdSlaveTableNameAlias) {
        params.put(entry.getKey(), ID);
        String masterSql = dsIdsqlMap.get(masterTabeldataServiceId);
        params.put("insertSql", masterSql);
        this.lrBaseMapper.insert(params);
        if (dataServiceIdsSingle.size() > 0) {
            for (String slaversId : dataServiceIdsSingle) {
                String slavesql = dsIdsqlMap.get(slaversId);
                params.put("insertSql", slavesql);
                this.lrBaseMapper.insert(params);
            }
        }
        if (dataserviceIdSlaveTableNameAlias.size() > 0) {
            for (String dataServiceIdslavemult : dataserviceIdSlaveTableNameAlias.keySet()) {
                String slaveTableNameAlias = dataserviceIdSlaveTableNameAlias.get(dataServiceIdslavemult);
                List dataList = (List)params.get(slaveTableNameAlias);
                String slaveMutlSql = dsIdsqlMap.get(dataServiceIdslavemult);
                if (dataList == null) continue;
                for (Map dataParam : dataList) {
                    dataParam.put(entry.getKey(), ID);
                    dataParam.put("insertSql", slaveMutlSql);
                    this.lrBaseMapper.insert(dataParam);
                }
            }
        }
    }
}

