/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.mysql.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.jxdinfo.engine.metadata.dao.TLrDatasourceTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrMetadataDetailMapper;
import com.jxdinfo.engine.metadata.dao.TLrMetadataManageTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrPlatformTableMapper;
import com.jxdinfo.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.engine.metadata.model.TLrDatasourceTable;
import com.jxdinfo.engine.metadata.model.TLrMetadataDetail;
import com.jxdinfo.engine.metadata.model.TLrMetadataManageTable;
import com.jxdinfo.engine.metadata.model.TLrMetadataParam;
import com.jxdinfo.engine.metadata.service.DynamicDataSourceService;
import com.jxdinfo.engine.metadata.strategy.TLrPlatformTableFactory;
import com.jxdinfo.engine.metadata.util.DateUtils;
import com.jxdinfo.engine.metadata.util.IdAcquisitionUtil;
import com.jxdinfo.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.engine.metadata.util.StringUtils;
import com.jxdinfo.engine.mysql.dao.MysqlTargetDataBaseMapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DS(value="master")
public class MysqlLrMetadataTableServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(MysqlLrMetadataTableServiceImpl.class);
    @Autowired
    private MysqlTargetDataBaseMapper targetDataBaseMysqlMapper;
    @Autowired
    private TLrMetadataManageTableMapper generalMetadataManageTableMapper;
    @Autowired
    private TLrMetadataDetailMapper generalMetadataDetailMapper;
    @Autowired
    private TLrDatasourceTableMapper tLrDatasourceTableMapper;
    @Autowired
    private DynamicDataSourceService dynamicDataSourceService;
    private Map<String, TLrPlatformTableMapper> metadataDetailMapper = TLrPlatformTableFactory.getMappers((String)"metadataDetail");

    public boolean insertTLrMetadataManageTable(TLrMetadataParam paramData) throws EngineException {
        String dataSourceId;
        TLrDatasourceTable datasourceTable;
        final TLrMetadataManageTable baseInfo = paramData.getBaseInfo();
        List columns = paramData.getColumnInfo();
        ArrayList<Map<String, String>> columnInfos = new ArrayList<Map<String, String>>();
        ArrayList<String> setPkColumnNames = new ArrayList<String>();
        baseInfo.setCountColumn(Long.valueOf(columns.size()));
        baseInfo.setCreateTime(DateUtils.getNowDate());
        baseInfo.setVersion(Long.valueOf(0L));
        baseInfo.setStatus(Integer.valueOf(1));
        baseInfo.setCharacterSet("UTF8");
        baseInfo.setTableId(IdGenerateUtils.getId().toString());
        if (StringUtils.isEmpty((String)baseInfo.getTableChname())) {
            baseInfo.setTableChname(baseInfo.getTableName());
        }
        if (StringUtils.isEmpty((String)baseInfo.getTableComment())) {
            baseInfo.setTableComment(baseInfo.getTableName());
        }
        if (StringUtils.isEmpty((String)baseInfo.getRemark())) {
            baseInfo.setRemark(baseInfo.getTableName());
        }
        if (Objects.isNull(datasourceTable = this.tLrDatasourceTableMapper.selectTLrDatasourceTableByDatasourceId(dataSourceId = baseInfo.getDatasourceId()))) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        String tenantId = IdAcquisitionUtil.getCurrentTenantId();
        if (!tenantId.equalsIgnoreCase(datasourceTable.getTenantId())) {
            int code = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getCode();
            String message = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getMessage() + datasourceTable.getDatasourceName() + "\u7684\u8868";
            throw new EngineException(code, message);
        }
        for (TLrMetadataDetail column : columns) {
            String type;
            String columnType;
            if (column.getIsPk().intValue() == 1) {
                setPkColumnNames.add(column.getColumnName());
            }
            HashMap<String, String> columnInfo = new HashMap<String, String>();
            columnInfo.put("columnName", column.getColumnName());
            columnInfo.put("isRequired", column.getIsRequired().toString());
            columnInfo.put("isIncre", "0");
            columnInfo.put("columnComment", column.getColumnComment());
            columnInfo.put("defaultValue", column.getDefaultValue());
            if (StringUtils.isEmpty((String)column.getColumnChname())) {
                column.setColumnChname(column.getColumnName());
            }
            if (StringUtils.isEmpty((String)column.getColumnComment())) {
                column.setColumnComment(column.getColumnName());
            }
            if ("numeric".equalsIgnoreCase(columnType = column.getColumnType()) || "decimal".equalsIgnoreCase(columnType) || "double".equalsIgnoreCase(columnType)) {
                type = columnType + "(" + column.getColumnLength() + "," + column.getPointLength() + ")";
                columnInfo.put("columnType", type);
            } else if ("date".equalsIgnoreCase(columnType) || "datetime".equalsIgnoreCase(columnType)) {
                columnInfo.put("columnType", columnType);
            } else {
                type = column.getColumnType() + "(" + column.getColumnLength() + ")";
                columnInfo.put("columnType", type);
            }
            columnInfos.add(columnInfo);
        }
        boolean needSetPk = StringUtils.isNotEmpty(setPkColumnNames);
        try {
            this.dynamicDataSourceService.switchDataSource(datasourceTable);
            List<TLrMetadataDetail> tLrMetadataDetails = this.targetDataBaseMysqlMapper.selectColumnsByTableNames((List<String>)new ArrayList<String>(){
                {
                    this.add(baseInfo.getTableName());
                }
            }, null);
            if (ToolUtil.isNotEmpty(tLrMetadataDetails)) {
                throw new Exception(baseInfo.getTableName() + "\u8868\u5df2\u5b58\u5728");
            }
            this.targetDataBaseMysqlMapper.createTable(baseInfo.getTableName(), baseInfo.getTableComment(), columnInfos, needSetPk, setPkColumnNames);
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.CREATE_DATABASE_TABLE_FAILED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
        TLrMetadataManageTable tableExit = this.generalMetadataManageTableMapper.selectTLrMetadataManageTableByTableName(baseInfo);
        if (!StringUtils.isNull((Object)tableExit)) {
            this.generalMetadataManageTableMapper.deleteTLrMetadataManageTableById(tableExit.getTableId());
            this.generalMetadataDetailMapper.delColumn(tableExit.getTableId());
        }
        return this.insertTableInfo(paramData);
    }

    public boolean insertTableInfo(TLrMetadataParam paramData) throws EngineException {
        TLrMetadataManageTable baseInfo = paramData.getBaseInfo();
        String datasourceType = this.dynamicDataSourceService.getDatasourceType();
        try {
            baseInfo.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            baseInfo.setUserId(IdAcquisitionUtil.getCurrentUserId());
            baseInfo.setRemark(baseInfo.getTableComment());
            if (StringUtils.isEmpty((String)baseInfo.getTableChname())) {
                baseInfo.setTableChname(baseInfo.getTableName());
            }
            if (StringUtils.isEmpty((String)baseInfo.getTableComment())) {
                baseInfo.setTableComment(baseInfo.getTableName());
            }
            if (StringUtils.isEmpty((String)baseInfo.getRemark())) {
                baseInfo.setRemark(baseInfo.getTableName());
            }
            this.generalMetadataManageTableMapper.insertTLrMetadataManageTable(baseInfo);
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.INSERT_TABLE_INFORMATION_FAILED, (Throwable)e);
        }
        List columns = paramData.getColumnInfo();
        for (TLrMetadataDetail column : columns) {
            column.setColumnId(IdGenerateUtils.getId().toString());
            column.setTableId(baseInfo.getTableId());
            column.setStatus(Integer.valueOf(1));
            column.setCreateTime(DateUtils.getNowDate());
            column.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            column.setUserId(IdAcquisitionUtil.getCurrentUserId());
        }
        try {
            this.metadataDetailMapper.get(datasourceType).batchInsert(columns);
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.INSERT_COLUMN_INFORMATION_FAILED, (Throwable)e);
        }
        return true;
    }

    public boolean updateTLrMetadataManageTable(TLrMetadataParam paramData) throws EngineException {
        block41: {
            TLrMetadataManageTable baseInfo = paramData.getBaseInfo();
            List newColumnInfo = paramData.getColumnInfo();
            String dataSourceId = baseInfo.getDatasourceId();
            TLrDatasourceTable datasourceTable = this.tLrDatasourceTableMapper.selectTLrDatasourceTableByDatasourceId(dataSourceId);
            if (Objects.isNull(datasourceTable)) {
                throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
            }
            String tenantId = IdAcquisitionUtil.getCurrentTenantId();
            if (!tenantId.equalsIgnoreCase(datasourceTable.getTenantId())) {
                int code = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getCode();
                String message = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getMessage() + datasourceTable.getDatasourceName() + "\u7684\u8868";
                throw new EngineException(code, message);
            }
            List oldColumnInfo = this.generalMetadataDetailMapper.selectColumnInfo(baseInfo.getTableId());
            baseInfo.setCountColumn(Long.valueOf(newColumnInfo.size()));
            baseInfo.setUpdateTime(DateUtils.getNowDate());
            baseInfo.setUpdateByUserid(IdAcquisitionUtil.getCurrentUserId());
            baseInfo.setTenantId(tenantId);
            if (StringUtils.isEmpty((String)baseInfo.getTableChname())) {
                baseInfo.setTableChname(baseInfo.getTableName());
            }
            if (StringUtils.isEmpty((String)baseInfo.getTableComment())) {
                baseInfo.setTableComment(baseInfo.getTableName());
            }
            if (StringUtils.isEmpty((String)baseInfo.getRemark())) {
                baseInfo.setRemark(baseInfo.getTableName());
            }
            String oldTableName = this.generalMetadataManageTableMapper.getTableNameById(baseInfo.getTableId());
            String newTableName = baseInfo.getTableName();
            Long tableVersion = this.generalMetadataManageTableMapper.getVersion(baseInfo.getTableId());
            baseInfo.setVersion(tableVersion);
            ArrayList<Map<String, String>> editColumnsIsPk = new ArrayList<Map<String, String>>();
            ArrayList editColumnsNotPk = new ArrayList();
            ArrayList<Map<String, String>> addColumns = new ArrayList<Map<String, String>>();
            ArrayList<String> setPkColumnNames = new ArrayList<String>();
            ArrayList<String> delColNames = new ArrayList<String>();
            List delColList = paramData.getDeletedCols();
            Map columnMapOld = oldColumnInfo.stream().collect(Collectors.toMap(TLrMetadataDetail::getColumnName, Function.identity()));
            Map columnMapNew = newColumnInfo.stream().collect(Collectors.toMap(TLrMetadataDetail::getColumnName, Function.identity()));
            Map columnMapDel = delColList.stream().collect(Collectors.toMap(TLrMetadataDetail::getColumnName, Function.identity()));
            block17: for (Map.Entry entry : columnMapOld.entrySet()) {
                if (columnMapNew.get(entry.getKey()) != null || columnMapDel.get(entry.getKey()) != null || ((TLrMetadataDetail)entry.getValue()).getIsPk() != 1) continue;
                setPkColumnNames.add(entry.getKey());
                for (Map.Entry entryNew : columnMapNew.entrySet()) {
                    if (!((TLrMetadataDetail)entry.getValue()).getColumnId().equals(((TLrMetadataDetail)entryNew.getValue()).getColumnId())) continue;
                    setPkColumnNames.remove(entry.getKey());
                    continue block17;
                }
            }
            for (TLrMetadataDetail tLrMetadataDetail : newColumnInfo) {
                String type;
                if (StringUtils.isEmpty((String)tLrMetadataDetail.getColumnChname())) {
                    tLrMetadataDetail.setColumnComment(tLrMetadataDetail.getColumnName());
                    tLrMetadataDetail.setColumnChname(tLrMetadataDetail.getColumnName());
                }
                HashMap<String, String> column = new HashMap<String, String>();
                column.put("isRequired", tLrMetadataDetail.getIsRequired().toString());
                column.put("isIncre", tLrMetadataDetail.getIsIncre().toString());
                column.put("columnComment", tLrMetadataDetail.getColumnComment());
                column.put("defaultValue", tLrMetadataDetail.getDefaultValue());
                String columnType = tLrMetadataDetail.getColumnType();
                if ("numeric".equals(columnType) || "decimal".equalsIgnoreCase(columnType) || "double".equalsIgnoreCase(columnType) || "float".equalsIgnoreCase(columnType)) {
                    type = columnType + "(" + tLrMetadataDetail.getColumnLength() + "," + tLrMetadataDetail.getPointLength() + ")";
                    column.put("columnType", type);
                } else if ("date".equalsIgnoreCase(columnType) || "datetime".equalsIgnoreCase(columnType)) {
                    column.put("columnType", columnType);
                } else {
                    type = tLrMetadataDetail.getColumnType() + "(" + tLrMetadataDetail.getColumnLength() + ")";
                    column.put("columnType", type);
                }
                if (tLrMetadataDetail.getOperation() != null && "edit".equals(tLrMetadataDetail.getOperation())) {
                    column.put("newColumnName", tLrMetadataDetail.getColumnName());
                    for (TLrMetadataDetail oldColumn : oldColumnInfo) {
                        if (!tLrMetadataDetail.getColumnId().equals(oldColumn.getColumnId())) continue;
                        column.put("oldColumnName", oldColumn.getColumnName());
                        tLrMetadataDetail.setCreateTime(oldColumn.getCreateTime());
                        if (tLrMetadataDetail.getIsPk().intValue() != 1) break;
                        setPkColumnNames.add(oldColumn.getColumnName());
                        break;
                    }
                    if ("1".equals(tLrMetadataDetail.getIsPk().toString())) {
                        editColumnsIsPk.add(column);
                        continue;
                    }
                    editColumnsNotPk.add(column);
                    continue;
                }
                if (tLrMetadataDetail.getOperation() != null && "add".equals(tLrMetadataDetail.getOperation())) {
                    column.put("columnName", tLrMetadataDetail.getColumnName());
                    column.put("newColumnName", tLrMetadataDetail.getColumnName());
                    column.put("oldColumnName", tLrMetadataDetail.getColumnName());
                    addColumns.add(column);
                    if (tLrMetadataDetail.getIsPk().intValue() != 1) continue;
                    setPkColumnNames.add(tLrMetadataDetail.getColumnName());
                    continue;
                }
                if (tLrMetadataDetail.getIsPk().intValue() != 1) continue;
                setPkColumnNames.add(tLrMetadataDetail.getColumnName());
            }
            try {
                boolean bl;
                this.dynamicDataSourceService.switchDataSource(datasourceTable);
                if (!oldTableName.equalsIgnoreCase(newTableName)) {
                    try {
                        this.targetDataBaseMysqlMapper.changeTableName(oldTableName, newTableName);
                    }
                    catch (Exception e) {
                        throw new EngineException(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED, (Throwable)e);
                    }
                }
                if (StringUtils.isNotEmpty(addColumns)) {
                    try {
                        this.targetDataBaseMysqlMapper.addTableCols(newTableName, addColumns);
                    }
                    catch (Exception e) {
                        throw new EngineException(EngineExceptionEnum.INSERT_COLUMN_FAILED, (Throwable)e);
                    }
                }
                if (StringUtils.isNotEmpty(editColumnsNotPk)) {
                    for (final Map map : editColumnsNotPk) {
                        try {
                            this.targetDataBaseMysqlMapper.editTableCols(newTableName, (List<Map<String, String>>)new ArrayList<Map<String, String>>(){
                                {
                                    this.add(map);
                                }
                            });
                        }
                        catch (Exception e) {
                            throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_FAILED.getMessage() + "\u4e0d\u652f\u6301\u7c7b\u578b" + (String)map.get("columnType"), (Throwable)e);
                        }
                    }
                }
                if (StringUtils.isNotEmpty((Collection)delColList)) {
                    for (TLrMetadataDetail tLrMetadataDetail : delColList) {
                        delColNames.add(tLrMetadataDetail.getColumnName());
                    }
                    try {
                        this.targetDataBaseMysqlMapper.delTableCols(newTableName, delColNames);
                    }
                    catch (Exception e) {
                        throw new EngineException(EngineExceptionEnum.DELETE_COLUMN_FAILED, (Throwable)e);
                    }
                }
                boolean isHavePk = this.targetDataBaseMysqlMapper.isHavePk(newTableName) > 0;
                boolean bl2 = bl = !setPkColumnNames.isEmpty();
                if (isHavePk || bl) {
                    try {
                        this.targetDataBaseMysqlMapper.setPk(newTableName, isHavePk, bl, setPkColumnNames);
                    }
                    catch (Exception e) {
                        throw new EngineException(EngineExceptionEnum.INSERT_DELETE_PRIMARY_KEY_FAILED, (Throwable)e);
                    }
                }
                if (!StringUtils.isNotEmpty(editColumnsIsPk)) break block41;
                try {
                    this.targetDataBaseMysqlMapper.editTableCols(newTableName, editColumnsIsPk);
                }
                catch (Exception e) {
                    throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_FAILED, (Throwable)e);
                }
            }
            catch (Exception e) {
                throw new EngineException(e.getMessage());
            }
            finally {
                this.dynamicDataSourceService.clearDataSourceType();
            }
        }
        return this.updateTableInfo(paramData);
    }

    public boolean updateTableInfo(TLrMetadataParam paramData) throws EngineException {
        String datasourceType = this.dynamicDataSourceService.getDatasourceType();
        try {
            this.generalMetadataManageTableMapper.updateTLrMetadataManageTable(paramData.getBaseInfo());
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.EDIT_TABLE_INFORMATION_FAILED);
        }
        List delColsInfo = paramData.getDeletedCols();
        if (StringUtils.isNotEmpty((Collection)paramData.getDeletedCols())) {
            try {
                this.generalMetadataDetailMapper.delColInfo(delColsInfo);
            }
            catch (Exception e) {
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        List columnInfo = paramData.getColumnInfo();
        ArrayList<TLrMetadataDetail> editColumnInfo = new ArrayList<TLrMetadataDetail>();
        ArrayList<TLrMetadataDetail> addColumnInfo = new ArrayList<TLrMetadataDetail>();
        Date date = DateUtils.getNowDate();
        for (TLrMetadataDetail tLrMetadataDetail : columnInfo) {
            if (tLrMetadataDetail.getOperation() != null && "edit".equals(tLrMetadataDetail.getOperation())) {
                if (null == tLrMetadataDetail.getColumnComment() || "".equals(tLrMetadataDetail.getColumnComment())) {
                    tLrMetadataDetail.setColumnComment(tLrMetadataDetail.getColumnName());
                }
                if (null == tLrMetadataDetail.getColumnChname() || "".equals(tLrMetadataDetail.getColumnChname())) {
                    tLrMetadataDetail.setColumnChname(tLrMetadataDetail.getColumnName());
                }
                if (null == tLrMetadataDetail.getRemark() || "".equals(tLrMetadataDetail.getRemark())) {
                    tLrMetadataDetail.setRemark(tLrMetadataDetail.getColumnName());
                }
                tLrMetadataDetail.setUpdateTime(date);
                tLrMetadataDetail.setStatus(Integer.valueOf(1));
                tLrMetadataDetail.setUpdateByUserid(IdAcquisitionUtil.getCurrentUserId());
                tLrMetadataDetail.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
                editColumnInfo.add(tLrMetadataDetail);
                continue;
            }
            if (tLrMetadataDetail.getOperation() == null || !"add".equals(tLrMetadataDetail.getOperation())) continue;
            tLrMetadataDetail.setColumnId(IdGenerateUtils.getId().toString());
            if (null == tLrMetadataDetail.getColumnComment() || "".equals(tLrMetadataDetail.getColumnComment())) {
                tLrMetadataDetail.setColumnComment(tLrMetadataDetail.getColumnName());
            }
            if (null == tLrMetadataDetail.getColumnChname() || "".equals(tLrMetadataDetail.getColumnChname())) {
                tLrMetadataDetail.setColumnChname(tLrMetadataDetail.getColumnName());
            }
            if (null == tLrMetadataDetail.getRemark() || "".equals(tLrMetadataDetail.getRemark())) {
                tLrMetadataDetail.setRemark(tLrMetadataDetail.getColumnName());
            }
            tLrMetadataDetail.setStatus(Integer.valueOf(1));
            tLrMetadataDetail.setCreateTime(date);
            tLrMetadataDetail.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            tLrMetadataDetail.setUserId(IdAcquisitionUtil.getCurrentUserId());
            addColumnInfo.add(tLrMetadataDetail);
        }
        if (StringUtils.isNotEmpty(editColumnInfo)) {
            try {
                this.metadataDetailMapper.get(datasourceType).batchInsert(editColumnInfo);
            }
            catch (Exception e) {
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        if (StringUtils.isNotEmpty(addColumnInfo)) {
            try {
                this.metadataDetailMapper.get(datasourceType).batchInsert(addColumnInfo);
            }
            catch (Exception e) {
                throw new EngineException(EngineExceptionEnum.EDIT_COLUMN_INFORMATION_FAILED);
            }
        }
        return true;
    }

    public boolean insertView(TLrMetadataParam paramData) throws EngineException {
        TLrMetadataManageTable baseInfo = paramData.getBaseInfo();
        List columns = paramData.getColumnInfo();
        baseInfo.setCountColumn(Long.valueOf(columns.size()));
        baseInfo.setCreateTime(DateUtils.getNowDate());
        baseInfo.setVersion(Long.valueOf(0L));
        baseInfo.setStatus(Integer.valueOf(1));
        baseInfo.setViewFlag(Byte.valueOf((byte)1));
        baseInfo.setCharacterSet("UTF8");
        baseInfo.setTableId(IdGenerateUtils.getId().toString());
        for (TLrMetadataDetail column : columns) {
            column.setIsPk(Byte.valueOf((byte)0));
            column.setIsIncre(Byte.valueOf((byte)0));
            column.setIsRequired(Byte.valueOf((byte)0));
            if (StringUtils.isEmpty((String)column.getColumnChname())) {
                column.setColumnChname(column.getColumnName());
            }
            if (!StringUtils.isEmpty((String)column.getColumnComment())) continue;
            column.setColumnComment(column.getColumnName());
        }
        String dataSourceId = baseInfo.getDatasourceId();
        TLrDatasourceTable datasourceTable = this.tLrDatasourceTableMapper.selectTLrDatasourceTableByDatasourceId(dataSourceId);
        if (Objects.isNull(datasourceTable)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        String tenantId = IdAcquisitionUtil.getCurrentTenantId();
        if (!tenantId.equalsIgnoreCase(datasourceTable.getTenantId())) {
            int code = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getCode();
            String message = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getMessage() + datasourceTable.getDatasourceName() + "\u7684\u8868";
            throw new EngineException(code, message);
        }
        TLrMetadataManageTable tableExit = this.generalMetadataManageTableMapper.selectTLrMetadataManageTableByTableName(baseInfo);
        if (!StringUtils.isNull((Object)tableExit)) {
            this.generalMetadataManageTableMapper.deleteTLrMetadataManageTableById(tableExit.getTableId());
            this.generalMetadataDetailMapper.delColumn(tableExit.getTableId());
        }
        return this.insertTableInfo(paramData);
    }
}

