/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.kingbase.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.engine.common.service.LrCacheService;
import com.jxdinfo.engine.common.util.SpringUtils;
import com.jxdinfo.engine.kingbase.service.IKingbaseLrBaseInvokeService;
import com.jxdinfo.engine.kingbase.service.KingbaseTransactionalExecuteService;
import com.jxdinfo.engine.kingbase.service.KingbaseValidateParamService;
import com.jxdinfo.engine.kingbase.util.KingbaseQueryConditionUtil;
import com.jxdinfo.engine.kingbase.util.KingbaseQuerySingleConditionUtil;
import com.jxdinfo.engine.metadata.constant.LRConstants;
import com.jxdinfo.engine.metadata.dao.TLrBaseMapper;
import com.jxdinfo.engine.metadata.dao.TLrDataServiceSqlMapper;
import com.jxdinfo.engine.metadata.dao.TLrDataserviceAutoconfigMapper;
import com.jxdinfo.engine.metadata.dao.TLrDataserviceConfigrationTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrDatasourceTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrMetadataDetailMapper;
import com.jxdinfo.engine.metadata.dao.TLrMetadataManageTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrServiceDetailMapper;
import com.jxdinfo.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.engine.metadata.enums.MapperTypeEnum;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.engine.metadata.model.InputColumnVO;
import com.jxdinfo.engine.metadata.model.InvokeResponse;
import com.jxdinfo.engine.metadata.model.TLrDataServiceSql;
import com.jxdinfo.engine.metadata.model.TLrDataserviceAutoConfig;
import com.jxdinfo.engine.metadata.model.TLrDataserviceConfigurationTable;
import com.jxdinfo.engine.metadata.model.TLrDatasourceTable;
import com.jxdinfo.engine.metadata.model.TLrMetadataDetail;
import com.jxdinfo.engine.metadata.model.TLrMetadataManageTable;
import com.jxdinfo.engine.metadata.model.TLrServiceDetailTable;
import com.jxdinfo.engine.metadata.service.DynamicDataSourceService;
import com.jxdinfo.engine.metadata.util.DateUtils;
import com.jxdinfo.engine.metadata.util.IdAcquisitionUtil;
import com.jxdinfo.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.engine.metadata.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@DS(value="master")
public class KingbaseLrBaseInvokeServiceImpl
implements IKingbaseLrBaseInvokeService {
    private static final String FOREACH_COLUMN = "foreach_column";
    private static final String FOREACH_PREFIX = "foreach_";
    @Autowired
    private TLrDataserviceConfigrationTableMapper tLrDataserviceConfigrationTableMapper;
    @Autowired
    private KingbaseTransactionalExecuteService transactionalExecuteService;
    @Autowired
    private KingbaseValidateParamService validateParamService;
    @Autowired
    private TLrDatasourceTableMapper tLrDatasourceTableMapper;
    @Autowired
    private DynamicDataSourceService dynamicDataSourceService;
    @Autowired
    private TLrDataServiceSqlMapper tLrDataServiceSqlMapper;
    @Autowired
    private TLrBaseMapper lrBaseMapper;
    @Autowired
    private TLrMetadataDetailMapper tLrMetadataDetailMapper;
    @Autowired
    private TLrMetadataManageTableMapper tLrMetadataManageTableMapper;
    @Autowired
    private LrCacheService cacheService;
    @Autowired
    private TLrDataserviceAutoconfigMapper tLrDataserviceAutoconfigMapper;

    @Override
    public InvokeResponse remove(Map<String, Object> params, String serviceId) throws EngineException {
        return this.invokeMethod(params, serviceId, MapperTypeEnum.DELETE);
    }

    @Override
    public InvokeResponse queryInfoById(Map<String, Object> params, String serviceId) throws EngineException {
        return this.invokeInfoMethod(params, serviceId);
    }

    @Override
    public InvokeResponse queryDataList(Map<String, Object> params, String serviceId) throws EngineException {
        return this.invokeListMethod(params, serviceId, false);
    }

    @Override
    public InvokeResponse queryDataPageList(Map<String, Object> params, String serviceId) throws EngineException {
        return this.invokeListMethod(params, serviceId, true);
    }

    @Override
    public InvokeResponse queryProceList(Map<String, Object> params, String serviceId) throws EngineException {
        return this.invokeProceMethod(params, serviceId, false);
    }

    @Override
    public InvokeResponse queryPageProceList(Map<String, Object> params, String serviceId) throws EngineException {
        return this.invokeProceMethod(params, serviceId, true);
    }

    @Override
    public InvokeResponse add(Map<String, Object> params, String serviceId) throws EngineException {
        return this.invokeMethod(params, serviceId, MapperTypeEnum.INSERT);
    }

    @Override
    public InvokeResponse edit(Map<String, Object> params, String serviceId) throws EngineException {
        return this.invokeMethod(params, serviceId, MapperTypeEnum.UPDATE);
    }

    @Override
    public InvokeResponse saveOrUpdate(Map<String, Object> params, String serviceId) throws EngineException {
        return this.invokeSaveOrUpdateMethod(params, serviceId, MapperTypeEnum.SAVEORUPDATE);
    }

    @Override
    public InvokeResponse saveOrUpdateBatch(Map<String, Object> params, String serviceId) throws EngineException {
        return this.invokeSaveOrUpdateMethod(params, serviceId, MapperTypeEnum.SAVEORUPDATEBATCH);
    }

    @Override
    public InvokeResponse editSaveOrUpdateBatch(Map<String, Object> params, String serviceId) throws EngineException {
        return this.invokeEditSaveOrUpdateBatchMethod(params, serviceId, MapperTypeEnum.EDITSAVEORUPDATEBATCH);
    }

    private InvokeResponse invokeSaveOrUpdateMethod(Map<String, Object> params, String serviceId, MapperTypeEnum mapperType) throws EngineException {
        List<TLrServiceDetailTable> details = this.getServiceDetailsByServiceId(serviceId);
        TLrServiceDetailTable detail = details.get(0);
        String dataServiceId = detail.getDataserviceId();
        TLrDataserviceConfigurationTable dataService = this.tLrDataserviceConfigrationTableMapper.selectTLrDataserviceConfigrationTableById(dataServiceId);
        if (params.isEmpty()) {
            int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
            String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
            throw new EngineException(code, message);
        }
        List paramList = Lists.newArrayList();
        if (MapperTypeEnum.SAVEORUPDATEBATCH.name().equalsIgnoreCase(mapperType.name()) && CollectionUtils.isEmpty((Collection)(paramList = JSONObject.parseArray((String)JSONObject.toJSON((Object)params.get("importList")).toString(), Map.class)))) {
            int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
            String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
            throw new EngineException(code, message);
        }
        Map<String, List<TLrDataserviceAutoConfig>> dataServiceConfigMap = this.initAutoConfig(Sets.newHashSet((Object[])new String[]{dataServiceId}));
        Map<String, TLrDatasourceTable> dataSourceMap = this.getDataSources();
        TLrDatasourceTable dataSource = dataSourceMap.get(dataService.getDatasourceId());
        List<TLrDataserviceAutoConfig> autoConfigList = dataServiceConfigMap.get(dataServiceId);
        TLrMetadataManageTable tLrMetadataManageTable = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(autoConfigList.get(0).getTableId());
        LinkedHashMap columnMap = Maps.newLinkedHashMap();
        for (TLrDataserviceAutoConfig tLrDataserviceAutoConfig : autoConfigList) {
            TLrMetadataDetail tLrMetadataDetail = this.tLrMetadataDetailMapper.selectMetadataDetailBycolumnId(tLrDataserviceAutoConfig.getColumnId());
            columnMap.put(tLrDataserviceAutoConfig.getColumnId(), tLrMetadataDetail);
            if (MapperTypeEnum.SAVEORUPDATEBATCH.name().equalsIgnoreCase(mapperType.name())) {
                for (Map param : paramList) {
                    this.handleDate(tLrDataserviceAutoConfig, tLrMetadataDetail, param);
                }
                continue;
            }
            this.handleDate(tLrDataserviceAutoConfig, tLrMetadataDetail, params);
        }
        String sql = this.getSql(dataServiceId);
        try {
            this.dynamicDataSourceService.switchDataSource(dataSource);
            if (MapperTypeEnum.SAVEORUPDATEBATCH.name().equalsIgnoreCase(mapperType.name())) {
                for (Map param : paramList) {
                    this.executeSql(param, MapperTypeEnum.SAVEORUPDATE.name(), autoConfigList, tLrMetadataManageTable, columnMap, sql);
                }
                InvokeResponse invokeResponse = new InvokeResponse(true);
                return invokeResponse;
            }
            Object object = this.executeSql(params, mapperType.name(), autoConfigList, tLrMetadataManageTable, columnMap, sql);
            InvokeResponse invokeResponse = new InvokeResponse(true, object);
            return invokeResponse;
        }
        catch (EngineException engineException) {
            throw engineException;
        }
        catch (Exception exception) {
            throw new EngineException(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED, (Throwable)exception);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
    }

    private void handleDate(TLrDataserviceAutoConfig autoConfig, TLrMetadataDetail tLrMetadataDetail, Map<String, Object> params) throws EngineException {
        String columnAliasDefined = autoConfig.getColumnAliasDefined();
        if ((tLrMetadataDetail.getColumnType().toUpperCase().contains("DATE") || tLrMetadataDetail.getColumnType().toUpperCase().contains("TIME")) && params.containsKey(columnAliasDefined)) {
            String dateStr = params.get(columnAliasDefined).toString();
            Date date = DateUtils.convertStringToDate((String)dateStr);
            params.put(columnAliasDefined, date);
        }
        if (LRConstants.detail_type.contains(tLrMetadataDetail.getColumnType().toUpperCase()) && params.containsKey(columnAliasDefined) && params.get(columnAliasDefined) instanceof String && "".equals(String.valueOf(params.get(columnAliasDefined)).trim())) {
            params.put(columnAliasDefined, "");
        }
    }

    private InvokeResponse invokeEditSaveOrUpdateBatchMethod(Map<String, Object> params, String serviceId, MapperTypeEnum mapperType) throws EngineException {
        List<TLrServiceDetailTable> details = this.getServiceDetailsByServiceId(serviceId);
        TLrServiceDetailTable detail = details.get(0);
        String dataServiceId = detail.getDataserviceId();
        TLrDataserviceConfigurationTable dataService = this.tLrDataserviceConfigrationTableMapper.selectTLrDataserviceConfigrationTableById(dataServiceId);
        if (params.isEmpty()) {
            int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
            String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
            throw new EngineException(code, message);
        }
        Map<String, List<TLrDataserviceAutoConfig>> dataServiceConfigMap = this.initAutoConfig(Sets.newHashSet((Object[])new String[]{dataServiceId}));
        Map<String, TLrDatasourceTable> dataSourceMap = this.getDataSources();
        TLrDatasourceTable dataSource = dataSourceMap.get(dataService.getDatasourceId());
        List<TLrDataserviceAutoConfig> autoConfigList = dataServiceConfigMap.get(dataServiceId);
        TLrMetadataManageTable tLrMetadataManageTable = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(autoConfigList.get(0).getTableId());
        LinkedHashMap columnMap = Maps.newLinkedHashMap();
        List paramDeleteList = Lists.newArrayList();
        if (Objects.nonNull(params.get("del"))) {
            paramDeleteList = JSONObject.parseArray((String)JSONObject.toJSON((Object)params.get("del")).toString(), Map.class);
        }
        List paramSaveOrUpdateBatchList = Lists.newArrayList();
        if (Objects.nonNull(params.get("insertAndUpdate"))) {
            paramSaveOrUpdateBatchList = JSONObject.parseArray((String)JSONObject.toJSON((Object)params.get("insertAndUpdate")).toString(), Map.class);
        }
        for (TLrDataserviceAutoConfig tLrDataserviceAutoConfig : autoConfigList) {
            TLrMetadataDetail tLrMetadataDetail = this.tLrMetadataDetailMapper.selectMetadataDetailBycolumnId(tLrDataserviceAutoConfig.getColumnId());
            columnMap.put(tLrDataserviceAutoConfig.getColumnId(), tLrMetadataDetail);
            if (!CollectionUtils.isEmpty(paramDeleteList)) {
                for (Map param : paramDeleteList) {
                    this.handleDate(tLrDataserviceAutoConfig, tLrMetadataDetail, param);
                }
            }
            if (CollectionUtils.isEmpty(paramSaveOrUpdateBatchList)) continue;
            for (Map param : paramSaveOrUpdateBatchList) {
                this.handleDate(tLrDataserviceAutoConfig, tLrMetadataDetail, param);
            }
        }
        String sql = this.getSql(dataServiceId);
        try {
            this.dynamicDataSourceService.switchDataSource(dataSource);
            if (!CollectionUtils.isEmpty((Collection)paramDeleteList)) {
                for (Map param : paramDeleteList) {
                    this.executeSql(param, MapperTypeEnum.EDITSAVEORUPDATEBATCH.name(), autoConfigList, tLrMetadataManageTable, columnMap, sql);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)paramSaveOrUpdateBatchList)) {
                for (Map param : paramSaveOrUpdateBatchList) {
                    this.executeSql(param, MapperTypeEnum.SAVEORUPDATE.name(), autoConfigList, tLrMetadataManageTable, columnMap, sql);
                }
            }
            InvokeResponse invokeResponse = new InvokeResponse(true);
            return invokeResponse;
        }
        catch (EngineException engineException) {
            throw engineException;
        }
        catch (Exception exception) {
            throw new EngineException(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED, (Throwable)exception);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
    }

    private InvokeResponse invokeMethod(Map<String, Object> params, String serviceId, MapperTypeEnum mapperType) throws EngineException {
        List<TLrServiceDetailTable> details = this.getServiceDetailsByServiceId(serviceId);
        TLrServiceDetailTable detail = details.get(0);
        String dataServiceId = detail.getDataserviceId();
        TLrDataserviceConfigurationTable dataService = this.tLrDataserviceConfigrationTableMapper.selectTLrDataserviceConfigrationTableById(dataServiceId);
        this.validateParamService.validate(dataService.getMapperType(), params, serviceId, Sets.newHashSet((Object[])new String[]{dataServiceId}));
        Map<String, List<TLrDataserviceAutoConfig>> dataServiceConfigMap = this.initAutoConfig(Sets.newHashSet((Object[])new String[]{dataServiceId}));
        Map<String, TLrDatasourceTable> dataSourceMap = this.getDataSources();
        TLrDatasourceTable dataSource = dataSourceMap.get(dataService.getDatasourceId());
        List<TLrDataserviceAutoConfig> autoConfigList = dataServiceConfigMap.get(dataServiceId);
        TLrMetadataManageTable tLrMetadataManageTable = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(autoConfigList.get(0).getTableId());
        LinkedHashMap columnMap = Maps.newLinkedHashMap();
        for (TLrDataserviceAutoConfig autoConfig : autoConfigList) {
            TLrMetadataDetail tLrMetadataDetail = this.tLrMetadataDetailMapper.selectMetadataDetailBycolumnId(autoConfig.getColumnId());
            columnMap.put(autoConfig.getColumnId(), tLrMetadataDetail);
            this.handleDate(autoConfig, tLrMetadataDetail, params);
        }
        String sql = this.getSql(dataServiceId);
        try {
            this.dynamicDataSourceService.switchDataSource(dataSource);
            Object result = this.executeSql(params, mapperType.name(), autoConfigList, tLrMetadataManageTable, columnMap, sql);
            InvokeResponse invokeResponse = new InvokeResponse(true, result);
            return invokeResponse;
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
    }

    public Object executeSql(Map<String, Object> params, String mapperType, List<TLrDataserviceAutoConfig> autoConfigList, TLrMetadataManageTable tLrMetadataManageTable, Map<String, TLrMetadataDetail> columnMap, String sqlStr) throws EngineException {
        if (MapperTypeEnum.DELETE.name().equalsIgnoreCase(mapperType)) {
            sqlStr = this.perfectNoPageSql(sqlStr, params);
            params.put("deleteSql", sqlStr);
            int num = this.lrBaseMapper.delete(params);
            return num;
        }
        if (MapperTypeEnum.INSERT.name().equalsIgnoreCase(mapperType)) {
            return this.executeInsertSql(params, autoConfigList, columnMap, sqlStr);
        }
        if (MapperTypeEnum.SAVEORUPDATE.name().equalsIgnoreCase(mapperType)) {
            return this.executeSaveOrUpdateSql(params, autoConfigList, tLrMetadataManageTable, columnMap, sqlStr);
        }
        if (MapperTypeEnum.EDITSAVEORUPDATEBATCH.name().equalsIgnoreCase(mapperType)) {
            this.validateParamService.validateSaveOrUpdate(params, autoConfigList, tLrMetadataManageTable, columnMap, "DELETE");
            String sql = this.getDeleteSql(params, autoConfigList, tLrMetadataManageTable, columnMap);
            params.put("deleteSql", sql);
            int num = this.lrBaseMapper.delete(params);
            return num;
        }
        String sql = this.getUpdateSql(params, autoConfigList, tLrMetadataManageTable, columnMap);
        params.put("updateSql", sql);
        int num = this.lrBaseMapper.update(params);
        return num;
    }

    private Object executeInsertSql(Map<String, Object> params, List<TLrDataserviceAutoConfig> autoConfigList, Map<String, TLrMetadataDetail> columnMap, String sql) {
        this.handleSql(params, autoConfigList, columnMap);
        Object pkValue = null;
        for (TLrDataserviceAutoConfig autoConfig : autoConfigList) {
            TLrMetadataDetail tLrMetadataDetail = columnMap.get(autoConfig.getColumnId());
            if (tLrMetadataDetail.getIsPk() != 1) continue;
            String columnAliasDefined = autoConfig.getColumnAliasDefined();
            pkValue = params.get(columnAliasDefined);
        }
        params.put("insertSql", sql);
        this.lrBaseMapper.insert(params);
        return pkValue;
    }

    private String getDeleteSql(Map<String, Object> params, List<TLrDataserviceAutoConfig> autoConfigList, TLrMetadataManageTable tLrMetadataManageTable, Map<String, TLrMetadataDetail> columnMap) {
        StringBuilder sql = new StringBuilder();
        String columnPkName = "";
        String columnAliasDefined = "";
        for (TLrDataserviceAutoConfig autoConfig : autoConfigList) {
            TLrMetadataDetail tLrMetadataDetail = columnMap.get(autoConfig.getColumnId());
            String columnName = tLrMetadataDetail.getColumnName();
            if (!params.containsKey(autoConfig.getColumnAliasDefined()) || tLrMetadataDetail.getIsPk() != 1) continue;
            columnPkName = columnName;
            columnAliasDefined = autoConfig.getColumnAliasDefined();
        }
        sql.append("DELETE FROM ").append("\"").append(tLrMetadataManageTable.getTableName()).append("\"").append(" WHERE ").append("\"").append(columnPkName).append("\"").append(" = ").append("#{").append(columnAliasDefined).append("}");
        return sql.toString();
    }

    private void handleSql(Map<String, Object> params, List<TLrDataserviceAutoConfig> autoConfigList, Map<String, TLrMetadataDetail> columnMap) {
        for (TLrDataserviceAutoConfig autoConfig : autoConfigList) {
            TLrMetadataDetail tLrMetadataDetail = columnMap.get(autoConfig.getColumnId());
            String columnAliasDefined = autoConfig.getColumnAliasDefined();
            if (tLrMetadataDetail.getIsPk() == 1) {
                Long pkValue;
                if (!params.containsKey(columnAliasDefined)) {
                    pkValue = IdGenerateUtils.getId();
                    params.put(columnAliasDefined, pkValue);
                    continue;
                }
                if (null != params.get(columnAliasDefined) && !"".equals(params.get(columnAliasDefined).toString().trim())) continue;
                pkValue = IdGenerateUtils.getId();
                params.put(columnAliasDefined, pkValue);
                continue;
            }
            if (params.containsKey(columnAliasDefined)) continue;
            if (StringUtils.isNotEmpty((String)tLrMetadataDetail.getDefaultValue())) {
                params.put(columnAliasDefined, tLrMetadataDetail.getDefaultValue());
                continue;
            }
            params.put(columnAliasDefined, "");
        }
    }

    private String perfectNoPageSql(String sql, Map<String, Object> params) {
        if (sql == null) {
            return null;
        }
        if (params.containsKey(FOREACH_COLUMN)) {
            String columnStr = (String)params.get(FOREACH_COLUMN);
            Iterable columns = Splitter.on((String)",").trimResults().split((CharSequence)columnStr);
            for (String column : columns) {
                String key = FOREACH_PREFIX + column;
                sql = sql.replace("#{" + key + "}", (String)params.get(key));
            }
        }
        return sql;
    }

    private Object executeSaveOrUpdateSql(Map<String, Object> params, List<TLrDataserviceAutoConfig> autoConfigList, TLrMetadataManageTable tLrMetadataManageTable, Map<String, TLrMetadataDetail> columnMap, String sql) throws EngineException {
        String tableName = tLrMetadataManageTable.getTableName();
        Object pkValue = null;
        for (TLrDataserviceAutoConfig autoConfig : autoConfigList) {
            TLrMetadataDetail tLrMetadataDetail = columnMap.get(autoConfig.getColumnId());
            if (tLrMetadataDetail.getIsPk() != 1) continue;
            String columnAliasDefined = autoConfig.getColumnAliasDefined();
            if (params.containsKey(columnAliasDefined) && null != params.get(columnAliasDefined) && !"".equals(params.get(columnAliasDefined).toString().trim())) {
                boolean flag;
                String selectByPk = "select COUNT(*) from  \"" + tableName + "\" where \"" + tLrMetadataDetail.getColumnName() + "\" = #{" + columnAliasDefined + "}";
                params.put("selectByPk", selectByPk);
                boolean bl = flag = this.lrBaseMapper.selectByPk(params) > 0;
                if (flag) {
                    this.validateParamService.validateSaveOrUpdate(params, autoConfigList, tLrMetadataManageTable, columnMap, "UPDATE");
                    sql = this.getUpdateSql(params, autoConfigList, tLrMetadataManageTable, columnMap);
                } else {
                    this.validateParamService.validateSaveOrUpdate(params, autoConfigList, tLrMetadataManageTable, columnMap, "INSERT");
                    this.handleSql(params, autoConfigList, columnMap);
                }
            } else {
                this.validateParamService.validateSaveOrUpdate(params, autoConfigList, tLrMetadataManageTable, columnMap, "INSERT");
                this.handleSql(params, autoConfigList, columnMap);
            }
            pkValue = params.get(columnAliasDefined);
        }
        params.put("saveOrUpdate", sql);
        this.lrBaseMapper.saveOrUpdate(params);
        return pkValue;
    }

    private String getUpdateSql(Map<String, Object> params, List<TLrDataserviceAutoConfig> autoConfigList, TLrMetadataManageTable tLrMetadataManageTable, Map<String, TLrMetadataDetail> columnMap) {
        String updateSql = "UPDATE \"" + tLrMetadataManageTable.getTableName() + "\"";
        StringBuilder updateBuilder = new StringBuilder();
        StringBuilder whereBuilder = new StringBuilder();
        updateBuilder.append(" SET");
        whereBuilder.append(" WHERE");
        for (TLrDataserviceAutoConfig autoConfig : autoConfigList) {
            TLrMetadataDetail tLrMetadataDetail = columnMap.get(autoConfig.getColumnId());
            String columnName = tLrMetadataDetail.getColumnName();
            if (!params.containsKey(autoConfig.getColumnAliasDefined()) || null == params.get(autoConfig.getColumnAliasDefined())) continue;
            if (tLrMetadataDetail.getIsPk() == 1) {
                whereBuilder.append(" ").append("\"").append(columnName).append("\" ").append("=").append(" #{").append(autoConfig.getColumnAliasDefined()).append("},");
                continue;
            }
            updateBuilder.append(" ").append("\"").append(columnName).append("\" = #{").append(autoConfig.getColumnAliasDefined()).append("},");
        }
        updateSql = updateSql + updateBuilder.toString().substring(0, updateBuilder.length() - 1);
        String whereStr = whereBuilder.toString().substring(0, whereBuilder.length() - 1);
        return updateSql + whereStr;
    }

    private String getSql(String dataServiceId) throws EngineException {
        Map detailSqlMap = (Map)this.cacheService.get("lr-core", "LR:CORE:DATA:SERVICE:SQL");
        if (CollectionUtils.isEmpty((Map)detailSqlMap) || !detailSqlMap.containsKey(dataServiceId)) {
            TLrDataServiceSqlMapper lrDataServiceSqlMapper = (TLrDataServiceSqlMapper)SpringUtils.getBean((String)"lrDataServiceSqlMapper");
            TLrDataServiceSql dataServiceSql = lrDataServiceSqlMapper.selectByDataServiceId(dataServiceId);
            if (dataServiceSql == null) {
                throw new EngineException(EngineExceptionEnum.MISSING_SQL_CONFIGURATION_INFORMATION);
            }
            if (CollectionUtils.isEmpty((Map)detailSqlMap)) {
                detailSqlMap = Maps.newHashMapWithExpectedSize((int)1);
            }
            detailSqlMap.put(dataServiceId, dataServiceSql.getDataServiceSql());
            return dataServiceSql.getDataServiceSql();
        }
        return (String)detailSqlMap.get(dataServiceId);
    }

    private InvokeResponse invokeListMethod(Map<String, Object> params, String serviceId, boolean pagination) throws EngineException {
        List<TLrServiceDetailTable> details = this.getServiceDetailsByServiceId(serviceId);
        TLrServiceDetailTable detail = details.get(0);
        String dataServiceId = detail.getDataserviceId();
        TLrDataserviceConfigurationTable dataService = this.tLrDataserviceConfigrationTableMapper.selectTLrDataserviceConfigrationTableById(dataServiceId);
        this.validateParamService.validate(dataService.getMapperType(), params, serviceId, Sets.newHashSet((Object[])new String[]{dataServiceId}));
        Map<String, List<TLrDataserviceAutoConfig>> dataServiceConfigMap = this.initAutoConfig(Sets.newHashSet((Object[])new String[]{dataServiceId}));
        Map<String, TLrDatasourceTable> dataSourceMap = this.getDataSources();
        TLrDatasourceTable dataSource = dataSourceMap.get(dataService.getDatasourceId());
        List<TLrDataserviceAutoConfig> autoConfigList = dataServiceConfigMap.get(dataServiceId);
        if (!CollectionUtils.isEmpty(autoConfigList)) {
            for (TLrDataserviceAutoConfig autoConfig : autoConfigList) {
                TLrMetadataDetail tLrMetadataDetail = this.tLrMetadataDetailMapper.selectMetadataDetailBycolumnId(autoConfig.getColumnId());
                this.handleDate(autoConfig, tLrMetadataDetail, params);
            }
        }
        String sql = this.getSqlByDataServiceId(dataServiceId, params);
        try {
            this.dynamicDataSourceService.switchDataSource(dataSource);
            List<Map<String, Object>> resultList = this.executeSelectListSql(sql, params, pagination);
            resultList = this.transactionalExecuteService.handleResultList(dataServiceId, resultList);
            List<Map<String, Object>> resultListSize = this.executeSelectListSql(sql, params, false);
            LinkedHashMap resultMap = Maps.newLinkedHashMap();
            if (Boolean.TRUE.equals(pagination)) {
                if (params.containsKey("current") && params.get("current") != null && params.get("current") instanceof Integer) {
                    long current = ((Integer)params.get("current")).intValue();
                    resultMap.put("current", current);
                } else {
                    resultMap.put("current", 1);
                }
            }
            resultMap.put("count", resultListSize.size());
            resultMap.put("data", resultList);
            InvokeResponse invokeResponse = new InvokeResponse(true, (Object)resultMap);
            return invokeResponse;
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
    }

    private InvokeResponse invokeProceMethod(Map<String, Object> params, String serviceId, boolean pagination) throws EngineException {
        params.put("userIdLR", IdAcquisitionUtil.getCurrentUserId());
        List<TLrServiceDetailTable> details = this.getServiceDetailsByServiceId(serviceId);
        TLrServiceDetailTable detail = details.get(0);
        String dataServiceId = detail.getDataserviceId();
        TLrDataserviceConfigurationTable dataService = this.tLrDataserviceConfigrationTableMapper.selectTLrDataserviceConfigrationTableById(dataServiceId);
        this.validateParamService.validate("SELECT", params, serviceId, Sets.newHashSet((Object[])new String[]{dataServiceId}));
        Map<String, List<TLrDataserviceAutoConfig>> dataServiceConfigMap = this.initAutoConfig(Sets.newHashSet((Object[])new String[]{dataServiceId}));
        Map<String, TLrDatasourceTable> dataSourceMap = this.getDataSources();
        TLrDatasourceTable dataSource = dataSourceMap.get(dataService.getDatasourceId());
        List<TLrDataserviceAutoConfig> autoConfigList = dataServiceConfigMap.get(dataServiceId);
        if (!CollectionUtils.isEmpty(autoConfigList)) {
            for (TLrDataserviceAutoConfig autoConfig : autoConfigList) {
                TLrMetadataDetail tLrMetadataDetail = this.tLrMetadataDetailMapper.selectMetadataDetailBycolumnId(autoConfig.getColumnId());
                this.handleDate(autoConfig, tLrMetadataDetail, params);
            }
        }
        String sql = this.getProceSqlByDataServiceId(dataServiceId, params);
        try {
            this.dynamicDataSourceService.switchDataSource(dataSource);
            List<Map<String, Object>> resultList = this.executeSelectListSql(sql, params, pagination);
            List<Map<String, Object>> resultListSize = this.executeSelectListSql(sql, params, false);
            resultList = this.transactionalExecuteService.handleResultList(dataServiceId, resultList);
            LinkedHashMap resultMap = Maps.newLinkedHashMap();
            if (Boolean.TRUE.equals(pagination)) {
                if (params.containsKey("current") && params.get("current") != null && params.get("current") instanceof Integer) {
                    long current = ((Integer)params.get("current")).intValue();
                    resultMap.put("current", current);
                } else {
                    resultMap.put("current", 1);
                }
                resultMap.put("count", resultListSize.size());
            }
            resultMap.put("data", resultList);
            InvokeResponse invokeResponse = new InvokeResponse(true, (Object)resultMap);
            return invokeResponse;
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
    }

    private String getProceSqlByDataServiceId(String dataServiceId, Map<String, Object> params) throws EngineException {
        String sql;
        Map detailSqlMap = (Map)this.cacheService.get("lr-core", "LR:CORE:DATA:SERVICE:SQL");
        if (CollectionUtils.isEmpty((Map)detailSqlMap) || !detailSqlMap.containsKey(dataServiceId)) {
            TLrDataServiceSqlMapper lrDataServiceSqlMapper = (TLrDataServiceSqlMapper)SpringUtils.getBean((String)"lrDataServiceSqlMapper");
            TLrDataServiceSql dataServiceSql = lrDataServiceSqlMapper.selectByDataServiceId(dataServiceId);
            if (dataServiceSql == null) {
                throw new EngineException(EngineExceptionEnum.MISSING_SQL_CONFIGURATION_INFORMATION);
            }
            if (CollectionUtils.isEmpty((Map)detailSqlMap)) {
                detailSqlMap = Maps.newHashMapWithExpectedSize((int)1);
            }
            detailSqlMap.put(dataServiceId, dataServiceSql.getDataServiceSql());
            sql = dataServiceSql.getDataServiceSql();
        } else {
            sql = (String)detailSqlMap.get(dataServiceId);
        }
        TLrDataServiceSql dataServiceSql = this.tLrDataServiceSqlMapper.selectByDataServiceId(dataServiceId);
        List inputColumnVOList = JSONArray.parseArray((String)dataServiceSql.getWhereChildren(), InputColumnVO.class);
        String whereStr = KingbaseQueryConditionUtil.dynamicWhereSql(inputColumnVOList, params);
        String sqlFinal = "".equals(whereStr.trim()) ? sql.replace("${WHERE}", "WHERE") : sql.replace("${WHERE}", whereStr + " AND ");
        return sqlFinal;
    }

    public List<Map<String, Object>> executeSelectListSql(String sql, Map<String, Object> params, boolean pagination) {
        List resultList;
        sql = KingbaseLrBaseInvokeServiceImpl.perfectSql(sql, params);
        if (!Boolean.TRUE.equals(pagination)) {
            params.put("selectListSql", sql);
            resultList = this.lrBaseMapper.selectList(params);
        } else {
            Page page = this.getPageInfo(params);
            params.put("selectListPage", sql);
            resultList = this.lrBaseMapper.selectListPage(page, params);
        }
        return resultList;
    }

    private Page getPageInfo(Map<String, Object> params) {
        Page page = new Page();
        if (params.containsKey("current") && params.get("current") != null && params.get("current") instanceof Integer) {
            int pageNum = (Integer)params.get("current");
            page.setCurrent((long)pageNum);
        } else {
            page.setCurrent(1L);
        }
        if (params.containsKey("size") && params.get("size") != null && params.get("size") instanceof Integer) {
            int pageSize = (Integer)params.get("size");
            page.setSize((long)pageSize);
        } else {
            page.setSize(50L);
        }
        return page;
    }

    private InvokeResponse invokeInfoMethod(Map<String, Object> params, String serviceId) throws EngineException {
        List<TLrServiceDetailTable> details = this.getServiceDetailsByServiceId(serviceId);
        TLrServiceDetailTable detail = details.get(0);
        String dataServiceId = detail.getDataserviceId();
        TLrDataserviceConfigurationTable dataService = this.tLrDataserviceConfigrationTableMapper.selectTLrDataserviceConfigrationTableById(dataServiceId);
        this.validateParamService.validate(dataService.getMapperType(), params, serviceId, Sets.newHashSet((Object[])new String[]{dataServiceId}));
        Map<String, List<TLrDataserviceAutoConfig>> dataServiceConfigMap = this.initAutoConfig(Sets.newHashSet((Object[])new String[]{dataServiceId}));
        Map<String, TLrDatasourceTable> dataSourceMap = this.getDataSources();
        TLrDatasourceTable dataSource = dataSourceMap.get(dataService.getDatasourceId());
        List<TLrDataserviceAutoConfig> autoConfigList = dataServiceConfigMap.get(dataServiceId);
        for (TLrDataserviceAutoConfig autoConfig : autoConfigList) {
            TLrMetadataDetail tLrMetadataDetail = this.tLrMetadataDetailMapper.selectMetadataDetailBycolumnId(autoConfig.getColumnId());
            this.handleDate(autoConfig, tLrMetadataDetail, params);
        }
        String sql = this.getSqlByDataServiceId(dataServiceId, params);
        try {
            this.dynamicDataSourceService.switchDataSource(dataSource);
            Map<String, Object> resultMap = this.executeSelectOneSql(sql, params);
            resultMap = this.transactionalExecuteService.handleResultMap(dataServiceId, resultMap);
            InvokeResponse invokeResponse = new InvokeResponse(true, resultMap);
            return invokeResponse;
        }
        catch (Exception e) {
            throw new EngineException(EngineExceptionEnum.SWITCH_DATA_SOURCE_OR_DATABASE_OPERATION_FAILED, (Throwable)e);
        }
        finally {
            this.dynamicDataSourceService.clearDataSourceType();
        }
    }

    public Map<String, Object> executeSelectOneSql(String sql, Map<String, Object> params) {
        sql = KingbaseLrBaseInvokeServiceImpl.perfectSql(sql, params);
        params.put("selectOneSql", sql);
        return this.lrBaseMapper.selectOne(params);
    }

    private static String perfectSql(String sql, Map<String, Object> params) {
        if (sql == null) {
            return null;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (!sql.contains("#{" + entry.getKey() + "}")) continue;
            sql = sql.replace("#{" + entry.getKey() + "}", "#{lr." + entry.getKey() + "}");
        }
        if (params.containsKey(FOREACH_COLUMN)) {
            String columnStr = (String)params.get(FOREACH_COLUMN);
            Iterable columns = Splitter.on((String)",").trimResults().split((CharSequence)columnStr);
            for (String column : columns) {
                String key = FOREACH_PREFIX + column;
                sql = sql.replace("#{lr." + key + "}", (String)params.get(key));
            }
        }
        return sql;
    }

    private String getSqlByDataServiceId(String dataServiceId, Map<String, Object> params) throws EngineException {
        String sql;
        Map detailSqlMap = (Map)this.cacheService.get("lr-core", "LR:CORE:DATA:SERVICE:SQL");
        if (CollectionUtils.isEmpty((Map)detailSqlMap) || !detailSqlMap.containsKey(dataServiceId)) {
            TLrDataServiceSqlMapper lrDataServiceSqlMapper = (TLrDataServiceSqlMapper)SpringUtils.getBean((String)"lrDataServiceSqlMapper");
            TLrDataServiceSql dataServiceSql = lrDataServiceSqlMapper.selectByDataServiceId(dataServiceId);
            if (dataServiceSql == null) {
                throw new EngineException(EngineExceptionEnum.MISSING_SQL_CONFIGURATION_INFORMATION);
            }
            if (CollectionUtils.isEmpty((Map)detailSqlMap)) {
                detailSqlMap = Maps.newHashMapWithExpectedSize((int)1);
            }
            detailSqlMap.put(dataServiceId, dataServiceSql.getDataServiceSql());
            sql = dataServiceSql.getDataServiceSql();
        } else {
            sql = (String)detailSqlMap.get(dataServiceId);
        }
        TLrDataServiceSql dataServiceSql = this.tLrDataServiceSqlMapper.selectByDataServiceId(dataServiceId);
        List inputColumnVOList = JSONArray.parseArray((String)dataServiceSql.getWhereChildren(), InputColumnVO.class);
        if (sql.contains(" WHERE ")) {
            String whereStr = KingbaseQuerySingleConditionUtil.dynamicWhereSql(inputColumnVOList, params);
            String selectSql = sql.substring(0, sql.lastIndexOf(" WHERE "));
            String constraintSql = sql.toLowerCase().contains("group by") ? sql.substring(sql.toLowerCase().indexOf("group by")) : (sql.toLowerCase().contains("order by") ? sql.substring(sql.toLowerCase().indexOf("order by")) : "");
            return selectSql + " " + whereStr + " " + constraintSql;
        }
        return sql;
    }

    private Map<String, TLrDatasourceTable> getDataSources() {
        Object obj = this.cacheService.get("lr-core", "LR:CORE:DATASOURCE");
        if (obj != null) {
            return (Map)obj;
        }
        List dataSources = this.tLrDatasourceTableMapper.selectAll();
        if (CollectionUtils.isEmpty((Collection)dataSources)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return dataSources.stream().collect(Collectors.toMap(TLrDatasourceTable::getDatasourceId, Function.identity()));
    }

    private Map<String, TLrDataserviceConfigurationTable> getDataServices(String serviceId, List<String> dataServiceIds) {
        String key = "LR:CORE:DATA:SERVICE:" + serviceId;
        Map<Object, Object> dataServiceMap = Maps.newHashMap();
        Object obj = this.cacheService.get("lr-core", key);
        if (obj != null) {
            dataServiceMap = (Map)obj;
        }
        if (!CollectionUtils.isEmpty((Map)dataServiceMap)) {
            return dataServiceMap;
        }
        List dataServices = this.tLrDataserviceConfigrationTableMapper.selectByIds((List)Lists.newArrayList(dataServiceIds));
        dataServiceMap = dataServices.stream().collect(Collectors.toMap(TLrDataserviceConfigurationTable::getDataserviceId, Function.identity()));
        this.cacheService.put("lr-core", key, (Object)dataServiceMap);
        return dataServiceMap;
    }

    private List<TLrServiceDetailTable> getServiceDetailsByServiceId(String serviceId) {
        Map serviceDetailMap = (Map)this.cacheService.get("lr-core", "LR:CORE:BUSINESS:SERVICE:DETAILS");
        if (CollectionUtils.isEmpty((Map)serviceDetailMap) || !serviceDetailMap.containsKey(serviceId)) {
            TLrServiceDetailMapper lrServiceDetailMapper = (TLrServiceDetailMapper)SpringUtils.getBean((String)"lrServiceDetailMapper");
            List details = lrServiceDetailMapper.selectByServiceIds((List)Lists.newArrayList((Object[])new String[]{serviceId}));
            if (CollectionUtils.isEmpty((Map)serviceDetailMap)) {
                serviceDetailMap = Maps.newHashMapWithExpectedSize((int)1);
            }
            HashMap subServiceDetailMap = Maps.newHashMapWithExpectedSize((int)1);
            subServiceDetailMap.put((byte)1, details);
            serviceDetailMap.put(serviceId, subServiceDetailMap);
            this.cacheService.put("lr-core", "LR:CORE:BUSINESS:SERVICE:DETAILS", (Object)serviceDetailMap);
            return details;
        }
        Map treeSortDetailMap = (Map)serviceDetailMap.get(serviceId);
        if (CollectionUtils.isEmpty((Map)treeSortDetailMap)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList details = Lists.newArrayList();
        for (Map.Entry entry : treeSortDetailMap.entrySet()) {
            details.addAll((Collection)entry.getValue());
        }
        return details;
    }

    public Map<String, List<TLrDataserviceAutoConfig>> initAutoConfig(Set<String> dataServiceIds) throws EngineException {
        List dsConfigList = this.tLrDataserviceAutoconfigMapper.selectByDataServiceIds(dataServiceIds);
        HashMap dsConfigsMap = Maps.newHashMapWithExpectedSize((int)dataServiceIds.size());
        if (CollectionUtils.isEmpty((Collection)dsConfigList)) {
            throw new EngineException(EngineExceptionEnum.DATA_SERVICE_CONFIGURATION_INFORMATION_NOT_OBTAINED);
        }
        for (TLrDataserviceAutoConfig autoConf : dsConfigList) {
            List<TLrDataserviceAutoConfig> configs;
            String dsId = autoConf.getDataserviceId();
            if (dsConfigsMap.containsKey(dsId)) {
                configs = (List)dsConfigsMap.get(dsId);
            } else {
                configs = Lists.newArrayList();
                dsConfigsMap.put(dsId, configs);
            }
            configs.add(autoConf);
        }
        return dsConfigsMap;
    }
}

