/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.kingbase.service;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.engine.common.service.LrCacheService;
import com.jxdinfo.engine.metadata.dao.TLrDataserviceAutoconfigMapper;
import com.jxdinfo.engine.metadata.dao.TLrMetadataDetailMapper;
import com.jxdinfo.engine.metadata.dao.TLrMetadataManageTableMapper;
import com.jxdinfo.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.engine.metadata.enums.MapperTypeEnum;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.engine.metadata.model.TLrDataserviceAutoConfig;
import com.jxdinfo.engine.metadata.model.TLrMetadataDetail;
import com.jxdinfo.engine.metadata.model.TLrMetadataManageTable;
import com.jxdinfo.engine.metadata.util.CommonUtils;
import com.jxdinfo.engine.metadata.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@DS(value="master")
public class KingbaseValidateParamService {
    private static final Logger logger = LoggerFactory.getLogger(KingbaseValidateParamService.class);
    private static final String INPUT_TYPE = "00";
    private static final long IN_DIC_CODE = 124L;
    private static final long NOT_IN_DIC_CODE = 125L;
    private static final String FOREACH_COLUMN = "foreach_column";
    private static final String FOREACH_PREFIX = "foreach_";
    @Autowired
    private TLrDataserviceAutoconfigMapper tLrDataserviceAutoconfigMapper;
    @Autowired
    private TLrMetadataManageTableMapper tLrMetadataManageTableMapper;
    @Autowired
    private TLrMetadataDetailMapper tLrMetadataDetailMapper;
    @Autowired
    private LrCacheService cacheService;

    public void validate(String mapperType, Map<String, Object> params, String serviceId, Set<String> dataServiceIds) throws EngineException {
        if (CollectionUtils.isEmpty(dataServiceIds)) {
            return;
        }
        Map<String, List<TLrDataserviceAutoConfig>> autoConfigMap = this.getDsAutoConf(dataServiceIds, serviceId);
        List<TLrDataserviceAutoConfig> autoConfList = autoConfigMap.get(dataServiceIds.iterator().next());
        HashMap mapperTypeMap = Maps.newHashMapWithExpectedSize((int)4);
        mapperTypeMap.put(MapperTypeEnum.SELECT.name(), MapperTypeEnum.SELECT);
        mapperTypeMap.put(MapperTypeEnum.INSERT.name(), MapperTypeEnum.INSERT);
        mapperTypeMap.put(MapperTypeEnum.DELETE.name(), MapperTypeEnum.DELETE);
        mapperTypeMap.put(MapperTypeEnum.UPDATE.name(), MapperTypeEnum.UPDATE);
        if (MapperTypeEnum.UPDATE == mapperTypeMap.get(mapperType)) {
            this.validateUpdate(params, autoConfList, mapperType);
        } else if (MapperTypeEnum.INSERT == mapperTypeMap.get(mapperType)) {
            this.validateInsert(serviceId, params, autoConfList);
        } else if (MapperTypeEnum.SELECT == mapperTypeMap.get(mapperType)) {
            this.validateQueryByKey(params, autoConfList, mapperType);
        } else if (MapperTypeEnum.DELETE == mapperTypeMap.get(mapperType)) {
            this.validateDeleteByKey(params, autoConfList, mapperType);
        }
    }

    private void validateUpdate(Map<String, Object> params, List<TLrDataserviceAutoConfig> autoConfList, String mapperType) throws EngineException {
        int count = 0;
        for (TLrDataserviceAutoConfig config : autoConfList) {
            if (!params.containsKey(config.getColumnAliasDefined()) || null == params.get(config.getColumnAliasDefined())) continue;
            ++count;
        }
        if (count <= 1) {
            logger.info("\u6ca1\u6709\u9700\u8981\u4fee\u6539\u7684\u5185\u5bb9");
            int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
            String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + "\u6ca1\u6709\u9700\u8981\u4fee\u6539\u7684\u5185\u5bb9";
            throw new EngineException(code, message);
        }
        if (CollectionUtils.isEmpty(autoConfList)) {
            throw new EngineException(EngineExceptionEnum.PARAMS_CONFIGURATION_INFORMATION_EMPTY);
        }
        for (TLrDataserviceAutoConfig autoConf : autoConfList) {
            String columnNameAlias = autoConf.getColumnAliasDefined();
            if (INPUT_TYPE.equals(autoConf.getInputWhere()) && !params.containsKey(columnNameAlias)) {
                logger.info("{}\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a, {}", (Object)columnNameAlias, params);
                int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
                String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + columnNameAlias + "\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a";
                throw new EngineException(code, message);
            }
            if (params.get(columnNameAlias) == null || "".equals(String.valueOf(params.get(columnNameAlias)).trim())) continue;
            KingbaseValidateParamService.handleEachParams(columnNameAlias, params.get(columnNameAlias), params, autoConf.getDictCode(), mapperType);
        }
    }

    private void validateDeleteByKey(Map<String, Object> params, List<TLrDataserviceAutoConfig> autoConfList, String mapperType) throws EngineException {
        if (CollectionUtils.isEmpty(autoConfList)) {
            logger.info("\u8be5\u5220\u9664\u65b9\u6cd5\u672a\u914d\u7f6e\u5165\u53c2");
            return;
        }
        String tableId = autoConfList.get(0).getTableId();
        String columnId = this.tLrMetadataDetailMapper.selectColumnByTableIdAndPk(tableId).getColumnId();
        for (TLrDataserviceAutoConfig autoConfig : autoConfList) {
            if (!autoConfig.getColumnId().equals(columnId)) continue;
            String columnAliasDefined = autoConfig.getColumnAliasDefined();
            if (!params.containsKey(columnAliasDefined)) {
                int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
                String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + columnAliasDefined + "\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a";
                throw new EngineException(code, message);
            }
            if (params.get(columnAliasDefined) == null || "".equals(String.valueOf(params.get(columnAliasDefined)).trim())) continue;
            KingbaseValidateParamService.handleEachParams(columnAliasDefined, params.get(columnAliasDefined), params, autoConfig.getDictCode(), mapperType);
        }
    }

    private void validateQueryByKey(Map<String, Object> params, List<TLrDataserviceAutoConfig> autoConfList, String mapperType) {
        if (null == params) {
            params = Maps.newHashMapWithExpectedSize((int)1);
        }
        if (CollectionUtils.isEmpty(autoConfList)) {
            return;
        }
        for (TLrDataserviceAutoConfig autoConf : autoConfList) {
            String columnNameAlias = autoConf.getColumnAliasDefined();
            if (!params.containsKey(columnNameAlias) || params.get(columnNameAlias) == null || "".equals(String.valueOf(params.get(columnNameAlias)).trim())) continue;
            KingbaseValidateParamService.handleEachParams(columnNameAlias, params.get(columnNameAlias), params, autoConf.getDictCode(), mapperType);
        }
    }

    private static void handleEachParams(String columnAlias, Object obj, Map<String, Object> params, Long dictCode, String mapperType) {
        long[] multiCodes = new long[]{124L, 125L};
        if (dictCode == null || !ArrayUtils.contains((long[])multiCodes, (long)dictCode)) {
            params.put(columnAlias, obj);
            return;
        }
        String val = obj.toString();
        if (obj.getClass().isArray()) {
            Object[] objs = (String[])obj;
            val = Joiner.on((String)",").skipNulls().join(objs);
        }
        params.put(FOREACH_COLUMN, Joiner.on((String)",").skipNulls().join(params.get(FOREACH_COLUMN), (Object)columnAlias, new Object[0]));
        int i = 1;
        Iterable values = Splitter.on((String)",").trimResults().split((CharSequence)val);
        String foreachStr = null;
        if (MapperTypeEnum.SELECT.name().equals(mapperType)) {
            for (String value : values) {
                String key = columnAlias + i + "LR";
                params.put(key, CommonUtils.executeDataStr((Object)value));
                foreachStr = Joiner.on((String)",").skipNulls().join(foreachStr, (Object)("#{lr." + key + "}"), new Object[0]);
                ++i;
            }
        } else {
            for (String value : values) {
                String key = columnAlias + i + "LR";
                params.put(key, CommonUtils.executeDataStr((Object)value));
                foreachStr = Joiner.on((String)",").skipNulls().join(foreachStr, (Object)("#{" + key + "}"), new Object[0]);
                ++i;
            }
        }
        params.put(FOREACH_PREFIX + columnAlias, foreachStr);
    }

    private Map<String, List<TLrDataserviceAutoConfig>> getDsAutoConf(Set<String> dataServiceIds, String serviceId) {
        String key = "LR:CORE:BUSINESS:INPUT:AUTOCONFIG:" + serviceId;
        Map confMap = Maps.newHashMap();
        Object obj = this.cacheService.get("lr-core-runtime", key);
        if (obj != null) {
            confMap = (Map)obj;
        }
        if (!CollectionUtils.isEmpty((Map)confMap)) {
            return confMap;
        }
        confMap = Maps.newHashMapWithExpectedSize((int)dataServiceIds.size());
        List autoConfList = this.tLrDataserviceAutoconfigMapper.selectByDataServiceIdsAndPutType(dataServiceIds, INPUT_TYPE);
        for (TLrDataserviceAutoConfig autoConf : autoConfList) {
            List<TLrDataserviceAutoConfig> confList;
            String dsId = autoConf.getDataserviceId();
            if (confMap.containsKey(dsId)) {
                confList = (List)confMap.get(dsId);
            } else {
                confList = Lists.newArrayList();
                confMap.put(dsId, confList);
            }
            confList.add(autoConf);
        }
        this.cacheService.put("lr-core-runtime", key, (Object)confMap);
        return confMap;
    }

    private void validateInsert(String serviceId, Map<String, Object> params, List<TLrDataserviceAutoConfig> autoConfList) throws EngineException {
        Byte isPk;
        TLrDataserviceAutoConfig autoConf;
        String columnId;
        if (CollectionUtils.isEmpty(params)) {
            logger.info("\u53c2\u6570\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a, {}", params);
            int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
            String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
            throw new EngineException(code, message);
        }
        int count = 0;
        for (TLrDataserviceAutoConfig config : autoConfList) {
            if (!params.containsKey(config.getColumnAliasDefined())) continue;
            ++count;
        }
        if (count < 1) {
            logger.info("\u6ca1\u6709\u63d2\u5165\u7684\u6570\u636e");
            int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
            String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + "\u6ca1\u6709\u63d2\u5165\u7684\u6570\u636e";
            throw new EngineException(code, message);
        }
        Map autoConfMap = autoConfList.stream().collect(Collectors.toMap(TLrDataserviceAutoConfig::getColumnId, Function.identity()));
        List<TLrMetadataDetail> metadataDetails = this.getColumns(serviceId, Lists.newArrayList(autoConfMap.keySet()));
        if (CollectionUtils.isEmpty(metadataDetails)) {
            logger.info("\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a");
            throw new EngineException(EngineExceptionEnum.COLUMN_INFORMATION_EMPTY);
        }
        TLrMetadataDetail column = metadataDetails.get(0);
        TLrMetadataManageTable metadataManage = this.getTableById(column.getTableId());
        List columns = new ArrayList();
        columns = this.tLrMetadataDetailMapper.selectByTableId(metadataManage.getTableId());
        for (TLrMetadataDetail metadataDetail : columns) {
            columnId = metadataDetail.getColumnId();
            autoConf = (TLrDataserviceAutoConfig)autoConfMap.get(columnId);
            isPk = metadataDetail.getIsPk();
            Byte isIncre = metadataDetail.getIsIncre();
            if (isPk == null || isPk != 1 || isIncre == 1 || !StringUtils.isNull((Object)autoConf)) continue;
            logger.info("\u4e3b\u952e\u6ca1\u6709\u914d\u7f6e");
            throw new EngineException(EngineExceptionEnum.PRIMARY_KEY_NOT_CONFIGURED);
        }
        for (TLrMetadataDetail metadataDetail : metadataDetails) {
            columnId = metadataDetail.getColumnId();
            autoConf = (TLrDataserviceAutoConfig)autoConfMap.get(columnId);
            String columnAlias = autoConf.getColumnAlias();
            String fieldName = autoConf.getColumnAliasDefined();
            Byte isRequired = metadataDetail.getIsRequired();
            isPk = metadataDetail.getIsPk();
            if (isPk == 1 || isRequired == null || isRequired != 1 || !StringUtils.isEmpty((String)metadataDetail.getDefaultValue()) || params.containsKey(fieldName)) continue;
            int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
            String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + fieldName + "\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a";
            throw new EngineException(code, message);
        }
    }

    private List<TLrMetadataDetail> getColumns(String serviceId, List<String> columnIds) {
        String key = "LR:CORE:BUSINESS:INPUT:COLUMNS:" + serviceId;
        Object obj = this.cacheService.get("lr-core-runtime", key);
        if (obj != null) {
            return (List)obj;
        }
        List metadataDetails = this.tLrMetadataDetailMapper.selectByIds(columnIds);
        if (CollectionUtils.isEmpty((Collection)metadataDetails)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        this.cacheService.put("lr-core-runtime", key, (Object)metadataDetails);
        return metadataDetails;
    }

    private TLrMetadataManageTable getTableById(String tableId) {
        String key = "LR:METADATA:TABLE:SINGLE:" + tableId;
        Object obj = this.cacheService.get("lr-core-runtime", key);
        if (obj != null) {
            return (TLrMetadataManageTable)obj;
        }
        TLrMetadataManageTable metadataManage = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(tableId);
        this.cacheService.put("lr-core-runtime", key, (Object)metadataManage);
        return metadataManage;
    }

    public void validateSaveOrUpdate(Map<String, Object> params, List<TLrDataserviceAutoConfig> autoConfigList, TLrMetadataManageTable tLrMetadataManageTable, Map<String, TLrMetadataDetail> columnMap, String type) throws EngineException {
        block14: {
            block15: {
                Byte isPk;
                TLrDataserviceAutoConfig autoConf;
                String columnId;
                block13: {
                    if (!type.equalsIgnoreCase(MapperTypeEnum.UPDATE.name())) break block13;
                    int count = 0;
                    for (TLrDataserviceAutoConfig config : autoConfigList) {
                        if (!params.containsKey(config.getColumnAliasDefined()) || null == params.get(config.getColumnAliasDefined())) continue;
                        ++count;
                    }
                    if (count <= 1) {
                        logger.info("\u6ca1\u6709\u9700\u8981\u4fee\u6539\u7684\u5185\u5bb9");
                        int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
                        String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + "\u6ca1\u6709\u9700\u8981\u4fee\u6539\u7684\u5185\u5bb9";
                        throw new EngineException(code, message);
                    }
                    if (CollectionUtils.isEmpty(autoConfigList)) {
                        throw new EngineException(EngineExceptionEnum.PARAMS_CONFIGURATION_INFORMATION_EMPTY);
                    }
                    break block14;
                }
                if (!type.equalsIgnoreCase(MapperTypeEnum.INSERT.name())) break block15;
                if (CollectionUtils.isEmpty(params)) {
                    logger.info("\u53c2\u6570\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a, {}", params);
                    int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
                    String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
                    throw new EngineException(code, message);
                }
                int count = 0;
                for (TLrDataserviceAutoConfig config : autoConfigList) {
                    if (!params.containsKey(config.getColumnAliasDefined())) continue;
                    ++count;
                }
                if (count < 1) {
                    logger.info("\u6ca1\u6709\u63d2\u5165\u7684\u6570\u636e");
                    int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
                    String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + "\u6ca1\u6709\u63d2\u5165\u7684\u6570\u636e";
                    throw new EngineException(code, message);
                }
                ArrayList metadataDetails = Lists.newArrayList();
                for (Map.Entry<String, TLrMetadataDetail> entry : columnMap.entrySet()) {
                    metadataDetails.add(entry.getValue());
                }
                if (CollectionUtils.isEmpty((Collection)metadataDetails)) {
                    logger.info("\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a");
                    throw new EngineException(EngineExceptionEnum.COLUMN_INFORMATION_EMPTY);
                }
                Map autoConfMap = autoConfigList.stream().collect(Collectors.toMap(TLrDataserviceAutoConfig::getColumnId, Function.identity()));
                for (TLrMetadataDetail metadataDetail : metadataDetails) {
                    columnId = metadataDetail.getColumnId();
                    autoConf = (TLrDataserviceAutoConfig)autoConfMap.get(columnId);
                    isPk = metadataDetail.getIsPk();
                    if (isPk == null || isPk != 1 || !StringUtils.isNull((Object)autoConf)) continue;
                    logger.info("\u4e3b\u952e\u6ca1\u6709\u914d\u7f6e");
                    throw new EngineException(EngineExceptionEnum.PRIMARY_KEY_NOT_CONFIGURED);
                }
                for (TLrMetadataDetail metadataDetail : metadataDetails) {
                    columnId = metadataDetail.getColumnId();
                    autoConf = (TLrDataserviceAutoConfig)autoConfMap.get(columnId);
                    String fieldName = autoConf.getColumnAliasDefined();
                    Byte isRequired = metadataDetail.getIsRequired();
                    isPk = metadataDetail.getIsPk();
                    if (isPk == 1 || isRequired == null || isRequired != 1 || !StringUtils.isEmpty((String)metadataDetail.getDefaultValue()) || params.containsKey(fieldName)) continue;
                    int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
                    String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + fieldName + "\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a";
                    throw new EngineException(code, message);
                }
                break block14;
            }
            if (!type.equalsIgnoreCase(MapperTypeEnum.DELETE.name())) break block14;
            if (CollectionUtils.isEmpty(autoConfigList)) {
                logger.info("\u8be5\u5220\u9664\u65b9\u6cd5\u672a\u914d\u7f6e\u5165\u53c2");
                return;
            }
            for (Map.Entry<String, TLrMetadataDetail> entry : columnMap.entrySet()) {
                if (entry.getValue().getIsPk() != 1) continue;
                String columnId = entry.getKey();
                for (TLrDataserviceAutoConfig autoConfig : autoConfigList) {
                    String columnAliasDefined;
                    if (!autoConfig.getColumnId().equals(columnId) || params.containsKey(columnAliasDefined = autoConfig.getColumnAliasDefined())) continue;
                    int code = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getCode();
                    String message = EngineExceptionEnum.INPUT_PARAMS_EXCEPTION.getMessage() + columnAliasDefined + "\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a";
                    throw new EngineException(code, message);
                }
            }
        }
    }
}

