/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.dm.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.engine.dm.service.IDMLrMasterSlaveModelService;
import com.jxdinfo.engine.dm.service.impl.DMLrCacheSyncServiceImpl;
import com.jxdinfo.engine.dm.util.DMQueryConditionUtil;
import com.jxdinfo.engine.metadata.constant.LRConstants;
import com.jxdinfo.engine.metadata.dao.TLrDataServiceSqlMapper;
import com.jxdinfo.engine.metadata.dao.TLrDataserviceConfigrationTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrDatasourceTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrImplementsMapper;
import com.jxdinfo.engine.metadata.dao.TLrMasterslaveModelMapper;
import com.jxdinfo.engine.metadata.dao.TLrMetadataDetailMapper;
import com.jxdinfo.engine.metadata.dao.TLrMetadataManageTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrPlatformTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrServiceDetailMapper;
import com.jxdinfo.engine.metadata.dao.TLrServiceTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrTableRelationshipMapper;
import com.jxdinfo.engine.metadata.enums.ConnectEnum;
import com.jxdinfo.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.engine.metadata.enums.MapperTypeEnum;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.engine.metadata.model.ColumnNameDefinedVO;
import com.jxdinfo.engine.metadata.model.ConstraintionVO;
import com.jxdinfo.engine.metadata.model.InputColumnVO;
import com.jxdinfo.engine.metadata.model.MasterSlaveColumnDefinedVO;
import com.jxdinfo.engine.metadata.model.MasterSlaveQueryColumnVO;
import com.jxdinfo.engine.metadata.model.OutputColumnVO;
import com.jxdinfo.engine.metadata.model.SlaveMultiOutputColumnVO;
import com.jxdinfo.engine.metadata.model.TLrDataServiceSql;
import com.jxdinfo.engine.metadata.model.TLrDataserviceAutoConfig;
import com.jxdinfo.engine.metadata.model.TLrDataserviceConfigurationTable;
import com.jxdinfo.engine.metadata.model.TLrDatasourceTable;
import com.jxdinfo.engine.metadata.model.TLrImplements;
import com.jxdinfo.engine.metadata.model.TLrMasterslaveModel;
import com.jxdinfo.engine.metadata.model.TLrMetadataDetail;
import com.jxdinfo.engine.metadata.model.TLrMetadataManageTable;
import com.jxdinfo.engine.metadata.model.TLrServiceDetailTable;
import com.jxdinfo.engine.metadata.model.TLrServiceTable;
import com.jxdinfo.engine.metadata.model.TLrTableRelationship;
import com.jxdinfo.engine.metadata.service.DynamicDataSourceService;
import com.jxdinfo.engine.metadata.strategy.TLrPlatformTableFactory;
import com.jxdinfo.engine.metadata.util.DateUtils;
import com.jxdinfo.engine.metadata.util.IdAcquisitionUtil;
import com.jxdinfo.engine.metadata.util.IdGenerateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@DS(value="master")
public class DMLrMasterSlaveModelServiceImpl
implements IDMLrMasterSlaveModelService {
    private static final Logger logger = LoggerFactory.getLogger(DMLrMasterSlaveModelServiceImpl.class);
    public static final Long MASTER_SLAVE_RELATION_ASSOCIATION = 1L;
    public static final Long MASTER_SLAVE_RELATION_COLLECTION = 2L;
    public static final Byte MASTER_SLAVE_RESULT_TYPE_SINGLE = 0;
    public static final Byte MASTER_SLAVE_RESULT_TYPE_MULTIPLE = 1;
    @Autowired
    private TLrMasterslaveModelMapper tLrMasterslaveModelMapper;
    @Autowired
    private TLrTableRelationshipMapper relationshipMapper;
    @Autowired
    private TLrMetadataManageTableMapper tLrMetadataManageTableMapper;
    @Autowired
    private TLrDatasourceTableMapper tLrDatasourceTableMapper;
    @Autowired
    private TLrDataserviceConfigrationTableMapper tLrDataserviceConfigrationTableMapper;
    @Autowired
    private TLrDataServiceSqlMapper tLrDataServiceSqlMapper;
    @Autowired
    private TLrMetadataDetailMapper metadataDetailMapper;
    @Autowired
    private TLrServiceTableMapper tLrServiceTableMapper;
    @Autowired
    private TLrServiceDetailMapper serviceDetailMapper;
    @Autowired
    private TLrImplementsMapper implementsMapper;
    @Autowired
    private DMLrCacheSyncServiceImpl LrCacheSyncService;
    @Autowired
    private DynamicDataSourceService dynamicDataSourceService;

    @Override
    public List<TLrMasterslaveModel> selectTLrMasterSlaveModelList(TLrMasterslaveModel tLrMasterslaveModel) throws EngineException {
        List modelList;
        if (null != tLrMasterslaveModel && null != tLrMasterslaveModel.getModelName() && !"".equals(tLrMasterslaveModel.getModelName().trim())) {
            tLrMasterslaveModel.setModelName("%" + tLrMasterslaveModel.getModelName() + "%");
        }
        if (tLrMasterslaveModel != null) {
            tLrMasterslaveModel.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        }
        if (CollectionUtils.isEmpty((Collection)(modelList = this.tLrMasterslaveModelMapper.selectTLrMasterslaveModelList(tLrMasterslaveModel)))) {
            return modelList;
        }
        for (TLrMasterslaveModel model : modelList) {
            TLrTableRelationship shipQuery = new TLrTableRelationship();
            shipQuery.setModelId(model.getModelId());
            shipQuery.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            List relationshipList = this.relationshipMapper.selectTLrTableRelationshipList(shipQuery);
            model.setRelationlist(relationshipList);
        }
        return modelList;
    }

    @Override
    public List<TLrMasterslaveModel> selectTLrMasterSlaveModelByModelName(TLrMasterslaveModel tLrMasterslaveModel) {
        tLrMasterslaveModel.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        List modelList = this.tLrMasterslaveModelMapper.selectTLrMasterslaveModelByModelName(tLrMasterslaveModel);
        if (CollectionUtils.isEmpty((Collection)modelList)) {
            return modelList;
        }
        for (TLrMasterslaveModel model : modelList) {
            TLrTableRelationship shipQuery = new TLrTableRelationship();
            shipQuery.setModelId(model.getModelId());
            shipQuery.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
            List relationshipList = this.relationshipMapper.selectTLrTableRelationshipList(shipQuery);
            model.setRelationlist(relationshipList);
        }
        return modelList;
    }

    @Override
    public boolean insertTLrMasterSlaveModel(TLrMasterslaveModel tLrMasterslaveModel) throws EngineException {
        String modelId;
        String tenantId = IdAcquisitionUtil.getCurrentTenantId();
        String userId = IdAcquisitionUtil.getCurrentUserId();
        TLrMetadataManageTable masterTable = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(tLrMasterslaveModel.getMasterTableid());
        if (Objects.isNull(masterTable)) {
            int code = EngineExceptionEnum.TABLE_NOT_EXIST.getCode();
            String message = EngineExceptionEnum.TABLE_NOT_EXIST.getMessage() + ": " + tLrMasterslaveModel.getMasterTablename();
            throw new EngineException(code, message);
        }
        if (!tenantId.equalsIgnoreCase(masterTable.getTenantId())) {
            int code = EngineExceptionEnum.OPERATION_TABLE_FAILED.getCode();
            String message = EngineExceptionEnum.OPERATION_TABLE_FAILED.getMessage() + ": " + tLrMasterslaveModel.getMasterTablename();
            throw new EngineException(code, message);
        }
        tLrMasterslaveModel.setTenantId(tenantId);
        List masterSlaveModelList = this.tLrMasterslaveModelMapper.selectTLrMasterslaveModelByModelName(tLrMasterslaveModel);
        if (!CollectionUtils.isEmpty((Collection)masterSlaveModelList)) {
            modelId = ((TLrMasterslaveModel)masterSlaveModelList.get(0)).getModelId();
            tLrMasterslaveModel.setModelId(modelId);
            tLrMasterslaveModel.setUpdateTime(DateUtils.getNowDate());
            tLrMasterslaveModel.setUpdateByUserid(userId);
            tLrMasterslaveModel.setStatus(Integer.valueOf(1));
            this.tLrMasterslaveModelMapper.updateTLrMasterslaveModel(tLrMasterslaveModel);
            this.relationshipMapper.deleteRelationShipByModelid(modelId);
        } else {
            tLrMasterslaveModel.setCreateTime(DateUtils.getNowDate());
            modelId = String.valueOf(IdGenerateUtils.getId());
            tLrMasterslaveModel.setModelId(modelId);
            tLrMasterslaveModel.setUserId(userId);
            tLrMasterslaveModel.setStatus(Integer.valueOf(1));
            this.tLrMasterslaveModelMapper.insertTLrMasterslaveModel(tLrMasterslaveModel);
        }
        List relationList = tLrMasterslaveModel.getRelationlist();
        for (TLrTableRelationship s : relationList) {
            TLrMetadataManageTable slaveTable = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(s.getSlaveTableId());
            if (Objects.isNull(slaveTable)) {
                int code = EngineExceptionEnum.TABLE_NOT_EXIST.getCode();
                String message = EngineExceptionEnum.TABLE_NOT_EXIST.getMessage() + ": " + s.getSlaveTableId();
                throw new EngineException(code, message);
            }
            if (!tenantId.equalsIgnoreCase(slaveTable.getTenantId())) {
                int code = EngineExceptionEnum.OPERATION_TABLE_FAILED.getCode();
                String message = EngineExceptionEnum.OPERATION_TABLE_FAILED.getMessage() + ": " + s.getSlaveTableId();
                throw new EngineException(code, message);
            }
            if (!slaveTable.getDatasourceId().equals(masterTable.getDatasourceId())) {
                throw new EngineException(EngineExceptionEnum.MASTER_SLAVE_NOT_SAME_DATASOURCE);
            }
            s.setId(String.valueOf(IdGenerateUtils.getId()));
            s.setModelId(modelId);
            s.setCreateTime(DateUtils.getNowDate());
            s.setUserId(userId);
            s.setStatus(Integer.valueOf(1));
            s.setTenantId(tenantId);
        }
        String dsType = this.dynamicDataSourceService.getDatasourceType();
        Map mapperMap = TLrPlatformTableFactory.getMappers((String)"relationship");
        int row = ((TLrPlatformTableMapper)mapperMap.get(dsType)).batchInsertTLrTableRelationship(relationList);
        return row > 0;
    }

    @Override
    public boolean updateTLrMasterSlaveModel(TLrMasterslaveModel tLrMasterslaveModel) throws EngineException {
        String tenantId = IdAcquisitionUtil.getCurrentTenantId();
        TLrMasterslaveModel masterSlaveModel = this.tLrMasterslaveModelMapper.selectTLrMasterslaveModelById(tLrMasterslaveModel.getModelId());
        if (Objects.isNull(masterSlaveModel)) {
            int code = EngineExceptionEnum.MASTER_SLAVE_NOT_EXIST.getCode();
            String message = EngineExceptionEnum.MASTER_SLAVE_NOT_EXIST.getMessage() + ": " + tLrMasterslaveModel.getModelId();
            throw new EngineException(code, message);
        }
        if (!tenantId.equalsIgnoreCase(masterSlaveModel.getTenantId())) {
            int code = EngineExceptionEnum.OPERATION_MASTER_SLAVE_MODEL_FAILED.getCode();
            String message = EngineExceptionEnum.OPERATION_MASTER_SLAVE_MODEL_FAILED.getMessage() + ": " + tLrMasterslaveModel.getModelId();
            throw new EngineException(code, message);
        }
        TLrMetadataManageTable masterTable = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(tLrMasterslaveModel.getMasterTableid());
        if (Objects.isNull(masterTable)) {
            int code = EngineExceptionEnum.TABLE_NOT_EXIST.getCode();
            String message = EngineExceptionEnum.TABLE_NOT_EXIST.getMessage() + ": " + tLrMasterslaveModel.getMasterTablename();
            throw new EngineException(code, message);
        }
        if (!tenantId.equalsIgnoreCase(masterTable.getTenantId())) {
            int code = EngineExceptionEnum.OPERATION_TABLE_FAILED.getCode();
            String message = EngineExceptionEnum.OPERATION_TABLE_FAILED.getMessage() + ": " + tLrMasterslaveModel.getMasterTablename();
            throw new EngineException(code, message);
        }
        String key = this.checkModelNameUnique(tLrMasterslaveModel);
        if ("1".equals(key)) {
            throw new EngineException(EngineExceptionEnum.DUPLICATE_MODEL_NAME);
        }
        tLrMasterslaveModel.setUpdateTime(DateUtils.getNowDate());
        tLrMasterslaveModel.setUpdateByUserid(IdAcquisitionUtil.getCurrentUserId());
        tLrMasterslaveModel.setStatus(Integer.valueOf(1));
        this.tLrMasterslaveModelMapper.updateTLrMasterslaveModel(tLrMasterslaveModel);
        this.relationshipMapper.deleteRelationShipByModelid(tLrMasterslaveModel.getModelId());
        List relationList = tLrMasterslaveModel.getRelationlist();
        for (TLrTableRelationship s : relationList) {
            TLrMetadataManageTable slaveTable = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(s.getSlaveTableId());
            if (Objects.isNull(slaveTable)) {
                int code = EngineExceptionEnum.TABLE_NOT_EXIST.getCode();
                String message = EngineExceptionEnum.TABLE_NOT_EXIST.getMessage() + ": " + s.getSlaveTableId();
                throw new EngineException(code, message);
            }
            if (!tenantId.equalsIgnoreCase(slaveTable.getTenantId())) {
                int code = EngineExceptionEnum.OPERATION_TABLE_FAILED.getCode();
                String message = EngineExceptionEnum.OPERATION_TABLE_FAILED.getMessage() + ": " + s.getSlaveTableId();
                throw new EngineException(code, message);
            }
            if (!slaveTable.getDatasourceId().equals(masterTable.getDatasourceId())) {
                throw new EngineException(EngineExceptionEnum.MASTER_SLAVE_NOT_SAME_DATASOURCE);
            }
            s.setId(String.valueOf(IdGenerateUtils.getId()));
            s.setModelId(tLrMasterslaveModel.getModelId());
            s.setCreateTime(DateUtils.getNowDate());
            s.setUserId(IdAcquisitionUtil.getCurrentUserId());
            s.setStatus(Integer.valueOf(1));
            s.setTenantId(tenantId);
        }
        String dsType = this.dynamicDataSourceService.getDatasourceType();
        Map mapperMap = TLrPlatformTableFactory.getMappers((String)"relationship");
        int row = ((TLrPlatformTableMapper)mapperMap.get(dsType)).batchInsertTLrTableRelationship(relationList);
        return row > 0;
    }

    @Override
    public String saveMasterSlaveService(MasterSlaveColumnDefinedVO masterSlaveColumnDefinedVO) throws EngineException {
        TLrMetadataManageTable baseInfo = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(masterSlaveColumnDefinedVO.getTableId());
        TLrDatasourceTable datasourceTable = this.tLrDatasourceTableMapper.selectTLrDatasourceTableByDatasourceId(baseInfo.getDatasourceId());
        if (Objects.isNull(datasourceTable)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        String tenantId = IdAcquisitionUtil.getCurrentTenantId();
        if (!tenantId.equalsIgnoreCase(datasourceTable.getTenantId())) {
            int code = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getCode();
            String message = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getMessage() + datasourceTable.getDatasourceName();
            throw new EngineException(code, message);
        }
        ArrayList dataServiceList = Lists.newArrayList();
        String dsType = this.dynamicDataSourceService.getDatasourceType();
        this.insertDataServiceTable(dataServiceList, baseInfo, masterSlaveColumnDefinedVO, datasourceTable, dsType);
        TLrImplements lrImplements = this.insertServiceAndImp(masterSlaveColumnDefinedVO, dataServiceList);
        this.LrCacheSyncService.syncInterfaceCache("ADD", lrImplements.getServiceId());
        return lrImplements.getServiceId();
    }

    @Override
    public String selectMasterSlaveService(MasterSlaveQueryColumnVO masterSlaveQueryColumnVO) throws EngineException {
        TLrMasterslaveModel masterSlaveModel = this.tLrMasterslaveModelMapper.selectTLrMasterslaveModelById(masterSlaveQueryColumnVO.getModelId());
        TLrMetadataManageTable baseInfo = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(masterSlaveModel.getMasterTableid());
        TLrDatasourceTable datasourceTable = this.tLrDatasourceTableMapper.selectTLrDatasourceTableByDatasourceId(baseInfo.getDatasourceId());
        if (Objects.isNull(datasourceTable)) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_NOT_EXIST);
        }
        String tenantId = IdAcquisitionUtil.getCurrentTenantId();
        if (!tenantId.equalsIgnoreCase(datasourceTable.getTenantId())) {
            int code = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getCode();
            String message = EngineExceptionEnum.OPERATION_DATA_SOURCE_FAILED.getMessage() + datasourceTable.getDatasourceName();
            throw new EngineException(code, message);
        }
        ArrayList dataServiceList = Lists.newArrayList();
        String dsType = this.dynamicDataSourceService.getDatasourceType();
        this.insertSelectDataServiceTable(dataServiceList, baseInfo, masterSlaveQueryColumnVO, dsType);
        TLrImplements lrImplements = this.insertSelectServiceAndImp(masterSlaveQueryColumnVO, dataServiceList);
        this.LrCacheSyncService.syncInterfaceCache("ADD", lrImplements.getServiceId());
        return lrImplements.getServiceId();
    }

    private TLrImplements insertSelectServiceAndImp(MasterSlaveQueryColumnVO masterSlaveQueryColumnVO, List<TLrDataserviceConfigurationTable> dataServiceList) {
        String userId = IdAcquisitionUtil.getCurrentUserId();
        String tenantId = IdAcquisitionUtil.getCurrentTenantId();
        String serviceId = String.valueOf(IdGenerateUtils.getId());
        String nameFlag = masterSlaveQueryColumnVO.getMapperType() + serviceId + System.currentTimeMillis();
        TLrServiceTable serviceTable = new TLrServiceTable();
        serviceTable.setServiceId(serviceId);
        serviceTable.setServiceName(nameFlag);
        serviceTable.setServiceVersion(Long.valueOf(1L));
        serviceTable.setServiceChname(nameFlag);
        serviceTable.setServiceType("00");
        serviceTable.setServiceStatuts(LRConstants.service_statuts_release);
        serviceTable.setStatus(Integer.valueOf(1));
        serviceTable.setUserId(userId);
        serviceTable.setCreateTime(DateUtils.getNowDate());
        serviceTable.setTenantId(tenantId);
        serviceTable.setRemark("\u4e3b\u4ece\u8868\u7ba1\u7406\u4e1a\u52a1\u670d\u52a1:" + this.getRemarkDetail(masterSlaveQueryColumnVO.getMapperType()));
        serviceTable.setRsv1("masterSlave");
        this.tLrServiceTableMapper.insertTLrServiceTable(serviceTable);
        for (int i = 0; i < dataServiceList.size(); ++i) {
            TLrServiceDetailTable serviceDetailTable = new TLrServiceDetailTable();
            serviceDetailTable.setDetailId(String.valueOf(IdGenerateUtils.getId()));
            serviceDetailTable.setServiceId(serviceId);
            serviceDetailTable.setDataserviceId(dataServiceList.get(i).getDataserviceId());
            serviceDetailTable.setTreeSort(Byte.valueOf((byte)(i + 1)));
            serviceDetailTable.setSortNumber(Integer.valueOf(1));
            serviceDetailTable.setStatus(Integer.valueOf(1));
            serviceDetailTable.setUserId(userId);
            serviceDetailTable.setCreateTime(DateUtils.getNowDate());
            serviceDetailTable.setTenantId(tenantId);
            this.serviceDetailMapper.insertTlrServiceDeatilTable(serviceDetailTable);
        }
        String url = masterSlaveQueryColumnVO.getMapperType() + serviceId + System.currentTimeMillis();
        TLrImplements lrImplements = new TLrImplements();
        lrImplements.setId(String.valueOf(IdGenerateUtils.getId()));
        lrImplements.setImpFlag(nameFlag);
        lrImplements.setImpName(nameFlag);
        lrImplements.setServiceId(serviceId);
        lrImplements.setUrl("/T_LR/masterSlave/" + url);
        if (masterSlaveQueryColumnVO.getMapperType().contains("DELETE")) {
            lrImplements.setRequestType("GET");
        } else {
            lrImplements.setRequestType("POST");
        }
        lrImplements.setImpVersion(Long.valueOf(1L));
        lrImplements.setImpStatus(Integer.valueOf(1));
        lrImplements.setStatus(Integer.valueOf(1));
        lrImplements.setUserId(userId);
        lrImplements.setCreateTime(DateUtils.getNowDate());
        lrImplements.setTenantId(tenantId);
        lrImplements.setVersion(Long.valueOf(1L));
        lrImplements.setReleaseSource(Integer.valueOf(3));
        lrImplements.setRemark("\u4e3b\u4ece\u8868\u7ba1\u7406\u53d1\u5e03\u63a5\u53e3:" + this.getRemarkDetail(masterSlaveQueryColumnVO.getMapperType()));
        lrImplements.setRsv1("masterSlave");
        this.implementsMapper.insertTLrImplements(lrImplements);
        return lrImplements;
    }

    private void insertSelectDataServiceTable(List<TLrDataserviceConfigurationTable> dataServiceList, TLrMetadataManageTable baseInfo, MasterSlaveQueryColumnVO masterSlaveQueryColumnVO, String dsType) {
        Map tableIdRelationMap;
        String selectOneSql;
        ArrayList<TLrDataserviceAutoConfig> autoList;
        TLrDataserviceConfigurationTable oneInsertDataServiceVo;
        TLrMasterslaveModel masterSlaveModel = this.tLrMasterslaveModelMapper.selectTLrMasterslaveModelById(masterSlaveQueryColumnVO.getModelId());
        String masterSlaveModelName = masterSlaveModel.getModelName();
        List relationshipList = this.relationshipMapper.selectTLrTableRelationshipListByModelId(masterSlaveQueryColumnVO.getModelId());
        LinkedHashMap tableIdFlag = Maps.newLinkedHashMap();
        LinkedHashMap tableIdSql = Maps.newLinkedHashMap();
        for (TLrTableRelationship relationship : relationshipList) {
            TLrMetadataManageTable masterMetadataManageTable;
            String masterTableId = relationship.getMasterTableId();
            String slaveTableId = relationship.getSlaveTableId();
            TLrMetadataManageTable slaveMetadataManageTable = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(slaveTableId);
            if (!tableIdFlag.containsKey(masterTableId)) {
                masterMetadataManageTable = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(masterTableId);
                tableIdFlag.put(masterTableId, masterMetadataManageTable.getViewFlag());
            }
            if (!tableIdSql.containsKey(masterTableId)) {
                masterMetadataManageTable = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(masterTableId);
                tableIdSql.put(masterTableId, masterMetadataManageTable.getViewSql());
            }
            if (!tableIdFlag.containsKey(slaveTableId)) {
                tableIdFlag.put(slaveTableId, slaveMetadataManageTable.getViewFlag());
            }
            if (tableIdSql.containsKey(slaveTableId)) continue;
            tableIdSql.put(slaveTableId, slaveMetadataManageTable.getViewSql());
        }
        LinkedHashMap relationTypeMap = Maps.newLinkedHashMap();
        for (TLrTableRelationship relationship : relationshipList) {
            List<TLrTableRelationship> relationships;
            Map slaveTableIdRelationMap;
            Long relationType = relationship.getRelationType();
            String slaveTableId = relationship.getSlaveTableId();
            if (relationTypeMap.containsKey(relationType)) {
                slaveTableIdRelationMap = (Map)relationTypeMap.get(relationType);
            } else {
                slaveTableIdRelationMap = Maps.newLinkedHashMap();
                relationTypeMap.put(relationType, slaveTableIdRelationMap);
            }
            if (slaveTableIdRelationMap.containsKey(slaveTableId)) {
                relationships = (List)slaveTableIdRelationMap.get(slaveTableId);
            } else {
                relationships = Lists.newArrayList();
                slaveTableIdRelationMap.put(slaveTableId, relationships);
            }
            relationships.add(relationship);
        }
        String mapperType = masterSlaveQueryColumnVO.getMapperType();
        if (mapperType.equalsIgnoreCase(MapperTypeEnum.PROCESELECT.name())) {
            if (!relationTypeMap.containsKey(MASTER_SLAVE_RELATION_ASSOCIATION)) {
                oneInsertDataServiceVo = this.insetDataServiceConfiguration(masterSlaveQueryColumnVO, baseInfo, "");
                dataServiceList.add(oneInsertDataServiceVo);
                autoList = new ArrayList<TLrDataserviceAutoConfig>();
                selectOneSql = this.getMasterProcessSelectSql(masterSlaveQueryColumnVO, oneInsertDataServiceVo, autoList);
                logger.info(" \u4e3b\u4ece\u8868\u7ba1\u7406:\u4e3b\u4ece\u67e5\u8be2,\u4e3b\u4ece\u6a21\u578b{}\u521b\u5efa\u7684\u4e3b\u8868sql======={}", (Object)masterSlaveModelName, (Object)selectOneSql);
                this.insertDataServiceDetailAndSQL(dsType, autoList, oneInsertDataServiceVo.getDataserviceId(), selectOneSql, masterSlaveQueryColumnVO.getInputColumnVoList());
            }
            for (Map.Entry entry : relationTypeMap.entrySet()) {
                tableIdRelationMap = (Map)entry.getValue();
                if (MASTER_SLAVE_RELATION_ASSOCIATION.equals(entry.getKey())) {
                    TLrDataserviceConfigurationTable oneInsertDataServiceVo2 = this.insetDataServiceConfiguration(masterSlaveQueryColumnVO, baseInfo, "");
                    dataServiceList.add(oneInsertDataServiceVo2);
                    ArrayList<TLrDataserviceAutoConfig> autoList2 = new ArrayList<TLrDataserviceAutoConfig>();
                    String selectOneSql2 = this.getOneProcessSelectSql(tableIdRelationMap, masterSlaveQueryColumnVO, oneInsertDataServiceVo2, autoList2);
                    logger.info(" \u4e3b\u4ece\u8868\u7ba1\u7406:\u4e3b\u4ece1:1\u67e5\u8be2,\u4e3b\u4ece\u6a21\u578b{}\u521b\u5efa\u76841:1\u7684sql======={}", (Object)masterSlaveModelName, (Object)selectOneSql2);
                    this.insertDataServiceDetailAndSQL(dsType, autoList2, oneInsertDataServiceVo2.getDataserviceId(), selectOneSql2, masterSlaveQueryColumnVO.getInputColumnVoList());
                    continue;
                }
                for (SlaveMultiOutputColumnVO slaveMultiOutputColumnVO : masterSlaveQueryColumnVO.getSlavemultioutputColumnVoList()) {
                    String slaveTableId = slaveMultiOutputColumnVO.getSlaveTableId();
                    TLrDataserviceConfigurationTable multiInsertDataServiceVo = this.insetDataServiceConfiguration(masterSlaveQueryColumnVO, baseInfo, slaveTableId);
                    dataServiceList.add(multiInsertDataServiceVo);
                    ArrayList<TLrDataserviceAutoConfig> autoList3 = new ArrayList<TLrDataserviceAutoConfig>();
                    String selectMultiSql = this.getMultiSelectSql(tableIdRelationMap, masterSlaveQueryColumnVO, multiInsertDataServiceVo, slaveMultiOutputColumnVO, autoList3);
                    logger.info(" \u4e3b\u4ece\u8868\u7ba1\u7406:\u4e3b\u4ece1:n\u67e5\u8be2,\u4ece\u8868{}\u521b\u5efa\u76841:n\u7684sql======={}", (Object)slaveMultiOutputColumnVO.getSlavetableName(), (Object)selectMultiSql);
                    this.insertDataServiceDetailAndSQL(dsType, autoList3, multiInsertDataServiceVo.getDataserviceId(), selectMultiSql, null);
                }
            }
        } else {
            if (!relationTypeMap.containsKey(MASTER_SLAVE_RELATION_ASSOCIATION)) {
                oneInsertDataServiceVo = this.insetDataServiceConfiguration(masterSlaveQueryColumnVO, baseInfo, "");
                dataServiceList.add(oneInsertDataServiceVo);
                autoList = new ArrayList();
                selectOneSql = tableIdFlag.get(((TLrTableRelationship)relationshipList.get(0)).getMasterTableId()) != null && (Byte)tableIdFlag.get(((TLrTableRelationship)relationshipList.get(0)).getMasterTableId()) == 1 ? this.getViewMasterSelectSql(masterSlaveQueryColumnVO, oneInsertDataServiceVo, autoList, tableIdSql) : this.getMasterSelectSql(masterSlaveQueryColumnVO, oneInsertDataServiceVo, autoList);
                logger.info(" \u4e3b\u4ece\u8868\u7ba1\u7406:\u4e3b\u4ece\u67e5\u8be2,\u4e3b\u4ece\u6a21\u578b{}\u521b\u5efa\u7684\u4e3b\u8868sql======={}", (Object)masterSlaveModelName, (Object)selectOneSql);
                this.insertDataServiceDetailAndSQL(dsType, autoList, oneInsertDataServiceVo.getDataserviceId(), selectOneSql, masterSlaveQueryColumnVO.getInputColumnVoList());
            }
            for (Map.Entry entry : relationTypeMap.entrySet()) {
                tableIdRelationMap = (Map)entry.getValue();
                if (MASTER_SLAVE_RELATION_ASSOCIATION.equals(entry.getKey())) {
                    TLrDataserviceConfigurationTable oneInsertDataServiceVo3 = this.insetDataServiceConfiguration(masterSlaveQueryColumnVO, baseInfo, "");
                    dataServiceList.add(oneInsertDataServiceVo3);
                    ArrayList<TLrDataserviceAutoConfig> autoList4 = new ArrayList<TLrDataserviceAutoConfig>();
                    String masterTableId = ((TLrTableRelationship)relationshipList.get(0)).getMasterTableId();
                    boolean viewFlag = false;
                    for (String slaveTableId : tableIdRelationMap.keySet()) {
                        if (tableIdFlag.get(slaveTableId) == null || (Byte)tableIdFlag.get(slaveTableId) != 1) continue;
                        viewFlag = true;
                        break;
                    }
                    String selectOneSql3 = tableIdFlag.get(masterTableId) != null && ((Byte)tableIdFlag.get(masterTableId) == 1 || viewFlag) ? this.getOneViewSelectSql(tableIdRelationMap, masterSlaveQueryColumnVO, oneInsertDataServiceVo3, autoList4, tableIdFlag, tableIdSql) : this.getOneSelectSql(tableIdRelationMap, masterSlaveQueryColumnVO, oneInsertDataServiceVo3, autoList4);
                    logger.info(" \u4e3b\u4ece\u8868\u7ba1\u7406:\u4e3b\u4ece1:1\u67e5\u8be2,\u4e3b\u4ece\u6a21\u578b{}\u521b\u5efa\u76841:1\u7684sql======={}", (Object)masterSlaveModelName, (Object)selectOneSql3);
                    this.insertDataServiceDetailAndSQL(dsType, autoList4, oneInsertDataServiceVo3.getDataserviceId(), selectOneSql3, masterSlaveQueryColumnVO.getInputColumnVoList());
                    continue;
                }
                for (SlaveMultiOutputColumnVO slaveMultiOutputColumnVO : masterSlaveQueryColumnVO.getSlavemultioutputColumnVoList()) {
                    String slaveTableId = slaveMultiOutputColumnVO.getSlaveTableId();
                    TLrDataserviceConfigurationTable multiInsertDataServiceVo = this.insetDataServiceConfiguration(masterSlaveQueryColumnVO, baseInfo, slaveTableId);
                    dataServiceList.add(multiInsertDataServiceVo);
                    ArrayList autoList3 = new ArrayList();
                    String selectMultiSql = tableIdFlag.get(slaveTableId) != null && (Byte)tableIdFlag.get(slaveTableId) == 1 ? this.getMultiViewSelectSql(tableIdRelationMap, masterSlaveQueryColumnVO, multiInsertDataServiceVo, slaveMultiOutputColumnVO, autoList3, tableIdSql) : this.getMultiSelectSql(tableIdRelationMap, masterSlaveQueryColumnVO, multiInsertDataServiceVo, slaveMultiOutputColumnVO, autoList3);
                    logger.info(" \u4e3b\u4ece\u8868\u7ba1\u7406:\u4e3b\u4ece1:n\u67e5\u8be2,\u4ece\u8868{}\u521b\u5efa\u76841:n\u7684sql======={}", (Object)slaveMultiOutputColumnVO.getSlavetableName(), (Object)selectMultiSql);
                    this.insertDataServiceDetailAndSQL(dsType, autoList3, multiInsertDataServiceVo.getDataserviceId(), selectMultiSql, null);
                }
            }
        }
    }

    private String getOneProcessSelectSql(Map<String, List<TLrTableRelationship>> tableIdRelationMap, MasterSlaveQueryColumnVO masterSlaveQueryColumnVO, TLrDataserviceConfigurationTable dataServiceVo, List<TLrDataserviceAutoConfig> autoList) {
        StringBuilder outBuilder = new StringBuilder();
        StringBuilder outBuilderFirst = new StringBuilder();
        StringBuilder outBuilderSecond = new StringBuilder();
        outBuilder.append("SELECT");
        List masterOutputList = masterSlaveQueryColumnVO.getMasteroutputColumnVoList();
        Map<String, String> outTable = masterOutputList.stream().collect(Collectors.toMap(OutputColumnVO::getTableName, OutputColumnVO::getOutTableId, (key1, key2) -> key2));
        String masterTableId = null;
        String masterTableName = null;
        for (Map.Entry<String, String> entry : outTable.entrySet()) {
            if ("ACT_RU_TASK".equals(entry.getKey()) || "ACT_RU_IDENTITYLINK".equals(entry.getKey()) || "ACT_HI_PROCINST".equals(entry.getKey()) || "ACT_HI_TASKINST".equals(entry.getKey())) continue;
            masterTableId = entry.getValue();
            masterTableName = entry.getKey();
        }
        String masterTableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, masterTableName);
        List slaveSingleOutputList = masterSlaveQueryColumnVO.getSlavesingleoutputColumnVoList();
        for (OutputColumnVO masterOutput : masterOutputList) {
            this.getOutAutoConfig(autoList, "01", masterOutput, dataServiceVo.getDataserviceId());
            String tableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, masterOutput.getTableName());
            if (null != masterOutput.getFunctionFlag() && "".equals(masterOutput.getFunctionFlag().trim())) {
                if (masterOutput.getTableName().equals("ACT_RU_TASK") || masterOutput.getTableName().equals("ACT_RU_IDENTITYLINK")) {
                    outBuilderFirst.append(" ").append(masterOutput.getFunctionFlag()).append("(\"").append(tableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\"").append(")").append("  \"").append(masterOutput.getColumnAliasDefined()).append("\"  ").append(",");
                    continue;
                }
                if (masterOutput.getTableName().equals("ACT_HI_TASKINST")) {
                    outBuilderSecond.append(" ").append(masterOutput.getFunctionFlag()).append("(\"").append(tableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\"").append(")").append("  \"").append(masterOutput.getColumnAliasDefined()).append("\"  ").append(",");
                    continue;
                }
                outBuilder.append(" ").append(masterOutput.getFunctionFlag()).append("(\"").append(tableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\"").append(")").append("  \"").append(masterOutput.getColumnAliasDefined()).append("\"  ").append(",");
                continue;
            }
            if (masterOutput.getTableName().equals("ACT_RU_TASK") || masterOutput.getTableName().equals("ACT_RU_IDENTITYLINK")) {
                outBuilderFirst.append(" \"").append(tableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\" ").append("\"").append(masterOutput.getColumnAliasDefined()).append("\"  ").append(",");
                continue;
            }
            if (masterOutput.getTableName().equals("ACT_HI_TASKINST")) {
                outBuilderSecond.append(" \"").append(tableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\" ").append("\"").append(masterOutput.getColumnAliasDefined()).append("\"  ").append(",");
                continue;
            }
            outBuilder.append(" \"").append(tableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\" ").append("\"").append(masterOutput.getColumnAliasDefined()).append("\"  ").append(",");
        }
        for (OutputColumnVO slaveOutput : slaveSingleOutputList) {
            this.getOutAutoConfig(autoList, "01", slaveOutput, dataServiceVo.getDataserviceId());
            String slaveTableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, slaveOutput.getTableName());
            if (null != slaveOutput.getFunctionFlag() && "".equals(slaveOutput.getFunctionFlag().trim())) {
                outBuilder.append(" ").append(slaveOutput.getFunctionFlag()).append("(\"").append(slaveTableNameAlias).append("\".").append("\"").append(slaveOutput.getColumnName()).append("\"").append(")").append("  \"").append(slaveOutput.getColumnAliasDefined()).append("\"  ").append(",");
                continue;
            }
            outBuilder.append(" \"").append(slaveTableNameAlias).append("\".").append("\"").append(slaveOutput.getColumnName()).append("\" ").append("\"").append(slaveOutput.getColumnAliasDefined()).append("\"  ").append(",");
        }
        StringBuilder firstRelate = new StringBuilder();
        StringBuilder relate = new StringBuilder();
        firstRelate.append("FROM").append(" \"").append(masterTableName).append("\"").append(" \"").append(masterTableNameAlias).append("\" ");
        Map masterColumnMap = masterOutputList.stream().collect(Collectors.toMap(OutputColumnVO::getOutColumnId, Function.identity()));
        Map slaveColumnMap = slaveSingleOutputList.stream().collect(Collectors.toMap(OutputColumnVO::getOutColumnId, Function.identity()));
        for (Map.Entry<String, List<TLrTableRelationship>> entry : tableIdRelationMap.entrySet()) {
            TLrTableRelationship relationship = entry.getValue().get(0);
            OutputColumnVO masterRelateColumn = (OutputColumnVO)masterColumnMap.get(relationship.getMasterColumnId());
            OutputColumnVO slaveRelateColumn = (OutputColumnVO)slaveColumnMap.get(relationship.getSlaveColumnId());
            if (null == slaveRelateColumn) continue;
            String slaveTableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, slaveRelateColumn.getTableName());
            relate.append("LEFT JOIN").append(" ").append(" \"").append(slaveRelateColumn.getTableName()).append("\" \"").append(slaveTableNameAlias).append("\" ").append(" ON \"").append(masterTableNameAlias).append("\".").append("\"").append(masterRelateColumn.getColumnName()).append("\"").append(" = \"").append(slaveTableNameAlias).append("\".").append("\"").append(slaveRelateColumn.getColumnName()).append("\" ");
        }
        List inputColumnVOList = masterSlaveQueryColumnVO.getInputColumnVoList();
        LinkedHashMap params = Maps.newLinkedHashMap();
        this.handleParams(params, inputColumnVOList, autoList, dataServiceVo.getDataserviceId());
        String whereSql = " ${WHERE} ";
        StringBuilder groupByBuilder = new StringBuilder();
        groupByBuilder.append(" ").append(" GROUP BY ");
        boolean groupBy = false;
        StringBuilder sortBuilder = new StringBuilder();
        sortBuilder.append(" ORDER BY  ");
        boolean sortFlag = false;
        List constraintionVoList = masterSlaveQueryColumnVO.getConstraintionVoList();
        if (!CollectionUtils.isEmpty((Collection)constraintionVoList)) {
            List groupByCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(1)).collect(Collectors.toList());
            List sortCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(2)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(groupByCon)) {
                for (ConstraintionVO c2 : groupByCon) {
                    groupBy = true;
                    String tableStr = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, c2.getTableName());
                    groupByBuilder.append("\"").append(tableStr).append("\".").append("\"").append(c2.getColumnName()).append("\" ").append(",");
                }
            }
            if (!CollectionUtils.isEmpty(sortCon)) {
                for (ConstraintionVO c2 : sortCon) {
                    sortFlag = true;
                    String columnNameSort = "\"" + c2.getColumnAliasDefined() + "\"";
                    if (c2.getConstraintOper().equals(21)) {
                        sortBuilder.append(columnNameSort).append(" ASC,");
                        continue;
                    }
                    if (!c2.getConstraintOper().equals(22)) continue;
                    sortBuilder.append(columnNameSort).append(" DESC,");
                }
            }
        }
        List metadataDetailList = this.metadataDetailMapper.selectColumnInfo(masterTableId);
        String masterPk = null;
        for (TLrMetadataDetail metadataDetail : metadataDetailList) {
            if (metadataDetail.getIsPk() != 1) continue;
            masterPk = metadataDetail.getColumnName();
            break;
        }
        String outFirst = "NULL AS \"taskEndTime\", 0 \"procStatus\" ";
        String connectionFirst = "LEFT JOIN \"ACT_HI_PROCINST\" \"actHiProcinst\" ON \"" + masterTableNameAlias + "\".\"" + masterPk + "\" = \"actHiProcinst\".\"BUSINESS_KEY_\" LEFT JOIN \"ACT_RU_TASK\" \"actRuTask\" ON \"actRuTask\".\"PROC_INST_ID_\" = \"actHiProcinst\".\"ID_\" LEFT JOIN \"ACT_RU_IDENTITYLINK\" \"actRuIdentitylink\" ON \"actRuIdentitylink\".\"TASK_ID_\" = \"actRuTask\".\"ID_\"";
        String whereFirst = "( \"actRuIdentitylink\".\"TYPE_\" = 'candidate' AND \"actRuIdentitylink\".\"USER_ID_\" = #{userIdLR} ) OR \"actRuTask\".\"ASSIGNEE_\" = #{userIdLR} ";
        String outSecond = "\"actHiTaskinst\".\"END_TIME_\" AS \"taskEndTime\", CASE WHEN \"actHiTaskinst\".\"END_TIME_\" IS NULL THEN 1 ELSE 2 END AS \"procStatus\" ";
        String connectionSecond = "LEFT JOIN \"ACT_HI_PROCINST\" \"actHiProcinst\" ON \"" + masterTableNameAlias + "\".\"" + masterPk + "\" = \"actHiProcinst\".\"BUSINESS_KEY_\" LEFT JOIN \"ACT_HI_TASKINST\" \"actHiTaskinst\" ON \"actHiTaskinst\".\"PROC_INST_ID_\" = \"actHiProcinst\".\"ID_\" ";
        String whereSecond = "\"actHiTaskinst\".\"END_TIME_\" IS NOT NULL AND \"actHiTaskinst\".\"ASSIGNEE_\" = #{userIdLR}";
        String outStrFirst = outBuilder.toString() + outBuilderFirst.toString();
        String outStrSecond = outBuilder.toString() + outBuilderSecond.toString();
        String fromStr = firstRelate.toString() + relate.toString();
        String groupStr = groupByBuilder.toString().substring(0, groupByBuilder.length() - 1);
        String sortStr = sortBuilder.toString().substring(0, sortBuilder.length() - 1);
        String sqlFirst = outStrFirst + " " + outFirst + fromStr + connectionFirst + whereSql + whereFirst;
        String sqlSecond = outStrSecond + " " + outSecond + fromStr + connectionSecond + whereSql + whereSecond;
        if (groupBy) {
            sqlFirst = sqlFirst + groupStr;
            sqlSecond = sqlSecond + groupStr;
        }
        String sql = "(" + sqlFirst + ") UNION ALL (" + sqlSecond + ")";
        if (sortFlag) {
            sql = sql + sortStr;
        }
        return sql;
    }

    private String getMasterProcessSelectSql(MasterSlaveQueryColumnVO masterSlaveQueryColumnVO, TLrDataserviceConfigurationTable dataServiceVo, List<TLrDataserviceAutoConfig> autoList) {
        StringBuilder outBuilder = new StringBuilder();
        StringBuilder outBuilderFirst = new StringBuilder();
        StringBuilder outBuilderSecond = new StringBuilder();
        StringBuilder whereBuilder = new StringBuilder();
        outBuilder.append("SELECT");
        whereBuilder.append("WHERE");
        List masterOutputList = masterSlaveQueryColumnVO.getMasteroutputColumnVoList();
        Map<String, String> outTable = masterOutputList.stream().collect(Collectors.toMap(OutputColumnVO::getTableName, OutputColumnVO::getOutTableId, (key1, key2) -> key2));
        String masterTableId = null;
        String masterTableName = null;
        for (Map.Entry<String, String> entry : outTable.entrySet()) {
            if ("ACT_RU_TASK".equals(entry.getKey()) || "ACT_RU_IDENTITYLINK".equals(entry.getKey()) || "ACT_HI_PROCINST".equals(entry.getKey()) || "ACT_HI_TASKINST".equals(entry.getKey())) continue;
            masterTableName = (String)entry.getKey();
            masterTableId = (String)entry.getValue();
        }
        String masterTableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, masterTableName);
        for (OutputColumnVO masterOutput : masterOutputList) {
            String tableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, masterOutput.getTableName());
            this.getOutAutoConfig(autoList, "01", masterOutput, dataServiceVo.getDataserviceId());
            if (null != masterOutput.getFunctionFlag() && "".equals(masterOutput.getFunctionFlag())) {
                if (masterOutput.getTableName().equals("ACT_RU_TASK") || masterOutput.getTableName().equals("ACT_RU_IDENTITYLINK")) {
                    outBuilderFirst.append(" ").append(masterOutput.getFunctionFlag()).append("(\"").append(tableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\"").append(")").append(" \"").append(masterOutput.getColumnAliasDefined()).append("\" ").append(",");
                    continue;
                }
                if (masterOutput.getTableName().equals("ACT_HI_TASKINST")) {
                    outBuilderSecond.append(" ").append(masterOutput.getFunctionFlag()).append("(\"").append(tableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\"").append(")").append(" \"").append(masterOutput.getColumnAliasDefined()).append("\" ").append(",");
                    continue;
                }
                outBuilder.append(" ").append(masterOutput.getFunctionFlag()).append("(\"").append(tableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\"").append(")").append(" \"").append(masterOutput.getColumnAliasDefined()).append("\" ").append(",");
                continue;
            }
            if (masterOutput.getTableName().equals("ACT_RU_TASK") || masterOutput.getTableName().equals("ACT_RU_IDENTITYLINK")) {
                outBuilderFirst.append(" \"").append(tableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\" ").append("\"").append(masterOutput.getColumnAliasDefined()).append("\" ").append(",");
                continue;
            }
            if (masterOutput.getTableName().equals("ACT_HI_TASKINST")) {
                outBuilderSecond.append(" \"").append(tableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\" ").append("\"").append(masterOutput.getColumnAliasDefined()).append("\" ").append(",");
                continue;
            }
            outBuilder.append(" \"").append(tableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\" ").append("\"").append(masterOutput.getColumnAliasDefined()).append("\" ").append(",");
        }
        StringBuilder fromRelate = new StringBuilder();
        fromRelate.append("FROM").append(" \"").append(masterTableName).append("\"").append(" \"").append(masterTableNameAlias).append("\" ");
        List inputColumnVOList = masterSlaveQueryColumnVO.getInputColumnVoList();
        LinkedHashMap params = Maps.newLinkedHashMap();
        this.handleParams(params, inputColumnVOList, autoList, dataServiceVo.getDataserviceId());
        String whereSql = " ${WHERE} ";
        StringBuilder groupByBuilder = new StringBuilder();
        groupByBuilder.append(" ").append(" GROUP BY ");
        boolean groupBy = false;
        StringBuilder sortBuilder = new StringBuilder();
        sortBuilder.append(" ORDER BY  ");
        boolean sortFlag = false;
        List constraintionVoList = masterSlaveQueryColumnVO.getConstraintionVoList();
        if (!CollectionUtils.isEmpty((Collection)constraintionVoList)) {
            List groupByCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(1)).collect(Collectors.toList());
            List sortCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(2)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(groupByCon)) {
                for (ConstraintionVO c2 : groupByCon) {
                    groupBy = true;
                    String tableStr = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, c2.getTableName());
                    groupByBuilder.append("\"").append(tableStr).append(".").append("\"").append(c2.getColumnName()).append("\" ").append(",");
                }
            }
            if (!CollectionUtils.isEmpty(sortCon)) {
                for (ConstraintionVO c2 : sortCon) {
                    sortFlag = true;
                    String columnNameSort = "\"" + c2.getColumnAliasDefined() + "\"";
                    if (c2.getConstraintOper().equals(21)) {
                        sortBuilder.append(columnNameSort).append(" ASC,");
                        continue;
                    }
                    if (!c2.getConstraintOper().equals(22)) continue;
                    sortBuilder.append(columnNameSort).append(" DESC,");
                }
            }
        }
        List metadataDetailList = this.metadataDetailMapper.selectColumnInfo(masterTableId);
        String masterPk = null;
        for (TLrMetadataDetail metadataDetail : metadataDetailList) {
            if (metadataDetail.getIsPk() != 1) continue;
            masterPk = metadataDetail.getColumnName();
            break;
        }
        String outFirst = "NULL AS \"taskEndTime\", 0 \"procStatus\" ";
        String connectionFirst = "LEFT JOIN \"ACT_HI_PROCINST\" \"actHiProcinst\" ON \"" + masterTableNameAlias + "\".\"" + masterPk + "\" = \"actHiProcinst\".\"BUSINESS_KEY_\" LEFT JOIN \"ACT_RU_TASK\" \"actRuTask\" ON \"actRuTask\".\"PROC_INST_ID_\" = \"actHiProcinst\".\"ID_\" LEFT JOIN \"ACT_RU_IDENTITYLINK\" \"actRuIdentitylink\" ON \"actRuIdentitylink\".\"TASK_ID_\" = \"actRuTask\".\"ID_\"";
        String whereFirst = "( \"actRuIdentitylink\".\"TYPE_\" = 'candidate' AND \"actRuIdentitylink\".\"USER_ID_\" = #{userIdLR} ) OR \"actRuTask\".\"ASSIGNEE_\" = #{userIdLR} ";
        String outSecond = "\"actHiTaskinst\".\"END_TIME_\" AS \"taskEndTime\", CASE WHEN \"actHiTaskinst\".\"END_TIME_\" IS NULL THEN 1 ELSE 2 END AS \"procStatus\" ";
        String connectionSecond = "LEFT JOIN \"ACT_HI_PROCINST\" \"actHiProcinst\" ON \"" + masterTableNameAlias + "\".\"" + masterPk + "\" = \"actHiProcinst\".\"BUSINESS_KEY_\" LEFT JOIN \"ACT_HI_TASKINST\" \"actHiTaskinst\" ON \"actHiTaskinst\".\"PROC_INST_ID_\" = \"actHiProcinst\".\"ID_\" ";
        String whereSecond = "\"actHiTaskinst\".\"END_TIME_\" IS NOT NULL AND \"actHiTaskinst\".\"ASSIGNEE_\" = #{userIdLR}";
        String outStrFirst = outBuilder.toString() + outBuilderFirst.toString();
        String outStrSecond = outBuilder.toString() + outBuilderSecond.toString();
        String fromStr = fromRelate.toString();
        String groupStr = groupByBuilder.toString().substring(0, groupByBuilder.length() - 1);
        String sortStr = sortBuilder.toString().substring(0, sortBuilder.length() - 1);
        String sqlFirst = outStrFirst + " " + outFirst + fromStr + connectionFirst + whereSql + whereFirst;
        String sqlSecond = outStrSecond + " " + outSecond + fromStr + connectionSecond + whereSql + whereSecond;
        if (groupBy) {
            sqlFirst = sqlFirst + groupStr;
            sqlSecond = sqlSecond + groupStr;
        }
        String sql = "(" + sqlFirst + ") UNION ALL (" + sqlSecond + ")";
        if (sortFlag) {
            sql = sql + sortStr;
        }
        return sql;
    }

    private String getMultiViewSelectSql(Map<String, List<TLrTableRelationship>> tableIdRelationMap, MasterSlaveQueryColumnVO masterSlaveQueryColumnVO, TLrDataserviceConfigurationTable dataServiceVo, SlaveMultiOutputColumnVO slaveMultiOutputColumnVO, List<TLrDataserviceAutoConfig> autoList, Map<String, String> tableIdSql) {
        String masterPkColumnNameAlias;
        StringBuilder outBuilder = new StringBuilder();
        StringBuilder whereBuilder = new StringBuilder();
        outBuilder.append("SELECT");
        whereBuilder.append("WHERE");
        List masterOutputList = masterSlaveQueryColumnVO.getMasteroutputColumnVoList();
        List slaveOutputList = slaveMultiOutputColumnVO.getSlaveoutputColumnVoList();
        for (OutputColumnVO slaveOutput : slaveOutputList) {
            this.getOutAutoConfig(autoList, "01", slaveOutput, dataServiceVo.getDataserviceId());
            if (null != slaveOutput.getFunctionFlag() && "".equals(slaveOutput.getFunctionFlag().trim())) {
                outBuilder.append(" ").append(slaveOutput.getFunctionFlag()).append("(").append("\"").append(slaveOutput.getColumnName()).append("\"").append(")").append(" \"").append(slaveOutput.getColumnAliasDefined()).append("\"").append(",");
                continue;
            }
            outBuilder.append(" ").append("\"").append(slaveOutput.getColumnName()).append("\"").append(" \"").append(slaveOutput.getColumnAliasDefined()).append("\"").append(",");
        }
        StringBuilder fromBuilder = new StringBuilder();
        String tableId = ((OutputColumnVO)slaveOutputList.get(0)).getOutTableId();
        fromBuilder.append(" FROM").append(" (").append(tableIdSql.get(tableId)).append(") ");
        TLrTableRelationship relationship = tableIdRelationMap.get(slaveMultiOutputColumnVO.getSlaveTableId()).get(0);
        TLrMetadataDetail slaveColumn = this.metadataDetailMapper.selectMetadataDetailBycolumnId(relationship.getSlaveColumnId());
        if (MASTER_SLAVE_RESULT_TYPE_SINGLE.equals(masterSlaveQueryColumnVO.getResultType())) {
            masterPkColumnNameAlias = ((InputColumnVO)masterSlaveQueryColumnVO.getInputColumnVoList().get(0)).getColumnAliasDefined();
        } else {
            Map masterColumnMap = masterOutputList.stream().collect(Collectors.toMap(OutputColumnVO::getOutColumnId, Function.identity()));
            OutputColumnVO masterOutputColumnVo = (OutputColumnVO)masterColumnMap.get(relationship.getMasterColumnId());
            masterPkColumnNameAlias = masterOutputColumnVo.getColumnAliasDefined();
        }
        whereBuilder.append(" \"").append(slaveColumn.getColumnName()).append("\" = #{").append(masterPkColumnNameAlias).append("}");
        Map slaveColumnMap = slaveOutputList.stream().collect(Collectors.toMap(OutputColumnVO::getOutColumnId, Function.identity()));
        OutputColumnVO slaveOutputColumnVo = (OutputColumnVO)slaveColumnMap.get(relationship.getSlaveColumnId());
        slaveOutputColumnVo.setColumnAliasDefined(masterPkColumnNameAlias);
        this.getOutAutoConfig(autoList, "00", slaveOutputColumnVo, dataServiceVo.getDataserviceId());
        String outStr = outBuilder.toString().substring(0, outBuilder.length() - 1);
        String whereStr = whereBuilder.toString();
        StringBuilder selectBuilder = new StringBuilder();
        selectBuilder.append(outStr).append((CharSequence)fromBuilder).append(whereStr);
        return selectBuilder.toString();
    }

    private String getOneViewSelectSql(Map<String, List<TLrTableRelationship>> tableIdRelationMap, MasterSlaveQueryColumnVO masterSlaveQueryColumnVO, TLrDataserviceConfigurationTable dataServiceVo, List<TLrDataserviceAutoConfig> autoList, Map<String, Byte> tableIdFlag, Map<String, String> tableIdSql) {
        StringBuilder outBuilder = new StringBuilder();
        outBuilder.append("SELECT");
        List masterOutputList = masterSlaveQueryColumnVO.getMasteroutputColumnVoList();
        String masterTableName = ((OutputColumnVO)masterOutputList.get(0)).getTableName();
        String masterTableId = ((OutputColumnVO)masterOutputList.get(0)).getOutTableId();
        String masterTableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, masterTableName);
        List slaveSingleOutputList = masterSlaveQueryColumnVO.getSlavesingleoutputColumnVoList();
        for (OutputColumnVO masterOutput : masterOutputList) {
            this.getOutAutoConfig(autoList, "01", masterOutput, dataServiceVo.getDataserviceId());
            if (null != masterOutput.getFunctionFlag() && "".equals(masterOutput.getFunctionFlag().trim())) {
                outBuilder.append(" ").append(masterOutput.getFunctionFlag()).append("(\"").append(masterTableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\"").append(")").append("  \"").append(masterOutput.getColumnAliasDefined()).append("\"  ").append(",");
                continue;
            }
            outBuilder.append(" \"").append(masterTableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\"").append(" \"").append(masterOutput.getColumnAliasDefined()).append("\"  ").append(",");
        }
        for (OutputColumnVO slaveOutput : slaveSingleOutputList) {
            this.getOutAutoConfig(autoList, "01", slaveOutput, dataServiceVo.getDataserviceId());
            String slaveTableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, slaveOutput.getTableName());
            if (null != slaveOutput.getFunctionFlag() && "".equals(slaveOutput.getFunctionFlag().trim())) {
                outBuilder.append(" ").append(slaveOutput.getFunctionFlag()).append("(\"").append(slaveTableNameAlias).append("\".").append("\"").append(slaveOutput.getColumnName()).append("\"").append(")").append("  \"").append(slaveOutput.getColumnAliasDefined()).append("\"  ").append(",");
                continue;
            }
            outBuilder.append(" \"").append(slaveTableNameAlias).append("\".").append("\"").append(slaveOutput.getColumnName()).append("\"").append(" \"").append(slaveOutput.getColumnAliasDefined()).append("\"  ").append(",");
        }
        StringBuilder firstRelate = new StringBuilder();
        StringBuilder relate = new StringBuilder();
        if (tableIdFlag.get(masterTableId) != null && tableIdFlag.get(masterTableId) == 1) {
            firstRelate.append("FROM").append(" (").append(tableIdSql.get(masterTableId)).append(")").append(" \"").append(masterTableNameAlias).append("\" ");
        } else {
            firstRelate.append("FROM").append(" \"").append(masterTableName).append("\"").append(" \"").append(masterTableNameAlias).append("\" ");
        }
        Map masterColumnMap = masterOutputList.stream().collect(Collectors.toMap(OutputColumnVO::getOutColumnId, Function.identity()));
        Map slaveColumnMap = slaveSingleOutputList.stream().collect(Collectors.toMap(OutputColumnVO::getOutColumnId, Function.identity()));
        for (Map.Entry<String, List<TLrTableRelationship>> entry : tableIdRelationMap.entrySet()) {
            String slaveTableNameAlias;
            TLrTableRelationship relationship = entry.getValue().get(0);
            String slaveTableId = entry.getKey();
            OutputColumnVO masterRelateColumn = (OutputColumnVO)masterColumnMap.get(relationship.getMasterColumnId());
            OutputColumnVO slaveRelateColumn = (OutputColumnVO)slaveColumnMap.get(relationship.getSlaveColumnId());
            if (tableIdFlag.get(slaveTableId) != null && tableIdFlag.get(slaveTableId) == 1) {
                if (null == slaveRelateColumn) continue;
                slaveTableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, slaveRelateColumn.getTableName());
                relate.append("LEFT JOIN").append(" ").append(" (").append(tableIdSql.get(slaveTableId)).append(") \"").append(slaveTableNameAlias).append("\" ").append(" ON \"").append(masterTableNameAlias).append("\".").append("\"").append(masterRelateColumn.getColumnName()).append("\"").append(" = \"").append(slaveTableNameAlias).append("\".").append("\"").append(slaveRelateColumn.getColumnName()).append("\" ");
                continue;
            }
            if (null == slaveRelateColumn) continue;
            slaveTableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, slaveRelateColumn.getTableName());
            relate.append("LEFT JOIN").append(" ").append(" \"").append(slaveRelateColumn.getTableName()).append("\" \"").append(slaveTableNameAlias).append("\" ").append(" ON \"").append(masterTableNameAlias).append("\".").append("\"").append(masterRelateColumn.getColumnName()).append("\"").append(" = \"").append(slaveTableNameAlias).append("\".").append("\"").append(slaveRelateColumn.getColumnName()).append("\" ");
        }
        List inputColumnVOList = masterSlaveQueryColumnVO.getInputColumnVoList();
        LinkedHashMap params = Maps.newLinkedHashMap();
        this.handleParams(params, inputColumnVOList, autoList, dataServiceVo.getDataserviceId());
        String whereSql = " WHERE ";
        StringBuilder groupByBuilder = new StringBuilder();
        groupByBuilder.append(" ").append(" GROUP BY ");
        boolean groupBy = false;
        StringBuilder sortBuilder = new StringBuilder();
        sortBuilder.append(" ORDER BY  ");
        boolean sortFlag = false;
        List constraintionVoList = masterSlaveQueryColumnVO.getConstraintionVoList();
        if (!CollectionUtils.isEmpty((Collection)constraintionVoList)) {
            String tableStr;
            List groupByCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(1)).collect(Collectors.toList());
            List sortCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(2)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(groupByCon)) {
                for (ConstraintionVO c2 : groupByCon) {
                    groupBy = true;
                    tableStr = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, c2.getTableName());
                    groupByBuilder.append("\"").append(tableStr).append("\".").append("\"").append(c2.getColumnName()).append("\" ").append(",");
                }
            }
            if (!CollectionUtils.isEmpty(sortCon)) {
                for (ConstraintionVO c2 : sortCon) {
                    sortFlag = true;
                    tableStr = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, c2.getTableName());
                    String columnNameSort = c2.getFunctionFlag().equals(1) ? "\"" + c2.getColumnName() + "\"" : "\"" + tableStr + "\".\"" + c2.getColumnName() + "\"";
                    if (c2.getConstraintOper().equals(21)) {
                        sortBuilder.append(columnNameSort).append(" ASC,");
                        continue;
                    }
                    if (!c2.getConstraintOper().equals(22)) continue;
                    sortBuilder.append(columnNameSort).append(" DESC,");
                }
            }
        }
        String outStr = outBuilder.toString().substring(0, outBuilder.length() - 1);
        String relateStr = firstRelate.append(relate.toString()).toString();
        String groupStr = groupByBuilder.toString().substring(0, groupByBuilder.length() - 1);
        String sortStr = sortBuilder.toString().substring(0, sortBuilder.length() - 1);
        StringBuilder selectBuilder = new StringBuilder();
        selectBuilder.append(outStr).append(relateStr).append(whereSql);
        if (groupBy) {
            selectBuilder.append(groupStr);
        }
        if (sortFlag) {
            selectBuilder.append(sortStr);
        }
        return selectBuilder.toString();
    }

    private String getViewMasterSelectSql(MasterSlaveQueryColumnVO masterSlaveQueryColumnVO, TLrDataserviceConfigurationTable dataServiceVo, List<TLrDataserviceAutoConfig> autoList, Map<String, String> tableIdSql) {
        StringBuilder outBuilder = new StringBuilder();
        outBuilder.append("SELECT");
        List masterOutputList = masterSlaveQueryColumnVO.getMasteroutputColumnVoList();
        String masterTableName = ((OutputColumnVO)masterOutputList.get(0)).getTableName();
        String masterTableId = ((OutputColumnVO)masterOutputList.get(0)).getOutTableId();
        String masterTableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, masterTableName);
        for (OutputColumnVO masterOutput : masterOutputList) {
            this.getOutAutoConfig(autoList, "01", masterOutput, dataServiceVo.getDataserviceId());
            if (null != masterOutput.getFunctionFlag() && "".equals(masterOutput.getFunctionFlag())) {
                outBuilder.append(" ").append(masterOutput.getFunctionFlag()).append("(\"").append(masterTableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\"").append(")").append(" \"").append(masterOutput.getColumnAliasDefined()).append("\" ").append(",");
                continue;
            }
            outBuilder.append(" \"").append(masterTableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\"").append(" \"").append(masterOutput.getColumnAliasDefined()).append("\" ").append(",");
        }
        StringBuilder fromRelate = new StringBuilder();
        fromRelate.append("FROM").append(" (").append(tableIdSql.get(masterTableId)).append(")").append(" \"").append(masterTableNameAlias).append("\" ");
        List inputColumnVOList = masterSlaveQueryColumnVO.getInputColumnVoList();
        LinkedHashMap params = Maps.newLinkedHashMap();
        this.handleParams(params, inputColumnVOList, autoList, dataServiceVo.getDataserviceId());
        String whereSql = " WHERE ";
        StringBuilder groupByBuilder = new StringBuilder();
        groupByBuilder.append(" ").append(" GROUP BY ");
        boolean groupBy = false;
        StringBuilder sortBuilder = new StringBuilder();
        sortBuilder.append(" ORDER BY  ");
        boolean sortFlag = false;
        List constraintionVoList = masterSlaveQueryColumnVO.getConstraintionVoList();
        if (!CollectionUtils.isEmpty((Collection)constraintionVoList)) {
            String tableStr;
            List groupByCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(1)).collect(Collectors.toList());
            List sortCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(2)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(groupByCon)) {
                for (ConstraintionVO c2 : groupByCon) {
                    groupBy = true;
                    tableStr = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, c2.getTableName());
                    groupByBuilder.append("\"").append(tableStr).append("\".").append("\"").append(c2.getColumnName()).append("\" ").append(",");
                }
            }
            if (!CollectionUtils.isEmpty(sortCon)) {
                for (ConstraintionVO c2 : sortCon) {
                    sortFlag = true;
                    tableStr = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, c2.getTableName());
                    String columnNameSort = c2.getFunctionFlag().equals(1) ? "\"" + c2.getColumnName() + "\"" : "\"" + tableStr + "\".\"" + c2.getColumnName() + "\"";
                    if (c2.getConstraintOper().equals(21)) {
                        sortBuilder.append(columnNameSort).append(" ASC,");
                        continue;
                    }
                    if (!c2.getConstraintOper().equals(22)) continue;
                    sortBuilder.append(columnNameSort).append(" DESC,");
                }
            }
        }
        String outStr = outBuilder.toString().substring(0, outBuilder.length() - 1);
        String fromStr = fromRelate.toString();
        String groupStr = groupByBuilder.toString().substring(0, groupByBuilder.length() - 1);
        String sortStr = sortBuilder.toString().substring(0, sortBuilder.length() - 1);
        StringBuilder selectBuilder = new StringBuilder();
        selectBuilder.append(outStr).append(fromStr).append(whereSql);
        if (groupBy) {
            selectBuilder.append(groupStr);
        }
        if (sortFlag) {
            selectBuilder.append(sortStr);
        }
        return selectBuilder.toString();
    }

    private String getMasterSelectSql(MasterSlaveQueryColumnVO masterSlaveQueryColumnVO, TLrDataserviceConfigurationTable dataServiceVo, List<TLrDataserviceAutoConfig> autoList) {
        StringBuilder outBuilder = new StringBuilder();
        StringBuilder whereBuilder = new StringBuilder();
        outBuilder.append("SELECT");
        whereBuilder.append("WHERE");
        List masterOutputList = masterSlaveQueryColumnVO.getMasteroutputColumnVoList();
        String masterTableName = ((OutputColumnVO)masterOutputList.get(0)).getTableName();
        String masterTableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, masterTableName);
        for (OutputColumnVO masterOutput : masterOutputList) {
            this.getOutAutoConfig(autoList, "01", masterOutput, dataServiceVo.getDataserviceId());
            if (null != masterOutput.getFunctionFlag() && "".equals(masterOutput.getFunctionFlag())) {
                outBuilder.append(" ").append(masterOutput.getFunctionFlag()).append("(\"").append(masterTableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\"").append(")").append(" \"").append(masterOutput.getColumnAliasDefined()).append("\" ").append(",");
                continue;
            }
            outBuilder.append(" \"").append(masterTableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\"").append(" \"").append(masterOutput.getColumnAliasDefined()).append("\" ").append(",");
        }
        StringBuilder fromRelate = new StringBuilder();
        fromRelate.append("FROM").append(" \"").append(masterTableName).append("\"").append(" \"").append(masterTableNameAlias).append("\" ");
        List inputColumnVOList = masterSlaveQueryColumnVO.getInputColumnVoList();
        LinkedHashMap params = Maps.newLinkedHashMap();
        this.handleParams(params, inputColumnVOList, autoList, dataServiceVo.getDataserviceId());
        String whereSql = DMQueryConditionUtil.dynamicWhereSql(masterSlaveQueryColumnVO.getInputColumnVoList(), params);
        StringBuilder groupByBuilder = new StringBuilder();
        groupByBuilder.append(" ").append(" GROUP BY ");
        boolean groupBy = false;
        StringBuilder sortBuilder = new StringBuilder();
        sortBuilder.append(" ORDER BY  ");
        boolean sortFlag = false;
        List constraintionVoList = masterSlaveQueryColumnVO.getConstraintionVoList();
        if (!CollectionUtils.isEmpty((Collection)constraintionVoList)) {
            String tableStr;
            List groupByCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(1)).collect(Collectors.toList());
            List sortCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(2)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(groupByCon)) {
                for (ConstraintionVO c2 : groupByCon) {
                    groupBy = true;
                    tableStr = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, c2.getTableName());
                    groupByBuilder.append("\"").append(tableStr).append("\".").append("\"").append(c2.getColumnName()).append("\" ").append(",");
                }
            }
            if (!CollectionUtils.isEmpty(sortCon)) {
                for (ConstraintionVO c2 : sortCon) {
                    sortFlag = true;
                    tableStr = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, c2.getTableName());
                    String columnNameSort = c2.getFunctionFlag().equals(1) ? "\"" + c2.getColumnName() + "\"" : "\"" + tableStr + "\".\"" + c2.getColumnName() + "\"";
                    if (c2.getConstraintOper().equals(21)) {
                        sortBuilder.append(columnNameSort).append(" ASC,");
                        continue;
                    }
                    if (!c2.getConstraintOper().equals(22)) continue;
                    sortBuilder.append(columnNameSort).append(" DESC,");
                }
            }
        }
        String outStr = outBuilder.toString().substring(0, outBuilder.length() - 1);
        String fromStr = fromRelate.toString();
        String groupStr = groupByBuilder.toString().substring(0, groupByBuilder.length() - 1);
        String sortStr = sortBuilder.toString().substring(0, sortBuilder.length() - 1);
        StringBuilder selectBuilder = new StringBuilder();
        selectBuilder.append(outStr).append(fromStr).append(whereSql);
        if (groupBy) {
            selectBuilder.append(groupStr);
        }
        if (sortFlag) {
            selectBuilder.append(sortStr);
        }
        return selectBuilder.toString();
    }

    private String getMultiSelectSql(Map<String, List<TLrTableRelationship>> tableIdRelationMap, MasterSlaveQueryColumnVO masterSlaveQueryColumnVO, TLrDataserviceConfigurationTable dataServiceVo, SlaveMultiOutputColumnVO slaveMultiOutputColumnVO, List<TLrDataserviceAutoConfig> autoList) {
        String masterPkColumnNameAlias;
        StringBuilder outBuilder = new StringBuilder();
        StringBuilder whereBuilder = new StringBuilder();
        outBuilder.append("SELECT");
        whereBuilder.append("WHERE");
        List masterOutputList = masterSlaveQueryColumnVO.getMasteroutputColumnVoList();
        List slaveOutputList = slaveMultiOutputColumnVO.getSlaveoutputColumnVoList();
        for (OutputColumnVO slaveOutput : slaveOutputList) {
            this.getOutAutoConfig(autoList, "01", slaveOutput, dataServiceVo.getDataserviceId());
            if (null != slaveOutput.getFunctionFlag() && "".equals(slaveOutput.getFunctionFlag().trim())) {
                outBuilder.append(" ").append(slaveOutput.getFunctionFlag()).append("(").append("\"").append(slaveOutput.getColumnName()).append("\"").append(")").append(" \"").append(slaveOutput.getColumnAliasDefined()).append("\"").append(",");
                continue;
            }
            outBuilder.append(" ").append("\"").append(slaveOutput.getColumnName()).append("\"").append(" \"").append(slaveOutput.getColumnAliasDefined()).append("\"").append(",");
        }
        StringBuilder fromBuilder = new StringBuilder();
        fromBuilder.append(" FROM").append(" \"").append(((OutputColumnVO)slaveOutputList.get(0)).getTableName()).append("\" ");
        TLrTableRelationship relationship = tableIdRelationMap.get(slaveMultiOutputColumnVO.getSlaveTableId()).get(0);
        TLrMetadataDetail slaveColumn = this.metadataDetailMapper.selectMetadataDetailBycolumnId(relationship.getSlaveColumnId());
        if (MASTER_SLAVE_RESULT_TYPE_SINGLE.equals(masterSlaveQueryColumnVO.getResultType())) {
            masterPkColumnNameAlias = ((InputColumnVO)masterSlaveQueryColumnVO.getInputColumnVoList().get(0)).getColumnAliasDefined();
        } else {
            Map masterColumnMap = masterOutputList.stream().collect(Collectors.toMap(OutputColumnVO::getOutColumnId, Function.identity()));
            OutputColumnVO masterOutputColumnVo = (OutputColumnVO)masterColumnMap.get(relationship.getMasterColumnId());
            masterPkColumnNameAlias = masterOutputColumnVo.getColumnAliasDefined();
        }
        whereBuilder.append(" \"").append(slaveColumn.getColumnName()).append("\" = #{").append(masterPkColumnNameAlias).append("}");
        Map slaveColumnMap = slaveOutputList.stream().collect(Collectors.toMap(OutputColumnVO::getOutColumnId, Function.identity()));
        OutputColumnVO slaveOutputColumnVo = (OutputColumnVO)slaveColumnMap.get(relationship.getSlaveColumnId());
        slaveOutputColumnVo.setColumnAliasDefined(masterPkColumnNameAlias);
        this.getOutAutoConfig(autoList, "00", slaveOutputColumnVo, dataServiceVo.getDataserviceId());
        String outStr = outBuilder.toString().substring(0, outBuilder.length() - 1);
        String whereStr = whereBuilder.toString();
        StringBuilder selectBuilder = new StringBuilder();
        selectBuilder.append(outStr).append((CharSequence)fromBuilder).append(whereStr);
        return selectBuilder.toString();
    }

    private String getOneSelectSql(Map<String, List<TLrTableRelationship>> tableIdRelationMap, MasterSlaveQueryColumnVO masterSlaveQueryColumnVO, TLrDataserviceConfigurationTable dataServiceVo, List<TLrDataserviceAutoConfig> autoList) {
        StringBuilder outBuilder = new StringBuilder();
        StringBuilder whereBuilder = new StringBuilder();
        outBuilder.append("SELECT");
        whereBuilder.append("WHERE");
        List masterOutputList = masterSlaveQueryColumnVO.getMasteroutputColumnVoList();
        String masterTableName = ((OutputColumnVO)masterOutputList.get(0)).getTableName();
        String masterTableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, masterTableName);
        List slaveSingleOutputList = masterSlaveQueryColumnVO.getSlavesingleoutputColumnVoList();
        for (OutputColumnVO masterOutput : masterOutputList) {
            this.getOutAutoConfig(autoList, "01", masterOutput, dataServiceVo.getDataserviceId());
            if (null != masterOutput.getFunctionFlag() && "".equals(masterOutput.getFunctionFlag().trim())) {
                outBuilder.append(" ").append(masterOutput.getFunctionFlag()).append("(\"").append(masterTableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\"").append(")").append("  \"").append(masterOutput.getColumnAliasDefined()).append("\"  ").append(",");
                continue;
            }
            outBuilder.append(" \"").append(masterTableNameAlias).append("\".").append("\"").append(masterOutput.getColumnName()).append("\"").append(" \"").append(masterOutput.getColumnAliasDefined()).append("\"  ").append(",");
        }
        for (OutputColumnVO slaveOutput : slaveSingleOutputList) {
            this.getOutAutoConfig(autoList, "01", slaveOutput, dataServiceVo.getDataserviceId());
            String slaveTableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, slaveOutput.getTableName());
            if (null != slaveOutput.getFunctionFlag() && "".equals(slaveOutput.getFunctionFlag().trim())) {
                outBuilder.append(" ").append(slaveOutput.getFunctionFlag()).append("(\"").append(slaveTableNameAlias).append("\".").append("\"").append(slaveOutput.getColumnName()).append("\"").append(")").append("  \"").append(slaveOutput.getColumnAliasDefined()).append("\"  ").append(",");
                continue;
            }
            outBuilder.append(" \"").append(slaveTableNameAlias).append("\".").append("\"").append(slaveOutput.getColumnName()).append("\"").append(" \"").append(slaveOutput.getColumnAliasDefined()).append("\"  ").append(",");
        }
        StringBuilder firstRelate = new StringBuilder();
        StringBuilder relate = new StringBuilder();
        firstRelate.append("FROM").append(" \"").append(masterTableName).append("\"").append(" \"").append(masterTableNameAlias).append("\" ");
        Map masterColumnMap = masterOutputList.stream().collect(Collectors.toMap(OutputColumnVO::getOutColumnId, Function.identity()));
        Map slaveColumnMap = slaveSingleOutputList.stream().collect(Collectors.toMap(OutputColumnVO::getOutColumnId, Function.identity()));
        for (Map.Entry<String, List<TLrTableRelationship>> entry : tableIdRelationMap.entrySet()) {
            TLrTableRelationship relationship = entry.getValue().get(0);
            OutputColumnVO masterRelateColumn = (OutputColumnVO)masterColumnMap.get(relationship.getMasterColumnId());
            OutputColumnVO slaveRelateColumn = (OutputColumnVO)slaveColumnMap.get(relationship.getSlaveColumnId());
            if (null == slaveRelateColumn) continue;
            String slaveTableNameAlias = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, slaveRelateColumn.getTableName());
            relate.append("LEFT JOIN").append(" ").append(" \"").append(slaveRelateColumn.getTableName()).append("\" \"").append(slaveTableNameAlias).append("\" ").append(" ON \"").append(masterTableNameAlias).append("\".").append("\"").append(masterRelateColumn.getColumnName()).append("\"").append(" = \"").append(slaveTableNameAlias).append("\".").append("\"").append(slaveRelateColumn.getColumnName()).append("\" ");
        }
        List inputColumnVOList = masterSlaveQueryColumnVO.getInputColumnVoList();
        LinkedHashMap params = Maps.newLinkedHashMap();
        this.handleParams(params, inputColumnVOList, autoList, dataServiceVo.getDataserviceId());
        String whereSql = DMQueryConditionUtil.dynamicWhereSql(masterSlaveQueryColumnVO.getInputColumnVoList(), params);
        StringBuilder groupByBuilder = new StringBuilder();
        groupByBuilder.append(" ").append(" GROUP BY ");
        boolean groupBy = false;
        StringBuilder sortBuilder = new StringBuilder();
        sortBuilder.append(" ORDER BY  ");
        boolean sortFlag = false;
        List constraintionVoList = masterSlaveQueryColumnVO.getConstraintionVoList();
        if (!CollectionUtils.isEmpty((Collection)constraintionVoList)) {
            String tableStr;
            List groupByCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(1)).collect(Collectors.toList());
            List sortCon = constraintionVoList.stream().filter(c -> c.getConstraintType().equals(2)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(groupByCon)) {
                for (ConstraintionVO c2 : groupByCon) {
                    groupBy = true;
                    tableStr = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, c2.getTableName());
                    groupByBuilder.append("\"").append(tableStr).append("\".").append("\"").append(c2.getColumnName()).append("\" ").append(",");
                }
            }
            if (!CollectionUtils.isEmpty(sortCon)) {
                for (ConstraintionVO c2 : sortCon) {
                    sortFlag = true;
                    tableStr = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, c2.getTableName());
                    String columnNameSort = c2.getFunctionFlag().equals(1) ? "\"" + c2.getColumnName() + "\"" : "\"" + tableStr + "\".\"" + c2.getColumnName() + "\"";
                    if (c2.getConstraintOper().equals(21)) {
                        sortBuilder.append(columnNameSort).append(" ASC,");
                        continue;
                    }
                    if (!c2.getConstraintOper().equals(22)) continue;
                    sortBuilder.append(columnNameSort).append(" DESC,");
                }
            }
        }
        String outStr = outBuilder.toString().substring(0, outBuilder.length() - 1);
        String relateStr = firstRelate.append(relate.toString()).toString();
        String groupStr = groupByBuilder.toString().substring(0, groupByBuilder.length() - 1);
        String sortStr = sortBuilder.toString().substring(0, sortBuilder.length() - 1);
        StringBuilder selectBuilder = new StringBuilder();
        selectBuilder.append(outStr).append(relateStr).append(whereSql);
        if (groupBy) {
            selectBuilder.append(groupStr);
        }
        if (sortFlag) {
            selectBuilder.append(sortStr);
        }
        return selectBuilder.toString();
    }

    private void getInAutoConfig(List<TLrDataserviceAutoConfig> autoList, String putType, InputColumnVO inputColumnVO, String dataServiceId) {
        TLrDataserviceAutoConfig auto = new TLrDataserviceAutoConfig();
        auto.setColumnAliasDefined(inputColumnVO.getColumnAliasDefined());
        auto.setColumnAlias(inputColumnVO.getColumnAliasDefined());
        auto.setId(String.valueOf(IdGenerateUtils.getId()));
        auto.setDataserviceId(dataServiceId);
        auto.setColumnId(inputColumnVO.getInColumnId());
        auto.setTableId(inputColumnVO.getInTableId());
        auto.setPutType(putType);
        auto.setDictCode(inputColumnVO.getInDictCode());
        auto.setStatus(Integer.valueOf(1));
        auto.setUserId(IdAcquisitionUtil.getCurrentUserId());
        auto.setCreateTime(DateUtils.getNowDate());
        auto.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        autoList.add(auto);
    }

    private void getOutAutoConfig(List<TLrDataserviceAutoConfig> autoList, String put_type, OutputColumnVO outputColumnVO, String dataServiceId) {
        TLrDataserviceAutoConfig auto = new TLrDataserviceAutoConfig();
        auto.setColumnAliasDefined(outputColumnVO.getColumnAliasDefined());
        auto.setColumnAlias(outputColumnVO.getColumnAliasDefined());
        auto.setId(String.valueOf(IdGenerateUtils.getId()));
        auto.setDataserviceId(dataServiceId);
        auto.setColumnId(outputColumnVO.getOutColumnId());
        auto.setTableId(outputColumnVO.getOutTableId());
        auto.setPutType(put_type);
        auto.setDictCode(outputColumnVO.getOutDictCode());
        auto.setStatus(Integer.valueOf(1));
        auto.setUserId(IdAcquisitionUtil.getCurrentUserId());
        auto.setCreateTime(DateUtils.getNowDate());
        auto.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        autoList.add(auto);
    }

    private TLrDataserviceConfigurationTable insetDataServiceConfiguration(MasterSlaveQueryColumnVO masterSlaveQueryColumnVO, TLrMetadataManageTable baseInfo, String tableId) {
        TLrDataserviceConfigurationTable dataServiceVo = new TLrDataserviceConfigurationTable();
        String dataServiceId = String.valueOf(IdGenerateUtils.getId());
        String nameFlag = masterSlaveQueryColumnVO.getMapperType() + dataServiceId + System.currentTimeMillis();
        dataServiceVo.setDataserviceId(dataServiceId);
        dataServiceVo.setMapperType(masterSlaveQueryColumnVO.getMapperType());
        dataServiceVo.setDataserviceName(nameFlag);
        dataServiceVo.setDataserviceChname(nameFlag);
        dataServiceVo.setDataserviceVersion(Long.valueOf(1L));
        dataServiceVo.setDataserviceStatus(LRConstants.data_statuts_release);
        dataServiceVo.setDatasourceId(baseInfo.getDatasourceId());
        dataServiceVo.setOperType("00");
        dataServiceVo.setResultType(masterSlaveQueryColumnVO.getResultType());
        dataServiceVo.setUpdateByUserid(masterSlaveQueryColumnVO.getUserId());
        dataServiceVo.setResultType(masterSlaveQueryColumnVO.getResultType());
        if (MASTER_SLAVE_RESULT_TYPE_MULTIPLE.equals(masterSlaveQueryColumnVO.getResultType())) {
            if (masterSlaveQueryColumnVO.getPagination().booleanValue()) {
                dataServiceVo.setPageSize(Integer.valueOf(50));
                dataServiceVo.setPagination(Byte.valueOf((byte)1));
            } else {
                dataServiceVo.setPagination(Byte.valueOf((byte)0));
            }
        }
        if ("".equals(tableId)) {
            dataServiceVo.setMasterDataserviceFalg(Integer.valueOf(1));
        }
        dataServiceVo.setCreateTime(DateUtils.getNowDate());
        dataServiceVo.setModelId(masterSlaveQueryColumnVO.getModelId());
        dataServiceVo.setTableId(tableId);
        dataServiceVo.setUserId(IdAcquisitionUtil.getCurrentUserId());
        dataServiceVo.setStatus(Integer.valueOf(1));
        dataServiceVo.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        this.tLrDataserviceConfigrationTableMapper.insertTLrDataServiceConfigurationTable(dataServiceVo);
        return dataServiceVo;
    }

    @Override
    public String checkModelNameUnique(TLrMasterslaveModel tLrMasterSlaveModel) {
        tLrMasterSlaveModel.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        List masterSlaveModelList = this.tLrMasterslaveModelMapper.selectTLrMasterslaveModelByModelName(tLrMasterSlaveModel);
        if (null != masterSlaveModelList && masterSlaveModelList.size() > 0) {
            return "1";
        }
        return "0";
    }

    private TLrImplements insertServiceAndImp(MasterSlaveColumnDefinedVO de, List<TLrDataserviceConfigurationTable> dataServiceList) {
        String userId = IdAcquisitionUtil.getCurrentUserId();
        String tenantId = IdAcquisitionUtil.getCurrentTenantId();
        String serviceId = String.valueOf(IdGenerateUtils.getId());
        String nameFlag = de.getMapperType() + serviceId + System.currentTimeMillis();
        TLrServiceTable serviceTable = new TLrServiceTable();
        serviceTable.setServiceId(serviceId);
        serviceTable.setServiceName(nameFlag);
        serviceTable.setServiceVersion(Long.valueOf(1L));
        serviceTable.setServiceChname(nameFlag);
        serviceTable.setServiceType("00");
        serviceTable.setServiceStatuts(LRConstants.service_statuts_release);
        serviceTable.setStatus(Integer.valueOf(1));
        serviceTable.setUserId(userId);
        serviceTable.setCreateTime(DateUtils.getNowDate());
        serviceTable.setTenantId(tenantId);
        serviceTable.setRemark("\u4e3b\u4ece\u8868\u7ba1\u7406\u4e1a\u52a1\u670d\u52a1:" + this.getRemarkDetail(de.getMapperType()));
        serviceTable.setRsv1("masterSlave");
        this.tLrServiceTableMapper.insertTLrServiceTable(serviceTable);
        for (int i = 0; i < dataServiceList.size(); ++i) {
            TLrServiceDetailTable serviceDetailTable = new TLrServiceDetailTable();
            serviceDetailTable.setDetailId(String.valueOf(IdGenerateUtils.getId()));
            serviceDetailTable.setServiceId(String.valueOf(serviceId));
            serviceDetailTable.setDataserviceId(dataServiceList.get(i).getDataserviceId());
            serviceDetailTable.setTreeSort(Byte.valueOf((byte)(i + 1)));
            serviceDetailTable.setSortNumber(Integer.valueOf(1));
            serviceDetailTable.setStatus(Integer.valueOf(1));
            serviceDetailTable.setUserId(userId);
            serviceDetailTable.setCreateTime(DateUtils.getNowDate());
            serviceDetailTable.setTenantId(tenantId);
            this.serviceDetailMapper.insertTlrServiceDeatilTable(serviceDetailTable);
        }
        String url = de.getMapperType() + serviceId + System.currentTimeMillis();
        TLrImplements lrImplements = new TLrImplements();
        lrImplements.setId(String.valueOf(IdGenerateUtils.getId()));
        lrImplements.setImpFlag(nameFlag);
        lrImplements.setImpName(nameFlag);
        lrImplements.setServiceId(String.valueOf(serviceId));
        lrImplements.setUrl("/T_LR/masterSlave/" + url);
        if (de.getMapperType().contains("DELETE")) {
            lrImplements.setRequestType("GET");
        } else {
            lrImplements.setRequestType("POST");
        }
        lrImplements.setImpVersion(Long.valueOf(1L));
        lrImplements.setImpStatus(Integer.valueOf(1));
        lrImplements.setStatus(Integer.valueOf(1));
        lrImplements.setUserId(userId);
        lrImplements.setCreateTime(DateUtils.getNowDate());
        lrImplements.setTenantId(tenantId);
        lrImplements.setVersion(Long.valueOf(1L));
        lrImplements.setReleaseSource(Integer.valueOf(3));
        lrImplements.setRemark("\u4e3b\u4ece\u8868\u7ba1\u7406\u4e00\u952e\u53d1\u5e03\u63a5\u53e3:" + this.getRemarkDetail(de.getMapperType()));
        lrImplements.setRsv1("masterSlave");
        this.implementsMapper.insertTLrImplements(lrImplements);
        return lrImplements;
    }

    private void insertDataServiceTable(List<TLrDataserviceConfigurationTable> dataServiceList, TLrMetadataManageTable baseInfo, MasterSlaveColumnDefinedVO de, TLrDatasourceTable datasourceTable, String dsType) throws EngineException {
        String tableDsType = datasourceTable.getDatasourceType();
        if (tableDsType == null) {
            throw new EngineException(EngineExceptionEnum.DATA_SOURCE_TYPE_NOT_EXIST);
        }
        if ("INSERT".equals(de.getMapperType())) {
            TLrDataserviceConfigurationTable masterInsertDataServiceVo = this.dataServiceConfiguration(de.getModelId(), de.getTableName(), "", de.getMapperType(), baseInfo);
            dataServiceList.add(masterInsertDataServiceVo);
            ArrayList<TLrDataserviceAutoConfig> autoListMaster = new ArrayList<TLrDataserviceAutoConfig>();
            HashMap masterWhereColumnMap = Maps.newHashMap();
            String insertMasterInSql = this.getMasterInsertSql(de, masterInsertDataServiceVo, masterWhereColumnMap, autoListMaster);
            logger.info(" \u4e3b\u4ece\u8868\u7ba1\u7406:\u4e3b\u4ece\u63d2\u5165,\u4e3b\u8868{}\u521b\u5efa\u7684sql======={}", (Object)de.getTableName(), (Object)insertMasterInSql);
            this.insertDataServiceDetailAndSQL(dsType, autoListMaster, masterInsertDataServiceVo.getDataserviceId(), insertMasterInSql, null);
            for (ColumnNameDefinedVO slave : de.getSlave()) {
                TLrDataserviceConfigurationTable dataServiceVoSlave = this.dataServiceConfiguration(de.getModelId(), de.getTableName(), slave.getTableName(), de.getMapperType(), baseInfo);
                dataServiceList.add(dataServiceVoSlave);
                ArrayList<TLrDataserviceAutoConfig> autoListSlave = new ArrayList<TLrDataserviceAutoConfig>();
                String insertSlaveInSql = this.getInsertSlaveInSql(de, slave, masterWhereColumnMap, dataServiceVoSlave, autoListSlave);
                logger.info(" \u4e3b\u4ece\u8868\u7ba1\u7406:\u4e3b\u4ece\u63d2\u5165,\u4ece\u8868{}\u521b\u5efa\u7684sql{}", (Object)slave.getTableName(), (Object)insertSlaveInSql);
                this.insertDataServiceDetailAndSQL(dsType, autoListSlave, dataServiceVoSlave.getDataserviceId(), insertSlaveInSql, null);
            }
            return;
        }
        if ("UPDATE".equals(de.getMapperType())) {
            TLrDataserviceConfigurationTable masterUpdateDataServiceVo = this.dataServiceConfiguration(de.getModelId(), de.getTableName(), "", de.getMapperType(), baseInfo);
            dataServiceList.add(masterUpdateDataServiceVo);
            ArrayList<TLrDataserviceAutoConfig> autoListMaster = new ArrayList<TLrDataserviceAutoConfig>();
            HashMap masterWhereColumnMap = Maps.newHashMap();
            String updateMasterSql = this.getMasterUpdateSql(de, masterUpdateDataServiceVo, autoListMaster, masterWhereColumnMap);
            logger.info(" \u4e3b\u4ece\u8868\u7ba1\u7406:\u4e3b\u4ece\u66f4\u65b0,\u4e3b\u8868{}\u521b\u5efa\u7684sql{}======", (Object)de.getTableName(), (Object)updateMasterSql);
            this.insertDataServiceDetailAndSQL(dsType, autoListMaster, masterUpdateDataServiceVo.getDataserviceId(), updateMasterSql, null);
            for (ColumnNameDefinedVO slave : de.getSlave()) {
                TLrDataserviceConfigurationTable dataServiceVoSlave = this.dataServiceConfiguration(de.getModelId(), de.getTableName(), slave.getTableName(), de.getMapperType(), baseInfo);
                dataServiceList.add(dataServiceVoSlave);
                ArrayList<TLrDataserviceAutoConfig> autoListSlave = new ArrayList<TLrDataserviceAutoConfig>();
                String insertSlaveInSql = this.getInsertSlaveInSql(de, slave, masterWhereColumnMap, dataServiceVoSlave, autoListSlave);
                logger.info(" \u4e3b\u4ece\u8868\u7ba1\u7406:\u4e3b\u4ece\u66f4\u65b0,\u4ece\u8868{}\u521b\u5efa\u7684sql{}", (Object)slave.getTableName(), (Object)insertSlaveInSql);
                this.insertDataServiceDetailAndSQL(dsType, autoListSlave, dataServiceVoSlave.getDataserviceId(), insertSlaveInSql, null);
            }
            return;
        }
        if ("DELETE".equals(de.getMapperType())) {
            TLrDataserviceConfigurationTable masterDeleteDataServiceVo = this.dataServiceConfiguration(de.getModelId(), de.getTableName(), "", de.getMapperType(), baseInfo);
            dataServiceList.add(masterDeleteDataServiceVo);
            List masterInColumnList = de.getMasterInColumn();
            ArrayList<TLrDataserviceAutoConfig> autoListMaster = new ArrayList<TLrDataserviceAutoConfig>();
            HashMap masterWhereColumnMap = Maps.newHashMap();
            String deleteTableSql = "DELETE FROM \"" + de.getTableName() + "\" ";
            String selectMasterInSql = this.getSqlIn(de.getTableName(), masterInColumnList, masterDeleteDataServiceVo, autoListMaster, masterWhereColumnMap);
            String masterDeleteSql = deleteTableSql + selectMasterInSql;
            logger.info(" \u4e3b\u4ece\u8868\u7ba1\u7406:\u4e3b\u4ece\u5220\u9664,\u4e3b\u8868{}\u521b\u5efa\u7684sql====={}", (Object)de.getTableName(), (Object)masterDeleteSql);
            this.insertDataServiceDetailAndSQL(dsType, autoListMaster, masterDeleteDataServiceVo.getDataserviceId(), masterDeleteSql, null);
            List relationshipList = this.relationshipMapper.selectTLrTableRelationshipListByModelId(de.getModelId());
            ArrayList columnNameDefinedVOList = Lists.newArrayList();
            for (TLrTableRelationship relationship : relationshipList) {
                ColumnNameDefinedVO columnNameDefinedVO = new ColumnNameDefinedVO();
                columnNameDefinedVO.setTableId(relationship.getSlaveTableId());
                String tableName = this.tLrMetadataManageTableMapper.selectTLrMetadataManageTableById(relationship.getSlaveTableId()).getTableName();
                columnNameDefinedVO.setTableName(tableName);
                columnNameDefinedVOList.add(columnNameDefinedVO);
            }
            for (ColumnNameDefinedVO slave : columnNameDefinedVOList) {
                TLrDataserviceConfigurationTable dataServiceVoSlave = this.dataServiceConfiguration(de.getModelId(), de.getTableName(), slave.getTableName(), de.getMapperType(), baseInfo);
                dataServiceList.add(dataServiceVoSlave);
                ArrayList<TLrDataserviceAutoConfig> autoListSlave = new ArrayList<TLrDataserviceAutoConfig>();
                String slaveDeleteFromTable = "DELETE FROM \"" + slave.getTableName() + "\" ";
                String slaveSqlIn = this.getSlaveSqlIn(de, slave, masterWhereColumnMap, dataServiceVoSlave, autoListSlave);
                String slaveDeleteSql = slaveDeleteFromTable + slaveSqlIn;
                logger.info(" \u4e3b\u4ece\u8868\u7ba1\u7406:\u4e3b\u4ece\u5220\u9664,\u4ece\u8868{}\u521b\u5efa\u7684sql{}====", (Object)slave.getTableName(), (Object)slaveDeleteSql);
                this.insertDataServiceDetailAndSQL(dsType, autoListSlave, dataServiceVoSlave.getDataserviceId(), slaveDeleteSql, null);
            }
        }
        if ("SAVEORUPDATE".equals(de.getMapperType())) {
            TLrDataserviceConfigurationTable masterSaveOrUpdateDataServiceVo = this.dataServiceConfiguration(de.getModelId(), de.getTableName(), "", de.getMapperType(), baseInfo);
            dataServiceList.add(masterSaveOrUpdateDataServiceVo);
            ArrayList<TLrDataserviceAutoConfig> autoListMaster = new ArrayList<TLrDataserviceAutoConfig>();
            HashMap masterWhereColumnMap = Maps.newHashMap();
            String insertMasterInSql = this.getMasterInsertSql(de, masterSaveOrUpdateDataServiceVo, masterWhereColumnMap, autoListMaster);
            logger.info(" \u4e3b\u4ece\u8868\u7ba1\u7406:\u4e3b\u4ecesaveOrUpdate,\u4e3b\u8868{}\u521b\u5efa\u7684sql{}======", (Object)de.getTableName(), (Object)insertMasterInSql);
            this.insertDataServiceDetailAndSQL(dsType, autoListMaster, masterSaveOrUpdateDataServiceVo.getDataserviceId(), insertMasterInSql, null);
            for (ColumnNameDefinedVO slave : de.getSlave()) {
                TLrDataserviceConfigurationTable dataServiceVoslave = this.dataServiceConfiguration(de.getModelId(), de.getTableName(), slave.getTableName(), de.getMapperType(), baseInfo);
                dataServiceList.add(dataServiceVoslave);
                ArrayList<TLrDataserviceAutoConfig> autoListSlave = new ArrayList<TLrDataserviceAutoConfig>();
                String insertSlaveInSql = this.getInsertSlaveInSql(de, slave, masterWhereColumnMap, dataServiceVoslave, autoListSlave);
                logger.info(" \u4e3b\u4ece\u8868\u7ba1\u7406:\u4e3b\u4ecesaveOrUpdate,\u4ece\u8868{}\u521b\u5efa\u7684sql{}", (Object)slave.getTableName(), (Object)insertSlaveInSql);
                this.insertDataServiceDetailAndSQL(dsType, autoListSlave, dataServiceVoslave.getDataserviceId(), insertSlaveInSql, null);
            }
        }
    }

    private String getMasterInsertSql(MasterSlaveColumnDefinedVO d, TLrDataserviceConfigurationTable masterDataServiceVo, Map<String, String> masterWhereColumnMap, List<TLrDataserviceAutoConfig> autoListMaster) {
        StringBuilder insertBuilder = new StringBuilder();
        insertBuilder.append("INSERT INTO ");
        insertBuilder.append(" \"").append(d.getTableName()).append("\" ").append("( ");
        StringBuilder valueBuffer = new StringBuilder();
        valueBuffer.append("  VALUES  (");
        for (TLrMetadataDetail in : d.getMasterInColumn()) {
            in.setTableName(d.getTableName());
            String columnNameAliasDefine = in.getColumnNameAlias();
            this.getAutoConfig(autoListMaster, "00", LRConstants.sys_dataservice_whereflag_id, LRConstants.sys_dataservice_whereflag_value, in, masterDataServiceVo.getDataserviceId(), columnNameAliasDefine);
            insertBuilder.append(" \"").append(in.getColumnName()).append("\",");
            valueBuffer.append(" #{").append(columnNameAliasDefine).append("},");
            masterWhereColumnMap.put(in.getColumnId(), columnNameAliasDefine);
        }
        String insertStr = insertBuilder.toString().substring(0, insertBuilder.toString().length() - 1) + ")";
        String valueStr = valueBuffer.toString().substring(0, valueBuffer.toString().length() - 1) + ")";
        return insertStr + valueStr;
    }

    private String getInsertSlaveInSql(MasterSlaveColumnDefinedVO de, ColumnNameDefinedVO slave, Map<String, String> masterWhereColumnMap, TLrDataserviceConfigurationTable dataServiceVoslave, List<TLrDataserviceAutoConfig> autoListSlave) {
        StringBuilder slaveInsert = new StringBuilder();
        StringBuilder slaveValue = new StringBuilder();
        List<TLrTableRelationship> relationshipLists = this.getRelationShipListByModeId(de, slave.getTableId());
        Map<String, List<TLrTableRelationship>> slaveColumnShip = relationshipLists.stream().collect(Collectors.groupingBy(TLrTableRelationship::getSlaveColumnId));
        TLrTableRelationship relationship = relationshipLists.get(0);
        slaveInsert.append("INSERT INTO ").append(" \"").append(slave.getTableName()).append("\" ").append("( ");
        slaveValue.append(" VALUES  (");
        for (TLrMetadataDetail in : slave.getInColumn()) {
            in.setTableName(slave.getTableName());
            String columnNameAlias = null != slaveColumnShip.get(in.getColumnId()) ? masterWhereColumnMap.get(relationship.getMasterColumnId()) : in.getColumnNameAlias();
            this.getAutoConfig(autoListSlave, "00", LRConstants.sys_dataservice_whereflag_id, LRConstants.sys_dataservice_whereflag_value, in, dataServiceVoslave.getDataserviceId(), columnNameAlias);
            slaveInsert.append(" \"").append(in.getColumnName()).append("\",");
            slaveValue.append(" #{").append(columnNameAlias).append("},");
        }
        String slaveInsertStr = slaveInsert.toString().substring(0, slaveInsert.toString().length() - 1) + ")";
        String slaveValueStr = slaveValue.toString().substring(0, slaveValue.toString().length() - 1) + ")";
        return slaveInsertStr + slaveValueStr;
    }

    private String getMasterUpdateSql(MasterSlaveColumnDefinedVO de, TLrDataserviceConfigurationTable masterDataServiceVo, List<TLrDataserviceAutoConfig> autoListMaster, Map<String, String> masterWhereColumnMap) {
        List masterInColumnList = de.getMasterInColumn();
        StringBuilder updateBuffer = new StringBuilder();
        StringBuilder whereBuilder = new StringBuilder();
        updateBuffer.append("UPDATE").append(" \"").append(de.getTableName()).append("\" ").append(" SET ");
        whereBuilder.append(" WHERE ");
        for (TLrMetadataDetail in : masterInColumnList) {
            List<TLrTableRelationship> relationshipLists;
            Set masterColumnId;
            in.setTableName(de.getTableName());
            String columnNameAlis = in.getColumnNameAlias();
            this.getAutoConfig(autoListMaster, "00", LRConstants.sys_dataservice_whereflag_id, LRConstants.sys_dataservice_whereflag_value, in, masterDataServiceVo.getDataserviceId(), columnNameAlis);
            updateBuffer.append("\"").append(in.getColumnName()).append("\"=#{").append(columnNameAlis).append("},");
            if (null != in.getInputWhere() && "00".equals(in.getInputWhere())) {
                whereBuilder.append("  \"").append(in.getColumnName()).append("\" ").append(" =").append(" #{").append(columnNameAlis).append("} AND");
            }
            if (!(masterColumnId = (relationshipLists = this.getRelationShipListByModeIdMasterId(de, in.getTableId())).stream().map(TLrTableRelationship::getMasterColumnId).collect(Collectors.toSet())).contains(in.getColumnId())) continue;
            masterWhereColumnMap.put(in.getColumnId(), columnNameAlis);
        }
        String updateStr = updateBuffer.toString().substring(0, updateBuffer.length() - 1);
        String whereStr = whereBuilder.substring(0, whereBuilder.length() - 3);
        return updateStr + whereStr;
    }

    private String getSqlIn(String tableName, List<TLrMetadataDetail> inColumnList, TLrDataserviceConfigurationTable masterDataServiceVo, List<TLrDataserviceAutoConfig> autoList, Map<String, String> masterWhereColumnMap) {
        StringBuilder whereBuilder = new StringBuilder();
        whereBuilder.append(" WHERE");
        for (TLrMetadataDetail in : inColumnList) {
            in.setTableName(tableName);
            String columnNameAliasDefine = in.getColumnNameAlias();
            this.getAutoConfig(autoList, "00", LRConstants.sys_dataservice_whereflag_id, LRConstants.sys_dataservice_whereflag_value, in, masterDataServiceVo.getDataserviceId(), columnNameAliasDefine);
            whereBuilder.append(" \"").append(in.getColumnName()).append("\" = #{").append(columnNameAliasDefine).append("} AND");
            masterWhereColumnMap.put(in.getColumnId(), columnNameAliasDefine);
        }
        return whereBuilder.toString().substring(0, whereBuilder.toString().length() - 3);
    }

    private String getSlaveSqlIn(MasterSlaveColumnDefinedVO de, ColumnNameDefinedVO slave, Map<String, String> masterWhereColumnMap, TLrDataserviceConfigurationTable dataServiceVoslave, List<TLrDataserviceAutoConfig> autoList) {
        StringBuilder whereBuilder = new StringBuilder();
        whereBuilder.append(" WHERE");
        List<TLrTableRelationship> relationshipLists = this.getRelationShipListByModeId(de, slave.getTableId());
        relationshipLists.forEach(item -> {
            String masterColumn = (String)masterWhereColumnMap.get(item.getMasterColumnId());
            TLrMetadataDetail detailColumn = this.metadataDetailMapper.selectMetadataDetailBycolumnId(item.getSlaveColumnId());
            whereBuilder.append(" \"").append(detailColumn.getColumnName()).append("\" = #{").append(masterColumn).append("} AND");
            this.getAutoConfig(autoList, "00", LRConstants.sys_dataservice_whereflag_id, LRConstants.sys_dataservice_whereflag_value, detailColumn, dataServiceVoslave.getDataserviceId(), masterColumn);
        });
        return whereBuilder.toString().substring(0, whereBuilder.toString().length() - 3);
    }

    private TLrDataserviceConfigurationTable dataServiceConfiguration(String modelId, String masterTableName, String slaveTableName, String mapperType, TLrMetadataManageTable baseInfo) {
        TLrDataserviceConfigurationTable dataServiceVo = new TLrDataserviceConfigurationTable();
        String dataServiceId = String.valueOf(IdGenerateUtils.getId());
        String nameFlag = mapperType + dataServiceId + System.currentTimeMillis();
        dataServiceVo.setDataserviceId(dataServiceId);
        dataServiceVo.setMapperType(mapperType);
        dataServiceVo.setDataserviceName(nameFlag);
        dataServiceVo.setDataserviceChname(nameFlag);
        dataServiceVo.setDataserviceVersion(Long.valueOf(1L));
        dataServiceVo.setDataserviceStatus(LRConstants.data_statuts_release);
        dataServiceVo.setDatasourceId(baseInfo.getDatasourceId());
        dataServiceVo.setOperType("00");
        if (!"".equals(masterTableName) && "".equals(slaveTableName)) {
            dataServiceVo.setMasterDataserviceFalg(Integer.valueOf(1));
        }
        dataServiceVo.setCreateTime(DateUtils.getNowDate());
        dataServiceVo.setModelId(modelId);
        dataServiceVo.setUserId(IdAcquisitionUtil.getCurrentUserId());
        dataServiceVo.setStatus(Integer.valueOf(1));
        dataServiceVo.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        this.tLrDataserviceConfigrationTableMapper.insertTLrDataServiceConfigurationTable(dataServiceVo);
        return dataServiceVo;
    }

    private void getAutoConfig(List<TLrDataserviceAutoConfig> autoList, String putType, Long dicId, Long dictCode, TLrMetadataDetail d, String dataServiceId, String columnAliasDefined) {
        TLrDataserviceAutoConfig auto = new TLrDataserviceAutoConfig();
        auto.setColumnAliasDefined(columnAliasDefined);
        auto.setColumnAlias(columnAliasDefined);
        auto.setId(String.valueOf(IdGenerateUtils.getId()));
        auto.setDataserviceId(dataServiceId);
        auto.setColumnId(d.getColumnId());
        auto.setTableId(d.getTableId());
        auto.setPutType(putType);
        auto.setDicId(dicId);
        auto.setDictCode(dictCode);
        auto.setStatus(Integer.valueOf(1));
        auto.setUserId(IdAcquisitionUtil.getCurrentUserId());
        auto.setCreateTime(DateUtils.getNowDate());
        auto.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        if (null != d.getInputWhere() && !"".equals(d.getInputWhere().trim())) {
            auto.setInputWhere(d.getInputWhere());
        }
        autoList.add(auto);
    }

    private void batchInsertAutoconfig(String dsType, List<TLrDataserviceAutoConfig> autoList) {
        Map dataServiceAutoConfigMappers = TLrPlatformTableFactory.getMappers((String)"dataServiceAutoConfig");
        ((TLrPlatformTableMapper)dataServiceAutoConfigMappers.get(dsType)).batchInsertDataserviceAutoconfig(autoList);
    }

    private void insertTLrDataServiceSql(String dataServiceId, String sql, List<InputColumnVO> inputColumnVOList) {
        TLrDataServiceSql serviceSql = new TLrDataServiceSql();
        serviceSql.setId(String.valueOf(IdGenerateUtils.getId()));
        serviceSql.setDataServiceId(dataServiceId);
        serviceSql.setDataServiceSql(sql);
        if (!CollectionUtils.isEmpty(inputColumnVOList)) {
            serviceSql.setWhereChildren(JSON.toJSONString(inputColumnVOList));
        }
        serviceSql.setStatus(Integer.valueOf(1));
        serviceSql.setUserId(IdAcquisitionUtil.getCurrentUserId());
        serviceSql.setCreateTime(DateUtils.getNowDate());
        serviceSql.setTenantId(IdAcquisitionUtil.getCurrentTenantId());
        this.tLrDataServiceSqlMapper.insertTLrDataServiceSqlMapper(serviceSql);
    }

    private void insertDataServiceDetailAndSQL(String dsType, List<TLrDataserviceAutoConfig> autoList, String dataServiceId, String sql, List<InputColumnVO> inputColumnVOList) {
        this.batchInsertAutoconfig(dsType, autoList);
        this.insertTLrDataServiceSql(dataServiceId, sql, inputColumnVOList);
    }

    private List<TLrTableRelationship> getRelationShipListByModeId(MasterSlaveColumnDefinedVO de, String tableId) {
        TLrTableRelationship relationshipQuery = new TLrTableRelationship();
        relationshipQuery.setModelId(de.getModelId());
        relationshipQuery.setSlaveTableId(tableId);
        return this.relationshipMapper.selectTLrTableRelationshipList(relationshipQuery);
    }

    private void handleParams(Map<String, Object> params, List<InputColumnVO> inputColumnVOList, List<TLrDataserviceAutoConfig> autoList, String dataServiceId) {
        if (CollectionUtils.isEmpty(inputColumnVOList)) {
            return;
        }
        for (InputColumnVO inputColumnVO : inputColumnVOList) {
            if (ConnectEnum._ROW.getType().equals(inputColumnVO.getType())) {
                this.getInAutoConfig(autoList, "00", inputColumnVO, dataServiceId);
                params.put(inputColumnVO.getColumnAliasDefined(), "value");
            }
            if (!ConnectEnum._CHILD.getType().equals(inputColumnVO.getType())) continue;
            List children = inputColumnVO.getChildren();
            this.handleParams(params, children, autoList, dataServiceId);
        }
    }

    private List<TLrTableRelationship> getRelationShipListByModeIdMasterId(MasterSlaveColumnDefinedVO de, String tableId) {
        TLrTableRelationship relationshipQuery = new TLrTableRelationship();
        relationshipQuery.setModelId(de.getModelId());
        relationshipQuery.setMasterTableId(tableId);
        return this.relationshipMapper.selectTLrTableRelationshipList(relationshipQuery);
    }

    private String getRemarkDetail(String mapperType) {
        String remark = null;
        switch (mapperType) {
            case "INSERT": {
                remark = "\u4e3b\u4ece\u63d2\u5165";
                break;
            }
            case "SELECT": {
                remark = "\u4e3b\u4ece\u67e5\u8be2";
                break;
            }
            case "DELETE": {
                remark = "\u4e3b\u4ece\u5220\u9664";
                break;
            }
            case "UPDATE": {
                remark = "\u4e3b\u4ece\u66f4\u65b0";
                break;
            }
            case "PAGESELECT": {
                remark = "\u4e3b\u8868\u5206\u9875\u67e5\u8be2";
                break;
            }
            case "SAVEORUPDATE": {
                remark = "\u4e3b\u4ece\u65b0\u589e\u6216\u66f4\u65b0";
            }
        }
        return remark;
    }
}

