/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.dm.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.engine.common.service.LrCacheService;
import com.jxdinfo.engine.dm.service.IDMLrCacheSyncService;
import com.jxdinfo.engine.metadata.dao.TLrDataServiceSqlMapper;
import com.jxdinfo.engine.metadata.dao.TLrDataserviceConfigrationTableMapper;
import com.jxdinfo.engine.metadata.dao.TLrImplementsMapper;
import com.jxdinfo.engine.metadata.dao.TLrServiceDetailMapper;
import com.jxdinfo.engine.metadata.dao.TLrServiceOutputInputMapper;
import com.jxdinfo.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.engine.metadata.enums.MapperTypeEnum;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.engine.metadata.model.TLrDataServiceSql;
import com.jxdinfo.engine.metadata.model.TLrDataserviceConfigurationTable;
import com.jxdinfo.engine.metadata.model.TLrImplements;
import com.jxdinfo.engine.metadata.model.TLrServiceDetailTable;
import com.jxdinfo.engine.metadata.model.TLrServiceOutputInputTable;
import com.jxdinfo.engine.metadata.util.CommonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@DS(value="master")
public class DMLrCacheSyncServiceImpl
implements IDMLrCacheSyncService {
    private static final Logger logger = LoggerFactory.getLogger(DMLrCacheSyncServiceImpl.class);
    private static final String INTERFACE = "INTERFACE";
    private static final String DELETE = "DELETE";
    @Autowired
    private TLrImplementsMapper lrImplementsMapper;
    @Autowired
    private TLrServiceDetailMapper lrServiceDetailMapper;
    @Autowired
    private TLrDataServiceSqlMapper lrDataServiceSqlMapper;
    @Autowired
    private TLrDataserviceConfigrationTableMapper lrDataServiceMapper;
    @Autowired
    private TLrServiceOutputInputMapper lrServiceOutputInputMapper;
    @Autowired
    private LrCacheService cacheService;

    @Override
    public void syncInterfaceCache(String operateType, String serviceId) throws EngineException {
        TLrImplements lrImplements = this.lrImplementsMapper.selectTLrImplementsByserviceId(serviceId);
        if (lrImplements == null) {
            logger.info("\u6839\u636eserviceId\u67e5\u8be2\u63a5\u53e3\u5730\u5740\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0cserviceId:{}", (Object)serviceId);
            int code = EngineExceptionEnum.INTERFACE_CONFIGURATION_INFORMATION_NOT_OBTAINED.getCode();
            String message = "\u6839\u636eserviceId\uff1a" + serviceId + EngineExceptionEnum.INTERFACE_CONFIGURATION_INFORMATION_NOT_OBTAINED.getMessage();
            throw new EngineException(code, message);
        }
        Map<String, TLrImplements> urlMap = Maps.newHashMapWithExpectedSize((int)1);
        Object object = this.cacheService.get("lr-core", "LR:CORE:INTERFACES");
        if (object != null) {
            urlMap = (Map)this.cacheService.get("lr-core", "LR:CORE:INTERFACES");
        }
        if (CollectionUtils.isEmpty((Map)urlMap)) {
            urlMap = Maps.newHashMapWithExpectedSize((int)1);
        }
        String url = lrImplements.getUrl();
        if (DELETE.equals(operateType) && urlMap.containsKey(url)) {
            urlMap.remove(url);
        } else {
            urlMap.put(url, lrImplements);
        }
        this.cacheService.put("lr-core", "LR:CORE:INTERFACES", urlMap);
        List<TLrServiceDetailTable> serviceDetails = this.syncBusinessDetailCache(serviceId, operateType);
        List<String> dataServiceIds = serviceDetails.stream().map(TLrServiceDetailTable::getDataserviceId).collect(Collectors.toList());
        this.syncSqlCache(dataServiceIds, operateType);
        this.syncUrlMethodCache(dataServiceIds, lrImplements.getUrl(), operateType, serviceId, serviceDetails);
    }

    private void syncUrlMethodCache(List<String> dataServiceIds, String url, String operateType, String serviceId, List<TLrServiceDetailTable> serviceDetails) throws EngineException {
        Map<String, String> urlMethodNameMap = null;
        Object object = this.cacheService.get("lr-core", "LR:CORE:URL:METHOD:MAPPINGS");
        if (object != null) {
            urlMethodNameMap = (Map)this.cacheService.get("lr-core", "LR:CORE:URL:METHOD:MAPPINGS");
        }
        if (CollectionUtils.isEmpty(urlMethodNameMap)) {
            urlMethodNameMap = Maps.newHashMapWithExpectedSize((int)3);
        }
        if (DELETE.equals(operateType) && urlMethodNameMap.containsKey(url)) {
            urlMethodNameMap.remove(url);
            this.cacheService.put("lr-core", "LR:CORE:URL:METHOD:MAPPINGS", urlMethodNameMap);
            return;
        }
        List outputInputs = this.lrServiceOutputInputMapper.selectByServiceId(serviceId);
        if (CollectionUtils.isEmpty((Collection)outputInputs)) {
            outputInputs = Lists.newArrayListWithCapacity((int)0);
        }
        Set<String> outputs = outputInputs.stream().map(TLrServiceOutputInputTable::getOutDataserviceId).collect(Collectors.toSet());
        Sets.SetView finalOutputs = Sets.difference((Set)Sets.newHashSet(dataServiceIds), outputs);
        List dataServices = this.lrDataServiceMapper.selectByIds(dataServiceIds);
        if (CollectionUtils.isEmpty((Collection)dataServices)) {
            logger.info("\u6839\u636e\u6570\u636e\u670d\u52a1\u4e3b\u952e\u83b7\u53d6\u6570\u636e\u670d\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a, dataServiceIds:{}", dataServiceIds);
            throw new EngineException(EngineExceptionEnum.DATA_SERVICE_CONFIGURATION_INFORMATION_NOT_OBTAINED);
        }
        Map dataServiceMap = dataServices.stream().collect(Collectors.toMap(TLrDataserviceConfigurationTable::getDataserviceId, Function.identity()));
        TLrDataserviceConfigurationTable dataService = new TLrDataserviceConfigurationTable();
        int cnt = 0;
        for (String outputDsId : finalOutputs) {
            dataService = (TLrDataserviceConfigurationTable)dataServiceMap.get(outputDsId);
            if (!MapperTypeEnum.SELECT.name().equalsIgnoreCase(dataService.getMapperType())) continue;
            ++cnt;
        }
        if (cnt > 1) {
            urlMethodNameMap.put(serviceId, url.contains("T_LR/masterSlave/") ? CommonUtils.getMasterSlaveMethodName((String)dataService.getMapperType(), (Byte)dataService.getPagination(), (Byte)dataService.getResultType()) : CommonUtils.getMethodName((String)dataService.getMapperType(), (Byte)dataService.getPagination(), (Byte)dataService.getResultType()));
        } else {
            dataService = (TLrDataserviceConfigurationTable)dataServiceMap.get(DMLrCacheSyncServiceImpl.findDataServiceId(serviceDetails, outputs));
            String methodName = url.contains("T_LR/masterSlave/") ? CommonUtils.getMasterSlaveMethodName((String)dataService.getMapperType(), (Byte)dataService.getPagination(), (Byte)dataService.getResultType()) : CommonUtils.getMethodName((String)dataService.getMapperType(), (Byte)dataService.getPagination(), (Byte)dataService.getResultType());
            urlMethodNameMap.put(serviceId, methodName);
        }
        this.cacheService.put("lr-core", "LR:CORE:URL:METHOD:MAPPINGS", urlMethodNameMap);
    }

    private List<TLrServiceDetailTable> syncBusinessDetailCache(String id, String operateType) throws EngineException {
        List details;
        Map<String, HashMap> serviceDetailMap = Maps.newHashMapWithExpectedSize((int)1);
        Object object = this.cacheService.get("lr-core", "LR:CORE:BUSINESS:SERVICE:DETAILS");
        if (object != null) {
            serviceDetailMap = (Map)this.cacheService.get("lr-core", "LR:CORE:BUSINESS:SERVICE:DETAILS");
        }
        if (CollectionUtils.isEmpty((Map)serviceDetailMap)) {
            serviceDetailMap = Maps.newHashMapWithExpectedSize((int)1);
        }
        if (CollectionUtils.isEmpty((Collection)(details = this.lrServiceDetailMapper.selectByServiceIds((List)Lists.newArrayList((Object[])new String[]{id}))))) {
            logger.info("\u6839\u636eserviceId\u83b7\u53d6\u4e1a\u52a1\u670d\u52a1\u6620\u5c04\u4fe1\u606f\u4e3a\u7a7a\uff0cid:{}", (Object)id);
            throw new EngineException(EngineExceptionEnum.BUSINESS_SERVICE_MAPPING_INFORMATION_NOT_OBTAINED);
        }
        if (DELETE.equals(operateType) && serviceDetailMap.containsKey(id)) {
            serviceDetailMap.remove(id);
            this.cacheService.put("lr-core", "LR:CORE:BUSINESS:SERVICE:DETAILS", serviceDetailMap);
            return details;
        }
        HashMap detailMap = Maps.newHashMap();
        for (TLrServiceDetailTable detailTable : details) {
            List<TLrServiceDetailTable> sortDetails;
            Byte treeSort = detailTable.getTreeSort();
            if (detailMap.containsKey(treeSort)) {
                sortDetails = (List)detailMap.get(treeSort);
            } else {
                sortDetails = Lists.newArrayList();
                detailMap.put(treeSort, sortDetails);
            }
            sortDetails.add(detailTable);
        }
        serviceDetailMap.put(id, detailMap);
        this.cacheService.put("lr-core", "LR:CORE:BUSINESS:SERVICE:DETAILS", serviceDetailMap);
        return details;
    }

    private void syncSqlCache(List<String> dataServiceIds, String operateType) {
        Map<String, String> sqlMap = Maps.newHashMapWithExpectedSize((int)1);
        Object object = this.cacheService.get("lr-core", "LR:CORE:DATA:SERVICE:SQL");
        if (object != null) {
            sqlMap = (Map)this.cacheService.get("lr-core", "LR:CORE:DATA:SERVICE:SQL");
        }
        if (CollectionUtils.isEmpty((Map)sqlMap)) {
            sqlMap = Maps.newHashMapWithExpectedSize((int)1);
        }
        if (DELETE.equals(operateType)) {
            for (String dataServiceId : dataServiceIds) {
                sqlMap.remove(dataServiceId);
            }
            this.cacheService.put("lr-core", "LR:CORE:DATA:SERVICE:SQL", (Object)sqlMap);
            return;
        }
        List sqlList = this.lrDataServiceSqlMapper.selectByDataServiceIds(dataServiceIds);
        if (CollectionUtils.isEmpty((Collection)sqlList)) {
            logger.info("\u6839\u636e\u4e3b\u952eID\u83b7\u53d6\u6570\u636e\u670d\u52a1SQL\u4e3a\u7a7a");
            return;
        }
        for (TLrDataServiceSql sql : sqlList) {
            sqlMap.put(sql.getDataServiceId(), sql.getDataServiceSql());
        }
        this.cacheService.put("lr-core", "LR:CORE:DATA:SERVICE:SQL", sqlMap);
    }

    private static String findDataServiceId(List<TLrServiceDetailTable> serviceDetails, Set<String> outputs) {
        if (serviceDetails.size() == 1) {
            return serviceDetails.get(0).getDataserviceId();
        }
        if (CollectionUtils.isEmpty(outputs) || outputs.size() == serviceDetails.size()) {
            return serviceDetails.get(0).getDataserviceId();
        }
        ArrayList details = Lists.newArrayListWithCapacity((int)(serviceDetails.size() - outputs.size()));
        for (TLrServiceDetailTable detail : serviceDetails) {
            String dataServiceId = detail.getDataserviceId();
            if (outputs.contains(dataServiceId)) continue;
            details.add(detail);
        }
        return ((TLrServiceDetailTable)details.get(details.size() - 1)).getDataserviceId();
    }
}

