/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.compile.util.classloader.jarloader;

import com.jxdinfo.engine.compile.util.classloader.jarloader.DynamicURLClassLoader;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarClassLoader {
    private static final ConcurrentHashMap<String, DynamicURLClassLoader> LOADER_CACHE = new ConcurrentHashMap();
    private static final Logger logger = LoggerFactory.getLogger(JarClassLoader.class);

    public static void loadJar(String jarFilePath) throws Exception {
        String key = StringUtils.substringAfterLast((String)jarFilePath.replace("\\", "/"), (String)"/");
        DynamicURLClassLoader urlClassLoader = LOADER_CACHE.get(key);
        if (urlClassLoader != null) {
            return;
        }
        urlClassLoader = new DynamicURLClassLoader();
        URL jarUrl = new URL("jar:file:/" + jarFilePath + "!/");
        urlClassLoader.addURLFile(jarUrl);
        logger.info("\u52a0\u8f7djar\u5305\u6587\u4ef6" + jarUrl);
        LOADER_CACHE.put(key, urlClassLoader);
    }

    public static Class<?> loadClass(String jarFileName, String name) throws ClassNotFoundException {
        DynamicURLClassLoader urlClassLoader = LOADER_CACHE.get(jarFileName);
        if (urlClassLoader == null) {
            return null;
        }
        return urlClassLoader.loadClass(name);
    }

    public static void unloadJarFile(String jarFilePath) throws Exception {
        String key = StringUtils.substringAfterLast((String)jarFilePath.replace("\\", "/"), (String)"/");
        DynamicURLClassLoader urlClassLoader = LOADER_CACHE.get(key);
        if (urlClassLoader == null) {
            return;
        }
        String jarStr = "jar:file:/" + jarFilePath + "!/";
        urlClassLoader.unloadJarFile(jarStr);
        urlClassLoader = null;
        LOADER_CACHE.remove(key);
    }
}

