/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.compile.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.jxdinfo.engine.common.util.LrTenantUtil;
import com.jxdinfo.engine.compile.dao.PretreatmentMethodMapper;
import com.jxdinfo.engine.compile.model.PretreatmentInvoke;
import com.jxdinfo.engine.compile.util.classloader.ClassLoaderUtil;
import com.jxdinfo.engine.compile.util.classloader.DefaultClassLoader;
import com.jxdinfo.engine.metadata.enums.EngineExceptionEnum;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.engine.metadata.model.InvokeResponse;
import com.jxdinfo.engine.metadata.service.MetadataInvokeService;
import com.jxdinfo.engine.metadata.util.EngineSpringUtil;
import com.jxdinfo.engine.rvm.model.Coordinates;
import com.jxdinfo.engine.rvm.model.VersionResource;
import com.jxdinfo.engine.rvm.service.ResourceVersionManageService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="engine.compile.PretreatmentInvokeServiceImpl")
@DS(value="master")
public class PretreatmentInvokeServiceImpl
implements MetadataInvokeService {
    private static Logger logger = LoggerFactory.getLogger(PretreatmentInvokeServiceImpl.class);
    private final PretreatmentMethodMapper pretreatmentMethodMapper;
    private final ResourceVersionManageService resourceVersionManageService;

    @Autowired
    public PretreatmentInvokeServiceImpl(PretreatmentMethodMapper pretreatmentMethodMapper, ResourceVersionManageService resourceVersionManageService) {
        this.pretreatmentMethodMapper = pretreatmentMethodMapper;
        this.resourceVersionManageService = resourceVersionManageService;
    }

    public InvokeResponse invokeMethod(Map<String, Object> params, String serviceId) throws EngineException {
        MetadataInvokeService metadataInvokeService;
        Object bean;
        InvokeResponse invokeResponse = new InvokeResponse();
        if (serviceId == null) {
            logger.info("serviceId is null");
            invokeResponse.setSuccess(false);
            invokeResponse.setData((Object)"serviceId is null");
            return invokeResponse;
        }
        List<PretreatmentInvoke> pretreatmentInvokes = this.pretreatmentMethodMapper.getPretreatmentInvoke(serviceId, LrTenantUtil.getTenantId());
        if (ToolUtil.isEmpty(pretreatmentInvokes)) {
            logger.info("pretreatment method not exist");
            invokeResponse.setSuccess(false);
            invokeResponse.setData((Object)"pretreatment method not exist");
            return invokeResponse;
        }
        PretreatmentInvoke before = null;
        PretreatmentInvoke after = null;
        for (PretreatmentInvoke p : pretreatmentInvokes) {
            if ("before".equals(p.getMethodType())) {
                before = p;
                continue;
            }
            if (!"after".equals(p.getMethodType())) continue;
            after = p;
        }
        this.doPretreatment(before, params);
        if (before != null) {
            bean = EngineSpringUtil.getBean((String)before.getEngineName());
            if (!(bean instanceof MetadataInvokeService)) {
                throw new EngineException(EngineExceptionEnum.ENGINE_NOT_FOUND);
            }
            metadataInvokeService = (MetadataInvokeService)bean;
            invokeResponse = metadataInvokeService.invokeMethod(params, before.getEngineServiceId());
        } else if (after != null) {
            bean = EngineSpringUtil.getBean((String)after.getEngineName());
            if (!(bean instanceof MetadataInvokeService)) {
                throw new EngineException(EngineExceptionEnum.ENGINE_NOT_FOUND);
            }
            metadataInvokeService = (MetadataInvokeService)bean;
            invokeResponse = metadataInvokeService.invokeMethod(params, after.getEngineServiceId());
        } else {
            logger.error("Pretreatment method error,before method and after method don't exist");
            invokeResponse.setSuccess(false);
            invokeResponse.setData((Object)"Pretreatment method error,before method and after method don't exist");
        }
        this.doPretreatment(after, params);
        return invokeResponse;
    }

    private void doPretreatment(PretreatmentInvoke pretreatmentInvoke, Map<String, Object> map) throws EngineException {
        if (pretreatmentInvoke == null) {
            return;
        }
        Class<?> clazz = ClassLoaderUtil.loadClass(pretreatmentInvoke.getClassPath(), pretreatmentInvoke.getClassVersion());
        if (clazz == null) {
            clazz = this.reLoadClass(pretreatmentInvoke);
        }
        try {
            if (clazz == null) {
                logger.info("{} not exist,version {}", (Object)pretreatmentInvoke.getClassPath(), (Object)pretreatmentInvoke.getClassVersion());
                throw new EngineException(pretreatmentInvoke.getClassPath() + " not exist,version " + pretreatmentInvoke.getClassVersion());
            }
            Object o = clazz.newInstance();
            Method method = clazz.getDeclaredMethod(pretreatmentInvoke.getMethodName(), Map.class);
            method.invoke(o, map);
        }
        catch (Exception e) {
            throw new EngineException(e.getMessage());
        }
    }

    private Class<?> reLoadClass(PretreatmentInvoke pretreatmentInvoke) throws EngineException {
        Coordinates coordinates = new Coordinates();
        coordinates.setType("compile");
        coordinates.setName(pretreatmentInvoke.getClassId());
        coordinates.setLabel("");
        coordinates.setMajor(Integer.valueOf(1));
        coordinates.setMinor(Integer.valueOf(1));
        coordinates.setPatch(Integer.valueOf(pretreatmentInvoke.getClassVersion()));
        VersionResource versionResource = this.resourceVersionManageService.get(coordinates);
        if (versionResource == null) {
            logger.info("VersionResource is null,Coordinates:{}", (Object)coordinates);
            return null;
        }
        String javaCode = versionResource.getContent();
        try {
            Map<String, Object> map = ClassLoaderUtil.compileJavaCode(pretreatmentInvoke.getClassPath(), javaCode);
            String result = map.get("result").toString();
            if ("1".equals(result)) {
                DefaultClassLoader classLoader = (DefaultClassLoader)map.get("data");
                ClassLoaderUtil.saveLoader(pretreatmentInvoke.getClassPath(), pretreatmentInvoke.getClassVersion(), classLoader);
                return (Class)map.get("class");
            }
            throw new EngineException(map.get("data").toString());
        }
        catch (Exception e) {
            throw new EngineException(e.getMessage());
        }
    }
}

