/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.compile.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.engine.common.util.LrTenantUtil;
import com.jxdinfo.engine.compile.dao.ClassMethodMapper;
import com.jxdinfo.engine.compile.model.ClassMethod;
import com.jxdinfo.engine.compile.service.ClassMethodService;
import com.jxdinfo.engine.metadata.model.InvokeResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DS(value="master")
public class ClassMethodServiceImpl
extends ServiceImpl<ClassMethodMapper, ClassMethod>
implements ClassMethodService {
    private final ClassMethodMapper classMethodMapper;

    @Autowired
    public ClassMethodServiceImpl(ClassMethodMapper classMethodMapper) {
        this.classMethodMapper = classMethodMapper;
    }

    @Override
    public InvokeResponse getMethodsByVersionId(String versionId) {
        InvokeResponse response = new InvokeResponse();
        if (versionId != null && !"".equals(versionId)) {
            response.setSuccess(true);
            response.setData(this.classMethodMapper.getMethodListByVersionId(versionId, this.getTenantId()));
        } else {
            response.setSuccess(false);
            response.setData((Object)"versionId is not null");
        }
        return response;
    }

    private String getTenantId() {
        return LrTenantUtil.getTenantId();
    }
}

