/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.compile.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.engine.common.util.LrTenantUtil;
import com.jxdinfo.engine.compile.dao.ClassInfoMapper;
import com.jxdinfo.engine.compile.dao.ClassMethodMapper;
import com.jxdinfo.engine.compile.dao.ClassVersionMapper;
import com.jxdinfo.engine.compile.model.ClassInfo;
import com.jxdinfo.engine.compile.model.ClassMethod;
import com.jxdinfo.engine.compile.model.ClassResponse;
import com.jxdinfo.engine.compile.model.ClassVersion;
import com.jxdinfo.engine.compile.model.PretreatmentMethod;
import com.jxdinfo.engine.compile.service.ClassConfigService;
import com.jxdinfo.engine.compile.service.ClassInfoService;
import com.jxdinfo.engine.compile.service.ClassMethodService;
import com.jxdinfo.engine.compile.service.ClassVersionService;
import com.jxdinfo.engine.compile.service.PretreatmentMethodService;
import com.jxdinfo.engine.compile.util.classloader.ClassLoaderUtil;
import com.jxdinfo.engine.compile.util.classloader.DefaultClassLoader;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.engine.rvm.model.Coordinates;
import com.jxdinfo.engine.rvm.model.VersionResource;
import com.jxdinfo.engine.rvm.model.VersionStrategy;
import com.jxdinfo.engine.rvm.service.ResourceVersionManageService;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@DS(value="master")
public class ClassConfigServiceImpl
extends ServiceImpl<ClassInfoMapper, ClassInfo>
implements ClassConfigService {
    private static Logger logger = LoggerFactory.getLogger(ClassConfigServiceImpl.class);
    private final ClassMethodService classMethodService;
    private final ResourceVersionManageService resourceVersionManageService;
    private final ClassInfoMapper classInfoMapper;
    private final ClassVersionService classVersionService;
    private final ClassInfoService classInfoService;
    private final ClassVersionMapper classVersionMapper;
    private final ClassMethodMapper classMethodMapper;
    private final PretreatmentMethodService pretreatmentMethodService;

    @Autowired
    public ClassConfigServiceImpl(ResourceVersionManageService resourceVersionManageService, ClassMethodService classMethodService, ClassInfoMapper classInfoMapper, ClassVersionService classVersionService, ClassInfoService classInfoService, ClassVersionMapper classVersionMapper, ClassMethodMapper classMethodMapper, PretreatmentMethodService pretreatmentMethodService) {
        this.classMethodService = classMethodService;
        this.resourceVersionManageService = resourceVersionManageService;
        this.classInfoMapper = classInfoMapper;
        this.classVersionService = classVersionService;
        this.classInfoService = classInfoService;
        this.classVersionMapper = classVersionMapper;
        this.classMethodMapper = classMethodMapper;
        this.pretreatmentMethodService = pretreatmentMethodService;
    }

    @Override
    public List<ClassResponse> compileClass(File file, String description) throws EngineException {
        byte[] bytes = new byte[1024];
        StringBuilder sb = new StringBuilder();
        try (FileInputStream in = new FileInputStream(file);){
            int len;
            while ((len = in.read(bytes)) != -1) {
                sb.append(new String(bytes, 0, len));
            }
        }
        catch (IOException e) {
            throw new EngineException("Error:can't read class file ! " + file.getPath());
        }
        String javaCode = sb.toString();
        return this.compileClass(javaCode, description);
    }

    @Override
    public List<ClassResponse> compileClass(byte[] arr, String description) throws EngineException {
        String javaCode = new String(arr, Charset.forName("UTF-8"));
        return this.compileClass(javaCode, description);
    }

    @Override
    public List<ClassResponse> compileClass(String javaCode, String description) throws EngineException {
        return this.compileClass(javaCode, description, "1");
    }

    @Override
    public List<ClassResponse> compileClass(String javaCode, String description, String type) throws EngineException {
        int packageIndex = javaCode.indexOf("package");
        int pathIndex = javaCode.indexOf(";", packageIndex);
        int classIndex = javaCode.indexOf("class");
        int nameIndex = javaCode.indexOf("{", classIndex);
        String name = javaCode.substring(classIndex + 6, nameIndex).trim().split(" ")[0];
        String fullName = javaCode.substring(packageIndex + 7, pathIndex).trim() + "." + name;
        Map<String, Object> map = ClassLoaderUtil.compileJavaCode(fullName, javaCode);
        String result = map.get("result").toString();
        ArrayList<ClassResponse> responses = new ArrayList<ClassResponse>();
        if ("1".equals(result)) {
            String classId = this.selectOrSaveClassInfo(fullName, name, description);
            VersionResource versionResource = new VersionResource();
            versionResource.setType("compile");
            versionResource.setContent(javaCode);
            versionResource.setDescription(description);
            versionResource.setName(classId);
            versionResource.setMajor(Integer.valueOf(1));
            versionResource.setMinor(Integer.valueOf(1));
            versionResource.setLabel("");
            Coordinates coordinates = this.resourceVersionManageService.save(versionResource, VersionStrategy.PATCH);
            int version = coordinates.getPatch();
            ClassVersion classVersion = new ClassVersion();
            String versionId = UUID.randomUUID().toString().replace("-", "");
            classVersion.setClassId(classId);
            classVersion.setVersionId(versionId);
            classVersion.setClassVersion(version);
            classVersion.setClassPath(fullName);
            classVersion.setClassType(type);
            classVersion.setCreateTime(new Date());
            classVersion.setCreatorId(this.getUserId());
            classVersion.setTenantId(this.getTenantId());
            classVersion.setInUse("1");
            this.classVersionService.save(classVersion);
            ClassLoaderUtil.saveLoader(fullName, version, (DefaultClassLoader)map.get("data"));
            if ("1".equals(type)) {
                Class clazz = (Class)map.get("class");
                ArrayList<ClassMethod> methodList = new ArrayList<ClassMethod>();
                if (clazz != null) {
                    Method[] methods;
                    for (Method method : methods = clazz.getDeclaredMethods()) {
                        int modifiers = method.getModifiers();
                        if (!Modifier.isPublic(modifiers)) continue;
                        ClassMethod classMethod = new ClassMethod();
                        ClassResponse classResponse = new ClassResponse();
                        String methodId = UUID.randomUUID().toString().replace("-", "");
                        classMethod.setVersionId(versionId);
                        classMethod.setMethodId(methodId);
                        classMethod.setMethodName(method.getName());
                        classMethod.setTenantId(this.getTenantId());
                        methodList.add(classMethod);
                        classResponse.setClassName(fullName);
                        classResponse.setInvokeId(methodId);
                        classResponse.setMethodName(method.getName());
                        responses.add(classResponse);
                    }
                    if (methodList.size() > 0) {
                        this.classMethodService.saveBatch(methodList);
                    }
                }
            } else {
                ClassResponse classResponse = new ClassResponse();
                classResponse.setInvokeId(classId);
                classResponse.setClassName(fullName);
                responses.add(classResponse);
            }
        } else {
            throw new EngineException(map.get("data").toString());
        }
        return responses;
    }

    @Override
    public void exportCompileClass(List<String> idList, HttpServletResponse response) throws EngineException {
        if (ToolUtil.isEmpty(idList)) {
            throw new EngineException("Export data cannot be empty");
        }
        List<ClassMethod> methodList = this.classMethodMapper.getListByIds(idList, this.getTenantId());
        if (ToolUtil.isEmpty(methodList)) {
            throw new EngineException("Method data not exist");
        }
        HashMap map = new HashMap();
        ArrayList<String> versionIds = new ArrayList<String>();
        for (ClassMethod classMethod : methodList) {
            String key = classMethod.getVersionId();
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
                versionIds.add(key);
            }
            ((List)map.get(key)).add(classMethod);
        }
        List<ClassVersion> versionList = this.classVersionMapper.getListByIds(versionIds, this.getTenantId());
        if (ToolUtil.isEmpty(versionList)) {
            throw new EngineException("Data not exist");
        }
        ArrayList dataList = new ArrayList();
        for (ClassVersion classVersion : versionList) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("class", classVersion);
            if (map.containsKey(classVersion.getVersionId())) {
                dataMap.put("methods", map.get(classVersion.getVersionId()));
            }
            Coordinates coordinates = new Coordinates();
            coordinates.setType("compile");
            coordinates.setName(classVersion.getClassId());
            coordinates.setLabel("");
            coordinates.setMajor(Integer.valueOf(1));
            coordinates.setMinor(Integer.valueOf(1));
            coordinates.setPatch(Integer.valueOf(classVersion.getClassVersion()));
            VersionResource versionResource = this.resourceVersionManageService.get(coordinates);
            dataMap.put("javaCode", versionResource.getContent());
            dataList.add(dataMap);
        }
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("data", dataList);
        json.put("export_type", "compile_export");
        byte[] serializeData = SerializeUtils.serialize(json);
        String fileName = "compile_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss") + ".lr";
        if (response == null) {
            response = HttpKit.getResponse();
        }
        ClassConfigServiceImpl.byteToFile(serializeData, fileName, response);
    }

    @Override
    public List<ClassResponse> importClass(byte[] content) throws EngineException {
        ArrayList<ClassResponse> classResponses = new ArrayList<ClassResponse>();
        Map json = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = json.get("export_type").toString();
        if (!"compile_export".equals(export_type)) {
            throw new EngineException("Import type error");
        }
        List dataList = (List)json.get("data");
        for (Map data : dataList) {
            ClassVersion classVersion = (ClassVersion)data.get("class");
            String classPath = classVersion.getClassPath();
            String name = classPath.substring(classPath.lastIndexOf("."));
            String classId = this.selectOrSaveClassInfo(classPath, name, "");
            String javaCode = data.get("javaCode").toString();
            VersionResource versionResource = new VersionResource();
            versionResource.setType("compile");
            versionResource.setContent(javaCode);
            versionResource.setDescription("");
            versionResource.setName(classId);
            versionResource.setMajor(Integer.valueOf(1));
            versionResource.setMinor(Integer.valueOf(1));
            versionResource.setLabel("");
            Coordinates coordinates = this.resourceVersionManageService.save(versionResource, VersionStrategy.PATCH);
            int version = coordinates.getPatch();
            String versionId = UUID.randomUUID().toString().replace("-", "");
            classVersion.setVersionId(versionId);
            classVersion.setClassVersion(version);
            classVersion.setTenantId(this.getTenantId());
            classVersion.setCreatorId(this.getUserId());
            classVersion.setClassId(classId);
            classVersion.setCreateTime(new Date());
            this.classVersionService.save(classVersion);
            List classMethods = (List)data.get("methods");
            if (ToolUtil.isNotEmpty((Object)classMethods)) {
                for (ClassMethod classMethod : classMethods) {
                    String methodId = UUID.randomUUID().toString().replace("-", "");
                    classMethod.setMethodId(methodId);
                    classMethod.setTenantId(this.getTenantId());
                    classMethod.setVersionId(versionId);
                    ClassResponse classResponse = new ClassResponse();
                    classResponse.setClassName(classVersion.getClassPath());
                    classResponse.setInvokeId(methodId);
                    classResponse.setMethodName(classMethod.getMethodName());
                    classResponses.add(classResponse);
                }
                this.classMethodService.saveBatch(classMethods);
                continue;
            }
            ClassResponse classResponse = new ClassResponse();
            classResponse.setClassName(classVersion.getClassPath());
            classResponse.setInvokeId(versionId);
            classResponse.setMethodName("");
            classResponses.add(classResponse);
        }
        return classResponses;
    }

    @Override
    public List<ClassResponse> importClass(MultipartFile multipartFile) throws EngineException {
        try {
            byte[] bytes = multipartFile.getBytes();
            return this.importClass(bytes);
        }
        catch (IOException e) {
            throw new EngineException("MultipartFile fail to get bytes");
        }
    }

    @Override
    public String compilePretreatmentClass(String engineName, String serviceId, File file, String description) throws EngineException {
        byte[] bytes = new byte[1024];
        StringBuilder sb = new StringBuilder();
        try (FileInputStream in = new FileInputStream(file);){
            int len;
            while ((len = in.read(bytes)) != -1) {
                sb.append(new String(bytes, 0, len));
            }
        }
        catch (IOException e) {
            throw new EngineException("Error:can't read class file ! " + file.getPath());
        }
        String javaCode = sb.toString();
        return this.compilePretreatmentClass(engineName, serviceId, javaCode, description);
    }

    @Override
    public String compilePretreatmentClass(String engineName, String serviceId, byte[] content, String description) throws EngineException {
        String javaCode = new String(content, Charset.forName("UTF-8"));
        return this.compilePretreatmentClass(engineName, serviceId, javaCode, description);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String compilePretreatmentClass(String engineName, String serviceId, String javaCode, String description) throws EngineException {
        Method[] methods;
        int packageIndex = javaCode.indexOf("package");
        int pathIndex = javaCode.indexOf(";", packageIndex);
        int classIndex = javaCode.indexOf("class");
        int nameIndex = javaCode.indexOf("{", classIndex);
        String name = javaCode.substring(classIndex + 6, nameIndex).trim().split(" ")[0];
        String fullName = javaCode.substring(packageIndex + 7, pathIndex).trim() + "." + name;
        Map<String, Object> map = ClassLoaderUtil.compileJavaCode(fullName, javaCode);
        String result = map.get("result").toString();
        String invokeId = "";
        if (!"1".equals(result)) throw new EngineException(map.get("data").toString());
        String classId = this.selectOrSaveClassInfo(fullName, name, description);
        VersionResource versionResource = new VersionResource();
        versionResource.setType("compile");
        versionResource.setContent(javaCode);
        versionResource.setDescription(description);
        versionResource.setName(classId);
        versionResource.setMajor(Integer.valueOf(1));
        versionResource.setMinor(Integer.valueOf(1));
        versionResource.setLabel("");
        Coordinates coordinates = this.resourceVersionManageService.save(versionResource, VersionStrategy.PATCH);
        int version = coordinates.getPatch();
        ClassVersion classVersion = new ClassVersion();
        String versionId = UUID.randomUUID().toString().replace("-", "");
        classVersion.setClassId(classId);
        classVersion.setVersionId(versionId);
        classVersion.setClassVersion(version);
        classVersion.setClassPath(fullName);
        classVersion.setClassType("1");
        classVersion.setCreateTime(new Date());
        classVersion.setCreatorId(this.getUserId());
        classVersion.setTenantId(this.getTenantId());
        classVersion.setInUse("1");
        this.classVersionService.save(classVersion);
        ClassLoaderUtil.saveLoader(fullName, version, (DefaultClassLoader)map.get("data"));
        Class clazz = (Class)map.get("class");
        ArrayList<PretreatmentMethod> methodList = new ArrayList<PretreatmentMethod>();
        if (clazz == null) return invokeId;
        invokeId = UUID.randomUUID().toString().replace("-", "");
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (method.getAnnotation(Before.class) == null && method.getAnnotation(After.class) == null) continue;
            PretreatmentMethod pretreatmentMethod = new PretreatmentMethod();
            String methodId = UUID.randomUUID().toString().replace("-", "");
            pretreatmentMethod.setVersionId(versionId);
            pretreatmentMethod.setMethodId(methodId);
            pretreatmentMethod.setMethodName(method.getName());
            pretreatmentMethod.setTenantId(this.getTenantId());
            pretreatmentMethod.setCreateTime(new Date());
            pretreatmentMethod.setCreatorId(this.getUserId());
            pretreatmentMethod.setEngineName(engineName);
            pretreatmentMethod.setEngineServiceId(serviceId);
            pretreatmentMethod.setInvokeId(invokeId);
            if (method.getAnnotation(Before.class) != null) {
                pretreatmentMethod.setMethodType("before");
            } else {
                pretreatmentMethod.setMethodType("after");
            }
            methodList.add(pretreatmentMethod);
        }
        if (methodList.size() <= 0) throw new EngineException("Not found annotation before or after");
        this.pretreatmentMethodService.saveBatch(methodList);
        return invokeId;
    }

    private String getTenantId() {
        return LrTenantUtil.getTenantId();
    }

    private String getUserId() {
        return LrTenantUtil.getUserId();
    }

    private String selectOrSaveClassInfo(String classPath, String name, String description) {
        String tenantId = this.getTenantId();
        String classId = this.classInfoMapper.getClassIdByPath(classPath, tenantId);
        if (classId == null || "".equals(classId)) {
            ClassInfo classInfo = new ClassInfo();
            classId = UUID.randomUUID().toString().replace("-", "");
            classInfo.setClassId(classId);
            classInfo.setClassDescription(description);
            classInfo.setClassName(name);
            classInfo.setClassPath(classPath);
            classInfo.setCreateTime(new Date());
            classInfo.setTenantId(tenantId);
            classInfo.setCreatorId(this.getUserId());
            classInfo.setInUse("1");
            this.save(classInfo);
        } else if (description != null && !"".equals(description)) {
            this.classInfoService.updateClassDescription(classId, description);
        }
        return classId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void byteToFile(byte[] contents, String fileName, HttpServletResponse response) {
        String newFileName = fileName;
        String filePath = "D:\\lr" + File.separator + newFileName;
        File file = new File(filePath);
        File path = file.getParentFile();
        if (!path.exists()) {
            logger.info("Folder not exist\uff0ccreate folder.path={}", (Object)path);
            boolean isCreated = path.mkdirs();
            if (!isCreated) {
                logger.error("Create folder fail\uff0cpath={}", (Object)path);
            }
        }
        try (BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(contents));
             FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream output = new BufferedOutputStream(fos);){
            byte[] buffer = new byte[1024];
            int length = bis.read(buffer);
            while (length != -1) {
                output.write(buffer, 0, length);
                length = bis.read(buffer);
            }
            output.flush();
            newFileName = URLEncoder.encode(file.getName(), "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + newFileName);
            response.setContentType("multipart/form-data");
            try (BufferedInputStream bism = new BufferedInputStream(new FileInputStream(file), 10240);
                 BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                int len = 0;
                int i = bism.available();
                byte[] buff = new byte[i];
                while ((len = bism.read(buff)) > 0) {
                    bos.write(buff, 0, len);
                    bos.flush();
                }
            }
        }
        catch (Exception e) {
            logger.error("Export file stream error\uff0cfilePath={}", (Object)filePath, (Object)e);
        }
        finally {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException ex) {
                logger.error("File handle fail\uff0cfilePath={}", (Object)filePath, (Object)ex);
            }
        }
    }
}

