/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.compile.util.classloader.jarloader;

import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicURLClassLoader
extends URLClassLoader {
    private JarURLConnection cachedJarFile = null;
    private static final Logger logger = LoggerFactory.getLogger(DynamicURLClassLoader.class);

    public DynamicURLClassLoader() {
        super(new URL[0], DynamicURLClassLoader.findParentClassLoader());
    }

    public void addURLFile(URL file) {
        try {
            URLConnection uc = file.openConnection();
            if (uc instanceof JarURLConnection) {
                uc.setUseCaches(true);
                ((JarURLConnection)uc).getManifest();
                this.cachedJarFile = (JarURLConnection)uc;
            }
        }
        catch (Exception e) {
            logger.info("Failed to cache plugin JAR file: " + file.toExternalForm());
        }
        this.addURL(file);
    }

    public void unloadJarFile(String url) {
        JarURLConnection jarURLConnection = this.cachedJarFile;
        if (jarURLConnection == null) {
            return;
        }
        try {
            jarURLConnection.getJarFile().close();
            logger.info("\u6210\u529f\u5378\u8f7dJAR\u5305\u6587\u4ef6\uff1a" + jarURLConnection.getJarFile().getName());
            jarURLConnection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ClassLoader findParentClassLoader() {
        ClassLoader parent = DynamicURLClassLoader.class.getClassLoader();
        if (parent == null) {
            parent = DynamicURLClassLoader.class.getClassLoader();
        }
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return parent;
    }
}

