/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.compile.util.classloader;

import com.jxdinfo.engine.compile.util.classloader.ClassLoaderUtil;
import com.jxdinfo.engine.compile.util.classloader.DefaultJavaClassObject;
import com.jxdinfo.engine.metadata.exception.EngineException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;

public class DefaultClassLoader
extends ClassLoader
implements Serializable {
    private static final long serialVersionUID = 1L;

    DefaultClassLoader(ClassLoader parent) {
        super(parent);
    }

    Class<?> loadClass(String fullName, DefaultJavaClassObject jco) throws EngineException {
        try {
            byte[] classData = jco.getBytes();
            return this.defineClass(fullName, classData, 0, classData.length);
        }
        catch (Exception e) {
            throw new EngineException(String.valueOf(fullName) + " can not loadClass");
        }
    }

    Class<?> loadClassByName(String fullName) throws EngineException {
        byte[] classData = this.getBytes(fullName);
        if (classData == null) {
            return null;
        }
        return this.defineClass(fullName, classData, 0, classData.length);
    }

    private byte[] getBytes(String classPath) throws EngineException {
        if ((classPath = ClassLoaderUtil.getClassFilePath(classPath)).contains(".jar")) {
            return null;
        }
        File file = new File(classPath);
        if (!file.exists()) {
            return null;
        }
        return this.getBytes(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getBytes(File file) throws EngineException {
        long len = file.length();
        byte[] raw = new byte[(int)len];
        try (FileInputStream fin = new FileInputStream(file);){
            int r = fin.read(raw);
            if ((long)r != len) {
                throw new EngineException("Error:can't read class file ! " + file.getPath());
            }
            byte[] byArray = raw;
            return byArray;
        }
        catch (IOException e) {
            throw new EngineException("Error:can't read class file ! " + file.getPath());
        }
    }
}

