/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.compile.util.classloader;

import com.jxdinfo.engine.common.service.LrCacheService;
import com.jxdinfo.engine.common.service.impl.LrEhCacheServiceImpl;
import com.jxdinfo.engine.common.service.impl.LrRedisCacheServiceImpl;
import com.jxdinfo.engine.common.util.LrTenantUtil;
import com.jxdinfo.engine.compile.util.classloader.DefaultClassFileManager;
import com.jxdinfo.engine.compile.util.classloader.DefaultClassLoader;
import com.jxdinfo.engine.compile.util.classloader.DefaultJavaClassObject;
import com.jxdinfo.engine.compile.util.classloader.DefaultJavaFileObject;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class ClassLoaderUtil {
    private static ClassLoader parentClassLoader;
    private static JavaCompiler javaCompiler;
    private static String classpath;
    private static String compilePath;
    private static boolean isWindowsFlag;
    private static final Logger logger;
    private static LrCacheService cacheService;

    public static String getClasspath() {
        return classpath;
    }

    public static String getClassFilePath(String classPath) throws EngineException {
        if (compilePath.contains(".jar")) {
            return ClassLoaderUtil.getClassdoptions() + classPath.replace(".", "/") + ".class";
        }
        return ClassLoaderUtil.getCompilePath() + classPath.replace(".", "/") + ".class";
    }

    public static String getCompilePath() throws EngineException {
        if (StringUtils.isBlank((CharSequence)compilePath)) {
            compilePath = ClassUtils.getDefaultClassLoader().getResource("").getPath();
        }
        return compilePath;
    }

    public static void setCompilePath(String compilePath) {
        ClassLoaderUtil.compilePath = compilePath;
    }

    private static void buildClassPath() throws EngineException {
        classpath = null;
        StringBuilder sb = new StringBuilder();
        int i = ClassLoaderUtil.getJvmLoadJarPath(sb);
        if (i < 10) {
            String libPath = compilePath.replace("/classes/", "/lib/");
            sb.append(compilePath).append(File.pathSeparator);
            sb.append((CharSequence)ClassLoaderUtil.listJarFile(libPath));
        }
        classpath = sb.toString();
    }

    public static int getJvmLoadJarPath(StringBuilder sb) {
        int i;
        block9: {
            block8: {
                i = 0;
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                if (!(classLoader instanceof URLClassLoader)) break block8;
                URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
                for (URL url : urlClassLoader.getURLs()) {
                    ++i;
                    sb.append(url.getFile()).append(File.pathSeparator);
                }
                if (i >= 10) break block9;
                urlClassLoader = (URLClassLoader)ClassLoaderUtil.class.getClassLoader();
                for (URL url : urlClassLoader.getURLs()) {
                    ++i;
                    sb.append(url.getFile()).append(File.pathSeparator);
                }
                break block9;
            }
            ClassLoader classLoader9 = ClassLoaderUtil.class.getClassLoader();
            Enumeration<URL> paths = null;
            try {
                paths = classLoader9.getResources("META-INF");
                while (paths.hasMoreElements()) {
                    String path = paths.nextElement().toString();
                    if (path.contains("jdk")) continue;
                    if (path.contains("file:/")) {
                        path = isWindowsFlag ? StringUtils.substringAfter((String)path, (String)"file:/") : StringUtils.substringAfter((String)path, (String)"file:");
                    }
                    if (path.contains("!/META-INF")) {
                        path = StringUtils.substringBefore((String)path, (String)"!/META-INF");
                    }
                    if (path.contains("META-INF")) {
                        path = StringUtils.substringBeforeLast((String)path, (String)"/");
                    }
                    sb.append(path).append(File.pathSeparator);
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return i;
    }

    public static StringBuilder listJarFile(String path) {
        StringBuilder sb = new StringBuilder();
        File file = new File(path);
        if (!file.exists()) {
            return sb;
        }
        if (file.isDirectory()) {
            File[] dirFile;
            File[] arrayOfFile1 = dirFile = file.listFiles();
            int i = dirFile.length;
            for (int b = 0; b < i; b = (int)((byte)(b + 1))) {
                File f = arrayOfFile1[b];
                if (f.isDirectory() || !f.getName().endsWith(".jar")) continue;
                sb.append(f.getAbsolutePath()).append(File.pathSeparator);
            }
        }
        return sb;
    }

    public static DefaultClassFileManager getFileManager(DiagnosticCollector<JavaFileObject> diagnostics, boolean creatClass) {
        StandardJavaFileManager fm = javaCompiler.getStandardFileManager(diagnostics, null, null);
        return new DefaultClassFileManager(fm, creatClass);
    }

    public static Map<String, Object> compileJavaCode(String fullClassName, String javaCode) throws EngineException {
        return ClassLoaderUtil.compileJavaCode(fullClassName, javaCode, false);
    }

    public static Map<String, Object> compileJavaCode(String fullClassName, String javaCode, boolean creatClass) throws EngineException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultClassLoader defaultClassLoader = new DefaultClassLoader(parentClassLoader);
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        DefaultClassFileManager fileManager = ClassLoaderUtil.getFileManager(diagnostics, creatClass);
        ArrayList<DefaultJavaFileObject> jfiles = new ArrayList<DefaultJavaFileObject>();
        jfiles.add(new DefaultJavaFileObject(fullClassName, javaCode));
        ArrayList<String> options = new ArrayList<String>();
        options.add("-encoding");
        options.add("UTF-8");
        options.add("-d");
        options.add(ClassLoaderUtil.getClassdoptions());
        options.add("-classpath");
        options.add(classpath);
        JavaCompiler.CompilationTask task = javaCompiler.getTask(null, fileManager, diagnostics, options, null, jfiles);
        boolean success = task.call();
        if (success) {
            Class<?> clazz;
            if (!creatClass) {
                DefaultJavaClassObject jco = fileManager.getJavaClassObject();
                clazz = defaultClassLoader.loadClass(fullClassName, jco);
            } else {
                clazz = defaultClassLoader.loadClassByName(fullClassName);
            }
            map.put("result", "1");
            map.put("data", defaultClassLoader);
            map.put("class", clazz);
            return map;
        }
        String error = "";
        for (Diagnostic<JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
            error = String.valueOf(error) + ClassLoaderUtil.compilePrint(diagnostic);
        }
        map.put("result", "0");
        map.put("data", error);
        return map;
    }

    public static String getClassdoptions() {
        String classdOptions = compilePath;
        if (classdOptions.contains(".jar")) {
            classdOptions = ClassLoaderUtil.getExtCompilePath();
        }
        if (isWindowsFlag && classdOptions.startsWith("/")) {
            classdOptions = StringUtils.substringAfter((String)classdOptions, (String)"/");
        }
        return classdOptions;
    }

    public static String getExtCompilePath() {
        String path = System.getProperty("user.dir") + "/classes/";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path;
    }

    public static String encode(String str) throws EngineException {
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EngineException(String.valueOf(str) + " can not encode to utf-8");
        }
    }

    private static String compilePrint(Diagnostic<? extends JavaFileObject> diagnostic) {
        System.out.println("Code:" + diagnostic.getCode());
        System.out.println("Kind:" + (Object)((Object)diagnostic.getKind()));
        System.out.println("Position:" + diagnostic.getPosition());
        System.out.println("Start Position:" + diagnostic.getStartPosition());
        System.out.println("End Position:" + diagnostic.getEndPosition());
        System.out.println("Source:" + diagnostic.getSource());
        System.out.println("Message:" + diagnostic.getMessage(null));
        System.out.println("LineNumber:" + diagnostic.getLineNumber());
        System.out.println("ColumnNumber:" + diagnostic.getColumnNumber());
        return diagnostic.getCode() + "]<br>" + (Object)((Object)diagnostic.getKind()) + "]<br/>" + diagnostic.getMessage(null) + "]<br>" + diagnostic.getLineNumber() + "]<br/>" + diagnostic.getColumnNumber() + "]<br/>";
    }

    public static Object getObjByClassName(String className, int version) {
        String mapKey = className + "_" + ClassLoaderUtil.getTenantId();
        String key = className + String.valueOf(version);
        LinkedHashMap linkedHashMap = (LinkedHashMap)cacheService.get("lr-compile-class", mapKey);
        if (linkedHashMap == null) {
            return null;
        }
        DefaultClassLoader classLoader = (DefaultClassLoader)linkedHashMap.get(key);
        try {
            if (classLoader != null) {
                Class<?> clazz = Class.forName(className, true, classLoader);
                return clazz.newInstance();
            }
            logger.info(className + " is not exist");
            return null;
        }
        catch (ClassNotFoundException e) {
            logger.info(className + " is not exist");
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.info("Get object exception");
            return null;
        }
    }

    public static Class loadClass(String className, int version) {
        String mapKey = className + "_" + ClassLoaderUtil.getTenantId();
        String key = className + String.valueOf(version);
        LinkedHashMap linkedHashMap = (LinkedHashMap)cacheService.get("lr-compile-class", mapKey);
        if (linkedHashMap == null) {
            return null;
        }
        DefaultClassLoader classLoader = (DefaultClassLoader)linkedHashMap.get(key);
        try {
            Class<?> clazz = null;
            if (classLoader != null) {
                clazz = Class.forName(className, true, classLoader);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            logger.info(className + " is not exist");
            return null;
        }
    }

    public static void unLoadClass(String className, int version) {
        String mapKey = className + "_" + ClassLoaderUtil.getTenantId();
        String key = className + String.valueOf(version);
        LinkedHashMap linkedHashMap = (LinkedHashMap)cacheService.get("lr-compile-class", mapKey);
        if (linkedHashMap == null) {
            return;
        }
        DefaultClassLoader classLoader = (DefaultClassLoader)linkedHashMap.get(key);
        if (classLoader == null) {
            return;
        }
        classLoader = null;
        linkedHashMap.remove(key);
    }

    public static void saveLoader(String className, int version, DefaultClassLoader defaultClassLoader) {
        String mapKey = className + "_" + ClassLoaderUtil.getTenantId();
        LinkedHashMap<String, DefaultClassLoader> linkedHashMap = (LinkedHashMap<String, DefaultClassLoader>)cacheService.get("lr-compile-class", mapKey);
        String key = className + String.valueOf(version);
        if (linkedHashMap == null) {
            linkedHashMap = new LinkedHashMap<String, DefaultClassLoader>();
            linkedHashMap.put(key, defaultClassLoader);
            cacheService.put("lr-compile-class", mapKey, linkedHashMap);
        } else {
            if (linkedHashMap.size() >= 5) {
                Map.Entry entry = linkedHashMap.entrySet().iterator().next();
                linkedHashMap.remove(entry.getKey());
            }
            linkedHashMap.put(key, defaultClassLoader);
        }
    }

    private static String getTenantId() {
        return LrTenantUtil.getTenantId();
    }

    static {
        classpath = null;
        compilePath = "";
        isWindowsFlag = false;
        logger = LoggerFactory.getLogger(ClassLoaderUtil.class);
        javaCompiler = ToolProvider.getSystemJavaCompiler();
        parentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            cacheService = (LrCacheService)SpringContextHolder.getBean(LrRedisCacheServiceImpl.class);
        }
        catch (Exception e) {
            cacheService = (LrCacheService)SpringContextHolder.getBean(LrEhCacheServiceImpl.class);
        }
        try {
            String os = System.getProperty("os.name");
            if (os.toLowerCase().startsWith("win")) {
                isWindowsFlag = true;
            }
            ClassLoaderUtil.getCompilePath();
            ClassLoaderUtil.buildClassPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

