/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.engine.compile.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.jxdinfo.engine.common.util.LrTenantUtil;
import com.jxdinfo.engine.compile.dao.ClassVersionMapper;
import com.jxdinfo.engine.compile.model.ClassInvoke;
import com.jxdinfo.engine.compile.util.classloader.ClassLoaderUtil;
import com.jxdinfo.engine.compile.util.classloader.DefaultClassLoader;
import com.jxdinfo.engine.metadata.exception.EngineException;
import com.jxdinfo.engine.metadata.model.InvokeResponse;
import com.jxdinfo.engine.metadata.service.MetadataInvokeService;
import com.jxdinfo.engine.rvm.model.Coordinates;
import com.jxdinfo.engine.rvm.model.VersionResource;
import com.jxdinfo.engine.rvm.service.ResourceVersionManageService;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="engine.compile.ClassInvokeServiceImpl")
@DS(value="master")
public class ClassInvokeServiceImpl
implements MetadataInvokeService {
    private static Logger logger = LoggerFactory.getLogger(ClassInvokeServiceImpl.class);
    private final ClassVersionMapper classVersionMapper;
    private final ResourceVersionManageService resourceVersionManageService;

    @Autowired
    public ClassInvokeServiceImpl(ClassVersionMapper classVersionMapper, ResourceVersionManageService resourceVersionManageService) {
        this.classVersionMapper = classVersionMapper;
        this.resourceVersionManageService = resourceVersionManageService;
    }

    public InvokeResponse invokeMethod(Map<String, Object> params, String serviceId) throws EngineException {
        Class<?> clazz;
        InvokeResponse invokeResponse = new InvokeResponse();
        if (serviceId == null) {
            logger.info("serviceId is null");
            invokeResponse.setSuccess(false);
            invokeResponse.setData((Object)"serviceId is null");
            return invokeResponse;
        }
        ClassInvoke classInvoke = this.classVersionMapper.getClassInvoke(serviceId, this.getTenantId());
        if (classInvoke == null) {
            logger.info("Method not exist");
            invokeResponse.setSuccess(false);
            invokeResponse.setData((Object)"Method not exist");
            return invokeResponse;
        }
        String methodName = classInvoke.getMethodName();
        if (methodName == null) {
            methodName = "run";
        }
        if ((clazz = ClassLoaderUtil.loadClass(classInvoke.getClassPath(), classInvoke.getClassVersion())) == null) {
            clazz = this.reLoadClass(classInvoke);
        }
        try {
            if (clazz != null) {
                Object o = clazz.newInstance();
                Method method = clazz.getDeclaredMethod(methodName, Map.class);
                Object result = method.invoke(o, params);
                if (result instanceof InvokeResponse) {
                    return (InvokeResponse)result;
                }
                invokeResponse.setSuccess(true);
                invokeResponse.setData(result);
                return invokeResponse;
            }
            logger.info("{} not exist,version {}", (Object)classInvoke.getClassPath(), (Object)classInvoke.getClassVersion());
            invokeResponse.setSuccess(false);
            invokeResponse.setData((Object)(classInvoke.getClassPath() + " not exist,version " + classInvoke.getClassVersion()));
            return invokeResponse;
        }
        catch (Exception e) {
            throw new EngineException(e.getMessage());
        }
    }

    private Class<?> reLoadClass(ClassInvoke classInvoke) throws EngineException {
        Coordinates coordinates = new Coordinates();
        coordinates.setType("compile");
        coordinates.setName(classInvoke.getClassId());
        coordinates.setLabel("");
        coordinates.setMajor(Integer.valueOf(1));
        coordinates.setMinor(Integer.valueOf(1));
        coordinates.setPatch(Integer.valueOf(classInvoke.getClassVersion()));
        VersionResource versionResource = this.resourceVersionManageService.get(coordinates);
        if (versionResource == null) {
            logger.info("VersionResource is null,Coordinates:{}", (Object)coordinates);
            return null;
        }
        String javaCode = versionResource.getContent();
        try {
            Map<String, Object> map = ClassLoaderUtil.compileJavaCode(classInvoke.getClassPath(), javaCode);
            String result = map.get("result").toString();
            if ("1".equals(result)) {
                DefaultClassLoader classLoader = (DefaultClassLoader)map.get("data");
                ClassLoaderUtil.saveLoader(classInvoke.getClassPath(), classInvoke.getClassVersion(), classLoader);
                return (Class)map.get("class");
            }
            throw new EngineException(map.get("data").toString());
        }
        catch (Exception e) {
            throw new EngineException(e.getMessage());
        }
    }

    private String getTenantId() {
        return LrTenantUtil.getTenantId();
    }
}

