/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.timer.job;

import com.jxdinfo.doc.common.util.SpringContextUtil;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.manager.historymanager.service.RelationHistoryService;
import com.jxdinfo.hussar.quartz.job.BaseJob;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.context.ApplicationContext;

public class ScanUserLog
implements BaseJob {
    private static ApplicationContext appCtx = SpringContextUtil.getApplicationContext();
    private RelationHistoryService relationHistoryService = (RelationHistoryService)appCtx.getBean(RelationHistoryService.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.scan();
        System.out.println("===========\u5b9a\u65f6\u5668\u6267\u884c===========\u626b\u63cf\u7528\u6237\u64cd\u4f5c\u8bb0\u5f55");
    }

    public void scan() {
        int relationCount = this.relationHistoryService.selectRelationCount();
        String isEmpty = null;
        if (relationCount != 0) {
            isEmpty = "not";
        }
        List<Map> users = this.relationHistoryService.getUsers();
        for (Map user : users) {
            String userId = user.get("userId").toString();
            List<Map> list = this.relationHistoryService.getUserResourceLog(userId, isEmpty);
            for (int i = 0; i < list.size() - 1; ++i) {
                String currentId = list.get(i).get("docId").toString();
                String childId = list.get(i + 1).get("docId").toString();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("currentId", currentId);
                map.put("childId", childId);
                int count = this.relationHistoryService.selectCount(map);
                if (count == 0) {
                    if (currentId.equals(childId)) continue;
                    map.put("id", StringUtil.getUUID());
                    map.put("times", 1);
                    this.relationHistoryService.insertIntoDocRelation(map);
                    continue;
                }
                this.relationHistoryService.updateDocRelation(map);
            }
        }
    }
}

