/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.timer.job;

import com.jxdinfo.doc.common.docutil.service.FastdfsService;
import com.jxdinfo.doc.common.docutil.service.impl.PdfServiceImpl;
import com.jxdinfo.doc.common.util.DocbaseProperties;
import com.jxdinfo.doc.common.util.ExceptionUtils;
import com.jxdinfo.doc.common.util.FastDFSProperties;
import com.jxdinfo.doc.common.util.FileTool;
import com.jxdinfo.doc.common.util.SpringContextUtil;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.common.util.ThumbnailsUtil;
import com.jxdinfo.doc.front.docmanager.dao.FrontDocInfoMapper;
import com.jxdinfo.hussar.encrypt.file.FileEncryptUtil;
import com.jxdinfo.hussar.quartz.job.BaseJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CreateThumbnails
implements BaseJob {
    private static ApplicationContext appCtx = SpringContextUtil.getApplicationContext();
    private FastDFSProperties fastDFSProperties = (FastDFSProperties)appCtx.getBean(FastDFSProperties.class);
    private DocbaseProperties docbaseProperties = (DocbaseProperties)appCtx.getBean(DocbaseProperties.class);
    private FrontDocInfoMapper frontDocInfoMapper = (FrontDocInfoMapper)appCtx.getBean(FrontDocInfoMapper.class);
    private FastdfsService fastdfsService = (FastdfsService)appCtx.getBean(FastdfsService.class);
    public static final Logger LOGGER = LoggerFactory.getLogger(PdfServiceImpl.class);
    private FileTool fileTool = (FileTool)appCtx.getBean(FileTool.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.createThumbnails();
    }

    private void createThumbnails() {
        String tempdir = this.docbaseProperties.getTempdir();
        List<Map> list = this.frontDocInfoMapper.createThumbList();
        for (int i = 0; i < list.size(); ++i) {
            Map docInfo = list.get(i);
            if (null == docInfo) continue;
            String fileId = "";
            if (null != docInfo.get("fileId")) {
                fileId = docInfo.get("fileId").toString();
            }
            String filePath = "";
            if (null != docInfo.get("filePath")) {
                filePath = docInfo.get("filePath").toString();
            }
            String sourceKey = "";
            if (null != docInfo.get("sourceKey")) {
                sourceKey = docInfo.get("sourceKey").toString();
            }
            String suffix = "";
            if (null != docInfo.get("suffix")) {
                suffix = docInfo.get("suffix").toString();
            }
            FileOutputStream fos = null;
            byte[] bytes = null;
            FileInputStream input = null;
            try {
                String size;
                Map newThumbInfo;
                if (!this.fastDFSProperties.isUsing()) {
                    input = new FileInputStream(filePath);
                    bytes = new byte[input.available()];
                    input.read(bytes);
                } else {
                    bytes = this.fastdfsService.download(filePath);
                }
                if (list == null || list.size() <= 0) continue;
                if (sourceKey == null) {
                    // empty if block
                }
                String random = UUID.randomUUID().toString().replaceAll("-", "");
                String localPath = tempdir + "\\" + random + suffix;
                String newThumbPath = tempdir + "\\" + random + "_thumb" + suffix;
                File file = new File(localPath);
                File newSource = new File(newThumbPath);
                fos = new FileOutputStream(file);
                fos.write(bytes, 0, bytes.length);
                fos.close();
                boolean isDecrypt = FileEncryptUtil.getInstance().decrypt(localPath, sourceKey);
                if (!isDecrypt) continue;
                HashMap<String, Object> fsFile = new HashMap<String, Object>();
                boolean isCreateThumb = ThumbnailsUtil.createThumbnails((String)localPath, (String)newThumbPath, (double)1080.0, (double)857.0);
                String sourcePath = null;
                if (isCreateThumb) {
                    String newSourceKey;
                    newThumbInfo = ThumbnailsUtil.getHeightAndWidth((String)newThumbPath);
                    fsFile.putAll(newThumbInfo);
                    size = ThumbnailsUtil.pathSize((String)newThumbPath);
                    fsFile.put("sourceSize", size);
                    if (this.fastDFSProperties.isUsing()) {
                        newSourceKey = FileEncryptUtil.getInstance().encrypt(newThumbPath);
                        fsFile.put("sourceKey", newSourceKey);
                        sourcePath = this.fastdfsService.uploadFile(newSource);
                        fsFile.put("sourcePath", sourcePath);
                    } else {
                        newSourceKey = FileEncryptUtil.getInstance().encrypt(newThumbPath);
                        fsFile.put("sourceKey", newSourceKey);
                        fsFile.put("sourcePath", newThumbPath);
                    }
                } else {
                    newThumbInfo = ThumbnailsUtil.getHeightAndWidth((String)localPath);
                    fsFile.putAll(newThumbInfo);
                    size = ThumbnailsUtil.pathSize((String)localPath);
                    fsFile.put("sourceSize", size);
                    fsFile.put("sourceKey", sourceKey);
                    fsFile.put("sourcePath", filePath);
                }
                fsFile.put("sourceLevel", 2);
                fsFile.put("sourceId", StringUtil.getUUID());
                fsFile.put("fileId", fileId);
                this.frontDocInfoMapper.setNewThumbInfo(fsFile);
                if (null != input) {
                    input.close();
                }
                file.delete();
                newSource.delete();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("\u751f\u6210\u7f29\u7565\u56fe\u5f02\u5e38\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
            }
        }
    }
}

