/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.newupload.thread;

import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.docutil.service.ESService;
import com.jxdinfo.doc.common.util.ExamineProperties;
import com.jxdinfo.doc.common.util.ExceptionUtils;
import com.jxdinfo.doc.common.util.FileTool;
import com.jxdinfo.doc.common.util.SpringContextUtil;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.common.util.TikaUtil;
import com.jxdinfo.doc.manager.docmanager.dao.FilesMapper;
import com.jxdinfo.doc.manager.docmanager.model.FsFile;
import com.jxdinfo.doc.newupload.service.UploadService;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CreateEsThread
extends Thread {
    private String docId = "";
    private static ApplicationContext appCtx = SpringContextUtil.getApplicationContext();
    public static final Logger LOGGER = LoggerFactory.getLogger(CreateEsThread.class);
    private ESService esService = (ESService)appCtx.getBean(ESService.class);
    private CacheToolService cacheToolService = (CacheToolService)appCtx.getBean(CacheToolService.class);
    private UploadService uploadService = (UploadService)appCtx.getBean(UploadService.class);
    private FilesMapper filesMapper = (FilesMapper)appCtx.getBean(FilesMapper.class);
    private ExamineProperties examineProperties = (ExamineProperties)appCtx.getBean(ExamineProperties.class);
    private FileTool fileTool = (FileTool)appCtx.getBean(FileTool.class);

    public CreateEsThread(String id) {
        this.docId = id;
    }

    @Override
    public void run() {
        block12: {
            try {
                FsFile fsFileTemp = (FsFile)((Object)this.filesMapper.selectById((Serializable)((Object)this.docId)));
                List<Map<String, String>> uploadList = this.uploadService.selectUpload(this.docId);
                String sourcePath = uploadList.get(0).get("sourcePath");
                String title = fsFileTemp.getFileName();
                LOGGER.info("******************\u6587\u4ef6:" + title + "\u8fdb\u5165CreateEsThread\u7ebf\u7a0b\uff0c\u5f00\u59cb\u8f6c\u5316PDF******************");
                File sourceFile = new File(sourcePath);
                if (!sourceFile.exists()) break block12;
                String content = null;
                String contentType = "";
                HashMap<String, String> pdfInfo = new HashMap<String, String>();
                try {
                    if (sourcePath.endsWith(".ceb") || sourcePath.endsWith(".txt")) {
                        content = uploadList.get(0).get("content") == null ? "" : uploadList.get(0).get("content");
                        contentType = uploadList.get(0).get("contentType");
                    } else if (sourcePath.endsWith(".rar")) {
                        content = "";
                        contentType = "";
                    } else {
                        Map metadata = TikaUtil.autoParse((String)sourcePath);
                        content = metadata.get("content").toString().replaceAll("<", "<&nbsp;");
                        contentType = metadata.get("contentType").toString();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error("\u66f4\u65b0EsIO\u5f02\u5e38\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("\u66f4\u65b0Es\u51fa\u9519" + ExceptionUtils.getErrorInfo((Exception)e));
                }
                pdfInfo.put("contentType", contentType);
                pdfInfo.put("content", content);
                if (this.cacheToolService.getFastDFSUsingFlag()) {
                    sourceFile.delete();
                }
                LOGGER.info("******************\u6587\u4ef6:" + title + "\u6b63\u5728\u751f\u6210ES\u7d22\u5f15******************");
                HashMap<String, Object> docVO = new HashMap<String, Object>();
                docVO.put("contentType", StringUtil.getString(pdfInfo.get("contentType")));
                docVO.put("upDate", new Date());
                docVO.put("content", StringUtil.getString(pdfInfo.get("content")));
                try {
                    this.esService.updateIndex(this.docId, docVO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("\u521b\u5efaES\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
                }
                LOGGER.info("******************\u6587\u4ef6:" + title + "\u521b\u5efaES\u7ed3\u675f******************");
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("\u521b\u5efaES\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
            }
        }
    }
}

