/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.newupload.service.impl;

import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.front.docmanager.dao.FrontDocInfoMapper;
import com.jxdinfo.doc.manager.docmanager.model.FsFile;
import com.jxdinfo.doc.newupload.dao.UploadMapper;
import com.jxdinfo.doc.newupload.service.UploadService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UploadServiceImpl
implements UploadService {
    @Resource
    private UploadMapper uploadMapper;
    @Resource
    private FrontDocInfoMapper frontDocInfoMapper;
    @Resource
    private CacheToolService cacheToolService;

    @Override
    public void newUploadState(Map map) {
        this.uploadMapper.newUploadState(map);
    }

    @Override
    public List<Map<String, String>> getUploadState() {
        return this.uploadMapper.getUploadState();
    }

    @Override
    public int updateUploadState(Map map) {
        return this.uploadMapper.updateUploadState(map);
    }

    @Override
    public void deleteUploadState(Map map) {
        if (null != map.get("docId")) {
            this.uploadMapper.deleteUploadState(map.get("docId").toString());
        }
    }

    @Override
    public void deleteUploadState(String docId) {
        this.uploadMapper.deleteUploadState(docId);
    }

    @Override
    public boolean checkUploadState(String docId) {
        List<Map<String, String>> changePdf = this.cacheToolService.getUploadStateList();
        return this.checkUploadStateFromFast(docId);
    }

    @Override
    public boolean checkUploadStateFromFast(String docId) {
        String pdfPath = null;
        pdfPath = this.frontDocInfoMapper.getPdfPathById(docId);
        if (pdfPath == null || pdfPath.equals("")) {
            String md5;
            FsFile fsfile = this.frontDocInfoMapper.selectDocId(docId);
            if (fsfile != null && (md5 = fsfile.getMd5()) != null && !"".equals(md5)) {
                List<String> path = this.frontDocInfoMapper.selectPdfPath(md5, docId);
                List<String> pdfKey = this.frontDocInfoMapper.selectKey(md5, docId);
                if (path != null && pdfKey != null && path.size() > 0 && pdfKey.size() > 0) {
                    this.frontDocInfoMapper.updatePdfPath(path.get(0), pdfKey.get(0), docId);
                }
            }
            return this.frontDocInfoMapper.getPdfPathById(docId) != null && !this.frontDocInfoMapper.getPdfPathById(docId).equals("");
        }
        return true;
    }

    @Override
    public List<Map<String, String>> selectUpload(String docId) {
        return this.uploadMapper.selectUpload(docId);
    }
}

