/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.topicmanager.service;

import com.jxdinfo.doc.manager.topicmanager.dao.SpecialTopicFilesMapper;
import com.jxdinfo.doc.manager.topicmanager.dao.SpecialTopicMapper;
import com.jxdinfo.doc.manager.topicmanager.model.SpecialTopic;
import com.jxdinfo.doc.manager.topicmanager.model.SpecialTopicFiles;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class SpecialTopicService {
    @Autowired
    private SpecialTopicMapper mapper;
    @Autowired
    private SpecialTopicFilesMapper specialTopicFilesMapper;
    @Autowired
    private SysUsersMapper sysUsersMapper;
    @Autowired
    private SysStruMapper sysStruMapper;

    public List searchTopicFilesDetail(String[] fileTypeArry, int page, String keyWords, String topicId, String fileType) {
        return this.specialTopicFilesMapper.searchTopicFilesDetail(fileTypeArry, page, keyWords, topicId, fileType);
    }

    public int countTopicFilesDetail(String[] fileTypeArry, int page, String keyWords, String topicId, String fileType) {
        return this.specialTopicFilesMapper.countTopicFilesDetail(fileTypeArry, page, keyWords, topicId, fileType);
    }

    public SpecialTopic searchTopicDetail(String id) {
        return this.mapper.searchTopicDetail(id);
    }

    public int countTopicFiles(String id) {
        return this.specialTopicFilesMapper.countTopicFiles(id);
    }

    public int countPreviewTopicFiles(String id) {
        return this.specialTopicFilesMapper.countPreviewTopicFiles(id);
    }

    public List getSpecialTopicFiles() {
        return this.specialTopicFilesMapper.getSpecialTopicFiles();
    }

    public List<SpecialTopic> topicList(String topicName, int startIndex, int pageSize) {
        return this.mapper.topicList(topicName, startIndex, pageSize);
    }

    public List<SpecialTopic> getValidTopicList(String userId, String isValid) {
        return this.mapper.getValidTopicList(userId, isValid);
    }

    public List<SpecialTopic> getSpecialTopicList(String userId) {
        return this.mapper.getSpecialTopicList(userId);
    }

    public int getTopicListCount(String topicName) {
        return this.mapper.getTopicListCount(topicName);
    }

    public int addTopic(SpecialTopic specialTopic, String docIds) {
        ArrayList<SpecialTopicFiles> filesList = new ArrayList<SpecialTopicFiles>();
        if (this.sysUsersMapper.selectById((Serializable)((Object)specialTopic.getAuthorId())) != null) {
            specialTopic.setAuthorId(((SysUsers)this.sysUsersMapper.selectById((Serializable)((Object)specialTopic.getAuthorId()))).getUserId());
        }
        if (!StringUtils.isEmpty((Object)docIds)) {
            List<String> docIdsList = Arrays.asList(docIds.split(","));
            int i = 0;
            for (String id : docIdsList) {
                SpecialTopicFiles specialTopicFiles = new SpecialTopicFiles();
                specialTopicFiles.setTopicFileId(UUID.randomUUID().toString());
                specialTopicFiles.setDocId(id);
                specialTopicFiles.setTopicId(specialTopic.getTopicId());
                specialTopicFiles.setShowOrder(i++);
                filesList.add(specialTopicFiles);
            }
            this.specialTopicFilesMapper.addSpecialTopicFiles(filesList);
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        specialTopic.setCreateTime(ts);
        return this.mapper.addSpecialTopic(specialTopic);
    }

    @Transactional(rollbackFor={Exception.class})
    public int editTopic(SpecialTopic specialTopic, String docIds) {
        if (this.sysUsersMapper.selectById((Serializable)((Object)specialTopic.getAuthorId())) != null) {
            specialTopic.setAuthorId(((SysUsers)this.sysUsersMapper.selectById((Serializable)((Object)specialTopic.getAuthorId()))).getUserId());
        }
        ArrayList<SpecialTopicFiles> filesList = new ArrayList<SpecialTopicFiles>();
        ArrayList<String> topicIdList = new ArrayList<String>();
        topicIdList.add(specialTopic.getTopicId());
        if (!StringUtils.isEmpty((Object)docIds)) {
            List<String> docIdsList = Arrays.asList(docIds.split(","));
            int i = 0;
            for (String id : docIdsList) {
                SpecialTopicFiles specialTopicFiles = new SpecialTopicFiles();
                specialTopicFiles.setTopicFileId(UUID.randomUUID().toString());
                specialTopicFiles.setDocId(id);
                specialTopicFiles.setTopicId(specialTopic.getTopicId());
                specialTopicFiles.setShowOrder(i++);
                filesList.add(specialTopicFiles);
            }
            this.specialTopicFilesMapper.delDoc(topicIdList);
            this.specialTopicFilesMapper.addSpecialTopicFiles(filesList);
        }
        return this.mapper.updateSpecialTopic(specialTopic);
    }

    public int checkTopicExist(SpecialTopic specialTopic) {
        return this.mapper.checkTopicExist(specialTopic);
    }

    public int delDocById(List<String> list, String topicId) {
        return this.specialTopicFilesMapper.delDocById(list, topicId);
    }

    public int delDocs(List<String> list) {
        this.specialTopicFilesMapper.delDoc(list);
        return this.mapper.delSpecialTopic(list);
    }

    public int publishTopics(List<String> list, Integer topicShow) {
        return this.mapper.publishTopic(list, topicShow);
    }

    public int delDoc(String id, String topicId) {
        return this.mapper.delDoc(id, topicId);
    }

    public int updateViewNum(String topicId, Integer num) {
        return this.mapper.updateViewNum(topicId, num);
    }

    public int getMaxOrder() {
        return this.mapper.getMaxOrder();
    }

    public int moveTopic(String table, String idColumn, String idOne, String idTwo) {
        return this.mapper.moveTopic(table, idColumn, idOne, idTwo);
    }
}

