/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.topicmanager.controller;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.doc.manager.topicmanager.model.SpecialTopic;
import com.jxdinfo.doc.manager.topicmanager.model.TopicFile;
import com.jxdinfo.doc.manager.topicmanager.service.ITopicDocManagerService;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/topicDoc"})
public class TopicDocManagerController {
    @Autowired
    private ITopicDocManagerService iTopicDocManagerService;
    @Autowired
    private DocInfoService docInfoService;
    @Autowired
    private ISysIdtableService sysIdtableService;

    @RequestMapping(value={"/topicDocAdd"})
    public String specialTopicQuery(HttpServletRequest request, Model model) {
        String chooseFile = request.getParameter("chooseFile") == null ? "" : request.getParameter("chooseFile");
        String chooseFileType = request.getParameter("chooseFileType") == null ? "" : request.getParameter("chooseFileType");
        model.addAttribute("fsFiles", (Object)chooseFile);
        model.addAttribute("chooseFileType", (Object)chooseFileType);
        return "/doc/manager/topicmanager/topic_doc.html";
    }

    @RequestMapping(value={"/searchTopic"})
    @ResponseBody
    public JSON searchTopic(HttpServletRequest request, HttpServletResponse response) {
        List list = this.iTopicDocManagerService.searchTopic();
        com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
        json.put("data", (Object)list);
        return json;
    }

    @RequestMapping(value={"/getDocByFsFile"})
    @ResponseBody
    public JSON getDocByFsFile(HttpServletRequest request, HttpServletResponse response) {
        String fsFiles = request.getParameter("fsFiles") == null ? "" : request.getParameter("fsFiles");
        String chooseFileType = request.getParameter("chooseFileType") == null ? "" : request.getParameter("chooseFileType");
        List<String> list = Arrays.asList(fsFiles.split(","));
        List docList = this.iTopicDocManagerService.getDocByFsFile(list);
        com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
        json.put("count", (Object)docList.size());
        json.put("data", (Object)docList);
        json.put("msg", (Object)"success");
        json.put("code", (Object)0);
        return json;
    }

    @RequestMapping(value={"/saveTopicDoc"})
    @ResponseBody
    public JSON saveTopicDoc(String topicId, String docData) {
        String docId;
        JSONObject obj;
        int i;
        com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
        JSONArray jsonArray = JSONArray.fromObject((Object)docData);
        ArrayList<TopicFile> list = new ArrayList<TopicFile>();
        for (i = 0; i < jsonArray.size(); ++i) {
            obj = (JSONObject)jsonArray.get(i);
            docId = obj.get("docId").toString();
            String docName = this.docInfoService.getDocDetail(docId).getTitle();
            int sameNum = this.iTopicDocManagerService.checkIsSameNameExist(docName, topicId);
            if (sameNum == 0) continue;
            json.put("result", (Object)2);
            return json;
        }
        for (i = 0; i < jsonArray.size(); ++i) {
            obj = (JSONObject)jsonArray.get(i);
            docId = obj.get("docId").toString();
            int num = this.iTopicDocManagerService.checkIsExist(docId, topicId);
            if (num != 0) continue;
            TopicFile topicFile = new TopicFile();
            topicFile.setTopicFileId(UUID.randomUUID().toString().replaceAll("-", ""));
            topicFile.setDocId(docId);
            topicFile.setSpecialTopicId(topicId);
            String currentCode = this.sysIdtableService.getCurrentCode("TOPIC_FILE_NUM", "doc_special_topic_files");
            int bigNum = Integer.parseInt(currentCode);
            topicFile.setShowOrder(bigNum);
            list.add(topicFile);
        }
        if (list != null && list.size() > 0) {
            this.iTopicDocManagerService.saveTopicDoc(topicId, list);
        }
        json.put("result", (Object)1);
        return json;
    }

    @RequestMapping(value={"/topicFrontView"})
    public String topicFrontView(HttpServletRequest request, Model model, int page, int size) {
        String topicId = request.getParameter("topicId") == null ? "" : request.getParameter("topicId");
        SpecialTopic specialTopic = this.iTopicDocManagerService.getTopicDetail(topicId);
        int startNum = page * size - size;
        return "/docbase/admin/generalmanage/topic_front_view.jsp";
    }

    @RequestMapping(value={"/topicFrontList"})
    public String topicFrontList(Model model) {
        List<SpecialTopic> list = this.iTopicDocManagerService.getTopicList();
        model.addAttribute("list", list);
        return "/docbase/admin/generalmanage/topic_front_list.jsp";
    }

    @RequestMapping(value={"/getDocListByIds"})
    @ResponseBody
    public JSON getDocListByIds(String topicId, int page, int limit) {
        int startNum = page * limit - limit;
        List docList = this.iTopicDocManagerService.getTopicDoclist(topicId, startNum, limit);
        com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
        json.put("count", (Object)docList.size());
        json.put("data", (Object)docList);
        json.put("msg", (Object)"success");
        json.put("code", (Object)0);
        return json;
    }
}

