/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.system.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.doc.common.constant.DocConstant;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.util.FileTool;
import com.jxdinfo.doc.common.util.MD5Util;
import com.jxdinfo.doc.common.util.MathUtil;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.front.foldermanager.service.FrontFolderService;
import com.jxdinfo.doc.front.topicmanager.service.FrontTopicService;
import com.jxdinfo.doc.manager.docconfigure.model.DocConfigure;
import com.jxdinfo.doc.manager.docconfigure.service.DocConfigureService;
import com.jxdinfo.doc.manager.docmanager.model.DocFileAuthority;
import com.jxdinfo.doc.manager.docmanager.model.DocInfo;
import com.jxdinfo.doc.manager.docmanager.model.DocResourceLog;
import com.jxdinfo.doc.manager.docmanager.model.FsFile;
import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.doc.manager.docmanager.service.FilesService;
import com.jxdinfo.doc.manager.docmanager.service.FsFileService;
import com.jxdinfo.doc.manager.topicmanager.model.SpecialTopic;
import com.jxdinfo.doc.manager.topicmanager.model.TopicFile;
import com.jxdinfo.doc.manager.topicmanager.service.ITopicDocManagerService;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/JqxUpload"})
public class JqxUploadController
extends BaseController {
    private static Logger logger = LogManager.getLogger(JqxUploadController.class);
    @Autowired
    private ISysIdtableService sysIdtableService;
    @Autowired
    private HussarCacheManager cacheManager;
    @Autowired
    private CacheToolService cacheToolService;
    @Resource
    private DocConfigureService docConfigureService;
    @Autowired
    private FsFileService fsFileService;
    @Autowired
    private FileTool fileTool;
    @Autowired
    private ITopicDocManagerService iTopicDocManagerService;
    @Autowired
    private DocInfoService idocInfoService;
    @Autowired
    protected FrontTopicService frontTopicService;
    @Autowired
    private FilesService filesService;
    @Value(value="${docbase.breakdir}")
    private String breakdir;
    @Value(value="${docbase.filedir}")
    private String tempdir;
    @Autowired
    private FrontFolderService frontFolderService;

    @RequestMapping(value={"/uploadFile"})
    @ResponseBody
    public String mergeOrCheckVersionChunks(@RequestParam(value="file") MultipartFile file) {
        String userName = super.getPara("userName");
        String userId = "";
        userId = userName == null || "admin".equals(userName) ? "superadmin" : userName;
        String topicId = super.getPara("topicId");
        String categoryId = super.getPara("categoryId");
        String fileName = super.getPara("fileName");
        ByteArrayOutputStream baos = null;
        try {
            baos = FileTool.cloneInputStream(file.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ByteArrayInputStream md5InputStream = new ByteArrayInputStream(baos.toByteArray());
        String md5 = MD5Util.getFileMD5((InputStream)md5InputStream);
        String json = "";
        int pointIndex = fileName.lastIndexOf(".");
        ArrayList<String> docNameList = new ArrayList<String>();
        docNameList.add(fileName);
        String suffix = fileName.substring(pointIndex).toLowerCase();
        if (fileName.length() > 64) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("code", DocConstant.UPLOADRESULT.NAMELONG.getValue());
            return JSON.toJSONString(resultMap);
        }
        String regex = "^[^'\"\\|\\\\]*$";
        if (!Pattern.compile(regex).matcher(fileName).find()) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("code", DocConstant.UPLOADRESULT.NAMEERROR.getValue());
            return JSON.toJSONString(resultMap);
        }
        List<DocConfigure> typeList = this.docConfigureService.getConfigure();
        if (typeList.get(0).getConfigValue().contains(suffix.toLowerCase())) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("code", DocConstant.UPLOADRESULT.ERRORTYPE.getValue());
            return JSON.toJSONString(resultMap);
        }
        List<String> nameList = this.idocInfoService.checkFileExist(docNameList, categoryId);
        if (nameList != null && nameList.size() != 0) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("name", nameList.get(0));
            resultMap.put("code", DocConstant.UPLOADRESULT.FILEEXIST.getValue());
            resultMap.put("docId", this.idocInfoService.selectExistId(docNameList, categoryId).get(0));
            return JSON.toJSONString(resultMap);
        }
        try {
            String random = UUID.randomUUID().toString().replace("-", "");
            File outputFile = new File(this.tempdir + File.separator + random + suffix);
            try {
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                outputFile.createNewFile();
            }
            catch (IOException e) {
                logger.error("IO Exception\uff1a", (Throwable)e);
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                json = JSONObject.toJSONString(resultMap);
                return json;
            }
            FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)outputFile);
            List<FsFile> listMd5 = this.fsFileService.getInfoByMd5(md5);
            if (listMd5 != null && listMd5.size() != 0) {
                FsFile fsFile = listMd5.get(0);
                this.cacheToolService.updateLevelCodeCache(userId);
                String docId = this.filesService.uploadFastJqx(categoryId, "0", "1", null, null, null, md5, fileName, fsFile, fsFile.getFileSize(), "1", userId, topicId);
                if (docId == null) {
                    HashMap<String, String> resultMap = new HashMap<String, String>();
                    resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                    json = JSONObject.toJSONString(resultMap);
                    return json;
                }
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("code", DocConstant.UPLOADRESULT.FASTUPLOAD.getValue());
                json = JSONObject.toJSONString(resultMap);
                return json;
            }
            try {
                String[] operateTypeStrGroup;
                String[] authorTypeStrGroup;
                String[] groupArr;
                DocFileAuthority docFileAuthority;
                String docId;
                String contentType = this.getContentType(suffix.toLowerCase());
                Timestamp ts = new Timestamp(System.currentTimeMillis());
                DocInfo docInfo = new DocInfo();
                String idStr = docId = UUID.randomUUID().toString().replace("-", "");
                docInfo.setDocId(docId);
                docInfo.setFileId(outputFile.getName());
                docInfo.setUserId(userId);
                docInfo.setAuthorId(userId);
                docInfo.setContactsId(userId);
                docInfo.setCreateTime(ts);
                docInfo.setFoldId(categoryId);
                docInfo.setDocType(suffix);
                docInfo.setTitle(fileName.substring(0, fileName.lastIndexOf(".")));
                docInfo.setReadNum(0);
                docInfo.setDownloadNum(0);
                docInfo.setValidFlag("1");
                docInfo.setAuthority("1");
                docInfo.setSetAuthority("0");
                docInfo.setVisibleRange(Integer.parseInt("1"));
                docInfo.setValidFlag("1");
                docInfo.setShareFlag("1");
                FsFile fileModel = new FsFile();
                fileModel.setCreateTime(ts);
                fileModel.setFileIcon("");
                fileModel.setFileId(docId);
                fileModel.setMd5(md5);
                fileModel.setFileName(fileName.substring(0, fileName.lastIndexOf(".")));
                double size = MathUtil.getDecimal((double)(outputFile.length() / 1024L), (int)2);
                fileModel.setFileSize(size + "KB");
                fileModel.setFileType(suffix);
                ArrayList<DocResourceLog> resInfoList = new ArrayList<DocResourceLog>();
                DocResourceLog docResourceLog = new DocResourceLog();
                String id = UUID.randomUUID().toString().replace("-", "");
                docResourceLog.setId(id);
                docResourceLog.setResourceId(docId);
                docResourceLog.setOperateTime(ts);
                docResourceLog.setResourceType(0);
                docResourceLog.setUserId(userId);
                docResourceLog.setOperateType(0);
                resInfoList.add(docResourceLog);
                ArrayList<DocFileAuthority> list = new ArrayList<DocFileAuthority>();
                ArrayList<String> indexList = new ArrayList<String>();
                if ("555dd41471c2461aa3391af9e8282fc1".equals(categoryId) || "1a5168f3a50f4f32b57bf454c5895457".equals(categoryId) || "2d8ed2e02fc34be2a587f7e68a848e91".equals(categoryId) || "339d8cd61b3746e1839ebf725aacb824".equals(categoryId) || "5e5d93580f3a443eb3057627be68ffa6".equals(categoryId) || "5f7bf94d27224db7a41e6c694def6e46".equals(categoryId) || "784ba4775a734014a8f251783606f23d".equals(categoryId) || "795aa5765d9d49e4805a88ac7fefbc8d".equals(categoryId) || "831f8b19eee44ad094ae21d7a7242578".equals(categoryId) || "85eb0d9b8b1a428f847e7f5bc8ff43b9".equals(categoryId) || "9670e7b36ce549ffa074f6592bbda284".equals(categoryId) || "a18c3d4a7fbe4de5868bb6b45eaad1e2".equals(categoryId) || "a63df52c36584f8c9378ebc801499977".equals(categoryId) || "bbb99e2f9a15474cbdcaba2d8da63db9".equals(categoryId) || "c4960ef211d745a497a31e7e9e2c3db0".equals(categoryId) || "add316b125a84d519578694955a5af36".equals(categoryId) || "caf4bd7d5f3e42a9aff6beae6154576f".equals(categoryId) || "e4daf328be6648f99281fb33b282bf62".equals(categoryId) || "645e6a2e155740949cdb81df3fa350b1".equals(categoryId) || "8c56ad616c674d7eba191e79f0cda882".equals(categoryId)) {
                    docFileAuthority = new DocFileAuthority();
                    docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                    docFileAuthority.setAuthorId("allpersonflag");
                    docFileAuthority.setAuthorType(3);
                    docFileAuthority.setFileId(docId);
                    docFileAuthority.setAuthority(1);
                    list.add(docFileAuthority);
                    indexList.add("allpersonflag");
                    indexList.add(userId);
                } else if ("6b46e675e46a4a69a9c2fc93af143aae".equals(categoryId)) {
                    groupArr = "6091a4f767e24ba29f87719bd1b2cef8,allpersonflag,2817292a04944e3c96a800c7ad2c3857,6a7206343e4246f9b21db680dbcf1516,337babeee7a8453290146c0ce8a96478".split(",");
                    authorTypeStrGroup = "1,3,1,1,1".split(",");
                    operateTypeStrGroup = "1,0,1,1,1".split(",");
                    for (int i = 0; i < groupArr.length; ++i) {
                        DocFileAuthority docFileAuthority2 = new DocFileAuthority();
                        docFileAuthority2.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                        docFileAuthority2.setAuthorId(groupArr[i]);
                        docFileAuthority2.setAuthorType(StringUtil.getInteger((Object)authorTypeStrGroup[i]));
                        docFileAuthority2.setFileId(docId);
                        docFileAuthority2.setAuthority(StringUtil.getInteger((Object)operateTypeStrGroup[i]));
                        list.add(docFileAuthority2);
                        indexList.add(groupArr[i]);
                    }
                    indexList.add(userId);
                } else if ("0404".equals(categoryId)) {
                    groupArr = "8d6e50d29336428f8964c42248510c6d,6091a4f767e24ba29f87719bd1b2cef8,6a7206343e4246f9b21db680dbcf1516,52ed3715582245a48ad633052ce289d3,30e66bdf2a66453cba0d38e5e7af4ae7".split(",");
                    authorTypeStrGroup = "1,1,1,1,1".split(",");
                    operateTypeStrGroup = "0,0,0,0,0".split(",");
                    for (int i = 0; i < groupArr.length; ++i) {
                        DocFileAuthority docFileAuthority3 = new DocFileAuthority();
                        docFileAuthority3.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                        docFileAuthority3.setAuthorId(groupArr[i]);
                        docFileAuthority3.setAuthorType(StringUtil.getInteger((Object)authorTypeStrGroup[i]));
                        docFileAuthority3.setFileId(docId);
                        docFileAuthority3.setAuthority(StringUtil.getInteger((Object)operateTypeStrGroup[i]));
                        list.add(docFileAuthority3);
                        indexList.add(groupArr[i]);
                    }
                    indexList.add(userId);
                } else if ("0101".equals(categoryId)) {
                    docFileAuthority = new DocFileAuthority();
                    docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                    docFileAuthority.setAuthorId("allpersonflag");
                    docFileAuthority.setAuthorType(3);
                    docFileAuthority.setFileId(docId);
                    docFileAuthority.setAuthority(0);
                    list.add(docFileAuthority);
                    indexList.add("allpersonflag");
                    indexList.add(userId);
                } else if ("0403".equals(categoryId)) {
                    docFileAuthority = new DocFileAuthority();
                    docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                    docFileAuthority.setAuthorId("allpersonflag");
                    docFileAuthority.setAuthorType(3);
                    docFileAuthority.setFileId(docId);
                    docFileAuthority.setAuthority(0);
                    list.add(docFileAuthority);
                    indexList.add("allpersonflag");
                    indexList.add(userId);
                } else if ("508bf3dd2d4b408684313051a487fdcd".equals(categoryId)) {
                    docFileAuthority = new DocFileAuthority();
                    docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                    docFileAuthority.setAuthorId("allpersonflag");
                    docFileAuthority.setAuthorType(3);
                    docFileAuthority.setFileId(docId);
                    docFileAuthority.setAuthority(0);
                    list.add(docFileAuthority);
                    indexList.add("allpersonflag");
                    indexList.add(userId);
                } else if ("0304".equals(categoryId)) {
                    String[] personArr = "\u516c\u53f8\u9886\u5bfc".split(",");
                    String[] personOrganArr = "5A154DE6E1F94FBA9D7C48A11EF7F1C6".split(",");
                    String[] authorTypeStrPerson = "2".split(",");
                    String[] operateTypeStrPerson = "0".split(",");
                    for (int i = 0; i < personArr.length; ++i) {
                        DocFileAuthority docFileAuthority4 = new DocFileAuthority();
                        docFileAuthority4.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                        docFileAuthority4.setAuthorId(personArr[i]);
                        docFileAuthority4.setAuthorType(StringUtil.getInteger((Object)authorTypeStrPerson[i]));
                        docFileAuthority4.setFileId(docId);
                        docFileAuthority4.setAuthority(Integer.parseInt(operateTypeStrPerson[i]));
                        docFileAuthority4.setOrganId(personOrganArr[i]);
                        list.add(docFileAuthority4);
                        if (StringUtil.getInteger((Object)authorTypeStrPerson[i]) == 0) {
                            indexList.add(personArr[i]);
                        }
                        if (StringUtil.getInteger((Object)authorTypeStrPerson[i]) != 2) continue;
                        indexList.add(personOrganArr[i]);
                    }
                } else if ("900f060aa5ad49e981da10f5d619ec2a".equals(categoryId)) {
                    docFileAuthority = new DocFileAuthority();
                    docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                    docFileAuthority.setAuthorId("allpersonflag");
                    docFileAuthority.setAuthorType(3);
                    docFileAuthority.setFileId(docId);
                    docFileAuthority.setAuthority(1);
                    list.add(docFileAuthority);
                    indexList.add("allpersonflag");
                    indexList.add(userId);
                } else if ("0301".equals(categoryId)) {
                    groupArr = "fcfcf9b538444c719916ab339b5b30e1".split(",");
                    authorTypeStrGroup = "1".split(",");
                    operateTypeStrGroup = "0".split(",");
                    for (int i = 0; i < groupArr.length; ++i) {
                        DocFileAuthority docFileAuthority5 = new DocFileAuthority();
                        docFileAuthority5.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                        docFileAuthority5.setAuthorId(groupArr[i]);
                        docFileAuthority5.setAuthorType(StringUtil.getInteger((Object)authorTypeStrGroup[i]));
                        docFileAuthority5.setFileId(docId);
                        docFileAuthority5.setAuthority(StringUtil.getInteger((Object)operateTypeStrGroup[i]));
                        list.add(docFileAuthority5);
                        indexList.add(groupArr[i]);
                    }
                    indexList.add(userId);
                } else if ("1085dd96c43f4036b0654b66e9f163af".equals(categoryId)) {
                    groupArr = "6a7206343e4246f9b21db680dbcf1516,30e66bdf2a66453cba0d38e5e7af4ae7".split(",");
                    authorTypeStrGroup = "1,1".split(",");
                    operateTypeStrGroup = "1,1".split(",");
                    for (int i = 0; i < groupArr.length; ++i) {
                        DocFileAuthority docFileAuthority6 = new DocFileAuthority();
                        docFileAuthority6.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                        docFileAuthority6.setAuthorId(groupArr[i]);
                        docFileAuthority6.setAuthorType(StringUtil.getInteger((Object)authorTypeStrGroup[i]));
                        docFileAuthority6.setFileId(docId);
                        docFileAuthority6.setAuthority(StringUtil.getInteger((Object)operateTypeStrGroup[i]));
                        list.add(docFileAuthority6);
                        indexList.add(groupArr[i]);
                    }
                    indexList.add(userId);
                } else if ("8bea2cb2184c44c4a296710bad0d9673".equals(categoryId)) {
                    indexList.add(userId);
                } else if ("0521e2de1a93438d9fa5ecd512fc0105".equals(categoryId)) {
                    docFileAuthority = new DocFileAuthority();
                    docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                    docFileAuthority.setAuthorId("allpersonflag");
                    docFileAuthority.setAuthorType(3);
                    docFileAuthority.setFileId(docId);
                    docFileAuthority.setAuthority(1);
                    list.add(docFileAuthority);
                    indexList.add("allpersonflag");
                    indexList.add(userId);
                } else if ("5c8cee3afd0f47aba7ed4893d6ed9e66".equals(categoryId)) {
                    docFileAuthority = new DocFileAuthority();
                    docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                    docFileAuthority.setAuthorId("allpersonflag");
                    docFileAuthority.setAuthorType(3);
                    docFileAuthority.setFileId(docId);
                    docFileAuthority.setAuthority(1);
                    list.add(docFileAuthority);
                    indexList.add("allpersonflag");
                    indexList.add(userId);
                } else if ("0504".equals(categoryId) || "050402".equals(categoryId) || "050403".equals(categoryId) || "7d9f267b319741ca90844efc7108db87".equals(categoryId)) {
                    docFileAuthority = new DocFileAuthority();
                    docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                    docFileAuthority.setAuthorId("allpersonflag");
                    docFileAuthority.setAuthorType(3);
                    docFileAuthority.setFileId(docId);
                    docFileAuthority.setAuthority(1);
                    list.add(docFileAuthority);
                    indexList.add("allpersonflag");
                    indexList.add(userId);
                } else {
                    docFileAuthority = new DocFileAuthority();
                    docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                    docFileAuthority.setAuthorId("allpersonflag");
                    docFileAuthority.setAuthorType(3);
                    docFileAuthority.setFileId(docId);
                    docFileAuthority.setAuthority(0);
                    list.add(docFileAuthority);
                    indexList.add("allpersonflag");
                    indexList.add(userId);
                }
                this.cacheToolService.updateLevelCodeCache(userId);
                this.filesService.uploadFile(outputFile, docInfo, fileModel, resInfoList, list, indexList, contentType);
                TopicFile topicFile = new TopicFile();
                topicFile.setTopicFileId(UUID.randomUUID().toString().replaceAll("-", ""));
                topicFile.setDocId(docId);
                topicFile.setSpecialTopicId(topicId);
                String currentCode = this.sysIdtableService.getCurrentCode("TOPIC_FILE_NUM", "doc_special_topic_files");
                int bigNum = Integer.parseInt(currentCode);
                topicFile.setShowOrder(bigNum);
                ArrayList<TopicFile> topicList = new ArrayList<TopicFile>();
                topicList.add(topicFile);
                if (topicList != null && topicList.size() > 0) {
                    this.iTopicDocManagerService.saveTopicDoc(topicId, topicList);
                }
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("code", DocConstant.UPLOADRESULT.SUCCESS.getValue());
                json = JSONObject.toJSONString(resultMap);
                return json;
            }
            catch (IOException e) {
                logger.error("IO Exception\uff1a", (Throwable)e);
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                json = JSONObject.toJSONString(resultMap);
                return json;
            }
        }
        catch (Exception e) {
            logger.error("IO Exception\uff1a", (Throwable)e);
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("code", DocConstant.UPLOADRESULT.SUCCESS.getValue());
            return json;
        }
    }

    private String getContentType(String suffix) {
        String contentType = null;
        if (suffix.equals(".doc") || suffix.equals(".docx")) {
            contentType = "application/msword";
            return contentType;
        }
        if (suffix.equals(".ppt") || suffix.equals(".pptx")) {
            contentType = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
            return contentType;
        }
        if (suffix.equals(".xls") || suffix.equals(".xlsx")) {
            contentType = "spreadsheetml";
            return contentType;
        }
        if (suffix.equals(".png") || suffix.equals(".gif") || suffix.equals(".jpg") || suffix.equals(".bmp")) {
            contentType = "image";
            return contentType;
        }
        if (suffix.equals(".txt")) {
            contentType = "text/plain";
            return contentType;
        }
        if (suffix.equals(".pdf")) {
            contentType = "application/pdf";
            return contentType;
        }
        if (suffix.equals(".mp3")) {
            contentType = "audio/mp3";
            return contentType;
        }
        if (suffix.equals(".mp4")) {
            contentType = "video/mp4";
            return contentType;
        }
        if (suffix.equals(".wav")) {
            contentType = "audio/wav";
            return contentType;
        }
        if (suffix.equals(".avi")) {
            contentType = "video/avi";
            return contentType;
        }
        if (suffix.equals(".ceb")) {
            contentType = "ceb";
            return contentType;
        }
        return null;
    }

    @RequestMapping(value={"/getTopic"})
    @ResponseBody
    public void getTopic(HttpServletResponse response) throws IOException {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("application/json;charset=UTF-8");
        List<SpecialTopic> topicList = this.frontTopicService.getTopicList(0, 200);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String json = "";
        resultMap.put("total", topicList.size());
        resultMap.put("data", topicList);
        response.getWriter().write(JSON.toJSONString(resultMap));
    }

    @RequestMapping(value={"/getFolderTree"})
    @ResponseBody
    public List getFolderTree(String id, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        String type = "0";
        return this.frontFolderService.getTreeDataLazyJqx(id, type);
    }
}

