/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.statistics.service.impl;

import com.jxdinfo.doc.common.util.FileTool;
import com.jxdinfo.doc.common.util.MathUtil;
import com.jxdinfo.doc.manager.statistics.dao.DeptStatisticsMapper;
import com.jxdinfo.doc.manager.statistics.dao.DocSpaceMapper;
import com.jxdinfo.doc.manager.statistics.model.DocSpace;
import com.jxdinfo.doc.manager.statistics.service.DeptStatisticsService;
import com.jxdinfo.hussar.bsp.organ.dao.SysOrganMapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DeptStatisticsServiceImpl
implements DeptStatisticsService {
    @Resource
    private DeptStatisticsMapper deptStatisticsMapper;
    @Resource
    private DocSpaceMapper docSpaceMapper;
    @Resource
    private SysOrganMapper sysOrganMapper;

    @Override
    public List<Map<String, Object>> getStatisticsData() {
        List<Map<String, Object>> list = this.deptStatisticsMapper.getStatisticsData();
        for (Map<String, Object> map : list) {
            double count = (Double)map.get("NUM");
            DocSpace docSpace = (DocSpace)((Object)this.docSpaceMapper.selectById((Serializable)((Object)(map.get("ORGAN_ID") + ""))));
            if (docSpace == null) continue;
            Double initSpace = docSpace.getSpaceSize();
            double newCount = initSpace * 1024.0 * 1024.0 - count;
            if (newCount < 0.0) {
                newCount = 0.0;
            }
            map.put("INIT_SPACE", initSpace + "GB");
            map.put("NUM", FileTool.doubleToString(newCount));
            map.put("USERNUM", FileTool.doubleToString(count));
        }
        return list;
    }

    @Override
    public double getStatisticsDataByOrganId(String organId, String size) {
        Double fileSize = Double.parseDouble(size.substring(0, size.length() - 2));
        DocSpace docSpac = (DocSpace)((Object)this.docSpaceMapper.selectById((Serializable)((Object)organId)));
        if (docSpac != null) {
            double share = this.deptStatisticsMapper.getStatisticsDataByOrganId(organId);
            return docSpac.getSpaceSize() * 1024.0 * 1024.0 - share - fileSize;
        }
        return 5.24288E7;
    }

    @Override
    public double getUsedSpaceByOrganId(String organId) {
        return this.deptStatisticsMapper.getStatisticsDataByOrganId(organId);
    }

    @Override
    public void updateSpace(String id, String space) {
        DocSpace docSpac = (DocSpace)((Object)this.docSpaceMapper.selectById((Serializable)((Object)id)));
        if (docSpac != null) {
            docSpac.setSpaceSize(Double.parseDouble(space));
            this.docSpaceMapper.updateById((Object)docSpac);
        }
    }

    @Override
    public Map<String, String> getSpaceByOrganId(String id, Integer adminFlag) {
        HashMap<String, String> map = new HashMap<String, String>();
        DocSpace docSpace = (DocSpace)((Object)this.docSpaceMapper.selectById((Serializable)((Object)id)));
        if (docSpace != null && adminFlag != 1) {
            double present;
            map.put("limit", "1");
            double share = this.deptStatisticsMapper.getStatisticsDataByOrganId(id);
            map.put("total", docSpace.getSpaceSize() + "GB");
            Double lackSize = share;
            if (lackSize < 0.0) {
                share = docSpace.getSpaceSize();
            }
            if ((present = share / (docSpace.getSpaceSize() * 1024.0 * 1024.0) * 100.0) > 100.0) {
                present = 100.0;
            }
            map.put("present", MathUtil.getDecimal((double)present, (int)2) + "");
            map.put("lack", FileTool.doubleToString(Double.parseDouble(String.valueOf(share))));
        } else {
            map.put("limit", "0");
        }
        return map;
    }
}

