/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.groupmanager.service.impl;

import com.jxdinfo.doc.manager.groupmanager.dao.DocGroupMapper;
import com.jxdinfo.doc.manager.groupmanager.model.DocGroup;
import com.jxdinfo.doc.manager.groupmanager.model.DocGroupSort;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocGroupServiceImpl
implements DocGroupService {
    @Autowired
    private DocGroupMapper docGroupMapper;
    @Autowired
    private ISysIdtableService sysIdtableService;

    @Override
    public List<DocGroup> groupList(String groupId, String uerName, int startIndex, int pageSize) {
        return this.docGroupMapper.groupList(groupId, uerName, startIndex, pageSize);
    }

    @Override
    public int getGroupListCount(String groupId, String uerName) {
        return this.docGroupMapper.getGroupListCount(groupId, uerName);
    }

    @Override
    public int addGroup(DocGroup docGroup) {
        docGroup.setParenteGroupId("af9090a8fdfe487f9487df9cdc6e88");
        docGroup.setGroupLevel(1);
        docGroup.setCreateUserId(ShiroKit.getUser().getId());
        int num = this.docGroupMapper.insertGroup(docGroup);
        if (num > 0 && null != docGroup.getUserId()) {
            String[] uersIds = docGroup.getUserId().split(",");
            for (int i = 0; i < uersIds.length; ++i) {
                this.docGroupMapper.insertGroupUser(docGroup.getGroupId(), uersIds[i]);
            }
        }
        return num;
    }

    @Override
    public int addGroupUser(DocGroup docGroup) {
        int num = 0;
        if (null != docGroup.getUserId()) {
            this.docGroupMapper.deleteByPrimaryKey(docGroup.getGroupId());
            String[] uersIds = docGroup.getUserId().split(",");
            for (int i = 0; i < uersIds.length; ++i) {
                num = this.docGroupMapper.insertGroupUser(docGroup.getGroupId(), uersIds[i]);
            }
        }
        return num;
    }

    @Override
    public int checkGroupExist(String groupName, String groupId) {
        return this.docGroupMapper.checkGroupExist(groupName, groupId);
    }

    @Override
    public int updateGroup(DocGroup docGroup) {
        int num = this.docGroupMapper.updateByPrimaryKey(docGroup);
        if (num > 0 && null != docGroup.getUserId()) {
            this.docGroupMapper.deleteByPrimaryKey(docGroup.getGroupId());
            String[] uersIds = docGroup.getUserId().split(",");
            for (int i = 0; i < uersIds.length; ++i) {
                this.docGroupMapper.insertGroupUser(docGroup.getGroupId(), uersIds[i]);
            }
        }
        return num;
    }

    @Override
    public int delGroupById(String groupId) {
        this.docGroupMapper.deleteByPrimaryKey(groupId);
        return this.docGroupMapper.delGroupById(groupId);
    }

    @Override
    public DocGroup selectGroupById(String groupId) {
        return this.docGroupMapper.selectGroupById(groupId);
    }

    @Override
    public List<Map> selectGroupUserById(String groupId, int startIndex, int pageSize) {
        List<Map> list = this.docGroupMapper.selectGroupUserById(groupId, startIndex, pageSize);
        return list;
    }

    @Override
    public List<Map<String, Object>> selectGroupByName(String deptId) {
        List<Map<String, Object>> list = this.docGroupMapper.selectGroupByName(deptId);
        return list;
    }

    @Override
    public List<String> getPremission(String userId) {
        List<String> list = this.docGroupMapper.getPremission(userId);
        return list;
    }

    @Override
    public int delGroupUserById(String groupId, List<String> idList) {
        return this.docGroupMapper.delGroupUserById(groupId, idList);
    }

    @Override
    public int addGroupSort(DocGroupSort docGroupSort) {
        String groupSortId = UUID.randomUUID().toString().replaceAll("-", "");
        docGroupSort.setSortId(groupSortId);
        String currentCode = this.sysIdtableService.getCurrentCode("SORT_NUM", "doc_group_sort");
        int bigNum = Integer.parseInt(currentCode);
        docGroupSort.setShowOrder(bigNum);
        docGroupSort.setCreateUserId(ShiroKit.getUser().getId());
        int num = this.docGroupMapper.insertGroupSort(docGroupSort);
        return num;
    }

    @Override
    public int delGroupSortById(String groupSortId) {
        int num = 0;
        String res = this.getCheckSort(groupSortId);
        num = "false".equals(res) ? this.docGroupMapper.deleteSort(groupSortId) : 2;
        return num;
    }

    public String getCheckSort(String groupSortId) {
        String result = "false";
        int num = this.docGroupMapper.getSortToGroup(groupSortId);
        if (num > 0) {
            result = "true";
        }
        return result;
    }

    @Override
    public DocGroupSort selectSortInfo(String groupSortId) {
        String sortId = "";
        sortId = ToolUtil.isEmpty((Object)groupSortId) ? "af9090a8fdfe487f9487df9cdc6e88" : groupSortId;
        Map<String, Object> map = this.docGroupMapper.selectSortInfo(sortId);
        DocGroupSort docGroupSort = new DocGroupSort();
        if (map != null) {
            docGroupSort.setSortId(map.get("sortId").toString());
            docGroupSort.setSortName(map.get("sortName").toString());
            docGroupSort.setParentSortId(map.get("parentSortId").toString());
        } else {
            docGroupSort.setSortId("#");
            docGroupSort.setSortName("\u91d1\u73b0\u4ee3");
        }
        return docGroupSort;
    }

    @Override
    public boolean updateSortInfo(DocGroupSort docGruopSort) {
        boolean result = false;
        int num = this.docGroupMapper.updateSortInfo(docGruopSort);
        if (num > 0) {
            result = true;
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> selectSortAndGroup(String id) {
        List<Map<String, Object>> list = this.docGroupMapper.getSortAndGroupTree(id);
        return list;
    }

    @Override
    public int checkSortName(String sortName, String parentSortId, String sortId) {
        int num = 0;
        num = this.docGroupMapper.checkSortName(sortName, parentSortId, sortId);
        return num;
    }

    @Override
    public List<Map<String, Object>> getSortTreeData() {
        return this.docGroupMapper.getSortTreeData();
    }

    @Override
    public int getIsAuthority(String groupId) {
        int res = 0;
        int isFolder = this.docGroupMapper.getIsFolder(groupId);
        int isFile = this.docGroupMapper.getIsFile(groupId);
        if (isFile + isFolder > 0) {
            res = 1;
        }
        return res;
    }
}

