/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.foldermanager.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.manager.docmanager.model.FsFolderView;
import com.jxdinfo.doc.manager.foldermanager.dao.FsFolderMapper;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolder;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.foldermanager.service.IDocFoldAuthorityService;
import com.jxdinfo.doc.manager.foldermanager.service.IFsFolderService;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FsFolderServiceImpl
extends ServiceImpl<FsFolderMapper, FsFolder>
implements IFsFolderService {
    @Resource
    private FsFolderMapper fsFolderMapper;
    @Autowired
    private IDocFoldAuthorityService docFoldAuthorityService;
    @Resource
    private BusinessService folderService;
    @Autowired
    private DocGroupService docGroupService;
    @Resource
    private BusinessService businessService;

    @Override
    public List<FsFolder> getChildren(FsFolderParams fsFolderParams) {
        List<FsFolder> list = null;
        String orderResult = fsFolderParams.getOrderResult();
        int adminFlag = fsFolderParams.getAdminFlag();
        List groupList = fsFolderParams.getGroupList();
        String userId = fsFolderParams.getUserId();
        String type = fsFolderParams.getType();
        if ("title".equals(orderResult)) {
            orderResult = "folder_name";
        } else if ("doc_type".equals(orderResult)) {
            orderResult = "show_order";
        }
        fsFolderParams.setOrderResult(orderResult);
        if (adminFlag == 1) {
            list = this.fsFolderMapper.getChildrenBySuperAdmin(fsFolderParams);
        } else {
            List<String> levelCodeList = this.folderService.getlevelCodeList(groupList, userId, type);
            fsFolderParams.setLevelCodeList(levelCodeList);
            list = this.fsFolderMapper.selectByLevelCodePage(fsFolderParams);
        }
        return list;
    }

    @Override
    public int getNum(FsFolderParams fsFolderParams) {
        int num = 0;
        if (fsFolderParams.getAdminFlag() == 1) {
            num = this.fsFolderMapper.getNumBySuperAdmin(fsFolderParams.getId(), fsFolderParams.getName());
        } else {
            String levelCodeString = this.folderService.getLevelCodeByUser(fsFolderParams);
            num = this.fsFolderMapper.selectByLevelCodeNum(fsFolderParams.getId(), fsFolderParams.getUserId(), levelCodeString, fsFolderParams.getName());
        }
        return num;
    }

    @Override
    public List<FsFolder> getTreeDataLazy(FsFolderParams fsFolderParams) {
        List<FsFolder> list = null;
        list = fsFolderParams.getAdminFlag() == 1 ? this.fsFolderMapper.getTreeDataLazyBySuper(fsFolderParams.getId()) : this.fsFolderMapper.selectByLevelCode(fsFolderParams.getId(), fsFolderParams.getUserId(), fsFolderParams.getLevelCodeString());
        return list;
    }

    @Override
    public List<FsFolder> getRoot() {
        List<FsFolder> list = this.fsFolderMapper.getRoot();
        return list;
    }

    @Override
    public boolean isChildren(String id) {
        boolean result = false;
        int num = this.fsFolderMapper.getNumByChildFloder(id);
        if (num == 0) {
            result = true;
        }
        return result;
    }

    @Override
    public List<FsFolder> addCheck(String pid, String name, String folderId) {
        List<FsFolder> list = this.fsFolderMapper.addCheck(pid, name, folderId);
        return list;
    }

    @Override
    public List<FsFolder> getChildList(@Param(value="list") List list, @Param(value="groupList") List groupList, @Param(value="UserId") String userId, Integer adminFlag, String type, String levelCodeString) {
        List<Object> listFsFolder = new ArrayList();
        listFsFolder = adminFlag == 1 ? this.fsFolderMapper.getChildListForSuperAdmin(list) : this.fsFolderMapper.selectByLevelCodeList(list, userId, levelCodeString);
        return listFsFolder;
    }

    @Override
    public List<Map> getChildCountList(@Param(value="list") List list, @Param(value="groupList") List groupList, @Param(value="UserId") String userId, Integer adminFlag, String type, String levelCodeString) {
        List<Map> listMap = null;
        listMap = adminFlag == 1 ? this.fsFolderMapper.getChildCountListForSuperAdmin(list) : this.fsFolderMapper.getChildCount(list, userId, levelCodeString);
        return listMap;
    }

    @Override
    public List<FsFolder> countFolderName(@Param(value="pid") String pid, @Param(value="list") List list) {
        List<FsFolder> listFsFolder = this.fsFolderMapper.countFolderName(pid, list);
        return listFsFolder;
    }

    @Override
    public List getAuthority(@Param(value="folderId") String folderId) {
        List list = this.fsFolderMapper.getAuthority(folderId);
        return list;
    }

    @Override
    public List<FsFolder> getChildrenByRoot(int pageNumber, int pageSize) {
        List<FsFolder> listFsFolder = this.fsFolderMapper.getChildrenByRoot(pageNumber, pageSize);
        return listFsFolder;
    }

    @Override
    public int deleteInIds(List ids) {
        int amount = this.fsFolderMapper.deleteInIds(ids);
        return amount;
    }

    @Override
    public String getChildFsFolder(String rootId) {
        String ids = this.fsFolderMapper.getChildFsFolder(rootId);
        return ids;
    }

    @Override
    public String checkChildType(String rootId) {
        String ids = this.fsFolderMapper.getChildFsFolderType(rootId);
        return ids;
    }

    @Override
    public List searchLevel() {
        return this.fsFolderMapper.searchLevel();
    }

    @Override
    public List<Map> getPersonList(int pageNumber, int pageSize, String name, String deptId) {
        List<Map> list = this.fsFolderMapper.getPersonList(pageNumber, pageSize, name, deptId);
        return list;
    }

    @Override
    public List<FsFolderView> getFilesAndFloder(int pageNumber, int pageSize, String id, String[] typeArr, String name, String orderResult, List groupList, String userId, Integer adminFlag, String operateType, String levelCodeString, String levelCode, String isDesc, String orgId) {
        List<FsFolderView> list = null;
        list = adminFlag == 1 ? this.fsFolderMapper.getFilesAndFloderBySuperAdmin(pageNumber, pageSize, id, name, orderResult, typeArr, isDesc) : this.fsFolderMapper.getFilesAndFloderByAdmin(levelCodeString, pageNumber, pageSize, id, name, orderResult, groupList, userId, typeArr, operateType, levelCode, isDesc, orgId);
        return list;
    }

    @Override
    public int getFilesAndFloderNum(String id, String[] typeArr, String name, String orderResult, List groupList, String userId, Integer adminFlag, String operateType, String levelCodeString, String levelCode, String orgId) {
        int num = 0;
        num = adminFlag == 1 ? this.fsFolderMapper.getFilesAndFloderNumBySuperAdmin(id, name, orderResult, typeArr) : this.fsFolderMapper.getFilesAndFloderByAdminNum(levelCodeString, id, name, orderResult, groupList, userId, typeArr, operateType, levelCode, orgId);
        return num;
    }

    @Override
    public String getCurrentMaxLevelCode(String parentId) {
        return this.fsFolderMapper.getCurrentMaxLevelCode(parentId);
    }

    @Override
    public int getFileNum(String id, String[] typeArr, String name, List groupList, String userId, Integer adminFlag, String type, String levelCodeString, String orgId) {
        int num = 0;
        num = adminFlag == 1 ? this.fsFolderMapper.getFileNumBySuperAdmin(id, name, typeArr) : ("0".equals(type) ? this.fsFolderMapper.getFileNum(id, name, groupList, userId, type, typeArr, levelCodeString, orgId) : this.fsFolderMapper.getFileNum(id, name, groupList, userId, type, typeArr, levelCodeString, orgId));
        return num;
    }

    @Override
    public String updateFsFolder(FsFolder fsFolder) {
        if (fsFolder.getFolderName() == null || "".equals(fsFolder.getFolderName())) {
            Date date = new Date();
            Timestamp ts = new Timestamp(date.getTime());
            fsFolder.setUpdateTime(ts);
            this.updateById((Object)fsFolder);
        } else {
            Date date = new Date();
            Timestamp ts = new Timestamp(date.getTime());
            fsFolder.setUpdateTime(ts);
            this.updateById((Object)fsFolder);
        }
        return "success";
    }

    @Override
    public void addLevel(String rootId) {
        ArrayList<FsFolder> listFsFolder = new ArrayList<FsFolder>();
        int ss = 1;
        FsFolder root = new FsFolder();
        if (rootId == null) {
            root = (FsFolder)((Object)this.fsFolderMapper.selectById((Serializable)((Object)"2bb61cdb2b3c11e8aacf429ff4208431")));
            root.setLevelCode("001");
        } else {
            root = (FsFolder)((Object)this.fsFolderMapper.selectById((Serializable)((Object)rootId)));
        }
        listFsFolder.add(root);
        List<FsFolder> listFsFirst = this.fsFolderMapper.getChildByParentId(root.getFolderId());
        if (listFsFirst != null && listFsFirst.size() > 0) {
            for (int i = 0; i < listFsFirst.size(); ++i) {
                String levelCode = root.getLevelCode();
                int newI = i + 1;
                levelCode = newI < 10 ? levelCode + "00" + newI : (newI >= 10 && newI < 100 ? levelCode + "0" + newI : levelCode + "" + newI);
                listFsFirst.get(i).setShowOrder(++ss);
                listFsFirst.get(i).setLevelCode(levelCode);
                listFsFolder.add(listFsFirst.get(i));
                List<FsFolder> listFsSec = this.fsFolderMapper.getChildByParentId(listFsFirst.get(i).getFolderId());
                if (listFsSec == null || listFsSec.size() <= 0) continue;
                for (int j = 0; j < listFsSec.size(); ++j) {
                    String levelCodeSec = levelCode;
                    int newJ = j + 1;
                    levelCodeSec = newJ < 10 ? levelCodeSec + "00" + newJ : (newJ >= 10 && newJ < 100 ? levelCodeSec + "0" + newJ : levelCodeSec + "" + newJ);
                    listFsSec.get(j).setShowOrder(++ss);
                    listFsSec.get(j).setLevelCode(levelCodeSec);
                    listFsFolder.add(listFsSec.get(j));
                    List<FsFolder> listFsTh = this.fsFolderMapper.getChildByParentId(listFsSec.get(j).getFolderId());
                    if (listFsTh == null || listFsTh.size() <= 0) continue;
                    for (int k = 0; k < listFsTh.size(); ++k) {
                        String levelCodeTh = levelCodeSec;
                        int newK = k + 1;
                        levelCodeTh = newK < 10 ? levelCodeTh + "00" + newK : (newK >= 10 && newK < 100 ? levelCodeTh + "0" + newK : levelCodeTh + "" + newK);
                        listFsTh.get(k).setLevelCode(levelCodeTh);
                        listFsTh.get(k).setShowOrder(++ss);
                        listFsFolder.add(listFsTh.get(k));
                        List<FsFolder> listFsForth = this.fsFolderMapper.getChildByParentId(listFsTh.get(k).getFolderId());
                        if (listFsForth == null || listFsForth.size() <= 0) continue;
                        for (int n = 0; n < listFsForth.size(); ++n) {
                            String levelCodeForth = levelCodeTh;
                            int newN = n + 1;
                            levelCodeForth = newN < 10 ? levelCodeForth + "00" + newN : (newN >= 10 && newN < 100 ? levelCodeForth + "0" + newN : levelCodeForth + "" + newN);
                            listFsForth.get(n).setLevelCode(levelCodeForth);
                            listFsForth.get(n).setShowOrder(++ss);
                            listFsFolder.add(listFsForth.get(n));
                            List<FsFolder> listFsFirth = this.fsFolderMapper.getChildByParentId(listFsForth.get(n).getFolderId());
                            if (listFsFirth == null || listFsFirth.size() <= 0) continue;
                            for (int m = 0; m < listFsFirth.size(); ++m) {
                                String levelCodeFirth = levelCodeForth;
                                int newM = m + 1;
                                levelCodeFirth = newM < 10 ? levelCodeFirth + "00" + newM : (newM >= 10 && newM < 100 ? levelCodeFirth + "0" + newM : levelCodeFirth + "" + newM);
                                listFsFirth.get(m).setShowOrder(++ss);
                                listFsFirth.get(m).setLevelCode(levelCodeFirth);
                                listFsFolder.add(listFsFirth.get(m));
                            }
                        }
                    }
                }
            }
        }
        this.updateBatchById(listFsFolder);
    }

    @Override
    public int getChildCodeCount(String rootId) {
        String levelCode = ((FsFolder)((Object)this.fsFolderMapper.selectById((Serializable)((Object)rootId)))).getLevelCode();
        return this.fsFolderMapper.getChildCodeCount(levelCode);
    }

    @Override
    public List getTreeDataLazy(String id, String type) {
        List<Object> resultList = new ArrayList();
        FsFolderParams fsFolderParams = new FsFolderParams();
        List roleList = ShiroKit.getUser().getRolesList();
        String userId = ShiroKit.getUser().getId();
        List<String> listGroup = this.docGroupService.getPremission(userId);
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        fsFolderParams.setAdminFlag(adminFlag);
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType(type);
        String levelCodeString = this.businessService.getLevelCodeByUser(fsFolderParams);
        fsFolderParams.setLevelCodeString(levelCodeString);
        if ("#".equals(id)) {
            String idParam = "root";
            fsFolderParams.setId(idParam);
            fsFolderParams.setType("0");
            List<FsFolder> list = this.getTreeDataLazy(fsFolderParams);
            ArrayList<String> firstList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                FsFolder fsFolder = list.get(i);
                firstList.add(fsFolder.getFolderId());
            }
            List<FsFolder> childList = this.getChildList(firstList, listGroup, userId, adminFlag, type, levelCodeString);
            ArrayList<String> secondList = new ArrayList<String>();
            for (int i = 0; i < childList.size(); ++i) {
                FsFolder fsFolder = childList.get(i);
                secondList.add(fsFolder.getFolderId());
            }
            List<Map> childCountList = this.getChildCountList(secondList, listGroup, userId, adminFlag, type, levelCodeString);
            List<Map> childResultList = this.checkChildCount(childList, childCountList);
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, Object> parentMap = new HashMap<String, Object>();
                FsFolder fsFolder = list.get(i);
                parentMap.put("id", fsFolder.getFolderId());
                parentMap.put("text", fsFolder.getFolderName());
                ArrayList<Map> childMapList = new ArrayList<Map>();
                for (int j = 0; j < childResultList.size(); ++j) {
                    Map map = childResultList.get(j);
                    if (!fsFolder.getFolderId().equals(map.get("pid"))) continue;
                    childMapList.add(map);
                }
                parentMap.put("children", childMapList);
                parentMap.put("opened", true);
                resultList.add(parentMap);
            }
        } else {
            fsFolderParams.setId(id);
            fsFolderParams.setType(type);
            List<FsFolder> list = this.getTreeDataLazy(fsFolderParams);
            ArrayList<String> firstList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                FsFolder fsFolder = list.get(i);
                firstList.add(fsFolder.getFolderId());
            }
            List<Map> childCountList = this.getChildCountList(firstList, listGroup, userId, adminFlag, type, levelCodeString);
            resultList = this.checkChildCount(list, childCountList);
        }
        return resultList;
    }

    @Override
    public List<Map> checkChildCount(List<FsFolder> list, List<Map> childCountList) {
        ArrayList<Map> resultList = new ArrayList<Map>();
        for (int j = 0; j < list.size(); ++j) {
            FsFolder fsFolderChild = list.get(j);
            HashMap<String, Object> childMap = new HashMap<String, Object>();
            childMap.put("id", fsFolderChild.getFolderId());
            childMap.put("text", fsFolderChild.getFolderName());
            childMap.put("pid", fsFolderChild.getParentFolderId());
            for (int i = 0; i < childCountList.size(); ++i) {
                Map map = childCountList.get(i);
                if (!fsFolderChild.getFolderId().equals(map.get("id"))) continue;
                if (Integer.valueOf(map.get("num").toString()) > 0) {
                    childMap.put("children", true);
                    continue;
                }
                childMap.put("children", false);
            }
            resultList.add(childMap);
        }
        return resultList;
    }

    @Override
    public synchronized String getCurrentLevelCode(String parentCode, String parentId) {
        if (parentCode != null) {
            String currentMaxCode = this.getCurrentMaxLevelCode(parentId);
            if (currentMaxCode != null && !"".equals(currentMaxCode)) {
                Integer currCodeInt = Integer.parseInt(currentMaxCode = currentMaxCode.substring(currentMaxCode.length() - 3, currentMaxCode.length())) + 1;
                if (currCodeInt < 10) {
                    return parentCode + "00" + currCodeInt;
                }
                if (currCodeInt >= 10 && currCodeInt < 100) {
                    return parentCode + "0" + currCodeInt;
                }
                return parentCode + "" + currCodeInt;
            }
            return parentCode + "001";
        }
        return parentCode;
    }

    @Override
    public Object getChildren(FsFolderParams fsFolderParams, String nameFlag) {
        boolean isChild = this.isChildren(fsFolderParams.getId());
        FsFolder fsFolder = (FsFolder)((Object)this.selectById((Serializable)((Object)fsFolderParams.getId())));
        if (fsFolderParams.getPageNumber() == 0) {
            fsFolderParams.setPageNumber(1);
        }
        if (fsFolderParams.getPageSize() == 0) {
            fsFolderParams.setPageSize(300);
        }
        HashMap<String, String> orderMap = new HashMap<String, String>();
        orderMap.put("0", "create_time");
        orderMap.put("1", "folder_name");
        String userId = ShiroKit.getUser().getId();
        List<String> listGroup = this.docGroupService.getPremission(userId);
        String orderResult = (String)orderMap.get(fsFolderParams.getOrder());
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        List<Object> list = new ArrayList();
        int num = 0;
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        fsFolderParams.setPageNumber((fsFolderParams.getPageNumber() - 1) * fsFolderParams.getPageSize());
        fsFolderParams.setOrderResult(orderResult);
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setAdminFlag(adminFlag);
        if (nameFlag == null || "".equals(nameFlag)) {
            fsFolderParams.setName(null);
            list = this.getChildren(fsFolderParams);
            num = this.getNum(fsFolderParams);
        } else {
            list = this.getChildren(fsFolderParams);
            num = this.getNum(fsFolderParams);
        }
        if (adminFlag != 1) {
            int isEdits = this.docFoldAuthorityService.findEditNew(fsFolderParams.getId(), listGroup, userId);
            result.put("noChildPower", isEdits);
        }
        if (userId.equals(fsFolder.getCreateUserId())) {
            result.put("noChildPower", 1);
        }
        result.put("userId", ShiroKit.getUser().getName());
        result.put("isAdmin", adminFlag);
        result.put("total", num);
        result.put("rows", list);
        result.put("isChild", isChild);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getIsEdit(String chooseFolderId) {
        boolean res = false;
        String userId = ShiroKit.getUser().getId();
        List<String> listGroup = this.docGroupService.getPremission(userId);
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        String[] chooseFolderIds = chooseFolderId.split(",");
        for (int i = 0; i < chooseFolderIds.length; ++i) {
            FsFolder fsFolder = (FsFolder)((Object)this.selectById((Serializable)((Object)chooseFolderIds[i])));
            if (adminFlag != 1) {
                int isEdits = this.docFoldAuthorityService.findEditNew(chooseFolderIds[i], listGroup, userId);
                if (isEdits > 0) {
                    res = true;
                } else {
                    if (!userId.equals(fsFolder.getCreateUserId())) return false;
                    res = true;
                }
            } else {
                res = true;
            }
            if (!userId.equals(fsFolder.getCreateUserId())) continue;
            res = true;
        }
        return res;
    }

    @Override
    public List<FsFolderView> getPersonUpload(String userId, Integer pageNumber, Integer pageSize, String name, String[] typeArr, String order) {
        List<FsFolderView> list = null;
        list = this.fsFolderMapper.getPersonUpload(userId, pageNumber, pageSize, name, typeArr, order);
        return list;
    }

    @Override
    public int getPersonUploadNum(String userId, String name) {
        int num = this.fsFolderMapper.getPersonUploadNum(userId, name);
        return num;
    }

    public List<FsFolderView> changeFolderLocation(List<FsFolderView> list) {
        for (FsFolderView fsFolderView : list) {
            if (fsFolderView.getFolderLocal() == null || "".equals(fsFolderView.getFolderLocal())) continue;
            String localName = "";
            for (int i = 1; i <= fsFolderView.getFolderLocal().length() / 3; ++i) {
                String levelCode = fsFolderView.getFolderLocal().substring(0, i * 3);
                String folderName = this.fsFolderMapper.getFolderNameByLevelCode(levelCode);
                localName = localName + "/" + folderName;
            }
            localName = localName.substring(1, localName.length());
            fsFolderView.setFolderLocal(localName);
        }
        return list;
    }

    @Override
    public String getFolderNameByLevelCode(String levelCode) {
        return this.fsFolderMapper.getFolderNameByLevelCode(levelCode);
    }

    @Override
    public List<FsFolder> getFolderByLevelCodeStringFirst(String levelCodeString) {
        return this.fsFolderMapper.getFolderByLevelCodeStringFirst(levelCodeString);
    }

    @Override
    public List<FsFolder> getFolderByLevelCodeStringSecond(String levelCodeString) {
        return this.fsFolderMapper.getFolderByLevelCodeStringSecond(levelCodeString);
    }

    @Override
    public List<FsFolder> getFolderByLevelCodeStringThird(String levelCodeString) {
        return this.fsFolderMapper.getFolderByLevelCodeStringThird(levelCodeString);
    }
}

