/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.foldermanager.controller;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.docutil.service.DocConfigService;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolder;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.foldermanager.service.IDocFoldAuthorityService;
import com.jxdinfo.doc.manager.foldermanager.service.IFsFolderService;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/fsFolder"})
public class FsFolderController
extends BaseController {
    private String prefix = "/doc/manager/foldermanager/";
    @Autowired
    private IFsFolderService fsFolderService;
    @Autowired
    private IDocFoldAuthorityService docFoldAuthorityService;
    @Autowired
    private ISysIdtableService sysIdtableService;
    @Autowired
    private DocConfigService docConfigService;
    @Autowired
    private CacheToolService cacheToolService;
    @Autowired
    private DocGroupService docGroupService;

    @RequiresPermissions(value={"fsFolder:manager"})
    @RequestMapping(value={"/manager"})
    public String index() {
        return this.prefix + "folderManager.html";
    }

    @RequestMapping(value={"/powerManager"})
    public String indexAuth() {
        return this.prefix + "powerManager.html";
    }

    @RequestMapping(value={"/authority"})
    public String authority(String chooseFolder) {
        return "/doc/manager/docmanager/authority.html";
    }

    @RequestMapping(value={"/authorityPower"})
    public String authorityPower() {
        return this.prefix + "authorityPower.html";
    }

    @RequestMapping(value={"/getRoot"})
    @ResponseBody
    public Map getRoot() {
        List<FsFolder> list = this.fsFolderService.getRoot();
        HashMap<String, String> map = new HashMap<String, String>();
        FsFolder fsFolder = list.get(0);
        map.put("root", fsFolder.getFolderId());
        map.put("rootName", fsFolder.getFolderName());
        return map;
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public Object add(FsFolderParams fsFolderParams) {
        FsFolder fsFolder = new FsFolder();
        String userId = ShiroKit.getUser().getId();
        this.cacheToolService.updateLevelCodeCache(userId);
        fsFolder.setFolderId(fsFolderParams.getFolderId());
        fsFolder.setFolderName(fsFolderParams.getFolderName());
        fsFolder.setIsEdit(fsFolderParams.getIsEdit());
        fsFolder.setVisibleRange(fsFolderParams.getVisible());
        fsFolder.setParentFolderId(fsFolderParams.getParentFolderId());
        if (ToolUtil.isNotEmpty((Object)fsFolderParams.getFolderId())) {
            this.fsFolderService.updateFsFolder(fsFolder);
        } else {
            Date date = new Date();
            Timestamp ts = new Timestamp(date.getTime());
            fsFolder.setCreateTime(ts);
            String folderId = UUID.randomUUID().toString().replaceAll("-", "");
            fsFolder.setFolderId(folderId);
            fsFolder.setCreateUserId(userId);
            String folderParentId = fsFolder.getParentFolderId();
            if (folderParentId != null && !"".equals(folderParentId)) {
                FsFolder parentFolder = (FsFolder)((Object)this.fsFolderService.selectById((Serializable)((Object)folderParentId)));
                String parentCode = parentFolder.getLevelCode();
                String currentCode = this.fsFolderService.getCurrentLevelCode(parentCode, parentFolder.getFolderId());
                fsFolder.setLevelCode(currentCode);
            }
            String currentCode = this.sysIdtableService.getCurrentCode("FOLDER_NUM", "fs_folder");
            int num = Integer.parseInt(currentCode);
            fsFolder.setShowOrder(num);
            fsFolderParams.setFolderId(folderId);
            this.fsFolderService.insert((Object)fsFolder);
            this.docFoldAuthorityService.saveDocFoldAuthority(fsFolderParams);
        }
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/addCheck"})
    @ResponseBody
    public String addCheck(String name, String parentFolderId, String folderId) {
        String res = "true";
        List<FsFolder> list = this.fsFolderService.addCheck(parentFolderId, name, folderId);
        if (list.size() > 0) {
            return "false";
        }
        return res;
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public int delete(@RequestParam String fsFolderIds) {
        String userId = ShiroKit.getUser().getId();
        this.cacheToolService.updateLevelCodeCache(userId);
        String[] strArr = fsFolderIds.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String element : strArr) {
            String ids = this.fsFolderService.getChildFsFolder(element);
            String[] childArr = ids.split(",");
            list.addAll(Arrays.asList(childArr));
        }
        int num = this.fsFolderService.deleteInIds(list);
        this.docFoldAuthorityService.delete(new EntityWrapper().in("folder_id", list));
        return num;
    }

    @RequestMapping(value={"/checkChild"})
    @ResponseBody
    public String checkChild(@RequestParam String fsFolderIds, @RequestParam String id) {
        String[] strArr;
        String res = "success";
        for (String element : strArr = fsFolderIds.split(",")) {
            String ids = this.fsFolderService.getChildFsFolder(element);
            String[] childArr = ids.split(",");
            for (int i = 0; i < childArr.length; ++i) {
                if (!childArr[i].equals(id)) continue;
                res = "have";
            }
        }
        return res;
    }

    @RequestMapping(value={"/checkFolderType"})
    @ResponseBody
    public Object checkFolderType(@RequestParam String ids) {
        String flag = "success";
        String num = this.fsFolderService.checkChildType(ids);
        int fileNum = Integer.parseInt(num);
        if (fileNum > 0) {
            return "haveFile";
        }
        return flag;
    }

    @RequestMapping(value={"/getChildren"})
    @ResponseBody
    public Object getChildren(FsFolderParams fsFolderParams, String nameFlag) {
        return this.fsFolderService.getChildren(fsFolderParams, nameFlag);
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public String update(String ids, String parentFolderId, String folderName) {
        String res = "success";
        String parentLevelCode = ((FsFolder)((Object)this.fsFolderService.selectById((Serializable)((Object)parentFolderId)))).getLevelCode();
        if (folderName == null || "".equals(folderName)) {
            String userId = ShiroKit.getUser().getId();
            this.cacheToolService.updateLevelCodeCache(userId);
            String[] strArr = ids.split(",");
            ArrayList<FsFolder> listFs = new ArrayList<FsFolder>();
            for (String element : strArr) {
                int codeNum = this.fsFolderService.getChildCodeCount(element);
                int totalCode = parentLevelCode.length() / 3 + codeNum;
                String folderAmount = this.docConfigService.getConfigValueByKey("folder_amount");
                if (folderAmount == null || Integer.parseInt(folderAmount) < 4) {
                    folderAmount = "4";
                }
                if (totalCode > Integer.parseInt(folderAmount)) {
                    res = folderAmount;
                    return res;
                }
                FsFolder fsFolder = new FsFolder();
                fsFolder.setFolderId(element);
                fsFolder.setParentFolderId(parentFolderId);
                Date date = new Date();
                Timestamp ts = new Timestamp(date.getTime());
                fsFolder.setUpdateTime(ts);
                listFs.add(fsFolder);
            }
            this.fsFolderService.insertOrUpdateBatch(listFs);
            this.fsFolderService.addLevel(parentFolderId);
        } else {
            FsFolder fsFolder = new FsFolder();
            fsFolder.setFolderId(ids);
            fsFolder.setFolderName(folderName);
            Date date = new Date();
            Timestamp ts = new Timestamp(date.getTime());
            fsFolder.setUpdateTime(ts);
            this.fsFolderService.updateById((Object)fsFolder);
        }
        return res;
    }

    @RequestMapping(value={"/checkName"})
    @ResponseBody
    public String checkName(String nameStr, String folderPid) {
        String res = "success";
        String[] nameArr = nameStr.split("\\*");
        ArrayList list = new ArrayList();
        for (int i = 0; i < nameArr.length; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", nameArr[i]);
            list.add(map);
        }
        List<FsFolder> listFs = this.fsFolderService.countFolderName(folderPid, list);
        if (listFs.size() > 0) {
            res = "fail";
        }
        return res;
    }

    @RequestMapping(value={"/getTreeDataLazy"})
    @ResponseBody
    public List getTreeDataLazy(String id, String type) {
        return this.fsFolderService.getTreeDataLazy(id, type);
    }

    @RequestMapping(value={"/getAuthority"})
    @ResponseBody
    public List getAuthority(String folderId) {
        return this.fsFolderService.getAuthority(folderId);
    }

    @RequestMapping(value={"/editAuthority"})
    @ResponseBody
    public boolean editAuthority(FsFolderParams fsFolderEdit) {
        String userId = ShiroKit.getUser().getId();
        this.cacheToolService.updateLevelCodeCache(userId);
        String folderIds = fsFolderEdit.getFolderId();
        String folderNames = fsFolderEdit.getFolderName();
        boolean flag = false;
        Date date = new Date();
        if (folderIds.length() > 0) {
            String[] folderId = folderIds.split(",");
            String[] folderName = folderNames.split(",");
            for (int i = 0; i < folderId.length; ++i) {
                FsFolder fsFolder = new FsFolder();
                fsFolder.setUpdateUserId(userId);
                fsFolder.setFolderId(folderId[i]);
                fsFolder.setFolderName(folderName[i]);
                fsFolder.setIsEdit(fsFolderEdit.getIsEdit());
                fsFolder.setVisibleRange(fsFolderEdit.getVisible());
                Timestamp ts = new Timestamp(date.getTime());
                fsFolder.setUpdateTime(ts);
                fsFolderEdit.setFolderId(folderId[i]);
                this.fsFolderService.updateById((Object)fsFolder);
                this.docFoldAuthorityService.delete(new EntityWrapper().eq("folder_id", (Object)folderId[i]));
                flag = this.docFoldAuthorityService.saveDocFoldAuthority(fsFolderEdit);
            }
        } else {
            FsFolder fsFolder = new FsFolder();
            fsFolder.setUpdateUserId(userId);
            fsFolder.setFolderId(fsFolderEdit.getFolderId());
            fsFolder.setFolderName(fsFolderEdit.getFolderName());
            fsFolder.setIsEdit(fsFolderEdit.getIsEdit());
            fsFolder.setVisibleRange(fsFolderEdit.getVisible());
            Timestamp ts = new Timestamp(date.getTime());
            fsFolder.setUpdateTime(ts);
            this.fsFolderService.updateById((Object)fsFolder);
            this.docFoldAuthorityService.delete(new EntityWrapper().eq("folder_id", (Object)fsFolderEdit.getFolderId()));
            flag = this.docFoldAuthorityService.saveDocFoldAuthority(fsFolderEdit);
        }
        return flag;
    }

    @RequiresPermissions(value={"fsFolder:addLevel"})
    @RequestMapping(value={"/addLevel"})
    public void addLevel() {
        this.fsFolderService.addLevel(null);
    }

    @RequestMapping(value={"/folderAuthority"})
    public String folderAuthority() {
        return "/doc/manager/foldermanager/folderAuthority.html";
    }

    @RequestMapping(value={"/folderAuthority_manager"})
    public String folderAuthorityManager() {
        return "/doc/manager/foldermanager/folderAuthority_manager.html";
    }

    @RequestMapping(value={"/checkIsEdit"})
    @ResponseBody
    public boolean checkIsEdit(String chooseFolder) {
        return this.fsFolderService.getIsEdit(chooseFolder);
    }

    @RequestMapping(value={"/addFolder"})
    @ResponseBody
    public Object addFolder(FsFolderParams fsFolderParams) {
        int isEdits;
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        FsFolder fsFolder = new FsFolder();
        String userId = ShiroKit.getUser().getId();
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        this.cacheToolService.updateLevelCodeCache(userId);
        fsFolder.setFolderId(fsFolderParams.getFolderId());
        fsFolder.setFolderName(fsFolderParams.getFolderName());
        fsFolder.setIsEdit(fsFolderParams.getIsEdit());
        fsFolder.setVisibleRange(fsFolderParams.getVisible());
        fsFolder.setParentFolderId(fsFolderParams.getParentFolderId());
        List<String> listGroup = this.docGroupService.getPremission(userId);
        String parentId = fsFolderParams.getParentFolderId();
        FsFolder pFolder = (FsFolder)((Object)this.fsFolderService.selectById((Serializable)((Object)parentId)));
        String parentLevelCode = pFolder.getLevelCode();
        String folderAmount = this.docConfigService.getConfigValueByKey("folder_amount");
        if (folderAmount == null || Integer.parseInt(folderAmount) < 4) {
            folderAmount = "4";
        }
        if (parentLevelCode.length() / 3 >= Integer.parseInt(folderAmount) + 1) {
            result.put("fail", 1);
            result.put("folderAmount", folderAmount);
            return result;
        }
        if (adminFlag != 1 && (isEdits = this.docFoldAuthorityService.findEditByUpload(parentId, listGroup, userId)) != 2) {
            result.put("fail", 2);
            return result;
        }
        if (ToolUtil.isNotEmpty((Object)fsFolderParams.getFolderId())) {
            this.fsFolderService.updateFsFolder(fsFolder);
        } else {
            Date date = new Date();
            Timestamp ts = new Timestamp(date.getTime());
            fsFolder.setCreateTime(ts);
            String folderId = UUID.randomUUID().toString().replaceAll("-", "");
            fsFolder.setFolderId(folderId);
            fsFolder.setCreateUserId(userId);
            String folderParentId = fsFolder.getParentFolderId();
            if (folderParentId != null && !"".equals(folderParentId)) {
                FsFolder parentFolder = (FsFolder)((Object)this.fsFolderService.selectById((Serializable)((Object)folderParentId)));
                String parentCode = parentFolder.getLevelCode();
                String currentCode = this.fsFolderService.getCurrentLevelCode(parentCode, parentFolder.getFolderId());
                fsFolder.setLevelCode(currentCode);
            }
            String currentCode = this.sysIdtableService.getCurrentCode("FOLDER_NUM", "fs_folder");
            int num = Integer.parseInt(currentCode);
            fsFolder.setShowOrder(num);
            fsFolderParams.setFolderId(folderId);
            this.fsFolderService.insert((Object)fsFolder);
            this.docFoldAuthorityService.saveDocFoldAuthority(fsFolderParams);
            String levelCode = fsFolder.getLevelCode();
            String localName = "";
            for (int i = 2; i <= levelCode.length() / 3; ++i) {
                String levelCodeString = levelCode.substring(0, i * 3);
                String folderName = this.fsFolderService.getFolderNameByLevelCode(levelCodeString);
                localName = localName + ">" + folderName;
            }
            localName = localName.substring(1, localName.length());
            result.put("localName", localName);
            result.put("folderId", folderId);
        }
        return result;
    }

    @RequestMapping(value={"/addFolders"})
    @ResponseBody
    public Object addFolders(String pathContent, String categoryId) {
        int isEdits;
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        FsFolder fsFolder = new FsFolder();
        String userId = ShiroKit.getUser().getId();
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        String[] list = pathContent.split(",");
        List<String> listGroup = this.docGroupService.getPremission(userId);
        int max = 0;
        for (int i = 0; i < list.length; ++i) {
            String[] folderList = list[i].split("/");
            if (folderList.length - 1 <= max) continue;
            max = folderList.length - 1;
        }
        String parentLevelCode = ((FsFolder)((Object)this.fsFolderService.selectById((Serializable)((Object)categoryId)))).getLevelCode();
        String folderAmount = this.docConfigService.getConfigValueByKey("folder_amount");
        if (folderAmount == null || Integer.parseInt(folderAmount) < 4) {
            folderAmount = "4";
        }
        if (parentLevelCode.length() / 3 + max > Integer.parseInt(folderAmount) + 1) {
            result.put("fail", 1);
            result.put("folderAmount", folderAmount);
            return result;
        }
        if (adminFlag != 1 && (isEdits = this.docFoldAuthorityService.findEditByUpload(categoryId, listGroup, userId)) != 2) {
            result.put("fail", 2);
            return result;
        }
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<String> nameList = new ArrayList<String>();
        for (int i = 0; i < list.length; ++i) {
            String[] folderList = list[i].split("/");
            String folderId = categoryId;
            for (int j = 0; j < folderList.length - 1; ++j) {
                folderId = this.addFolder(folderList[j], folderId);
            }
            String levelCode = ((FsFolder)((Object)this.fsFolderService.selectById((Serializable)((Object)folderId)))).getLevelCode();
            String localName = "";
            for (int n = 2; n <= levelCode.length() / 3; ++n) {
                String levelCodeString = levelCode.substring(0, n * 3);
                String folderName = this.fsFolderService.getFolderNameByLevelCode(levelCodeString);
                localName = localName + ">" + folderName;
            }
            localName = localName.substring(1, localName.length());
            nameList.add(localName);
            idList.add(folderId);
        }
        result.put("idList", idList);
        result.put("localName", nameList);
        return result;
    }

    public String addFolder(String name, String id) {
        List<FsFolder> list = this.fsFolderService.addCheck(id, name, null);
        if (list.size() > 0) {
            return list.get(0).getFolderId();
        }
        Date date = new Date();
        FsFolder fsFolder = new FsFolder();
        fsFolder.setFolderName(name);
        fsFolder.setParentFolderId(id);
        FsFolderParams fsFolderParams = new FsFolderParams();
        Timestamp ts = new Timestamp(date.getTime());
        fsFolder.setCreateTime(ts);
        String folderId = UUID.randomUUID().toString().replaceAll("-", "");
        String userId = ShiroKit.getUser().getId();
        fsFolder.setFolderId(folderId);
        fsFolder.setCreateUserId(userId);
        String folderParentId = fsFolder.getParentFolderId();
        if (folderParentId != null && !"".equals(folderParentId)) {
            FsFolder parentFolder = (FsFolder)((Object)this.fsFolderService.selectById((Serializable)((Object)folderParentId)));
            String parentCode = parentFolder.getLevelCode();
            String currentCode = this.fsFolderService.getCurrentLevelCode(parentCode, parentFolder.getFolderId());
            fsFolder.setLevelCode(currentCode);
        }
        String currentCode = this.sysIdtableService.getCurrentCode("FOLDER_NUM", "fs_folder");
        int num = Integer.parseInt(currentCode);
        fsFolder.setShowOrder(num);
        fsFolderParams.setFolderId(folderId);
        fsFolderParams.setFolderName(name);
        this.fsFolderService.insert((Object)fsFolder);
        this.docFoldAuthorityService.saveDocFoldAuthority(fsFolderParams);
        return folderId;
    }
}

