/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.doctop.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.manager.doctop.model.DocTop;
import com.jxdinfo.doc.manager.doctop.service.DocTopService;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/top"})
public class DocTopController {
    @Autowired
    private ISysIdtableService sysIdtableService;
    @Autowired
    private DocTopService docTopService;

    @RequestMapping(value={"/addCheck"})
    @ResponseBody
    public String addCheck(String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        List<DocTop> listTop = this.docTopService.addCheck(list);
        if (listTop.size() > 0) {
            return "false";
        }
        return "true";
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public String add(String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        try {
            for (int i = 0; i < list.size(); ++i) {
                DocTop docTop = new DocTop();
                docTop.setTopId(UUID.randomUUID().toString().replaceAll("-", ""));
                docTop.setDocId(list.get(i));
                this.docTopService.add(docTop);
            }
            return "true";
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/topListView"})
    public String topicListView() {
        return "/doc/manager/doctop/top-list.html";
    }

    @RequestMapping(value={"/topList"})
    @ResponseBody
    public JSON topList(String title, int page, int limit) {
        int beginIndex = page * limit - limit;
        String bannerNameStr = StringUtil.transferSqlParam((String)title);
        List<Map> bannerList = this.docTopService.topList(bannerNameStr, beginIndex, limit);
        int bannerCount = this.docTopService.topListCount(bannerNameStr);
        JSONObject json = new JSONObject();
        json.put("count", (Object)bannerCount);
        json.put("data", bannerList);
        json.put("msg", (Object)"success");
        json.put("code", (Object)0);
        return json;
    }

    @RequestMapping(value={"/delTops"})
    @ResponseBody
    public int delBannersById(Map<String, String> param, String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        return this.docTopService.delTops(list);
    }

    @RequestMapping(value={"/moveTop"})
    @ResponseBody
    public int moveTop(String table, String idColumn, String idOne, String idTwo) {
        int num = this.docTopService.moveTop(table, idColumn, idTwo, idOne);
        return num;
    }
}

