/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.docrecycle.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.ESUtil;
import com.jxdinfo.doc.common.util.FileTool;
import com.jxdinfo.doc.manager.docmanager.dao.DocInfoMapper;
import com.jxdinfo.doc.manager.docmanager.model.DocInfo;
import com.jxdinfo.doc.manager.docrecycle.dao.DocRecycleMapper;
import com.jxdinfo.doc.manager.docrecycle.model.DocRecycle;
import com.jxdinfo.doc.manager.docrecycle.service.IDocRecycleService;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DocRecycleServiceImpl
extends ServiceImpl<DocRecycleMapper, DocRecycle>
implements IDocRecycleService {
    @Resource
    private DocRecycleMapper docRecycleMapper;
    @Resource
    private DocInfoMapper docInfoMapper;
    @Resource
    private CacheToolService cacheToolService;
    @Resource
    private ESUtil esUtil;
    @Resource
    private DocGroupService docGroupService;

    @Override
    public Map<String, Object> getDocRecycleList(String pageNum, String limitNum, String fileName) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (ToolUtil.isNotEmpty((Object)pageNum) && ToolUtil.isNotEmpty((Object)limitNum)) {
            Page pages = new Page(Integer.valueOf(pageNum).intValue(), Integer.valueOf(limitNum).intValue());
            List roleList = ShiroKit.getUser().getRolesList();
            Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
            String userId = null;
            if (adminFlag != 1) {
                userId = ShiroKit.getUser().getId();
            }
            List<DocRecycle> list = this.docRecycleMapper.getDocRecycleList(pages, fileName, userId);
            for (DocRecycle docRecycle : list) {
                if (docRecycle.getFileSize() == null || "".equals(docRecycle.getFileSize())) continue;
                docRecycle.setFileSize(FileTool.longToString(docRecycle.getFileSize()));
            }
            map.put("count", pages.getTotal());
            map.put("data", list);
            map.put("code", 0);
            return map;
        }
        map.put("data", null);
        map.put("code", "500");
        map.put("msg", "\u53c2\u6570\u4e0d\u7b26");
        map.put("count", null);
        return map;
    }

    @Override
    public Map<String, Object> getDocRecycleList(String pageNum, String limitNum, String fileName, String order) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (ToolUtil.isNotEmpty((Object)pageNum) && ToolUtil.isNotEmpty((Object)limitNum)) {
            Page pages = new Page(Integer.valueOf(pageNum).intValue(), Integer.valueOf(limitNum).intValue());
            List roleList = ShiroKit.getUser().getRolesList();
            Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
            String userId = null;
            String levelCodes = null;
            if (adminFlag != 1) {
                userId = ShiroKit.getUser().getId();
                String orgId = ShiroKit.getUser().getDeptName();
                FsFolderParams fsFolderParams = new FsFolderParams();
                List<String> listGroup = this.docGroupService.getPremission(userId);
                fsFolderParams.setGroupList(listGroup);
                fsFolderParams.setUserId(userId);
                fsFolderParams.setType("1");
                String groupIds = String.join((CharSequence)",", fsFolderParams.getGroupList());
                levelCodes = this.cacheToolService.getLevelCodeByUserByUploadCache(groupIds, userId, "2", orgId);
                if (levelCodes == null) {
                    levelCodes = "";
                }
                if (levelCodes.indexOf(",") == 0) {
                    levelCodes = levelCodes.substring(1, levelCodes.length());
                    levelCodes = "('" + levelCodes.replace(",", "','") + "')";
                } else {
                    levelCodes = "('')";
                }
            }
            List<DocRecycle> list = this.docRecycleMapper.getDocRecycleOrderedList(pages, fileName, userId, order, levelCodes);
            for (DocRecycle docRecycle : list) {
                if (docRecycle.getFileSize() == null || "".equals(docRecycle.getFileSize())) continue;
                docRecycle.setFileSize(FileTool.longToString(docRecycle.getFileSize()));
            }
            map.put("count", pages.getTotal());
            map.put("data", list);
            map.put("code", 0);
            return map;
        }
        map.put("data", null);
        map.put("code", "500");
        map.put("msg", "\u53c2\u6570\u4e0d\u7b26");
        map.put("count", null);
        return map;
    }

    @Override
    @Transactional(rollbackFor={SQLException.class})
    public boolean restore(String fileId, String folderId) {
        DocInfo docInfo = new DocInfo();
        docInfo.setFoldId(folderId);
        docInfo.setValidFlag("1");
        Object[] fileIds = fileId.split(",");
        this.docRecycleMapper.delete(new EntityWrapper().in("file_id", fileIds));
        this.docInfoMapper.update(docInfo, new EntityWrapper().in("file_id", fileIds));
        for (Object id : fileIds) {
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("recycle", "1");
            this.esUtil.updateIndex((String)id, map);
        }
        return true;
    }

    @Override
    public boolean clear() {
        String deleteUserId = null;
        String levelCodes = null;
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        if (adminFlag != 1) {
            deleteUserId = ShiroKit.getUser().getId();
            String orgId = ShiroKit.getUser().getDeptName();
            FsFolderParams fsFolderParams = new FsFolderParams();
            List<String> listGroup = this.docGroupService.getPremission(deleteUserId);
            fsFolderParams.setGroupList(listGroup);
            fsFolderParams.setUserId(deleteUserId);
            fsFolderParams.setType("1");
            String groupIds = String.join((CharSequence)",", fsFolderParams.getGroupList());
            levelCodes = this.cacheToolService.getLevelCodeByUserByUploadCache(groupIds, deleteUserId, "2", orgId);
            if (levelCodes == null) {
                levelCodes = "";
            }
            if (levelCodes.indexOf(",") == 0) {
                levelCodes = levelCodes.substring(1, levelCodes.length());
                levelCodes = "('" + levelCodes.replace(",", "','") + "')";
            } else {
                levelCodes = "('')";
            }
        }
        List<DocRecycle> list = this.docRecycleMapper.getDocRecycleOrderedList(new Page(1, 1000), null, deleteUserId, null, levelCodes);
        this.docRecycleMapper.updateDocRecycle(deleteUserId, levelCodes);
        for (DocRecycle doc : list) {
            this.esUtil.deleteIndex(doc.getRecycleId());
        }
        return true;
    }

    @Override
    public boolean checkDocExist(String folderId, String fileName) {
        fileName = "'" + fileName.replace(",", "','") + "'";
        int num = this.docRecycleMapper.checkDocExist(folderId, fileName);
        return num > 0;
    }
}

