/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.docmanager.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.jxdinfo.doc.common.constant.DocConstant;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.util.ESUtil;
import com.jxdinfo.doc.common.util.MathUtil;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.front.personalmanager.model.DocVersion;
import com.jxdinfo.doc.front.personalmanager.service.DocVersionService;
import com.jxdinfo.doc.manager.docconfigure.model.DocConfigure;
import com.jxdinfo.doc.manager.docconfigure.service.DocConfigureService;
import com.jxdinfo.doc.manager.docmanager.model.DocFileAuthority;
import com.jxdinfo.doc.manager.docmanager.model.DocInfo;
import com.jxdinfo.doc.manager.docmanager.model.DocResourceLog;
import com.jxdinfo.doc.manager.docmanager.model.FsFile;
import com.jxdinfo.doc.manager.docmanager.service.DocFileAuthorityService;
import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.doc.manager.docmanager.service.FilesService;
import com.jxdinfo.doc.manager.docmanager.service.FsFileService;
import com.jxdinfo.doc.manager.topicmanager.dao.SpecialTopicFilesMapper;
import com.jxdinfo.doc.manager.topicmanager.model.SpecialTopicFiles;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/breakpointUpload"})
public class BreakpointUploadController
extends BaseController {
    private static Logger logger = LogManager.getLogger(BreakpointUploadController.class);
    @Autowired
    private HussarProperties hussarProperties;
    @Resource
    private DocConfigureService docConfigureService;
    @Autowired
    private DocInfoService idocInfoService;
    @Autowired
    private FsFileService fsFileService;
    @Autowired
    private DocVersionService docVersionService;
    @Autowired
    private DocFileAuthorityService docFileAuthorityService;
    @Autowired
    private ESUtil esUtil;
    @Value(value="${docbase.filedir}")
    private String tempdir;
    @Value(value="${docbase.breakdir}")
    private String breakdir;
    @Autowired
    private FilesService filesService;
    @Autowired
    private HussarCacheManager cacheManager;
    @Autowired
    private CacheToolService cacheToolService;
    @Autowired
    private SpecialTopicFilesMapper specialTopicFilesMapper;

    @RequestMapping(value={"/view"})
    public String index() {
        return "/doc/manager/docmanager/breakpointUpload.html";
    }

    @RequestMapping(value={"selectProgressByFileName"})
    @ResponseBody
    public String selectProgressByFileName(String fileName) {
        String present = "0";
        if (ToolUtil.isNotEmpty((Object)fileName)) {
            present = ObjectUtils.toString((Object)this.cacheManager.getObject("file_upload", "jindutiao_" + fileName));
        }
        return "{jindutiao :'" + present + "'}";
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/fileSave"})
    @ResponseBody
    public void fileSave(@RequestPart(value="file") MultipartFile uploadFile) {
        String savePath = this.breakdir;
        String fileMd5 = super.getPara("fileMd5");
        String chunk = super.getPara("chunk");
        String fileName = uploadFile.getOriginalFilename();
        try {
            File file = new File(savePath + File.separator + this.cacheManager.getObject("file_upload", "fileName_" + fileName));
            if (!file.exists()) {
                file.mkdir();
            }
            File chunkFile = new File(savePath + File.separator + this.cacheManager.getObject("file_upload", "fileName_" + fileName) + File.separator + chunk);
            FileUtils.copyInputStreamToFile((InputStream)uploadFile.getInputStream(), (File)chunkFile);
        }
        catch (Exception e) {
            logger.error("IO Exception\uff1a", (Throwable)e);
        }
    }

    @RequestMapping(value={"mergeOrCheckChunks"})
    @ResponseBody
    public String mergeOrCheckChunks(HttpServletRequest request, HttpServletResponse response, String categoryId, String downloadAble, String visible, String group, String person, String watermarkUser, String watermarkCompany, String fileName, String shareable) {
        logger.info("******************\u6587\u4ef6:" + fileName + "\u5f00\u59cb\u4e0a\u4f20******************");
        String fileMd5 = super.getPara("fileMd5");
        String param = super.getPara("param");
        String json = "";
        String savePath = this.breakdir;
        if ("mergeChunks".equals(param)) {
            try {
                String idStr;
                File f = new File(savePath + File.separator + this.cacheManager.getObject("file_upload", "fileName_" + fileName));
                File[] fileArray = f.listFiles();
                ArrayList<File> fileList = new ArrayList<File>(Arrays.asList(fileArray));
                Collections.sort(fileList, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        if (Integer.parseInt(o1.getName()) < Integer.parseInt(o2.getName())) {
                            return -1;
                        }
                        return 1;
                    }
                });
                int pointIndex = fileName.lastIndexOf(".");
                String suffix = fileName.substring(pointIndex).toLowerCase();
                String random = UUID.randomUUID().toString().replace("-", "");
                File outputFile = new File(this.tempdir + File.separator + random + suffix);
                try {
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    outputFile.createNewFile();
                }
                catch (IOException e) {
                    logger.error("IO Exception\uff1a", (Throwable)e);
                    HashMap<String, String> resultMap = new HashMap<String, String>();
                    resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                    json = JSONObject.toJSONString(resultMap);
                    return json;
                }
                FileChannel outChannel = new FileOutputStream(outputFile).getChannel();
                FileInputStream fileInputStream = new FileInputStream(outputFile);
                for (File file : fileList) {
                    FileChannel inChannel = new FileInputStream(file).getChannel();
                    byte[] data = null;
                    data = new byte[(int)inChannel.size()];
                    fileInputStream.read(data);
                    try {
                        inChannel.transferTo(0L, inChannel.size(), outChannel);
                    }
                    catch (Exception e) {
                        logger.error(" Exception:", (Throwable)e);
                        HashMap<String, String> resultMap = new HashMap<String, String>();
                        resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                        json = JSONObject.toJSONString(resultMap);
                        return json;
                    }
                    try {
                        inChannel.close();
                    }
                    catch (IOException e) {
                        logger.error("IO Exception\uff1a", (Throwable)e);
                        HashMap<String, String> resultMap = new HashMap<String, String>();
                        resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                        json = JSONObject.toJSONString(resultMap);
                        return json;
                    }
                    file.delete();
                }
                fileInputStream.close();
                logger.info("******************\u6587\u4ef6:" + fileName + "\u521b\u5efa\u6210\u529f\uff0c\u8def\u5f84\u4e3a" + outputFile.getPath() + ",\u5927\u5c0f\u4e3a" + outputFile.length() + "******************");
                String userId = UserInfoUtil.getUserInfo().get("ID").toString();
                try {
                    String docId;
                    String contentType = this.getContentType(suffix.toLowerCase());
                    Timestamp ts = new Timestamp(System.currentTimeMillis());
                    DocInfo docInfo = new DocInfo();
                    idStr = docId = UUID.randomUUID().toString().replace("-", "");
                    docInfo.setDocId(docId);
                    docInfo.setFileId(outputFile.getName());
                    docInfo.setUserId(userId);
                    docInfo.setAuthorId(userId);
                    docInfo.setContactsId(userId);
                    docInfo.setCreateTime(ts);
                    docInfo.setFoldId(categoryId);
                    docInfo.setDocType(suffix);
                    docInfo.setTitle(fileName.substring(0, fileName.lastIndexOf(".")));
                    docInfo.setReadNum(0);
                    docInfo.setDownloadNum(0);
                    docInfo.setValidFlag(visible);
                    docInfo.setAuthority(downloadAble);
                    docInfo.setSetAuthority("0");
                    docInfo.setVisibleRange(Integer.parseInt(visible));
                    docInfo.setWatermarkUser(watermarkUser);
                    docInfo.setWatermarkCompany(watermarkCompany);
                    docInfo.setValidFlag("1");
                    docInfo.setShareFlag(shareable);
                    FsFile fileModel = new FsFile();
                    fileModel.setCreateTime(ts);
                    fileModel.setFileIcon("");
                    fileModel.setFileId(docId);
                    if (watermarkCompany == null || "".equals(watermarkCompany)) {
                        fileModel.setMd5(fileMd5);
                    }
                    fileModel.setFileName(fileName.substring(0, fileName.lastIndexOf(".")));
                    double size = MathUtil.getDecimal((double)(outputFile.length() / 1024L), (int)2);
                    fileModel.setFileSize(size + "KB");
                    Map<String, Object> deptSpaceIsFreeMap = this.filesService.checkDeptSpace(StringUtil.getString((Object)size));
                    Boolean deptSpaceIsFree = StringUtil.getBoolean((Object)deptSpaceIsFreeMap.get("flag"));
                    if (!deptSpaceIsFree.booleanValue()) {
                        HashMap<String, String> resultMap = new HashMap<String, String>();
                        resultMap.put("code", DocConstant.UPLOADRESULT.NOSPACE.getValue());
                        return JSON.toJSONString(resultMap);
                    }
                    fileModel.setFileType(suffix);
                    ArrayList<DocResourceLog> resInfoList = new ArrayList<DocResourceLog>();
                    DocResourceLog docResourceLog = new DocResourceLog();
                    String id = UUID.randomUUID().toString().replace("-", "");
                    docResourceLog.setId(id);
                    docResourceLog.setResourceId(docId);
                    docResourceLog.setOperateTime(ts);
                    docResourceLog.setResourceType(0);
                    docResourceLog.setUserId(userId);
                    docResourceLog.setOperateType(0);
                    resInfoList.add(docResourceLog);
                    ArrayList<DocFileAuthority> list = new ArrayList<DocFileAuthority>();
                    ArrayList<String> indexList = new ArrayList<String>();
                    DocFileAuthority docFileAuthority = new DocFileAuthority();
                    docFileAuthority.setFileAuthorityId(UUID.randomUUID().toString().replaceAll("-", ""));
                    docFileAuthority.setAuthorId("allpersonflag");
                    docFileAuthority.setAuthorType(3);
                    docFileAuthority.setFileId(docId);
                    docFileAuthority.setAuthority(0);
                    list.add(docFileAuthority);
                    indexList.add("allpersonflag");
                    indexList.add(userId);
                    outChannel.close();
                    fileInputStream.close();
                    this.cacheToolService.updateLevelCodeCache(userId);
                    this.filesService.uploadFile(outputFile, docInfo, fileModel, resInfoList, list, indexList, contentType);
                }
                catch (IOException e) {
                    logger.error("IO Exception\uff1a", (Throwable)e);
                    HashMap<String, String> resultMap = new HashMap<String, String>();
                    resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                    json = JSONObject.toJSONString(resultMap);
                    return json;
                }
                File tempFile = new File(savePath + File.separator + this.cacheManager.getObject("file_upload", "fileName_" + fileName));
                if (tempFile.isDirectory() && tempFile.exists()) {
                    tempFile.delete();
                }
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("lastUploadTime", ObjectUtils.toString((Object)this.cacheManager.getObject("file_upload", "lastUploadTime_" + fileName)));
                resultMap.put("pathFileName", this.cacheManager.getObject("file_upload", "fileName_" + fileName) + suffix);
                resultMap.put("code", DocConstant.UPLOADRESULT.SUCCESS.getValue());
                resultMap.put("id", idStr);
                resultMap.put("authorId", userId);
                this.cacheManager.delete("file_upload", "jindutiao_" + fileName);
                this.cacheManager.delete("file_upload", "lastUploadTime_" + fileName);
                this.cacheManager.delete("file_upload", "fileName_" + fileName);
                json = JSONObject.toJSONString(resultMap);
            }
            catch (Exception e) {
                logger.error("file merge failure:", (Throwable)e);
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                json = JSONObject.toJSONString(resultMap);
                return json;
            }
        }
        if ("checkChunk".equals(param)) {
            String chunk = super.getPara("chunk");
            String chunkSize = super.getPara("chunkSize");
            String jindutiao = super.getPara("jindutiao");
            try {
                File checkFile;
                this.cacheManager.setObject("file_upload", "jindutiao_" + fileName, (Object)jindutiao);
                String lastUploadTime = DateUtil.getTime();
                this.cacheManager.setObject("file_upload", "lastUploadTime_" + fileName, (Object)lastUploadTime);
                String tempFileName = ObjectUtils.toString((Object)System.currentTimeMillis());
                if (ToolUtil.isEmpty((Object)this.cacheManager.getObject("file_upload", "fileName_" + fileName))) {
                    this.cacheManager.setObject("file_upload", "fileName_" + fileName, (Object)(fileMd5 + tempFileName));
                }
                json = (checkFile = new File(savePath + File.separator + this.cacheManager.getObject("file_upload", "fileName_" + fileName) + File.separator + chunk)).exists() && checkFile.length() == (long)Integer.parseInt(chunkSize) ? "{\"ifExist\":1}" : "{\"ifExist\":0}";
            }
            catch (Exception e) {
                logger.error("file check failure:", (Throwable)e);
            }
        }
        return json;
    }

    @RequestMapping(value={"mergeOrCheckVersionChunks"})
    @ResponseBody
    public String mergeOrCheckVersionChunks(HttpServletRequest request, HttpServletResponse response, String categoryId, String downloadAble, String visible, String group, String person, String watermarkUser, String watermarkCompany, String fileName, String shareable, String oldDocId) {
        String fileMd5 = super.getPara("fileMd5");
        String param = super.getPara("param");
        String json = "";
        String savePath = this.breakdir;
        if ("mergeChunks".equals(param)) {
            try {
                String idStr;
                File f = new File(savePath + File.separator + this.cacheManager.getObject("file_upload", "fileName_" + fileName));
                File[] fileArray = f.listFiles();
                ArrayList<File> fileList = new ArrayList<File>(Arrays.asList(fileArray));
                Collections.sort(fileList, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        if (Integer.parseInt(o1.getName()) < Integer.parseInt(o2.getName())) {
                            return -1;
                        }
                        return 1;
                    }
                });
                int pointIndex = fileName.lastIndexOf(".");
                String suffix = fileName.substring(pointIndex).toLowerCase();
                String random = UUID.randomUUID().toString().replace("-", "");
                File outputFile = new File(this.tempdir + File.separator + random + suffix);
                try {
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    outputFile.createNewFile();
                }
                catch (IOException e) {
                    logger.error("IO Exception\uff1a", (Throwable)e);
                    HashMap<String, String> resultMap = new HashMap<String, String>();
                    resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                    json = JSONObject.toJSONString(resultMap);
                    return json;
                }
                FileChannel outChannel = new FileOutputStream(outputFile).getChannel();
                FileInputStream fileInputStream = new FileInputStream(outputFile);
                for (File file : fileList) {
                    FileChannel inChannel = new FileInputStream(file).getChannel();
                    byte[] data = null;
                    data = new byte[(int)inChannel.size()];
                    fileInputStream.read(data);
                    try {
                        inChannel.transferTo(0L, inChannel.size(), outChannel);
                    }
                    catch (Exception e) {
                        logger.error(" Exception\uff1a", (Throwable)e);
                        HashMap<String, String> resultMap = new HashMap<String, String>();
                        resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                        json = JSONObject.toJSONString(resultMap);
                        return json;
                    }
                    try {
                        inChannel.close();
                    }
                    catch (IOException e) {
                        logger.error("IO Exception\uff1a", (Throwable)e);
                        HashMap<String, String> resultMap = new HashMap<String, String>();
                        resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                        json = JSONObject.toJSONString(resultMap);
                        return json;
                    }
                    file.delete();
                }
                fileInputStream.close();
                logger.info("******************\u6587\u4ef6:" + fileName + "\u521b\u5efa\u6210\u529f\uff0c\u8def\u5f84\u4e3a" + outputFile.getPath() + ",\u5927\u5c0f\u4e3a" + outputFile.length() + "******************");
                String userId = UserInfoUtil.getUserInfo().get("ID").toString();
                try {
                    String docId;
                    String contentType = this.getContentType(suffix.toLowerCase());
                    DocInfo oldDocInfo = (DocInfo)this.idocInfoService.selectOne(new EntityWrapper().eq("doc_id", (Object)oldDocId));
                    if (this.docVersionService.selectCount(new EntityWrapper().eq("doc_id", (Object)oldDocId)) == 0) {
                        DocVersion oldVersion = new DocVersion();
                        oldVersion.setDocId(oldDocId);
                        oldVersion.setVersionReference(UUID.randomUUID().toString().replace("-", ""));
                        oldVersion.setValidFlag("1");
                        oldVersion.setApplyTime(oldDocInfo.getCreateTime());
                        oldVersion.setApplyUserId(oldDocInfo.getUserId());
                        this.docVersionService.insert((Object)oldVersion);
                    }
                    Timestamp ts = new Timestamp(System.currentTimeMillis());
                    DocInfo docInfo = new DocInfo();
                    idStr = docId = UUID.randomUUID().toString().replace("-", "");
                    docInfo.setDocId(docId);
                    docInfo.setFileId(outputFile.getName());
                    docInfo.setUserId(userId);
                    docInfo.setAuthorId(userId);
                    docInfo.setContactsId(userId);
                    docInfo.setCreateTime(ts);
                    docInfo.setFoldId(categoryId);
                    docInfo.setDocType(suffix);
                    docInfo.setTitle(fileName.substring(0, fileName.lastIndexOf(".")));
                    docInfo.setReadNum(oldDocInfo.getReadNum());
                    docInfo.setDownloadNum(oldDocInfo.getDownloadNum());
                    docInfo.setTags(oldDocInfo.getTags());
                    docInfo.setAuthority(downloadAble);
                    docInfo.setSetAuthority("0");
                    docInfo.setVisibleRange(Integer.parseInt(visible));
                    docInfo.setWatermarkUser(watermarkUser);
                    docInfo.setWatermarkCompany(watermarkCompany);
                    docInfo.setValidFlag("1");
                    docInfo.setShareFlag(oldDocInfo.getShareFlag());
                    FsFile fileModel = new FsFile();
                    fileModel.setCreateTime(ts);
                    fileModel.setFileIcon("");
                    fileModel.setFileId(docId);
                    if (watermarkCompany == null || "".equals(watermarkCompany)) {
                        fileModel.setMd5(fileMd5);
                    }
                    fileModel.setFileName(fileName.substring(0, fileName.lastIndexOf(".")));
                    double size = MathUtil.getDecimal((double)(outputFile.length() / 1024L), (int)2);
                    fileModel.setFileSize(size + "KB");
                    Map<String, Object> deptSpaceIsFreeMap = this.filesService.checkDeptSpace(StringUtil.getString((Object)size));
                    Boolean deptSpaceIsFree = StringUtil.getBoolean((Object)deptSpaceIsFreeMap.get("flag"));
                    if (!deptSpaceIsFree.booleanValue()) {
                        HashMap<String, String> resultMap = new HashMap<String, String>();
                        resultMap.put("code", DocConstant.UPLOADRESULT.NOSPACE.getValue());
                        return JSON.toJSONString(resultMap);
                    }
                    fileModel.setFileType(suffix);
                    ArrayList<DocResourceLog> resInfoList = new ArrayList<DocResourceLog>();
                    DocResourceLog docResourceLog = new DocResourceLog();
                    String id = UUID.randomUUID().toString().replace("-", "");
                    docResourceLog.setId(id);
                    docResourceLog.setResourceId(docId);
                    docResourceLog.setOperateTime(ts);
                    docResourceLog.setResourceType(0);
                    docResourceLog.setUserId(userId);
                    docResourceLog.setOperateType(0);
                    resInfoList.add(docResourceLog);
                    List<DocFileAuthority> list = new ArrayList();
                    ArrayList<String> indexList = new ArrayList<String>();
                    list = this.docFileAuthorityService.selectList(new EntityWrapper().eq("file_id", (Object)oldDocId));
                    for (int i = 0; i < list.size(); ++i) {
                        DocFileAuthority item = (DocFileAuthority)((Object)list.get(i));
                        String esId = item.getAuthorId();
                        if (item.getAuthorType() == 2) {
                            esId = item.getOrganId();
                        }
                        indexList.add(esId);
                        ((DocFileAuthority)((Object)list.get(i))).setFileId(docId);
                        list.get(i).setFileAuthorityId(null);
                    }
                    indexList.add(userId);
                    outChannel.close();
                    fileInputStream.close();
                    this.cacheToolService.updateLevelCodeCache(userId);
                    this.filesService.uploadFile(outputFile, docInfo, fileModel, resInfoList, list, indexList, contentType);
                    this.idocInfoService.updateValidFlag(oldDocId, "0");
                    HashMap<String, Object> map = new HashMap<String, Object>(1);
                    map.put("recycle", DocConstant.VALIDTYPE.INVALID.getValue());
                    this.esUtil.updateIndex(oldDocId, map);
                    HashMap<String, Object> mapTip = new HashMap<String, Object>(1);
                    mapTip.put("tags", oldDocInfo.getTags());
                    this.esUtil.updateIndex(docId, mapTip);
                    List<SpecialTopicFiles> topics = this.specialTopicFilesMapper.selectTopicsByDocId(oldDocId);
                    if (topics != null && topics.size() != 0) {
                        for (int i = 0; i < topics.size(); ++i) {
                            topics.get(i).setTopicFileId(UUID.randomUUID().toString().replace("-", ""));
                            topics.get(i).setDocId(docId);
                        }
                        this.specialTopicFilesMapper.addSpecialTopicFiles(topics);
                    }
                    DocVersion oldVersion = (DocVersion)((Object)this.docVersionService.selectOne(new EntityWrapper().eq("doc_id", (Object)oldDocId)));
                    DocVersion newVersion = new DocVersion();
                    newVersion.setVersionReference(oldVersion.getVersionReference());
                    newVersion.setDocId(docInfo.getDocId());
                    newVersion.setValidFlag("1");
                    newVersion.setApplyTime(docInfo.getCreateTime());
                    newVersion.setApplyUserId(docInfo.getUserId());
                    this.docVersionService.insert((Object)newVersion);
                }
                catch (IOException e) {
                    logger.error("IO Exception\uff1a", (Throwable)e);
                    HashMap<String, String> resultMap = new HashMap<String, String>();
                    resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                    json = JSONObject.toJSONString(resultMap);
                    return json;
                }
                File tempFile = new File(savePath + File.separator + this.cacheManager.getObject("file_upload", "fileName_" + fileName));
                if (tempFile.isDirectory() && tempFile.exists()) {
                    tempFile.delete();
                }
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("lastUploadTime", ObjectUtils.toString((Object)this.cacheManager.getObject("file_upload", "lastUploadTime_" + fileName)));
                resultMap.put("pathFileName", this.cacheManager.getObject("file_upload", "fileName_" + fileName) + suffix);
                resultMap.put("code", DocConstant.UPLOADRESULT.SUCCESS.getValue());
                resultMap.put("id", idStr);
                resultMap.put("authorId", userId);
                this.cacheManager.delete("file_upload", "jindutiao_" + fileName);
                this.cacheManager.delete("file_upload", "lastUploadTime_" + fileName);
                this.cacheManager.delete("file_upload", "fileName_" + fileName);
                json = JSONObject.toJSONString(resultMap);
            }
            catch (Exception e) {
                logger.error("file merge failure:", (Throwable)e);
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("code", DocConstant.UPLOADRESULT.FAIL.getValue());
                json = JSONObject.toJSONString(resultMap);
                return json;
            }
        }
        if ("checkChunk".equals(param)) {
            String chunk = super.getPara("chunk");
            String chunkSize = super.getPara("chunkSize");
            String jindutiao = super.getPara("jindutiao");
            try {
                File checkFile;
                this.cacheManager.setObject("file_upload", "jindutiao_" + fileName, (Object)jindutiao);
                String lastUploadTime = DateUtil.getTime();
                this.cacheManager.setObject("file_upload", "lastUploadTime_" + fileName, (Object)lastUploadTime);
                String tempFileName = ObjectUtils.toString((Object)System.currentTimeMillis());
                if (ToolUtil.isEmpty((Object)this.cacheManager.getObject("file_upload", "fileName_" + fileName))) {
                    this.cacheManager.setObject("file_upload", "fileName_" + fileName, (Object)(fileMd5 + tempFileName));
                }
                json = (checkFile = new File(savePath + File.separator + this.cacheManager.getObject("file_upload", "fileName_" + fileName) + File.separator + chunk)).exists() && checkFile.length() == (long)Integer.parseInt(chunkSize) ? "{\"ifExist\":1}" : "{\"ifExist\":0}";
            }
            catch (Exception e) {
                logger.error("file check failure:", (Throwable)e);
            }
        }
        return json;
    }

    @RequestMapping(value={"/checkFileExist"})
    @ResponseBody
    public JSON checkFileExist(String fileName, String pid) {
        JSONObject json = new JSONObject();
        ArrayList<String> docNameList = new ArrayList<String>();
        docNameList.add(fileName);
        List<String> nameList = this.idocInfoService.checkFileExist(docNameList, pid);
        json.put("result", nameList);
        return json;
    }

    @RequestMapping(value={"/checkMd5Exist"})
    @ResponseBody
    public JSON checkMd5Exist(String fileName, String categoryId, String downloadAble, String visible, String group, String person, String watermarkUser, String watermarkCompany, String shareable) {
        JSONObject json = new JSONObject();
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        String fileMd5 = super.getPara("fileMd5");
        ArrayList<String> docNameList = new ArrayList<String>();
        int pointIndex = fileName.lastIndexOf(".");
        String suffix = fileName.substring(pointIndex + 1);
        docNameList.add(fileName);
        if (fileName.length() > 64) {
            HashMap resultMap = new HashMap();
            json.put("code", (Object)DocConstant.UPLOADRESULT.NAMELONG.getValue());
            return json;
        }
        String regex = "^[^'\"\\|\\\\]*$";
        if (!Pattern.compile(regex).matcher(fileName).find()) {
            HashMap resultMap = new HashMap();
            json.put("code", (Object)DocConstant.UPLOADRESULT.NAMEERROR.getValue());
            return json;
        }
        List<DocConfigure> typeList = this.docConfigureService.getConfigure();
        if (typeList.get(0).getConfigValue().contains(suffix.toLowerCase())) {
            HashMap resultMap = new HashMap();
            json.put("code", (Object)DocConstant.UPLOADRESULT.ERRORTYPE.getValue());
            return json;
        }
        List<String> nameList = this.idocInfoService.checkFileExist(docNameList, categoryId);
        if (nameList != null && nameList.size() != 0) {
            HashMap resultMap = new HashMap();
            json.put("name", (Object)nameList.get(0));
            json.put("code", (Object)DocConstant.UPLOADRESULT.FILEEXIST.getValue());
            json.put("docId", (Object)this.idocInfoService.selectExistId(docNameList, categoryId).get(0));
            return json;
        }
        List<FsFile> list = this.fsFileService.getInfoByMd5(fileMd5);
        if (list == null || list.size() == 0 || !"".equals(watermarkCompany)) {
            json.put("code", (Object)DocConstant.UPLOADRESULT.SUCCESS.getValue());
        } else {
            FsFile fsFile = list.get(0);
            Map<String, Object> deptSpaceIsFreeMap = this.filesService.checkDeptSpace(StringUtil.getString((Object)fsFile.getFileSize()));
            Boolean deptSpaceIsFree = StringUtil.getBoolean((Object)deptSpaceIsFreeMap.get("flag"));
            if (!deptSpaceIsFree.booleanValue()) {
                HashMap resultMap = new HashMap();
                json.put("code", (Object)DocConstant.UPLOADRESULT.NOSPACE.getValue());
                return json;
            }
            this.cacheToolService.updateLevelCodeCache(userId);
            String docId = this.filesService.uploadFast(categoryId, downloadAble, visible, group, person, watermarkUser, fileMd5, fileName, fsFile, fsFile.getFileSize(), shareable, userId);
            if (docId == null) {
                json.put("code", (Object)DocConstant.UPLOADRESULT.FAIL.getValue());
                json.put("id", (Object)docId);
                json.put("authorId", (Object)userId);
                return json;
            }
            json.put("code", (Object)DocConstant.UPLOADRESULT.FASTUPLOAD.getValue());
            json.put("id", (Object)docId);
            json.put("authorId", (Object)userId);
        }
        return json;
    }

    @RequestMapping(value={"/checkVersionMd5Exist"})
    @ResponseBody
    public JSON checkVersionMd5Exist(String fileName, String categoryId, String downloadAble, String visible, String group, String person, String watermarkUser, String watermarkCompany, String shareable, String oldDocId) {
        List<String> nameList;
        JSONObject json = new JSONObject();
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        String fileMd5 = super.getPara("fileMd5");
        ArrayList<String> docNameList = new ArrayList<String>();
        int pointIndex = fileName.lastIndexOf(".");
        String suffix = fileName.substring(pointIndex + 1);
        docNameList.add(fileName);
        if (fileName.length() > 64) {
            HashMap resultMap = new HashMap();
            json.put("code", (Object)DocConstant.UPLOADRESULT.NAMELONG.getValue());
            return json;
        }
        String regex = "^[^'\"\\|\\\\]*$";
        if (!Pattern.compile(regex).matcher(fileName).find()) {
            HashMap resultMap = new HashMap();
            json.put("code", (Object)DocConstant.UPLOADRESULT.NAMEERROR.getValue());
            return json;
        }
        List<DocConfigure> typeList = this.docConfigureService.getConfigure();
        if (typeList.get(0).getConfigValue().contains(suffix.toLowerCase())) {
            HashMap resultMap = new HashMap();
            json.put("code", (Object)DocConstant.UPLOADRESULT.ERRORTYPE.getValue());
            return json;
        }
        List<String> existIdList = this.idocInfoService.selectExistId(docNameList, categoryId);
        if (existIdList != null && existIdList.size() != 0 && !oldDocId.equals(existIdList.get(0)) && (nameList = this.idocInfoService.checkFileExist(docNameList, categoryId)) != null && nameList.size() != 0) {
            HashMap resultMap = new HashMap();
            json.put("name", (Object)nameList.get(0));
            json.put("code", (Object)DocConstant.UPLOADRESULT.FILEEXIST.getValue());
            return json;
        }
        List<FsFile> list = this.fsFileService.getInfoByMd5(fileMd5);
        if (list == null || list.size() == 0 || !"".equals(watermarkCompany)) {
            json.put("code", (Object)DocConstant.UPLOADRESULT.SUCCESS.getValue());
        } else {
            FsFile fsFile = list.get(0);
            Map<String, Object> deptSpaceIsFreeMap = this.filesService.checkDeptSpace(StringUtil.getString((Object)fsFile.getFileSize()));
            Boolean deptSpaceIsFree = StringUtil.getBoolean((Object)deptSpaceIsFreeMap.get("flag"));
            if (!deptSpaceIsFree.booleanValue()) {
                json.put("code", (Object)DocConstant.UPLOADRESULT.NOSPACE.getValue());
                return json;
            }
            List<DocInfo> histories = this.docVersionService.selectVersionHistoriesByDocId(oldDocId, "", "");
            boolean mult = false;
            block0: for (int i = 0; i < list.size(); ++i) {
                for (int j = 0; j < histories.size(); ++j) {
                    if (!histories.get(j).getDocId().equals(list.get(i).getFileId())) continue;
                    mult = true;
                    break block0;
                }
            }
            if (mult) {
                json.put("code", (Object)DocConstant.UPLOADRESULT.HISTORYEXIST.getValue());
                return json;
            }
            this.cacheToolService.updateLevelCodeCache(userId);
            String docId = this.filesService.uploadVersionFast(categoryId, downloadAble, visible, group, person, watermarkUser, fileMd5, fileName, fsFile, fsFile.getFileSize(), shareable, oldDocId);
            json.put("code", (Object)DocConstant.UPLOADRESULT.FASTUPLOAD.getValue());
            json.put("id", (Object)docId);
            json.put("authorId", (Object)userId);
        }
        return json;
    }

    private String getContentType(String suffix) {
        String contentType = null;
        if (suffix.equals(".doc") || suffix.equals(".docx")) {
            contentType = "application/msword";
            return contentType;
        }
        if (suffix.equals(".ppt") || suffix.equals(".pptx")) {
            contentType = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
            return contentType;
        }
        if (suffix.equals(".xls") || suffix.equals(".xlsx")) {
            contentType = "spreadsheetml";
            return contentType;
        }
        if (suffix.equals(".png") || suffix.equals(".gif") || suffix.equals(".jpg") || suffix.equals(".bmp")) {
            contentType = "image";
            return contentType;
        }
        if (suffix.equals(".txt")) {
            contentType = "text/plain";
            return contentType;
        }
        if (suffix.equals(".pdf")) {
            contentType = "application/pdf";
            return contentType;
        }
        if (suffix.equals(".mp3")) {
            contentType = "audio/mp3";
            return contentType;
        }
        if (suffix.equals(".mp4")) {
            contentType = "video/mp4";
            return contentType;
        }
        if (suffix.equals(".wav")) {
            contentType = "audio/wav";
            return contentType;
        }
        if (suffix.equals(".avi")) {
            contentType = "video/avi";
            return contentType;
        }
        if (suffix.equals(".ceb")) {
            contentType = "ceb";
            return contentType;
        }
        if (suffix.equals(".zip")) {
            contentType = "application/x-zip-compressed";
            return contentType;
        }
        if (suffix.equals(".sql")) {
            contentType = "text/x-sql";
            return contentType;
        }
        if (suffix.equals(".rar")) {
            contentType = "application/octet-stream";
            return contentType;
        }
        return null;
    }
}

