/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.manager.docintegral.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.jxdinfo.doc.manager.docintegral.dao.IntegralRecordMapper;
import com.jxdinfo.doc.manager.docintegral.model.IntegralRecord;
import com.jxdinfo.doc.manager.docintegral.service.IntegralRecordService;
import com.jxdinfo.doc.manager.docintegral.service.IntegralRuleService;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntegralRecordServiceImpl
extends ServiceImpl<IntegralRecordMapper, IntegralRecord>
implements IntegralRecordService {
    @Resource
    private IntegralRuleService integralRuleService;
    @Resource
    private IntegralRecordMapper integralRecordMapper;
    @Autowired
    private DocGroupService docGroupService;

    @Override
    public Integer addIntegral(String docId, String userId, String ruleCode) {
        if (userId.equals("superadmin") || userId.equals("wkadmin")) {
            return null;
        }
        if (!"".equals(ruleCode) && ruleCode != null) {
            Integer totalntegral;
            int count;
            List<Map<String, Object>> list = this.integralRuleService.getRuleByCode(ruleCode);
            Integer dayLimit = (Integer)this.integralRuleService.getRuleByCode("dayLimit").get(0).get("ruleIntegral");
            if (list == null || list.size() == 0) {
                return null;
            }
            if (ruleCode.equals("download") && (count = this.integralRecordMapper.checkInDoc(docId)) != 0) {
                return null;
            }
            Map<String, Object> map = list.get(0);
            if (map.get("valid").equals("0")) {
                return null;
            }
            Integer userIntegralCount = this.integralRecordMapper.getTotalIntegral(userId);
            if (null == userIntegralCount) {
                Map<String, Object> defaultBonus = this.integralRuleService.getRuleByCode("defaultBonus").get(0);
                IntegralRecord integralRecord = new IntegralRecord();
                integralRecord.setDocId(docId);
                integralRecord.setRecordId(UUID.randomUUID().toString().replaceAll("-", ""));
                integralRecord.setUserId(userId);
                integralRecord.setIntegralState("1");
                integralRecord.setIntegral((Integer)defaultBonus.get("ruleIntegral"));
                integralRecord.setOperateRuleCode("defaultBonus");
                integralRecord.setRuleName((String)defaultBonus.get("ruleName"));
                integralRecord.setRuleDes((String)defaultBonus.get("ruleDes"));
                Timestamp ts = new Timestamp(System.currentTimeMillis() - 86400000L);
                integralRecord.setOperateTime(ts);
                this.integralRecordMapper.insertRecord(integralRecord);
            }
            Integer realIntegral = 0;
            Integer integral = (Integer)map.get("ruleIntegral");
            Integer times = (Integer)map.get("max_times");
            Integer todayIntegral = this.integralRecordMapper.getIntegralByToday(userId);
            Integer todayTimes = this.integralRecordMapper.getIntegralTimesByToday(userId, ruleCode);
            if (todayTimes != null && todayTimes + 1 > times && times != -1) {
                realIntegral = 0;
                return realIntegral;
            }
            if (todayIntegral == null) {
                todayIntegral = 0;
            }
            if (integral < 0 && (totalntegral = this.integralRecordMapper.getTotalIntegral(userId)) + integral < 0) {
                realIntegral = 0;
                return realIntegral;
            }
            realIntegral = integral + todayIntegral > dayLimit ? Integer.valueOf(dayLimit - todayIntegral) : integral;
            if (realIntegral != 0) {
                IntegralRecord integralRecord = new IntegralRecord();
                integralRecord.setDocId(docId);
                integralRecord.setRecordId(UUID.randomUUID().toString().replaceAll("-", ""));
                integralRecord.setUserId(userId);
                integralRecord.setIntegralState("1");
                integralRecord.setIntegral(realIntegral);
                integralRecord.setOperateRuleCode(ruleCode);
                integralRecord.setRuleName((String)map.get("ruleName"));
                integralRecord.setRuleDes((String)map.get("ruleDes"));
                Timestamp ts = new Timestamp(System.currentTimeMillis());
                integralRecord.setOperateTime(ts);
                this.integralRecordMapper.insertRecord(integralRecord);
            }
            return realIntegral;
        }
        return 0;
    }

    @Override
    public Integer showIntegral(String userId) {
        Integer Integral = 0;
        Integral = this.integralRecordMapper.getTotalIntegral(userId);
        if (Integral == null) {
            Integral = 0;
        }
        return Integral;
    }

    @Override
    public Integer getIntegralByType(String userId, String[] ruleCodes) {
        return this.integralRecordMapper.getIntegralByType(userId, ruleCodes);
    }

    @Override
    public List<Map<String, Object>> getIntegralRank() {
        return this.integralRecordMapper.getIntegralRank();
    }

    @Override
    public List<Map<String, Object>> getIntegralHistories(String userId, String integralState, String[] ruleCodes) {
        return this.integralRecordMapper.getIntegralHistories(userId, integralState, ruleCodes);
    }

    @Override
    public List<Map<String, Object>> getIntegralRank(int startIndex, int pageSize) {
        return this.integralRecordMapper.getIntegralRankByPage(startIndex, pageSize);
    }

    @Override
    public int getIntegralUserCount() {
        return this.integralRecordMapper.getIntegralUserCount();
    }

    @Override
    public int selectDocCountByUser(String[] docIds, String userId) {
        return this.integralRecordMapper.selectDocCountByUser(docIds, userId);
    }

    @Override
    public Integer getIntegralTimesByToday(String userId, String ruleCode) {
        return this.integralRecordMapper.getIntegralTimesByToday(userId, ruleCode);
    }

    @Override
    public int selectDownloadedCount(String[] ids, String userId) {
        return this.integralRecordMapper.selectDownloadedCount(ids, userId);
    }

    @Override
    public Integer getRankNum(String userId) {
        return this.integralRecordMapper.getRankNum(userId);
    }

    @Override
    public int recordIsNull(String userId) {
        return this.integralRecordMapper.recordIsNull(userId);
    }

    @Override
    public int checkInDoc(String docId) {
        return this.integralRecordMapper.checkInDoc(docId);
    }
}

