/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.front.topicmanager.controller;

import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.front.topicmanager.service.FrontTopicService;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.doc.manager.personalcenter.service.PersonalOperateService;
import com.jxdinfo.doc.manager.topicmanager.model.Message;
import com.jxdinfo.doc.manager.topicmanager.model.SpecialTopic;
import com.jxdinfo.doc.manager.topicmanager.service.MessageService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"frontTopic"})
public class FrontTopicController {
    private String PREFIX = "/doc/front/topicmanager/";
    @Autowired
    protected FrontTopicService frontTopicService;
    @Autowired
    private CacheToolService cacheToolService;
    @Autowired
    private DocGroupService docGroupService;
    @Autowired
    private MessageService messageService;
    @Resource
    private BusinessService businessService;
    @Resource
    private PersonalOperateService operateService;

    @RequestMapping(value={"topicList"})
    public String topicList(Model model, int page, int size) {
        String userName = UserInfoUtil.getUserInfo().get("NAME").toString();
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        String userId = UserInfoUtil.getCurrentUser().getId();
        List<String> listGroup = this.docGroupService.getPremission(userId);
        FsFolderParams fsFolderParams = new FsFolderParams();
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType("2");
        String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
        int startNum = page * size - size;
        List<SpecialTopic> topicList = this.frontTopicService.getTopicList(startNum, size);
        if (topicList != null) {
            try {
                int j = topicList.size();
                for (int i = 0; i < j; ++i) {
                    SpecialTopic specialTopic = topicList.get(i);
                    int docCount = this.frontTopicService.getDocByTopicIdCount(specialTopic.getTopicId(), userId, listGroup, levelCode, adminFlag);
                    String topicCover = URLEncoder.encode(specialTopic.getTopicCover(), "UTF-8");
                    specialTopic.setTopicCover(topicCover);
                    topicList.get(i).setDocNum(docCount);
                    topicList.get(i).setDocCount(docCount);
                    specialTopic.setViewNum(this.cacheToolService.getTopicReadNum(specialTopic.getTopicId()));
                    topicList.set(i, specialTopic);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        int topicCount = this.frontTopicService.getTopicListCount(null);
        model.addAttribute("userName", (Object)userName);
        model.addAttribute("topicCount", (Object)topicCount);
        model.addAttribute("topicList", topicList);
        model.addAttribute("curr", (Object)page);
        model.addAttribute("isPersonCenter", (Object)false);
        return this.PREFIX + "front_topic_list.html";
    }

    @RequestMapping(value={"topicDetail"})
    public String topicDetail(Model model, String topicId, int page, int size) {
        int startNum = page * size - size;
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        String userName = UserInfoUtil.getUserInfo().get("NAME").toString();
        String userId = UserInfoUtil.getCurrentUser().getId();
        List<String> listGroup = this.docGroupService.getPremission(userId);
        SpecialTopic specialTopic = this.frontTopicService.getTopicDetailById(topicId);
        try {
            String topicCover = URLEncoder.encode(specialTopic.getTopicCover(), "UTF-8");
            specialTopic.setTopicCover(topicCover);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        specialTopic.setViewNum(this.cacheToolService.getTopicReadNum(topicId) + 1);
        FsFolderParams fsFolderParams = new FsFolderParams();
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType("2");
        String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
        String orgId = ShiroKit.getUser().getDeptName();
        List docList = this.frontTopicService.getDocByTopicId(topicId, "create_time", startNum, size, userId, listGroup, levelCode, adminFlag, orgId);
        int docCount = this.frontTopicService.getDocByTopicIdCount(topicId, userId, listGroup, levelCode, adminFlag);
        ArrayList<Map> docListWithReadNum = new ArrayList<Map>();
        if (docList != null) {
            int j = docList.size();
            for (int i = 0; i < j; ++i) {
                Map docInfo = (Map)docList.get(i);
                docInfo.put("readNum", this.cacheToolService.getReadNum(StringUtil.getString(docInfo.get("doc_id"))));
                int collection = this.operateService.getMyHistoryCountByFileId(StringUtil.getString(docInfo.get("doc_id")), userId, "5");
                docInfo.put("collection", collection);
                docListWithReadNum.add(docInfo);
            }
        }
        specialTopic.setDocCount(docCount);
        specialTopic.setDocList(docListWithReadNum);
        model.addAttribute("userName", (Object)userName);
        model.addAttribute("topic", (Object)specialTopic);
        model.addAttribute("docCount", (Object)docList);
        model.addAttribute("curr", (Object)page);
        model.addAttribute("adminFlag", (Object)adminFlag);
        model.addAttribute("isPersonCenter", (Object)false);
        return this.PREFIX + "front_topic_detail.html";
    }

    @RequestMapping(value={"messageList"})
    public String messageList(Model model, int page, int size, String name, String year, String month) {
        String userName = UserInfoUtil.getUserInfo().get("NAME").toString();
        String userId = UserInfoUtil.getCurrentUser().getId();
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        int startNum = page * size - size;
        List<Message> topicList = this.messageService.getList(name, month, year, startNum, size);
        int topicCount = this.messageService.getListCount(name, month, year);
        model.addAttribute("topicCount", (Object)topicCount);
        model.addAttribute("topicList", topicList);
        model.addAttribute("userName", (Object)userName);
        model.addAttribute("name", (Object)name);
        model.addAttribute("year", (Object)year);
        model.addAttribute("month", (Object)month);
        model.addAttribute("curr", (Object)page);
        model.addAttribute("adminFlag", (Object)adminFlag);
        model.addAttribute("isPersonCenter", (Object)false);
        return this.PREFIX + "front_message_list.html";
    }
}

