/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.front.docsharemanager.service.impl;

import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.front.docsharemanager.dao.ShareResourceMapper;
import com.jxdinfo.doc.front.docsharemanager.service.ShareResourceService;
import com.jxdinfo.doc.manager.docmanager.model.DocResourceLog;
import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class ShareResourceServiceImpl
implements ShareResourceService {
    @Resource
    private ShareResourceMapper shareResourceMapper;
    @Resource
    private CacheToolService cacheToolService;
    @Resource
    private DocInfoService docInfoService;

    @Override
    public Map newShareResource(String fileId, String fileType, int pwdFlag, int validTime, HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!fileType.equals("component") && !this.getShareFlagByDocId(fileId)) {
            result.put("msg", "\u6587\u4ef6\u4e0d\u53ef\u5206\u4eab");
            result.put("status", 2);
            return result;
        }
        try {
            String href = "";
            HashMap<String, Object> map = new HashMap<String, Object>();
            switch (fileType = fileType.replace(".", "")) {
                case "png": 
                case "jpg": 
                case "gif": 
                case "bmp": 
                case "jpeg": {
                    href = "/sharefile/toShowIMG?id=" + fileId + "&fileType=0&keyWords=";
                    break;
                }
                case "doc": 
                case "docx": 
                case "dot": 
                case "xls": 
                case "wps": 
                case "xlt": 
                case "et": 
                case "ett": 
                case "ppts": 
                case "pot": 
                case "dps": 
                case "dpt": 
                case "xlsx": 
                case "txt": 
                case "pdf": 
                case "ceb": 
                case "ppt": 
                case "pptx": {
                    href = "/sharefile/toShowPDF?id=" + fileId + "&fileType=0&keyWords=";
                    break;
                }
                case "mp4": 
                case "wmv": {
                    href = "/sharefile/toShowVideo?id=" + fileId + "&fileType=0&keyWords=";
                    break;
                }
                case "mp3": 
                case "m4a": {
                    href = "/sharefile/toShowVoice?id=" + fileId + "&fileType=0&keyWords=";
                    break;
                }
                case "component": {
                    href = "/sharefile/toShowComponent?id=" + fileId + "&fileType=0&keyWords=";
                    break;
                }
                default: {
                    href = "/sharefile/toShowOthers?id=" + fileId + "&fileType=0&keyWords=";
                }
            }
            String hash = StringUtil.applySha256((String)(href + System.currentTimeMillis()));
            hash = hash.substring(0, 23);
            String pwd = "";
            if (pwdFlag == 1) {
                pwd = StringUtil.getRandomCode((int)4);
            }
            if (validTime == 0) {
                validTime = 36500;
            }
            map.put("shareId", StringUtil.getUUID());
            map.put("href", href);
            map.put("hash", hash);
            map.put("docId", fileId);
            map.put("creatorId", ShiroKit.getUser().getId());
            map.put("pwd", pwd);
            map.put("pwdFlag", pwdFlag);
            map.put("validTime", validTime);
            InetAddress address = InetAddress.getLocalHost();
            String hostAddress = address.getHostAddress();
            int isShare = this.shareResourceMapper.newShareResource(map);
            String mappingUrl = "";
            Map serverAddress = this.cacheToolService.getServerAddress();
            mappingUrl = serverAddress == null || serverAddress.get("addressValid") == null || "0".equals(serverAddress.get("addressValid").toString()) ? "http://" + request.getLocalAddr() + ":" + request.getLocalPort() + "/s/" + hash : "http://" + serverAddress.get("address").toString() + "/s/" + hash;
            if (isShare == 1) {
                ArrayList<DocResourceLog> resInfoList = new ArrayList<DocResourceLog>();
                DocResourceLog docResourceLog = new DocResourceLog();
                String id = UUID.randomUUID().toString().replace("-", "");
                docResourceLog.setId(id);
                docResourceLog.setResourceId(fileId);
                Timestamp ts = new Timestamp(System.currentTimeMillis());
                docResourceLog.setOperateTime(ts);
                docResourceLog.setResourceType(0);
                String userId = UserInfoUtil.getUserInfo().get("ID").toString();
                docResourceLog.setUserId(userId);
                docResourceLog.setOperateType(5);
                docResourceLog.setValidFlag("1");
                resInfoList.add(docResourceLog);
                this.docInfoService.insertResourceLog(resInfoList);
                result.put("mapping_url", mappingUrl);
                result.put("pwd_flag", pwdFlag);
                result.put("valid_time", validTime);
                result.put("msg", "\u5c06\u94fe\u63a5\u53d1\u9001\u7ed9\u5c0f\u4f19\u4f34");
                result.put("status", 1);
                if (pwdFlag == 1) {
                    result.put("pwd", pwd);
                }
            } else {
                result.put("msg", "\u5206\u4eab\u5931\u8d25");
                result.put("status", -1);
            }
            return result;
        }
        catch (Exception e) {
            result.put("msg", "\u5206\u4eab\u5931\u8d25");
            result.put("status", -1);
            return result;
        }
    }

    @Override
    public Map getShareResource(String hash) {
        return this.shareResourceMapper.getShareResource(hash);
    }

    @Override
    public String getPwdByHash(String hash) {
        return this.shareResourceMapper.getPwdByHash(hash);
    }

    @Override
    public boolean getShareFlagByDocId(String docId) {
        Map shareCheck = this.shareResourceMapper.getShareFlagByDocId(docId);
        String validFlag = "";
        validFlag = null == shareCheck.get("validFlag") ? "0" : shareCheck.get("validFlag").toString();
        String shareFlag = "";
        shareFlag = null == shareCheck.get("shareFlag") ? "0" : shareCheck.get("shareFlag").toString();
        return "1".equals(shareFlag) && "1".equals(validFlag);
    }

    @Override
    public Map getPdfPath(String hash) {
        return this.shareResourceMapper.getPdfPath(hash);
    }

    @Override
    public boolean isPdfPathExist(String hash) {
        if (this.getPdfPath(hash).get("pdfPath") == null) {
            return false;
        }
        return !this.getPdfPath(hash).get("pdfPath").toString().equals("");
    }

    @Override
    public void setPdfPathFast(String hash) {
        String docId = this.shareResourceMapper.getDocIdByHash(hash);
        List<Map<String, String>> changePdf = this.cacheToolService.getUploadStateList();
        if (null != changePdf) {
            for (Map<String, String> pdf : changePdf) {
                String state;
                String pdfId;
                if (null == pdf.get("docId") || !docId.equals(pdfId = pdf.get("docId")) || null == pdf.get("state") || !"1".equals(state = pdf.get("state"))) continue;
                this.cacheToolService.setReadyToFastChange(pdf, pdf.get("address"));
                this.cacheToolService.removeFromChangePdfById(docId, pdf.get("address"));
            }
        }
    }

    @Override
    public Map newShareResourceMobile(String fileId, String fileType, int pwdFlag, int validTime, HttpServletRequest request, String userId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.getShareFlagByDocId(fileId)) {
            result.put("msg", "\u6587\u4ef6\u4e0d\u53ef\u5206\u4eab");
            result.put("status", 2);
            return result;
        }
        try {
            String href = "";
            HashMap<String, Object> map = new HashMap<String, Object>();
            switch (fileType = fileType.replace(".", "")) {
                case "png": 
                case "jpg": 
                case "gif": 
                case "bmp": 
                case "jpeg": {
                    href = "/sharefile/toShowIMG?id=" + fileId + "&fileType=0&keyWords=";
                    break;
                }
                case "doc": 
                case "docx": 
                case "dot": 
                case "xls": 
                case "wps": 
                case "xlt": 
                case "et": 
                case "ett": 
                case "ppts": 
                case "pot": 
                case "dps": 
                case "dpt": 
                case "xlsx": 
                case "txt": 
                case "pdf": 
                case "ceb": 
                case "ppt": 
                case "pptx": {
                    href = "/sharefile/toShowPDF?id=" + fileId + "&fileType=0&keyWords=";
                    break;
                }
                case "mp4": 
                case "wmv": {
                    href = "/sharefile/toShowVideo?id=" + fileId + "&fileType=0&keyWords=";
                    break;
                }
                case "mp3": 
                case "m4a": {
                    href = "/sharefile/toShowVoice?id=" + fileId + "&fileType=0&keyWords=";
                    break;
                }
                default: {
                    href = "/sharefile/toShowOthers?id=" + fileId + "&fileType=0&keyWords=";
                }
            }
            String hash = StringUtil.applySha256((String)(href + System.currentTimeMillis()));
            hash = hash.substring(0, 23);
            String pwd = "";
            if (pwdFlag == 1) {
                pwd = StringUtil.getRandomCode((int)4);
            }
            if (validTime == 0) {
                validTime = 36500;
            }
            map.put("shareId", StringUtil.getUUID());
            map.put("href", href);
            map.put("hash", hash);
            map.put("docId", fileId);
            map.put("creatorId", userId);
            map.put("pwd", pwd);
            map.put("pwdFlag", pwdFlag);
            map.put("validTime", validTime);
            InetAddress address = InetAddress.getLocalHost();
            String hostAddress = address.getHostAddress();
            int isShare = this.shareResourceMapper.newShareResource(map);
            String mappingUrl = "";
            Map serverAddress = this.cacheToolService.getServerAddress();
            mappingUrl = serverAddress == null || serverAddress.get("addressValid") == null || "0".equals(serverAddress.get("addressValid").toString()) ? "http://" + request.getLocalAddr() + ":" + request.getLocalPort() + "/s/" + hash : "http://" + serverAddress.get("address").toString() + "/s/" + hash;
            if (isShare == 1) {
                result.put("mapping_url", mappingUrl);
                result.put("pwd_flag", pwdFlag);
                result.put("valid_time", validTime);
                result.put("msg", "\u5c06\u94fe\u63a5\u53d1\u9001\u7ed9\u5c0f\u4f19\u4f34");
                result.put("status", 1);
                if (pwdFlag == 1) {
                    result.put("pwd", pwd);
                }
            } else {
                result.put("msg", "\u5206\u4eab\u5931\u8d25");
                result.put("status", -1);
            }
            return result;
        }
        catch (Exception e) {
            result.put("msg", "\u5206\u4eab\u5931\u8d25");
            result.put("status", -1);
            return result;
        }
    }
}

