/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.front.docsearch.controller;

import com.jxdinfo.doc.common.docutil.model.ESResponse;
import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.docutil.service.ESService;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.front.docmanager.service.FrontDocInfoService;
import com.jxdinfo.doc.front.foldermanager.service.FrontFolderService;
import com.jxdinfo.doc.front.groupmanager.service.FrontDocGroupService;
import com.jxdinfo.doc.manager.docmanager.model.DocInfo;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolder;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.foldermanager.service.IFsFolderService;
import com.jxdinfo.doc.manager.historymanager.service.SearchHistoryService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SearchController
extends BaseController {
    @Value(value="${docbase.uploadPath}")
    private String uploadPath;
    @Autowired
    private IFsFolderService fsFolderService;
    @Autowired
    private ESService esService;
    @Autowired
    private FrontFolderService frontFolderService;
    @Autowired
    private FrontDocInfoService frontDocInfoService;
    @Autowired
    private CacheToolService cacheToolService;
    @Resource
    private BusinessService businessService;
    @Autowired
    private FrontDocGroupService frontDocGroupService;
    @Resource
    private SearchHistoryService historyService;
    @Value(value="${docbase.picCommond}")
    private boolean picCommond;
    private static final Map<String, String> fileTypeMap = new HashMap<String, String>();

    @RequestMapping(value={"/searchView"})
    public String showSearchView(String fileType, String keyWords, Model model) {
        String userName = UserInfoUtil.getUserInfo().get("NAME").toString();
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        String type = fileType == null ? "" : fileType;
        String docName = keyWords == null ? "" : keyWords;
        HashMap<String, Object> history = new HashMap<String, Object>();
        history.put("keywords", keyWords);
        history.put("userId", ShiroKit.getUser().getId());
        history.put("searchTime", new Date());
        this.historyService.insertIntoSearchHistory(history);
        model.addAttribute("fileType", (Object)type);
        model.addAttribute("key", (Object)docName);
        model.addAttribute("userName", (Object)userName);
        model.addAttribute("adminFlag", (Object)adminFlag);
        model.addAttribute("picCommond", (Object)this.picCommond);
        model.addAttribute("isPersonCenter", (Object)false);
        return "/doc/front/homemanager/searchResult.html";
    }

    @RequestMapping(value={"/searchAuthor"})
    public String searchAuthor(String fileType, String keyWords, Model model) {
        String userName = UserInfoUtil.getUserInfo().get("NAME").toString();
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        String type = fileType == null ? "" : fileType;
        String docName = keyWords == null ? "" : keyWords;
        model.addAttribute("fileType", (Object)type);
        model.addAttribute("key", (Object)docName);
        model.addAttribute("userName", (Object)userName);
        model.addAttribute("adminFlag", (Object)adminFlag);
        model.addAttribute("isPersonCenter", (Object)false);
        return "/doc/front/homemanager/searchAuthor.html";
    }

    @RequestMapping(value={"/searchPic"})
    public String shoSsearchPic(String fileType, String keyWords, Model model, String UIFolder) {
        String userName = UserInfoUtil.getUserInfo().get("NAME").toString();
        List roleList = ShiroKit.getUser().getRolesList();
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        String type = fileType == null ? "" : fileType;
        String docName = keyWords == null ? "" : keyWords;
        model.addAttribute("UIFolder", (Object)UIFolder);
        model.addAttribute("fileType", (Object)type);
        model.addAttribute("key", (Object)docName);
        model.addAttribute("userName", (Object)userName);
        model.addAttribute("adminFlag", (Object)adminFlag);
        model.addAttribute("isPersonCenter", (Object)false);
        return "/doc/front/docmanager/front-imgFlow.html";
    }

    @RequestMapping(value={"/search"})
    @ResponseBody
    public ESResponse<Map<String, Object>> search(String keyword, Integer page, String fileType, Integer size, String tagString, String UIFolder) {
        ShiroUser shiroUser = ShiroKit.getUser();
        List rolesList = shiroUser.getRolesList();
        Boolean adminFlag = CommonUtil.getAdminFlag((List)rolesList) == 1;
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        List<String> listGroup = this.frontDocGroupService.getPremission(userId);
        String keywordResult = "";
        String fileTypeResult = "";
        try {
            keywordResult = URLDecoder.decode(keyword.replaceAll("%", "%25"), "UTF-8");
            fileTypeResult = URLDecoder.decode(fileType, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if ("".equals(keyword) && UIFolder != null && !"".equals(UIFolder)) {
            ESResponse<Map<String, Object>> sd = new ESResponse<Map<String, Object>>();
            List list = sd.getItems();
            FsFolder folder = (FsFolder)((Object)this.fsFolderService.selectById((Serializable)((Object)UIFolder)));
            FsFolderParams fsFolderParams = new FsFolderParams();
            fsFolderParams.setGroupList(listGroup);
            fsFolderParams.setUserId(userId);
            fsFolderParams.setLevelCodeString(folder.getLevelCode());
            fsFolderParams.setId(UIFolder);
            String levelCodeString = this.businessService.getFileLevelCodeFront(fsFolderParams);
            if (adminFlag.booleanValue()) {
                levelCodeString = null;
            }
            String sql = "";
            if (tagString != null && !"".equals(tagString) && tagString.split("\\|").length != 0) {
                String[] strs = tagString.split("\\|");
                for (int i = 0; i < strs.length; ++i) {
                    String[] strs_tags = strs[i].split(",");
                    if (strs_tags.equals("")) continue;
                    sql = sql + " and (";
                    for (int j = 0; j < strs_tags.length; ++j) {
                        String strs_tag;
                        if (j == 0) {
                            strs_tag = strs_tags[j];
                            sql = sql + " D.tags like '%" + strs_tag + "%'";
                            continue;
                        }
                        strs_tag = strs_tags[j];
                        sql = sql + " or D.tags like '%" + strs_tag + "%'";
                    }
                    sql = sql + ")";
                }
            }
            List<DocInfo> docList = this.frontDocInfoService.getListByTime(folder.getLevelCode(), levelCodeString, (page - 1) * size, page * size, sql, null);
            int count = this.frontDocInfoService.getListByTimeCount(folder.getLevelCode(), levelCodeString, sql, null);
            ArrayList finalList = new ArrayList();
            if (docList != null && docList.size() > 0) {
                for (DocInfo docInfo : docList) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String docId = docInfo.getDocId();
                    map.put("createTime", docInfo.getCreateTime());
                    map.put("docId", docInfo.getDocId());
                    String fileSuffixName = docInfo.getDocType().substring(docInfo.getDocType().lastIndexOf(".") + 1);
                    map.put("contacts", docInfo.getContactsName());
                    map.put("fileName", docInfo.getTitle());
                    map.put("title", docInfo.getTitle());
                    map.put("downloadNum", docInfo.getDownloadNum());
                    map.put("readNum", this.cacheToolService.getReadNum(docInfo.getDocId()));
                    map.put("fileSuffixName", fileSuffixName);
                    map.put("filePdfPath", docInfo.getFilePdfPath());
                    map.put("filePath", docInfo.getFilePath());
                    map.put("docType", docInfo.getDocType().replace(".", ""));
                    finalList.add(map);
                }
                sd.setItems(finalList);
                sd.setTotal(Long.valueOf(count));
                return sd;
            }
        }
        String docType = "";
        ESResponse<Object> sd = new ESResponse();
        if ("0".equals(fileTypeResult)) {
            if (this.picCommond) {
                docType = fileTypeMap.get("11");
                sd = this.esService.search(keywordResult, docType, page, adminFlag, size, tagString);
            } else {
                sd = this.esService.search(keywordResult, page, adminFlag, size);
            }
        } else {
            docType = fileTypeMap.get(fileTypeResult);
            sd = this.esService.search(keywordResult, docType, page, adminFlag, size, tagString);
        }
        List<Object> list = sd.getItems();
        if (null != list && list.size() > 0) {
            ArrayList<String> idList = new ArrayList<String>();
            HashMap<String, String> titleMap = new HashMap<String, String>();
            HashMap<String, String> contentMap = new HashMap<String, String>();
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                String id = map.get("id") == null ? "" : map.get("id").toString();
                idList.add(id);
                String title = map.get("title") == null ? "" : map.get("title").toString();
                String content = map.get("content") == null ? "" : map.get("content").toString();
                titleMap.put(id, title);
                contentMap.put(id, content);
            }
            FsFolderParams fsFolderParams = new FsFolderParams();
            fsFolderParams.setGroupList(listGroup);
            fsFolderParams.setUserId(userId);
            fsFolderParams.setType("2");
            String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
            String orgId = ShiroKit.getUser().getDeptName();
            List<DocInfo> docList = this.frontDocInfoService.getDocInfo(idList, userId, listGroup, levelCode, orgId);
            ArrayList finalList = new ArrayList();
            if (docList != null && docList.size() > 0) {
                block6: for (String id : idList) {
                    for (DocInfo docInfo : docList) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        String docId = docInfo.getDocId();
                        if (!docId.equals(id)) continue;
                        map.put("createTime", docInfo.getCreateTime());
                        map.put("docId", docInfo.getDocId());
                        String fileSuffixName = docInfo.getDocType().substring(docInfo.getDocType().lastIndexOf(".") + 1);
                        map.put("author", docInfo.getAuthorName());
                        map.put("user", docInfo.getUserName());
                        map.put("contacts", docInfo.getContactsName());
                        map.put("fileName", titleMap.get(docId));
                        map.put("authorId", docInfo.getAuthorId());
                        map.put("content", contentMap.get(docId));
                        map.put("authority", docInfo.getAuthority());
                        map.put("title", docInfo.getTitle());
                        map.put("downloadNum", docInfo.getDownloadNum());
                        map.put("readNum", this.cacheToolService.getReadNum(docInfo.getDocId()));
                        map.put("fileSuffixName", fileSuffixName);
                        map.put("filePdfPath", docInfo.getFilePdfPath());
                        map.put("filePath", docInfo.getFilePath());
                        map.put("mobile", docInfo.getMobile());
                        map.put("docType", docInfo.getDocType().replace(".", ""));
                        finalList.add(map);
                        continue block6;
                    }
                }
            }
            sd.setItems(finalList);
        }
        return sd;
    }

    @RequestMapping(value={"/dicList"})
    @ResponseBody
    public Object getListData() {
        String dicType = super.getPara("dicType");
        List<Map<String, Object>> list = this.cacheToolService.getDictListByType(dicType);
        return list;
    }

    @RequestMapping(value={"/searchAuthorList"})
    @ResponseBody
    public ESResponse<Map<String, Object>> searchAuthor(String keyword, Integer page, String fileType, Integer size, String tagString, String UIFolder) {
        String[] typeArr;
        ShiroUser shiroUser = ShiroKit.getUser();
        List rolesList = shiroUser.getRolesList();
        Boolean adminFlag = CommonUtil.getAdminFlag((List)rolesList) == 1;
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        List<String> listGroup = this.frontDocGroupService.getPremission(userId);
        String keywordResult = "";
        String fileTypeResult = "";
        try {
            keywordResult = URLDecoder.decode(keyword.replaceAll("%", "%25"), "UTF-8");
            fileTypeResult = URLDecoder.decode(fileType, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ESResponse<Map<String, Object>> sd = new ESResponse<Map<String, Object>>();
        List list = sd.getItems();
        FsFolderParams fsFolderParams = new FsFolderParams();
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType("2");
        String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
        String orgId = ShiroKit.getUser().getDeptName();
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put("1", ".doc,.docx");
        typeMap.put("2", ".ppt,.pptx");
        typeMap.put("3", ".txt");
        typeMap.put("4", ".pdf");
        typeMap.put("5", ".xls,.xlsx");
        if (fileType == null || "".equals(fileType) || "15".equals(fileType)) {
            fileType = "0";
        }
        if ("0".equals(fileType)) {
            typeArr = null;
        } else {
            String typeResult = (String)typeMap.get(fileType);
            typeArr = typeResult.split(",");
        }
        ArrayList finalList = new ArrayList();
        List<DocInfo> docList = this.frontFolderService.getFileByAuthor((page - 1) * size, size, keyword, listGroup, userId, adminFlag, levelCode, orgId, typeArr);
        Integer count = this.frontFolderService.getFileByAuthorCount(keyword, listGroup, userId, adminFlag, levelCode, orgId, typeArr);
        if (docList != null && docList.size() > 0) {
            for (DocInfo docInfo : docList) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String docId = docInfo.getDocId();
                map.put("createTime", docInfo.getCreateTime());
                map.put("docId", docInfo.getDocId());
                String fileSuffixName = docInfo.getFileType().substring(docInfo.getFileType().lastIndexOf(".") + 1);
                map.put("user", docInfo.getUserName());
                map.put("contacts", docInfo.getContactsName());
                map.put("fileName", docInfo.getTitle());
                map.put("authority", docInfo.getAuthority());
                map.put("title", docInfo.getTitle());
                map.put("downloadNum", docInfo.getDownloadNum());
                map.put("readNum", this.cacheToolService.getReadNum(docInfo.getDocId()));
                map.put("fileSuffixName", fileSuffixName);
                map.put("filePdfPath", docInfo.getFilePdfPath());
                map.put("filePath", docInfo.getFilePath());
                map.put("docType", docInfo.getFileType().replace(".", ""));
                finalList.add(map);
            }
        }
        sd.setItems(finalList);
        sd.setTotal((long)count);
        return sd;
    }

    static {
        fileTypeMap.put("6", "all");
        fileTypeMap.put("8", "image");
        fileTypeMap.put("9", "video");
        fileTypeMap.put("10", "audio");
        fileTypeMap.put("11", "notimage");
        fileTypeMap.put("7", "allword");
        fileTypeMap.put("1", "word");
        fileTypeMap.put("2", "presentationml");
        fileTypeMap.put("3", "plain");
        fileTypeMap.put("4", "pdf");
        fileTypeMap.put("5", "spreadsheetml");
    }
}

