/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.front.docmanager.service.impl;

import com.jxdinfo.doc.common.docutil.service.FastdfsService;
import com.jxdinfo.doc.front.docmanager.service.PageOfficeService;
import com.jxdinfo.doc.manager.docmanager.dao.DocInfoMapper;
import com.jxdinfo.doc.manager.docmanager.dao.FsFileMapper;
import com.jxdinfo.doc.manager.docmanager.ex.ServiceException;
import com.jxdinfo.doc.manager.docmanager.model.DocInfo;
import com.jxdinfo.doc.manager.docmanager.model.FsFile;
import com.jxdinfo.hussar.encrypt.file.FileEncryptUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PageOfficeServiceImpl
implements PageOfficeService {
    @Autowired
    private DocInfoMapper docInfoMapper;
    @Autowired
    private FastdfsService fastdfsService;
    @Resource
    private FsFileMapper fsFileMapper;
    @Value(value="${docbase.filedir}")
    private String tempdir;

    @Override
    public String getEditFileByFast(String docId) {
        FileOutputStream fos = null;
        Object buffer = null;
        byte[] bytes = null;
        DocInfo docInfo = this.docInfoMapper.getDocDetail(docId);
        String path = docInfo.getFilePath();
        String suffix = path.substring(path.lastIndexOf("."));
        try {
            bytes = this.fastdfsService.download(path);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        List<FsFile> list = this.fsFileMapper.getInfoByPath(path);
        if (list != null && list.size() > 0) {
            if (list.get(0).getSourceKey() == null) {
                return null;
            }
            String random = UUID.randomUUID().toString().replaceAll("-", "");
            File file = new File(this.tempdir + "\\" + random + suffix);
            try {
                fos = new FileOutputStream(file);
                fos.write(bytes, 0, bytes.length);
                fos.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            boolean isDecrypt = FileEncryptUtil.getInstance().decrypt(this.tempdir + "\\" + random + suffix, list.get(0).getSourceKey());
            return this.tempdir + "\\" + random + suffix;
        }
        return null;
    }
}

