/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.front.docmanager.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.front.docmanager.dao.FrontDocInfoMapper;
import com.jxdinfo.doc.front.docmanager.dao.FrontFsFileMapper;
import com.jxdinfo.doc.front.docmanager.service.FrontFsFileService;
import com.jxdinfo.doc.front.foldermanager.dao.FrontFolderMapper;
import com.jxdinfo.doc.manager.docmanager.model.DocInfo;
import com.jxdinfo.doc.manager.docmanager.model.FsFolderView;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolder;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class FrontFsFileServiceImpl
implements FrontFsFileService {
    @Resource
    private FrontFsFileMapper frontFsFileMapper;
    @Resource
    private FrontDocInfoMapper frontDocInfoMapper;
    @Resource
    private FrontFolderMapper frontFolderMapper;
    @Resource
    private BusinessService businessService;
    @Resource
    private DocGroupService docGroupService;

    @Override
    public List<FsFolder> getFsFileList(String userId, List groupList, Integer adminFlag) {
        FsFolderParams fsFolderParams = new FsFolderParams();
        if (adminFlag == 1) {
            FsFolder rootFloder = this.frontFolderMapper.getRoot().get(0);
            return this.frontFsFileMapper.getFsFolderListBySuperAdmin(rootFloder.getFolderId());
        }
        fsFolderParams.setGroupList(groupList);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType("0");
        fsFolderParams.setLevelCodeString("001");
        String levelCodeString = this.businessService.getFileLevelCodeFront(fsFolderParams);
        ArrayList<String> list = new ArrayList<String>();
        FsFolder rootFloder = this.frontFolderMapper.getRoot().get(0);
        list.add(rootFloder.getFolderId());
        return this.frontFolderMapper.selectByLevelCodeList(list, userId, levelCodeString);
    }

    @Override
    public List<FsFolder> getFsFileListMobile(String userId, List groupList, Integer adminFlag) {
        FsFolderParams fsFolderParams = new FsFolderParams();
        if (adminFlag == 1) {
            FsFolder rootFloder = this.frontFolderMapper.getRoot().get(0);
            return this.frontFsFileMapper.getFsFolderListBySuperAdmin(rootFloder.getFolderId());
        }
        fsFolderParams.setGroupList(groupList);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType("0");
        fsFolderParams.setLevelCodeString("001");
        String levelCodeString = this.businessService.getFileLevelCodeFrontMobile(fsFolderParams);
        ArrayList<String> list = new ArrayList<String>();
        FsFolder rootFloder = this.frontFolderMapper.getRoot().get(0);
        list.add(rootFloder.getFolderId());
        return this.frontFolderMapper.selectByLevelCodeList(list, userId, levelCodeString);
    }

    @Override
    public List<FsFolder> getRoot() {
        List<FsFolder> list = this.frontFolderMapper.getRoot();
        return list;
    }

    @Override
    public List<Map> getInfo(List ids, String userId, List<String> listGroup) {
        List<Map> list = this.frontFsFileMapper.getInfo(ids, userId, listGroup);
        return list;
    }

    @Override
    public boolean isChildren(String id) {
        int num = this.frontFsFileMapper.getNumByChildFloder(id);
        return num == 0;
    }

    @Override
    public List<DocInfo> getList(Integer pageNumber, Integer pageSize) {
        return this.frontDocInfoMapper.getList(pageNumber, pageSize);
    }

    @Override
    public List<DocInfo> getListByFolderId(Integer pageNumber, Integer pageSize, String folderId) {
        return this.frontDocInfoMapper.getListByFolderId(pageNumber, pageSize, folderId);
    }

    @Override
    public List<FsFolderView> getListByType(Integer pageNumber, Integer pageSize, String folderId) {
        return this.frontDocInfoMapper.getListByType(pageNumber, pageSize, folderId);
    }

    @Override
    public List<DocInfo> getListByPermission(Integer pageNumber, Integer pageSize) {
        FsFolderParams fsFolderParams = new FsFolderParams();
        String userId = ShiroKit.getUser().getId();
        List<String> listGroup = this.docGroupService.getPremission(userId);
        List roleList = ShiroKit.getUser().getRolesList();
        fsFolderParams.setGroupList(listGroup);
        fsFolderParams.setUserId(userId);
        fsFolderParams.setType("front");
        fsFolderParams.setLevelCodeString("001");
        fsFolderParams.setId("2bb61cdb2b3c11e8aacf429ff4208431");
        String levelCodeString = this.businessService.getFileLevelCodeFront(fsFolderParams);
        fsFolderParams.setType("2");
        Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
        if (adminFlag == 1) {
            return this.frontDocInfoMapper.getListByPermissionSuper(pageNumber, pageSize);
        }
        String orgId = ShiroKit.getUser().getDeptName();
        return this.frontDocInfoMapper.getListByPermission(pageNumber, pageSize, levelCodeString, null, userId, listGroup, orgId);
    }

    @Override
    public List<Map> hotWord(Page page) {
        return this.frontDocInfoMapper.hotWord(page);
    }

    @Override
    public Integer hotWordCount() {
        return this.frontDocInfoMapper.hotWordCount();
    }
}

