/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.front.docmanager.controller;

import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.docutil.service.FastdfsService;
import com.jxdinfo.doc.common.util.DeviceUtil;
import com.jxdinfo.doc.common.util.ExceptionUtils;
import com.jxdinfo.doc.common.util.FileTool;
import com.jxdinfo.doc.front.docmanager.service.FrontDocInfoService;
import com.jxdinfo.doc.front.docmanager.service.PreviewService;
import com.jxdinfo.doc.front.docsharemanager.service.ShareResourceService;
import com.jxdinfo.doc.manager.docmanager.dao.FsFileMapper;
import com.jxdinfo.doc.manager.docmanager.ex.ServiceException;
import com.jxdinfo.doc.manager.docmanager.model.DocInfo;
import com.jxdinfo.doc.manager.docmanager.model.FsFile;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/sharefile"})
public class ShareFileController {
    private static Logger LOGGER = LoggerFactory.getLogger(ShareFileController.class);
    @Value(value="${docbase.downloadPdfFile}")
    private String downloadPdfFile;
    @Resource
    private FsFileMapper fsFileMapper;
    private boolean fastdfsUsingFlag = true;
    @Autowired
    private DocGroupService docGroupService;
    private String fileType;
    private String orderType;
    private String fileName;
    private String pdfFileId;
    @Autowired
    private PreviewService previewService;
    @Autowired
    FastdfsService fastdfsService;
    @Autowired
    private FrontDocInfoService frontDocInfoService;
    @Autowired
    private CacheToolService cacheToolService;
    @Autowired
    private HussarCacheManager hussarCacheManager;
    @Autowired
    private FileTool fileTool;
    @Resource
    private BusinessService businessService;
    @Resource
    private ShareResourceService shareResourceService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/video"})
    public void getVideo(HttpServletRequest request, HttpServletResponse response) {
        String uuid = UUID.randomUUID().toString();
        RandomAccessFile randomFile = null;
        ServletOutputStream out = null;
        String hash = request.getParameter("hash");
        Map getHash = this.shareResourceService.getPdfPath(hash);
        this.pdfFileId = getHash.get("filePath").toString();
        Map readInfo = new HashMap<String, String>();
        Object cacheMap = this.hussarCacheManager.getObject("MP4READLOCK", this.pdfFileId);
        if (cacheMap != null) {
            readInfo = (Map)cacheMap;
        }
        readInfo.put(uuid, "READING");
        this.hussarCacheManager.setObject("MP4READLOCK", this.pdfFileId, readInfo);
        File file = null;
        try {
            file = this.fileTool.downLoadFile(this.pdfFileId);
            randomFile = new RandomAccessFile(file, "r");
            long contentLength = file.length();
            String range = request.getHeader("Range");
            int start = 0;
            int end = 0;
            if (range != null && range.startsWith("bytes=")) {
                String[] values = range.split("=")[1].split("-");
                start = Integer.parseInt(values[0]);
                if (values.length > 1) {
                    end = Integer.parseInt(values[1]);
                }
            }
            int requestSize = 0;
            requestSize = end != 0 && end > start ? end - start + 1 : Integer.MAX_VALUE;
            byte[] buffer = new byte[4096];
            response.setContentType("video/mp4");
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("ETag", this.fileName);
            response.setHeader("Last-Modified", new Date().toString());
            if (range == null) {
                response.setHeader("Content-length", contentLength + "");
            } else {
                response.setStatus(206);
                long requestStart = 0L;
                long requestEnd = 0L;
                String[] ranges = range.split("=");
                if (ranges.length > 1) {
                    String[] rangeDatas = ranges[1].split("-");
                    requestStart = Integer.parseInt(rangeDatas[0]);
                    if (rangeDatas.length > 1) {
                        requestEnd = Integer.parseInt(rangeDatas[1]);
                    }
                }
                long length = 0L;
                if (requestEnd > 0L) {
                    length = requestEnd - requestStart + 1L;
                    response.setHeader("Content-length", "" + length);
                    response.setHeader("Content-Range", "bytes " + requestStart + "-" + requestEnd + "/" + contentLength);
                } else {
                    length = contentLength - requestStart;
                    response.setHeader("Content-length", "" + length);
                    response.setHeader("Content-Range", "bytes " + requestStart + "-" + (contentLength - 1L) + "/" + contentLength);
                }
            }
            out = response.getOutputStream();
            randomFile.seek(start);
            for (int needSize = requestSize; needSize > 0; needSize -= buffer.length) {
                int len = randomFile.read(buffer);
                if (needSize < buffer.length) {
                    out.write(buffer, 0, needSize);
                    continue;
                }
                out.write(buffer, 0, len);
                if (len >= buffer.length) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
        catch (ServiceException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
        finally {
            if (randomFile != null) {
                try {
                    randomFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
                    e.printStackTrace();
                }
            }
            if ((cacheMap = this.hussarCacheManager.getObject("MP4READLOCK", this.pdfFileId)) != null) {
                readInfo = (Map)cacheMap;
            }
            readInfo.remove(uuid);
            this.hussarCacheManager.setObject("MP4READLOCK", this.pdfFileId, readInfo);
            if (readInfo.size() == 0 && this.fastdfsUsingFlag && file != null) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/list"})
    public void getList(HttpServletRequest request, HttpServletResponse response) {
        String pdfFileId = request.getParameter("fileId");
        String isThumbnails = request.getParameter("isThumbnails");
        String isView = request.getParameter("isView");
        FileInputStream input = null;
        RandomAccessFile randomAccessFile = null;
        InputStream inputStream = null;
        try {
            if (isView != null && isView.equals("0")) {
                File file = null;
                List<FsFile> list = this.fsFileMapper.getInfoByPdfPath(pdfFileId);
                String random = list.get(0).getMd5();
                String suffix = pdfFileId.substring(pdfFileId.lastIndexOf("."));
                file = new File(this.downloadPdfFile + "\\" + random + suffix);
                if (!file.exists()) {
                    file = this.fileTool.chuckPdf(pdfFileId);
                }
                inputStream = new FileInputStream(file);
                byte[] bytes = new byte[inputStream.available()];
                inputStream.read(bytes);
                if (file.length() < 512000L) {
                    response.setDateHeader("expires", System.currentTimeMillis() + 604800000L);
                }
                response.setHeader("Accept-Ranges", "bytes");
                response.setHeader("Content-Type", "application/pdf");
                String range = request.getHeader("Range");
                if (ToolUtil.isNotEmpty((Object)range)) {
                    range = range.replace("bytes=", "");
                    String[] ranges = range.split("-");
                    int startIndex = Integer.parseInt(ranges[0]);
                    int endIndex = Integer.parseInt(ranges[1]);
                    byte[] buffer = new byte[endIndex - startIndex + 1];
                    randomAccessFile = new RandomAccessFile(file, "r");
                    randomAccessFile.seek(startIndex);
                    randomAccessFile.read(buffer);
                    response.setHeader("Content-Range", "bytes " + startIndex + "-" + (endIndex - 1) + "/" + file.length() + "");
                    response.setStatus(206);
                    response.getOutputStream().write(buffer);
                } else {
                    response.setHeader("Content-Length", file.length() + "");
                    response.getOutputStream().write(bytes);
                }
            } else {
                byte[] bytes = this.fileTool.downLoadFile(input, pdfFileId, isThumbnails);
                if (bytes.length < 512000) {
                    response.setDateHeader("expires", System.currentTimeMillis() + 604800000L);
                }
                response.getOutputStream().write(bytes);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOGGER.error("\u6ca1\u6709\u627e\u5230\u6587\u4ef6\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
        catch (ServiceException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
        catch (Exception e) {
            LOGGER.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
            e.printStackTrace();
        }
        finally {
            try {
                if (response.getOutputStream() != null) {
                    response.getOutputStream().close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
            }
        }
    }

    @RequestMapping(value={"/toShowPDF"})
    public String toShowPDF(String id, HttpServletRequest request, Model model) {
        String keyword = request.getParameter("keyword");
        model.addAttribute("fileName", (Object)keyword);
        model.addAttribute("fileType", (Object)this.fileType);
        model.addAttribute("category", (Object)this.orderType);
        model.addAttribute("isPersonCenter", (Object)false);
        String requestHeader = request.getHeader("user-agent");
        if (DeviceUtil.isMobileDevice((String)requestHeader)) {
            return "/doc/front/preview/sharePDF_mobile.html";
        }
        return "/doc/front/preview/sharePDF.html";
    }

    @RequestMapping(value={"/getFoldPath"})
    @ResponseBody
    public List<Map<String, String>> getFoldPathByDocId(String docId) {
        return this.previewService.getFoldPathByDocId(docId);
    }

    @RequestMapping(value={"/getFolderPath"})
    @ResponseBody
    public List<Map<String, String>> getFolderPathByDocId(String folderId, String folderName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foldId", folderId);
        map.put("foldName", folderName);
        return this.previewService.getFoldPathByFolder(map);
    }

    @RequestMapping(value={"/fileDetail"})
    @ResponseBody
    public Map<String, Object> getFileDetail(String hash) {
        boolean pdfFlag = this.shareResourceService.isPdfPathExist(hash);
        if (!pdfFlag) {
            this.shareResourceService.setPdfPathFast(hash);
        }
        Map map = this.frontDocInfoService.getDocByHash(hash);
        map.put("fileSuffixName", map.get("fileSuffixName").toString().substring(map.get("fileSuffixName").toString().lastIndexOf(".") + 1));
        map.put("fileSize", FileTool.longToString(map.get("fileSize").toString()));
        map.put("uploadState", pdfFlag);
        return map;
    }

    @RequestMapping(value={"/toShowIMG"})
    public ModelAndView toShowIMG(String id, HttpServletRequest request) {
        String requestHeader = request.getHeader("user-agent");
        ModelAndView mv = DeviceUtil.isMobileDevice((String)requestHeader) ? new ModelAndView("/doc/front/preview/shareImg_mobile.html") : new ModelAndView("/doc/front/preview/shareImg.html");
        mv.addObject("fileType", (Object)this.fileType);
        mv.addObject("isPersonCenter", (Object)false);
        mv.addObject("category", (Object)this.orderType);
        return mv;
    }

    @RequestMapping(value={"/toShowVoice"})
    public String toShowVoice(String id, Model model) {
        model.addAttribute("id", (Object)id);
        model.addAttribute("fileType", (Object)this.fileType);
        model.addAttribute("category", (Object)this.orderType);
        model.addAttribute("userName", (Object)"\u5206\u4eab\u7528\u6237");
        model.addAttribute("isPersonCenter", (Object)false);
        return "/doc/front/preview/shareVoice.html";
    }

    @RequestMapping(value={"/toShowVideo"})
    public String toShowVideo(String id, Model model) {
        model.addAttribute("id", (Object)id);
        model.addAttribute("fileType", (Object)this.fileType);
        model.addAttribute("category", (Object)this.orderType);
        model.addAttribute("isPersonCenter", (Object)false);
        model.addAttribute("userName", (Object)"\u6d4b\u8bd5");
        return "/doc/front/preview/shareVideo.html";
    }

    @RequestMapping(value={"/toShowOthers"})
    public String toShowOthers(String id, Model model) {
        model.addAttribute("fileType", (Object)this.fileType);
        model.addAttribute("category", (Object)this.orderType);
        model.addAttribute("isPersonCenter", (Object)false);
        model.addAttribute("id", (Object)"id");
        return "/doc/front/preview/shareOthers.html";
    }

    @RequestMapping(value={"/fileView"})
    public String shareFile(String type, String id, HttpServletRequest request, Model model) {
        String path = "";
        if ("pdf".equals(type)) {
            path = this.toShowPDF(id, request, model);
        }
        if ("mp4".equals(type)) {
            path = this.toShowVideo(id, model);
        }
        return path;
    }

    @RequestMapping(value={"/folderIMG"})
    @ResponseBody
    public Map<String, Object> folderIMG(String page, String limit, String folderId, String docId) {
        HashMap<String, Object> imgs = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        folderId = "8e4abfa7c6bb470dafb90947966efc6f";
        int pageNum = Integer.parseInt(page);
        int pageSize = Integer.parseInt(limit);
        int startIndex = (pageNum - 1) * pageSize;
        int count = this.frontDocInfoService.getFolderImgForShareCount(folderId);
        if (folderId != null) {
            List<DocInfo> docInfos = this.frontDocInfoService.getFolderImgForShare(startIndex, pageSize, folderId);
            for (DocInfo docInfo : docInfos) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("authority", docInfo.getAuthority());
                map.put("id", docInfo.getDocId());
                map.put("filePath", docInfo.getFilePath());
                map.put("filePdfPath", docInfo.getFilePdfPath());
                map.put("title", docInfo.getTitle());
                map.put("docType", docInfo.getDocType().replace(".", ""));
                map.put("docId", docInfo.getDocId());
                if (docInfo.getFileSize() != null && !"".equals(docInfo.getFileSize())) {
                    map.put("fileSize", FileTool.longToString(docInfo.getFileSize()));
                }
                if (docInfo.getDocId().equals(docId)) {
                    map.put("isSelf", true);
                    list.add(0, map);
                    continue;
                }
                map.put("isSelf", false);
                list.add(map);
            }
        }
        imgs.put("items", list);
        imgs.put("success", true);
        imgs.put("total", list.size());
        imgs.put("count", count);
        return imgs;
    }

    @RequestMapping(value={"/checkUploadState"})
    @ResponseBody
    public boolean checkUploadState(String hash) {
        return this.shareResourceService.isPdfPathExist(hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/videos"})
    public void getVideos(HttpServletRequest request, HttpServletResponse response) {
        String uuid = UUID.randomUUID().toString();
        RandomAccessFile randomFile = null;
        ServletOutputStream out = null;
        this.pdfFileId = request.getParameter("fileId");
        Map readInfo = new HashMap<String, String>();
        Object cacheMap = this.hussarCacheManager.getObject("MP4READLOCK", this.pdfFileId);
        if (cacheMap != null) {
            readInfo = (Map)cacheMap;
        }
        readInfo.put(uuid, "READING");
        this.hussarCacheManager.setObject("MP4READLOCK", this.pdfFileId, readInfo);
        File file = null;
        try {
            file = this.fileTool.downLoadFile(this.pdfFileId);
            randomFile = new RandomAccessFile(file, "r");
            long contentLength = file.length();
            String range = request.getHeader("Range");
            int start = 0;
            int end = 0;
            if (range != null && range.startsWith("bytes=")) {
                String[] values = range.split("=")[1].split("-");
                start = Integer.parseInt(values[0]);
                if (values.length > 1) {
                    end = Integer.parseInt(values[1]);
                }
            }
            int requestSize = 0;
            requestSize = end != 0 && end > start ? end - start + 1 : Integer.MAX_VALUE;
            byte[] buffer = new byte[4096];
            response.setContentType("video/mp4");
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("ETag", this.fileName);
            response.setHeader("Last-Modified", new Date().toString());
            if (range == null) {
                response.setHeader("Content-length", contentLength + "");
            } else {
                response.setStatus(206);
                long requestStart = 0L;
                long requestEnd = 0L;
                String[] ranges = range.split("=");
                if (ranges.length > 1) {
                    String[] rangeDatas = ranges[1].split("-");
                    requestStart = Integer.parseInt(rangeDatas[0]);
                    if (rangeDatas.length > 1) {
                        requestEnd = Integer.parseInt(rangeDatas[1]);
                    }
                }
                long length = 0L;
                if (requestEnd > 0L) {
                    length = requestEnd - requestStart + 1L;
                    response.setHeader("Content-length", "" + length);
                    response.setHeader("Content-Range", "bytes " + requestStart + "-" + requestEnd + "/" + contentLength);
                } else {
                    length = contentLength - requestStart;
                    response.setHeader("Content-length", "" + length);
                    response.setHeader("Content-Range", "bytes " + requestStart + "-" + (contentLength - 1L) + "/" + contentLength);
                }
            }
            out = response.getOutputStream();
            randomFile.seek(start);
            for (int needSize = requestSize; needSize > 0; needSize -= buffer.length) {
                int len = randomFile.read(buffer);
                if (needSize < buffer.length) {
                    out.write(buffer, 0, needSize);
                    continue;
                }
                out.write(buffer, 0, len);
                if (len >= buffer.length) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
        catch (ServiceException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
        }
        finally {
            if (randomFile != null) {
                try {
                    randomFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
                    e.printStackTrace();
                }
            }
            if ((cacheMap = this.hussarCacheManager.getObject("MP4READLOCK", this.pdfFileId)) != null) {
                readInfo = (Map)cacheMap;
            }
            readInfo.remove(uuid);
            this.hussarCacheManager.setObject("MP4READLOCK", this.pdfFileId, readInfo);
            if (readInfo.size() == 0 && this.fastdfsUsingFlag && file != null) {
                file.delete();
            }
        }
    }
}

