/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.front.docmanager.controller;

import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.docutil.service.ESService;
import com.jxdinfo.doc.common.docutil.service.FastdfsService;
import com.jxdinfo.doc.common.util.PdfUtil;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.common.util.TikaUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.front.docmanager.service.PageOfficeService;
import com.jxdinfo.doc.manager.docmanager.ex.ServiceException;
import com.jxdinfo.doc.manager.docmanager.model.DocInfo;
import com.jxdinfo.doc.manager.docmanager.model.DocResourceLog;
import com.jxdinfo.doc.manager.docmanager.model.FsFile;
import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.doc.manager.docmanager.service.FsFileService;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.groupmanager.service.DocGroupService;
import com.jxdinfo.hussar.bsp.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.encrypt.file.FileEncryptUtil;
import com.zhuozhengsoft.pageoffice.FileSaver;
import com.zhuozhengsoft.pageoffice.OfficeVendorType;
import com.zhuozhengsoft.pageoffice.OpenModeType;
import com.zhuozhengsoft.pageoffice.PageOfficeCtrl;
import com.zhuozhengsoft.pageoffice.PageOfficeLink;
import com.zhuozhengsoft.pageoffice.poserver.Server;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.tika.exception.TikaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.xml.sax.SAXException;

@RestController
@RequestMapping(value={"/editDoc"})
public class PageOfficeController {
    public static final Logger logger = LoggerFactory.getLogger(PageOfficeController.class);
    @Value(value="${docbase.filedir}")
    private String tempdir;
    @Value(value="${docbase.editdir}")
    private String editdir;
    @Value(value="${fastdfs.using}")
    private boolean fastdfsUsingFlag;
    @Autowired
    private ESService esService;
    @Resource
    private FsFileService fsFileService;
    @Resource
    private PageOfficeService pageOfficeService;
    @Autowired
    private FastdfsService fastdfsService;
    @Autowired
    private DocGroupService docGroupService;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private BusinessService businessService;
    @Resource
    private DocInfoService docInfoService;

    @RequestMapping(value={"/getWord"}, method={RequestMethod.GET})
    public String getWord(HttpServletRequest request, String docId) {
        String link = PageOfficeLink.openWindow((HttpServletRequest)request, (String)("/editDoc/word?docId=" + docId + "&" + Math.random()), (String)"width=800px;height=800px;");
        return link;
    }

    @RequestMapping(value={"/word"}, method={RequestMethod.GET})
    public ModelAndView showWord(HttpServletRequest request, Map<String, Object> map, String docId, String fileType, String keyWords, String userId, String userName) {
        try {
            String keyword = request.getParameter("keyword");
            List<String> listGroup = this.docGroupService.getPremission(userId);
            FsFolderParams fsFolderParams = new FsFolderParams();
            fsFolderParams.setGroupList(listGroup);
            fsFolderParams.setUserId(userId);
            fsFolderParams.setType("2");
            userName = ((SysUsers)this.sysUsersMapper.selectById((Serializable)((Object)userId))).getUserName();
            DocInfo docInfo = this.docInfoService.getDocDetail(docId);
            String path = "";
            if (!this.fastdfsUsingFlag) {
                path = docInfo.getFilePath();
                path = path.replaceAll("/", "\\\\");
            } else {
                path = this.pageOfficeService.getEditFileByFast(docId);
                path = path.replaceAll("/", "\\\\");
            }
            logger.info("******************\u672c\u5730\u8def\u5f84:" + path + "\uff0c******************");
            PageOfficeCtrl poCtrl = new PageOfficeCtrl(request);
            poCtrl.setOfficeVendor(OfficeVendorType.WPSOffice);
            poCtrl.setServerPage("/poserver.zz");
            poCtrl.setJsFunction_AfterDocumentOpened("AfterDocOpened");
            poCtrl.addCustomToolButton("\u4fdd\u5b58", "Save", 1);
            poCtrl.setSaveFilePage("/editDoc/save?docId=" + docId);
            if (path.endsWith(".doc") || path.endsWith("docx")) {
                poCtrl.webOpen(path, OpenModeType.docAdmin, userName);
            } else if (path.endsWith(".ppt") || path.endsWith("pptx")) {
                poCtrl.webOpen(path, OpenModeType.pptNormalEdit, userName);
            } else if (path.endsWith(".xls") || path.endsWith("xlsx")) {
                poCtrl.webOpen(path, OpenModeType.xlsNormalEdit, userName);
            }
            map.put("pageoffice", poCtrl.getHtmlCode("PageOfficeCtrl1"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ModelAndView mv = new ModelAndView("/doc/front/docmanager/pageOffice2.html");
        String type = fileType == null ? "" : fileType;
        String docName = keyWords == null ? "" : keyWords;
        mv.addObject("fileType", (Object)type);
        mv.addObject("key", (Object)docName);
        mv.addObject("id", (Object)docId);
        mv.addObject("isPersonCenter", (Object)false);
        mv.addObject("fileName", (Object)keyWords);
        mv.addObject("fileType", (Object)fileType);
        mv.addObject("userName", (Object)userName);
        mv.addObject("favorite", (Object)false);
        return mv;
    }

    @RequestMapping(value={"/save"})
    public void saveFile(HttpServletRequest request, HttpServletResponse response, String docId) {
        FileSaver fs = new FileSaver(request, response);
        String sourcePath = "";
        File newFile = null;
        sourcePath = this.tempdir + fs.getFileName();
        logger.info("******************\u7f16\u8f91\u540e\u8def\u5f84:" + sourcePath + "\uff0c******************");
        if (sourcePath.indexOf("_edit") == -1) {
            sourcePath = sourcePath.substring(0, sourcePath.lastIndexOf(".")) + "_edit1" + sourcePath.substring(sourcePath.lastIndexOf("."));
        } else {
            String subPath = sourcePath.substring(sourcePath.lastIndexOf("_edit"), sourcePath.lastIndexOf("."));
            subPath = subPath.substring(subPath.indexOf("t") + 1, subPath.length());
            Integer editNum = 1;
            editNum = "".equals(subPath) ? Integer.valueOf(1) : Integer.valueOf(Integer.parseInt(subPath) + 1);
            sourcePath = sourcePath.substring(0, sourcePath.indexOf("_edit")) + sourcePath.substring(sourcePath.indexOf("."), sourcePath.length());
            sourcePath = sourcePath.substring(0, sourcePath.lastIndexOf(".")) + "_edit" + editNum + sourcePath.substring(sourcePath.lastIndexOf("."));
        }
        logger.info("******************\u7f16\u8f91\u540eedit\u8def\u5f84:" + sourcePath + "\uff0c******************");
        fs.saveToFile(sourcePath);
        File oldFile = new File(sourcePath);
        Map metadata = null;
        try {
            metadata = TikaUtil.autoParse((String)sourcePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (TikaException e) {
            e.printStackTrace();
        }
        String content = metadata.get("content").toString().replaceAll("<", "<&nbsp;");
        HashMap<String, Object> docVO = new HashMap<String, Object>();
        docVO.put("upDate", new Date());
        docVO.put("content", StringUtil.getString((Object)content));
        try {
            this.esService.updateIndex(docId, docVO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String pdfFilePath = sourcePath.substring(0, sourcePath.lastIndexOf(".")) + ".pdf";
        logger.info("******************\u7f16\u8f91\u540eedit\u7684pdf\u8def\u5f84:" + pdfFilePath + "\uff0c******************");
        if (fs.getFileName().endsWith(".doc") || fs.getFileName().endsWith(".docx")) {
            PdfUtil.word2pdf((String)sourcePath, (String)pdfFilePath);
        } else if (fs.getFileName().endsWith(".xls") || fs.getFileName().endsWith(".xlsx")) {
            try {
                logger.info("******************\u7f16\u8f91\u540eedit\u7684pdf\u8def\u5f84:" + pdfFilePath + "\uff0c\u548c" + sourcePath + "******************");
                PdfUtil.excel2Pdf((String)sourcePath, (String)pdfFilePath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (fs.getFileName().endsWith(".ppt") || fs.getFileName().endsWith(".pptx")) {
            try {
                PdfUtil.ppt2pdf((String)sourcePath, (String)pdfFilePath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            pdfFilePath = fs.getFileName().endsWith(".pdf") ? sourcePath : null;
        }
        if (pdfFilePath != null) {
            if (!this.fastdfsUsingFlag) {
                File file = new File(sourcePath);
                FsFile fsFile = new FsFile();
                try {
                    String md5 = DigestUtils.md5Hex((InputStream)new FileInputStream(file));
                    fsFile.setMd5(md5);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                fsFile.setFileId(docId);
                fsFile.setFilePdfPath(pdfFilePath);
                fsFile.setFilePath(sourcePath);
                this.fsFileService.updateById((Object)fsFile);
            } else {
                newFile = new File(oldFile.getParentFile() + File.separator + oldFile.getName().substring(0, oldFile.getName().lastIndexOf(".")) + "_new" + oldFile.getName().substring(oldFile.getName().indexOf("."), oldFile.getName().length()));
                FsFile fsFile = new FsFile();
                String sourceKey = FileEncryptUtil.getInstance().encrypt(oldFile, newFile);
                fsFile.setSourceKey(sourceKey);
                try {
                    String filePath = this.fastdfsService.uploadFile(newFile);
                    fsFile.setFileId(docId);
                    try {
                        String md5 = DigestUtils.md5Hex((InputStream)new FileInputStream(newFile));
                        fsFile.setMd5(md5);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    fsFile.setFilePath(filePath);
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                File pdfFile = new File(pdfFilePath);
                String pdfKey = FileEncryptUtil.getInstance().encrypt(pdfFile);
                fsFile.setPdfKey(pdfKey);
                try {
                    String pdfPath = this.fastdfsService.uploadFile(pdfFile);
                    fsFile.setFilePdfPath(pdfPath);
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                this.fsFileService.updateById((Object)fsFile);
            }
        }
        ArrayList<DocResourceLog> resInfoList = new ArrayList<DocResourceLog>();
        DocResourceLog docResourceLog = new DocResourceLog();
        String id = UUID.randomUUID().toString().replace("-", "");
        docResourceLog.setId(id);
        docResourceLog.setResourceId(docId);
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        docResourceLog.setOperateTime(ts);
        docResourceLog.setResourceType(0);
        String userId = UserInfoUtil.getUserInfo().get("ID").toString();
        docResourceLog.setUserId(userId);
        docResourceLog.setOperateType(1);
        docResourceLog.setValidFlag("1");
        resInfoList.add(docResourceLog);
        this.docInfoService.insertResourceLog(resInfoList);
        fs.close();
    }

    @Bean
    public ServletRegistrationBean servletRegistrationOfficeBean() {
        Server poserver = new Server();
        poserver.setSysPath(this.editdir);
        ServletRegistrationBean srb = new ServletRegistrationBean((Servlet)poserver, new String[0]);
        srb.addUrlMappings(new String[]{"/poserver.zz"});
        srb.addUrlMappings(new String[]{"/posetup.exe"});
        srb.addUrlMappings(new String[]{"/pageoffice.js"});
        srb.addUrlMappings(new String[]{"/jquery.min.js"});
        srb.addUrlMappings(new String[]{"/pobstyle.css"});
        srb.addUrlMappings(new String[]{"/sealsetup.exe"});
        return srb;
    }

    public static String getFileMD5(File file) {
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        MessageDigest digest = null;
        FileInputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            int len;
            digest = MessageDigest.getInstance("MD5");
            in = new FileInputStream(file);
            while ((len = in.read(buffer, 0, 1024)) != -1) {
                digest.update(buffer, 0, len);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        BigInteger bigInt = new BigInteger(1, digest.digest());
        return bigInt.toString(16);
    }
}

