/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.front.docmanager.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.toolkit.IdWorker;
import com.jxdinfo.doc.front.docmanager.model.DocFeedback;
import com.jxdinfo.doc.front.docmanager.model.FeedbackAttachment;
import com.jxdinfo.doc.front.docmanager.service.DocFeedbackService;
import com.jxdinfo.doc.front.docmanager.service.FeedbackAttachmentService;
import com.jxdinfo.doc.manager.docmanager.service.FilesService;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/feedback"})
public class FeedbackController {
    private String prefixFront = "/doc/front/docmanager/";
    private String prefixManager = "/doc/manager/feedbackmanager/";
    @Autowired
    private DocFeedbackService docFeedbackService;
    @Autowired
    private FeedbackAttachmentService feedbackAttachmentService;
    @Autowired
    private FilesService filesService;

    @RequestMapping(value={""})
    public String openFeedback() {
        return this.prefixFront + "front-feedback.html";
    }

    @RequestMapping(value={"/add_feedback"})
    @ResponseBody
    public String addFeedback(String feedbackType, String feedbackDescribe, String contackWay, String attachmentUrls) {
        DocFeedback feedback = new DocFeedback(feedbackType, contackWay, feedbackDescribe);
        String userId = ShiroKit.getUser().getId();
        String userName = ShiroKit.getUser().getName();
        feedback.setFeedbackUserId(userId);
        feedback.setFeedbackUser(userName);
        feedback.setFeedbackTime(new Timestamp(new Date().getTime()));
        boolean isAdd1 = this.docFeedbackService.insert((Object)feedback);
        boolean isAdd2 = true;
        if (!"".equals(attachmentUrls) && attachmentUrls != null) {
            String[] urls = attachmentUrls.split(",");
            ArrayList<FeedbackAttachment> attachments = new ArrayList<FeedbackAttachment>();
            for (String url : urls) {
                FeedbackAttachment attachment = new FeedbackAttachment();
                attachment.setAttachmentType("0");
                attachment.setFeedbackId(feedback.getFeedbackId());
                attachment.setAttachmentUrl(url);
                attachments.add(attachment);
            }
            isAdd2 = this.feedbackAttachmentService.insertBatch(attachments);
        }
        return isAdd1 && isAdd2 ? "\u53cd\u9988\u6210\u529f" : "\u53cd\u9988\u5931\u8d25";
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/upload_attachment"})
    @ResponseBody
    public JSONObject upload(@RequestPart(value="file") MultipartFile file) {
        JSONObject json = new JSONObject();
        String fileName = file.getOriginalFilename();
        String prefix = fileName.substring(fileName.lastIndexOf("."));
        String fName = IdWorker.get32UUID() + prefix;
        try {
            String filePath = this.filesService.upload(file, fName);
            json.put("fName", (Object)filePath);
            json.put("fileName", (Object)fileName);
        }
        catch (IOException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.UPLOAD_ERROR);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    @RequiresPermissions(value={"feedback:manager"})
    @RequestMapping(value={"/manager"})
    public String manageFeedback() {
        return this.prefixManager + "feedback-manager.html";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public Map<String, Object> getList(@RequestParam(value="pageNumber", defaultValue="1") int pageNumber, @RequestParam(value="pageSize", defaultValue="20") int pageSize, String name) {
        List list = new ArrayList();
        list = name != null && name != "" ? this.docFeedbackService.selectList(new EntityWrapper().like("feedback_user", "%" + name + "%").orderBy("feedback_time", false)) : this.docFeedbackService.selectList(new EntityWrapper().orderBy("feedback_time", false));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", list.size());
        map.put("rows", list.stream().skip((pageNumber - 1) * pageSize).limit(pageSize).collect(Collectors.toList()));
        return map;
    }

    @RequestMapping(value={"/viewFeedback/{feedbackId}"})
    public String viewFeedback(@PathVariable String feedbackId, Model model) {
        DocFeedback docFeedback = this.docFeedbackService.selectDetailFeedback(feedbackId);
        String json = JSONObject.toJSONString(docFeedback.getFeedbackAttachments());
        model.addAttribute("feedback", (Object)docFeedback);
        model.addAttribute("imgs", (Object)json);
        return this.prefixManager + "feedback-detail.html";
    }

    @RequestMapping(value={"/delFeedback"})
    @ResponseBody
    public int delFeedback(String feedbackIds) {
        String[] ids = feedbackIds.split(",");
        List<String> idList = Arrays.asList(ids);
        int result = 0;
        boolean attachFlag = this.feedbackAttachmentService.delete(new EntityWrapper().in("feedback_id", idList));
        boolean feedbackFlag = this.docFeedbackService.deleteBatchIds(idList);
        result = attachFlag && feedbackFlag ? 1 : 0;
        return result;
    }
}

