/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.util;

import com.jxdinfo.doc.common.docutil.model.ESResponse;
import com.jxdinfo.doc.common.util.PrivilegeUtil;
import com.jxdinfo.doc.manager.docmanager.dao.DocInfoMapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ESUtil {
    @Value(value="${docbase.es-base}")
    private String INDEX_OF_DOCBASE;
    @Value(value="${examine.using}")
    private boolean examineUsingFlag;
    @Resource
    private DocInfoMapper docInfoMapper;
    private String TYPE_OF_DOCBASE = "doc";
    private String[] FIELDS_OF_DOC = new String[]{"title", "category", "tags", "content", "readType"};
    private int SIZE_OF_PAGE = 10;
    private String hosts;
    private TransportClient client = null;

    public ESUtil(@Value(value="${docbase.es-host}") String hosts) {
        this.hosts = hosts;
        this.client = new PreBuiltTransportClient(Settings.EMPTY, new Class[0]);
        for (String host : this.hosts.split(",")) {
            try {
                String address = host.split(":")[0];
                int port = Integer.parseInt(host.split(":")[1]);
                this.client.addTransportAddress(new TransportAddress(InetAddress.getByName(address), port));
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
    }

    public void createIndex() throws IOException {
        if (((IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{this.INDEX_OF_DOCBASE}).get()).isExists()) {
            this.client.admin().indices().prepareDelete(new String[]{this.INDEX_OF_DOCBASE}).get();
        }
        Settings settings = Settings.builder().put("index.number_of_shards", 3).put("index.number_of_replicas", 2).build();
        HashMap mappings = new HashMap();
        HashMap types = new HashMap();
        HashMap properties = new HashMap();
        for (String field : this.FIELDS_OF_DOC) {
            HashMap<String, String> property = new HashMap<String, String>();
            property.put("type", "text");
            property.put("analyzer", "ik_max_word");
            property.put("search_analyzer", "ik_max_word");
            properties.put(field, property);
        }
        types.put("properties", properties);
        mappings.put(this.TYPE_OF_DOCBASE, types);
        this.client.admin().indices().prepareCreate(this.INDEX_OF_DOCBASE).setSettings(settings).addMapping(this.TYPE_OF_DOCBASE, mappings).get();
    }

    public int index(String docId, Map<String, Object> source) {
        System.out.println("\u4f20\u8f93\u7684\u503c\u4e3a\uff1a" + source);
        IndexResponse response = (IndexResponse)this.client.prepareIndex(this.INDEX_OF_DOCBASE, this.TYPE_OF_DOCBASE, docId).setSource(source).get();
        RestStatus status = response.status();
        return status.getStatus();
    }

    public Map<String, Object> getIndex(String docId) {
        GetResponse response = (GetResponse)this.client.prepareGet(this.INDEX_OF_DOCBASE, this.TYPE_OF_DOCBASE, docId).get();
        if (response.isExists()) {
            return response.getSourceAsMap();
        }
        return null;
    }

    public int copyIndex(String oldDocId, String newDocId) {
        GetResponse response = (GetResponse)this.client.prepareGet(this.INDEX_OF_DOCBASE, this.TYPE_OF_DOCBASE, oldDocId).get();
        Map sourceMap = response.getSourceAsMap();
        System.out.println("****************************************************************************\u79d2\u4f20\u662f\u8f93\u51fa\u7684\u7d22\u5f15\uff1a" + sourceMap);
        sourceMap.put("recycle", "1");
        IndexResponse indexResponse = (IndexResponse)this.client.prepareIndex(this.INDEX_OF_DOCBASE, this.TYPE_OF_DOCBASE, newDocId).setSource(sourceMap).get();
        RestStatus status = indexResponse.status();
        return status.getStatus();
    }

    public int deleteIndex(String docId) {
        DeleteResponse response = (DeleteResponse)this.client.prepareDelete(this.INDEX_OF_DOCBASE, this.TYPE_OF_DOCBASE, docId).get();
        RestStatus status = response.status();
        return status.getStatus();
    }

    public int updateIndex(String docId, Map<String, Object> source) {
        UpdateResponse response = (UpdateResponse)this.client.prepareUpdate(this.INDEX_OF_DOCBASE, this.TYPE_OF_DOCBASE, docId).setDoc(source).get();
        RestStatus status = response.status();
        return status.getStatus();
    }

    public int upsertIndex(String docId, Map<String, Object> source) throws ExecutionException, InterruptedException {
        IndexRequest indexRequest = new IndexRequest(this.INDEX_OF_DOCBASE, this.TYPE_OF_DOCBASE, docId).source(source);
        UpdateRequest updateRequest = new UpdateRequest(this.INDEX_OF_DOCBASE, this.TYPE_OF_DOCBASE, docId).doc(source).upsert(indexRequest);
        UpdateResponse response = (UpdateResponse)this.client.update(updateRequest).get();
        return response.status().getStatus();
    }

    private ESResponse<Map<String, Object>> handleHits(SearchResponse response) {
        SearchHits hits = response.getHits();
        ESResponse<Map<String, Object>> result = new ESResponse<Map<String, Object>>();
        long totalHits = hits.totalHits;
        result.setTotal(totalHits);
        int totalPage = (int)(totalHits / 10L) + 1;
        result.setTotalPages(totalPage);
        List items = result.getItems();
        for (SearchHit searchHit : hits) {
            Map source = searchHit.getSourceAsMap();
            source.put("id", searchHit.getId());
            Map hightlightFields = searchHit.getHighlightFields();
            for (String key : hightlightFields.keySet()) {
                HighlightField field = (HighlightField)hightlightFields.get(key);
                Text[] fragments = field.fragments();
                StringBuffer sb = new StringBuffer();
                for (Text text : fragments) {
                    sb.append(text);
                }
                source.put(key, sb.toString());
            }
            items.add(source);
        }
        return result;
    }

    private SearchResponse doQuery(QueryBuilder queryBuilder, int page, Integer size) {
        if (size == null) {
            size = this.SIZE_OF_PAGE;
        }
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        for (String field : this.FIELDS_OF_DOC) {
            HighlightBuilder.Field fld = new HighlightBuilder.Field(field);
            fld.highlighterType("unified");
            highlightBuilder.field(fld);
        }
        String[] source = new String[]{"title", "upDate"};
        return (SearchResponse)this.client.prepareSearch(new String[]{this.INDEX_OF_DOCBASE}).setFetchSource(source, new String[0]).setFrom((page - 1) * size).setSize(size.intValue()).highlighter(highlightBuilder).setQuery(queryBuilder).addSort("_score", SortOrder.DESC).addSort("upDate", SortOrder.DESC).get();
    }

    public ESResponse<Map<String, Object>> matchQuery(String field, String keyword, int page, int size) {
        MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)field, (Object)keyword);
        SearchResponse response = this.doQuery((QueryBuilder)queryBuilder, page, size);
        return this.handleHits(response);
    }

    public ESResponse<Map<String, Object>> multiMatchQuery(String keyword, int page, Boolean adminFlag, Integer size) {
        String[] permission = PrivilegeUtil.getPremission();
        MultiMatchQueryBuilder queryBuilder = QueryBuilders.multiMatchQuery((Object)keyword, (String[])this.FIELDS_OF_DOC);
        TermsQueryBuilder termsQueryBuilder = QueryBuilders.termsQuery((String)"permission.keyword", (String[])permission);
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"recycle", (String)"1");
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).must((QueryBuilder)termQueryBuilder);
        if (!adminFlag.booleanValue()) {
            boolQueryBuilder.must((QueryBuilder)termsQueryBuilder);
        }
        SearchResponse response = this.doQuery((QueryBuilder)boolQueryBuilder, page, size);
        return this.handleHits(response);
    }

    public ESResponse<Map<String, Object>> multiMatchQuery(String keyword, int page, Boolean adminFlag, Integer size, String userId) {
        String[] permission = PrivilegeUtil.getPremission(userId);
        MultiMatchQueryBuilder queryBuilder = QueryBuilders.multiMatchQuery((Object)keyword, (String[])this.FIELDS_OF_DOC);
        TermsQueryBuilder termsQueryBuilder = QueryBuilders.termsQuery((String)"permission.keyword", (String[])permission);
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"recycle", (String)"1");
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).must((QueryBuilder)termQueryBuilder);
        if (!adminFlag.booleanValue()) {
            boolQueryBuilder.must((QueryBuilder)termsQueryBuilder);
        }
        SearchResponse response = this.doQuery((QueryBuilder)boolQueryBuilder, page, size);
        return this.handleHits(response);
    }

    public ESResponse<Map<String, Object>> onlyMatchWordQuery(String keyword, int size) {
        MatchPhraseQueryBuilder termQueryBuilder = QueryBuilders.matchPhraseQuery((String)"title", (Object)keyword);
        MatchPhraseQueryBuilder termQueryBuilder2 = QueryBuilders.matchPhraseQuery((String)"tags", (Object)keyword);
        MatchPhraseQueryBuilder termQueryBuilder3 = QueryBuilders.matchPhraseQuery((String)"content", (Object)keyword);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)termQueryBuilder).should((QueryBuilder)termQueryBuilder2).should((QueryBuilder)termQueryBuilder3);
        SearchResponse response = this.doQuery((QueryBuilder)boolQueryBuilder, 1, size);
        return this.handleHits(response);
    }

    public ESResponse<Map<String, Object>> boolQuery(String keyword, String contentType, int page, Boolean adminFlag, Integer size, String tagString) {
        String docType;
        String[] permission = PrivilegeUtil.getPremission();
        MultiMatchQueryBuilder queryBuilder = QueryBuilders.multiMatchQuery((Object)keyword, (String[])this.FIELDS_OF_DOC);
        TermsQueryBuilder termsQueryBuilder = QueryBuilders.termsQuery((String)"permission.keyword", (String[])permission);
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"recycle", (String)"1");
        TermsQueryBuilder queryStringQueryBuilder1 = null;
        QueryStringQueryBuilder queryStringQueryBuilder2 = null;
        BoolQueryBuilder boolQueryBuilder = null;
        if ("allword".equals(contentType)) {
            queryStringQueryBuilder1 = QueryBuilders.termsQuery((String)"contentType.keyword", (String[])new String[]{"application/msword", "spreadsheetml", "application/pdf", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "text/plain", "application/rtf", "application/vnd.openxmlformats-officedocument.presentationml.presentation"});
            boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).must((QueryBuilder)termQueryBuilder).must((QueryBuilder)queryStringQueryBuilder1);
        } else if ("video".equals(contentType)) {
            queryStringQueryBuilder1 = QueryBuilders.termsQuery((String)"contentType.keyword", (String[])new String[]{"application/mp4", "video/avi", "video/mpeg4", "video/mpeg4", "video/x-ms-wmv", "video/x-sgi-movie"});
            boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).must((QueryBuilder)termQueryBuilder).must((QueryBuilder)queryStringQueryBuilder1);
        } else if ("notimage".equals(contentType)) {
            contentType = "image";
            String psd = "contentType:*photoshop*";
            String docType2 = "contentType:*" + contentType + "*";
            if (!("text".equals(contentType) || "pdf".equals(contentType) || "msword".equals(contentType))) {
                docType2 = "contentType:*" + contentType.replaceAll(",", "*  contentType:*") + "*";
            }
            queryStringQueryBuilder2 = QueryBuilders.queryStringQuery((String)docType2);
            BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery().must((QueryBuilder)queryStringQueryBuilder2).mustNot((QueryBuilder)QueryBuilders.queryStringQuery((String)psd));
            boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).must((QueryBuilder)termQueryBuilder).mustNot((QueryBuilder)boolQueryBuilder2);
        } else if ("image".equals(contentType)) {
            docType = "contentType:*" + contentType + "*";
            String psd = "contentType:*photoshop*";
            if (!("text".equals(contentType) || "pdf".equals(contentType) || "msword".equals(contentType))) {
                docType = "contentType:*" + contentType.replaceAll(",", "*  contentType:*") + "*";
            }
            queryStringQueryBuilder2 = QueryBuilders.queryStringQuery((String)docType);
            boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).must((QueryBuilder)termQueryBuilder).must((QueryBuilder)queryStringQueryBuilder2).mustNot((QueryBuilder)QueryBuilders.queryStringQuery((String)psd));
            if (tagString != null && !"".equals(tagString) && tagString.split("\\|").length != 0) {
                String[] strs = tagString.split("\\|");
                for (int i = 0; i < strs.length; ++i) {
                    BoolQueryBuilder builderTag = QueryBuilders.boolQuery();
                    String[] strs_tags = strs[i].split(",");
                    for (int j = 0; j < strs_tags.length; ++j) {
                        String strs_tag = strs_tags[j];
                        builderTag.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"tags.keyword", (String)("*" + strs_tag + "*")));
                    }
                    boolQueryBuilder = boolQueryBuilder.must((QueryBuilder)builderTag);
                }
            }
        } else {
            docType = "contentType:*" + contentType + "*";
            if (!("text".equals(contentType) || "pdf".equals(contentType) || "msword".equals(contentType))) {
                docType = "contentType:*" + contentType.replaceAll(",", "*  contentType:*") + "*";
            }
            queryStringQueryBuilder2 = QueryBuilders.queryStringQuery((String)docType);
            boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).must((QueryBuilder)termQueryBuilder).must((QueryBuilder)queryStringQueryBuilder2);
        }
        if (!adminFlag.booleanValue()) {
            boolQueryBuilder.must((QueryBuilder)termsQueryBuilder);
        }
        SearchResponse response = this.doQuery((QueryBuilder)boolQueryBuilder, page, size);
        return this.handleHits(response);
    }

    public ESResponse<Map<String, Object>> boolQuery(String keyword, String contentType, int page, Boolean adminFlag, Integer size, String tagString, String userId) {
        String docType;
        String[] permission = PrivilegeUtil.getPremission(userId);
        MultiMatchQueryBuilder queryBuilder = QueryBuilders.multiMatchQuery((Object)keyword, (String[])this.FIELDS_OF_DOC);
        TermsQueryBuilder termsQueryBuilder = QueryBuilders.termsQuery((String)"permission.keyword", (String[])permission);
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"recycle", (String)"1");
        TermsQueryBuilder queryStringQueryBuilder1 = null;
        QueryStringQueryBuilder queryStringQueryBuilder2 = null;
        BoolQueryBuilder boolQueryBuilder = null;
        if ("allword".equals(contentType)) {
            queryStringQueryBuilder1 = QueryBuilders.termsQuery((String)"contentType.keyword", (String[])new String[]{"application/msword", "spreadsheetml", "application/pdf", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "text/plain", "application/rtf", "application/vnd.openxmlformats-officedocument.presentationml.presentation"});
            boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).must((QueryBuilder)termQueryBuilder).must((QueryBuilder)queryStringQueryBuilder1);
        } else if ("video".equals(contentType)) {
            queryStringQueryBuilder1 = QueryBuilders.termsQuery((String)"contentType.keyword", (String[])new String[]{"application/mp4", "video/avi", "video/mpeg4", "video/mpeg4", "video/x-ms-wmv", "video/x-sgi-movie"});
            boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).must((QueryBuilder)termQueryBuilder).must((QueryBuilder)queryStringQueryBuilder1);
        } else if ("notimage".equals(contentType)) {
            contentType = "image";
            String psd = "contentType:*photoshop*";
            String docType2 = "contentType:*" + contentType + "*";
            if (!("text".equals(contentType) || "pdf".equals(contentType) || "msword".equals(contentType))) {
                docType2 = "contentType:*" + contentType.replaceAll(",", "*  contentType:*") + "*";
            }
            queryStringQueryBuilder2 = QueryBuilders.queryStringQuery((String)docType2);
            BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery().must((QueryBuilder)queryStringQueryBuilder2).mustNot((QueryBuilder)QueryBuilders.queryStringQuery((String)psd));
            boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).must((QueryBuilder)termQueryBuilder).mustNot((QueryBuilder)boolQueryBuilder2);
        } else if ("image".equals(contentType)) {
            docType = "contentType:*" + contentType + "*";
            String psd = "contentType:*photoshop*";
            if (!("text".equals(contentType) || "pdf".equals(contentType) || "msword".equals(contentType))) {
                docType = "contentType:*" + contentType.replaceAll(",", "*  contentType:*") + "*";
            }
            queryStringQueryBuilder2 = QueryBuilders.queryStringQuery((String)docType);
            boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).must((QueryBuilder)termQueryBuilder).must((QueryBuilder)queryStringQueryBuilder2).mustNot((QueryBuilder)QueryBuilders.queryStringQuery((String)psd));
            if (tagString != null && !"".equals(tagString) && tagString.split("\\|").length != 0) {
                String[] strs = tagString.split("\\|");
                for (int i = 0; i < strs.length; ++i) {
                    BoolQueryBuilder builderTag = QueryBuilders.boolQuery();
                    String[] strs_tags = strs[i].split(",");
                    for (int j = 0; j < strs_tags.length; ++j) {
                        String strs_tag = strs_tags[j];
                        builderTag.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"tags", (String)("*" + strs_tag + "*")));
                    }
                    boolQueryBuilder = boolQueryBuilder.must((QueryBuilder)builderTag);
                }
            }
        } else {
            docType = "contentType:*" + contentType + "*";
            if (!("text".equals(contentType) || "pdf".equals(contentType) || "msword".equals(contentType))) {
                docType = "contentType:*" + contentType.replaceAll(",", "*  contentType:*") + "*";
            }
            queryStringQueryBuilder2 = QueryBuilders.queryStringQuery((String)docType);
            boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)queryBuilder).must((QueryBuilder)termQueryBuilder).must((QueryBuilder)queryStringQueryBuilder2);
        }
        if (!adminFlag.booleanValue()) {
            boolQueryBuilder.must((QueryBuilder)termsQueryBuilder);
        }
        SearchResponse response = this.doQuery((QueryBuilder)boolQueryBuilder, page, size);
        return this.handleHits(response);
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

