/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.docutil.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.doc.common.docutil.service.PdfService;
import com.jxdinfo.doc.common.util.ExceptionUtils;
import com.jxdinfo.doc.common.util.PdfUtil;
import com.jxdinfo.doc.common.util.TikaUtil;
import com.jxdinfo.doc.timer.client.ApiClient;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PdfServiceImpl
implements PdfService {
    public static final Logger LOGGER = LoggerFactory.getLogger(PdfServiceImpl.class);

    @Override
    public Map<String, Object> changeToPdf(String sourcePath, String targetPath, long fileSapce, String contentTypes, String fileId) throws Exception {
        String contentType;
        String content = null;
        boolean flag = false;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Object reader = null;
        try {
            if (fileSapce > 0x3200000L || fileId.endsWith(".ceb")) {
                content = "";
                contentType = contentTypes;
            } else {
                Map metadata = TikaUtil.autoParse((String)sourcePath);
                content = metadata.get("content").toString().replaceAll("<", "<&nbsp;");
                contentType = metadata.get("contentType").toString();
            }
            if (contentType.contains("powerpoint")) {
                contentType = contentType + ".presentationml";
            }
            if (contentType.contains("ms-excel")) {
                contentType = contentType + ".spreadsheetml";
            }
            if (contentType.contains("octet-stream")) {
                contentType = contentType + ".text/plain";
            }
            if (fileId.endsWith(".ceb")) {
                ApiClient client = new ApiClient();
                JSONObject cebName = new JSONObject();
                cebName.put("cebName", (Object)sourcePath);
                String ceb = client.cebToPdf(cebName);
                if (ceb != null && ceb.contains("true")) {
                    flag = true;
                    Map metadata = TikaUtil.autoParse((String)targetPath);
                    content = metadata.get("content").toString().replaceAll("<", "<&nbsp;");
                }
            } else if (contentType.contains("word") || contentType.contains("rtf")) {
                PdfUtil.word2pdf((String)sourcePath, (String)targetPath);
                flag = true;
            } else if (contentType.contains("text/html") && (fileId.endsWith(".doc") || fileId.endsWith(".docx"))) {
                PdfUtil.word2pdf((String)sourcePath, (String)targetPath);
                flag = true;
            } else if (contentType.contains("excel") || contentType.contains("spreadsheetml")) {
                PdfUtil.excel2Pdf((String)sourcePath, (String)targetPath);
                flag = true;
            } else if (contentType.contains("powerpoint") || contentType.contains("presentationml")) {
                PdfUtil.ppt2pdf((String)sourcePath, (String)targetPath);
                flag = true;
            } else if ((contentType.contains("octet-stream") || contentType.contains("text/plain")) && fileId.endsWith(".txt")) {
                PdfUtil.txt2pdf((String)sourcePath, (String)targetPath);
                flag = true;
            } else if (contentTypes != null && contentTypes.contains("image")) {
                double oldHeight;
                double toWidth = 290.0;
                String[] stringArray = new String[]{"jpg", "png", "gif", "bmp"};
                BufferedImage imageList = this.getImageList(sourcePath, stringArray);
                double oldWidth = imageList.getWidth();
                if (oldWidth / (oldHeight = (double)imageList.getHeight()) > 4.0) {
                    double toHeight = 200.0;
                    toWidth = toHeight / oldHeight * oldWidth;
                    this.writeHighQuality(targetPath, this.zoomImage(imageList, (int)toWidth, (int)toHeight));
                } else {
                    double toHeight = toWidth / oldWidth * oldHeight;
                    this.writeHighQuality(targetPath, this.zoomImage(imageList, (int)toWidth, (int)toHeight));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u8f6c\u6362PDF\u6587\u6863IO\u5f02\u5e38\uff1a" + ExceptionUtils.getErrorInfo((Exception)e));
            throw new Exception("\u8f6c\u6362PDF\u6587\u6863IO\u5f02\u5e38");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8f6c\u6362PDF\u683c\u5f0f\u51fa\u9519" + ExceptionUtils.getErrorInfo((Exception)e));
            throw new Exception("\u8f6c\u6362PDF\u683c\u5f0f\u51fa\u9519");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    System.out.println("\u5173\u95ed\u6d41\u9519\u8bef" + ExceptionUtils.getErrorInfo((Exception)e));
                }
            }
        }
        returnMap.put("targetPath", targetPath);
        returnMap.put("contentType", contentType);
        returnMap.put("content", content);
        returnMap.put("flag", flag);
        return returnMap;
    }

    public boolean writeHighQuality(String path, BufferedImage im) throws IOException {
        FileOutputStream newimage = null;
        try {
            newimage = new FileOutputStream(path);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)newimage);
            JPEGEncodeParam jep = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)im);
            jep.setQuality(1.0f, true);
            encoder.encode(im, jep);
            newimage.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public BufferedImage zoomImage(BufferedImage im, int toWidth, int toHeight) {
        BufferedImage result = new BufferedImage(toWidth, toHeight, 1);
        result.getGraphics().drawImage(im.getScaledInstance(toWidth, toHeight, 4), 0, 0, null);
        return result;
    }

    public BufferedImage getImageList(String ImgList, String[] type) throws IOException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (String s : type) {
            map.put(s, true);
        }
        BufferedImage imageList = null;
        File file = null;
        file = new File(ImgList);
        if (!file.exists()) {
            file.mkdir();
        }
        try {
            if (file.length() != 0L && map.get(this.getExtension(file.getName())) != null) {
                imageList = ImageIO.read(file);
            }
        }
        catch (Exception e) {
            imageList = null;
        }
        return imageList;
    }

    public boolean writeToDisk(BufferedImage im, String path, String fileName) {
        File f = new File(path + fileName);
        String fileType = this.getExtension(fileName);
        if (fileType == null) {
            return false;
        }
        try {
            ImageIO.write((RenderedImage)im, fileType, f);
            im.flush();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String getExtension(String fileName) {
        try {
            return fileName.split("\\.")[fileName.split("\\.").length - 1].toLowerCase();
        }
        catch (Exception e) {
            return null;
        }
    }
}

