/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.docutil.service.impl;

import com.jxdinfo.doc.common.docutil.service.DocConfigService;
import com.jxdinfo.doc.common.docutil.service.FileValidateService;
import com.jxdinfo.doc.common.util.FilenameUtils;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.manager.docmanager.ex.ParamException;
import com.jxdinfo.doc.manager.docmanager.ex.ServiceException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileValidateServiceImpl
implements FileValidateService {
    private static final String validateTypeKey = "fileValidType";
    @Autowired
    private DocConfigService docConfigService;
    private List<String> types;
    private boolean hasLoad = false;

    private void init() {
        if (!this.hasLoad) {
            String validateTypeCValue = this.docConfigService.getConfigValueByKey(validateTypeKey);
            this.types = !StringUtil.checkIsEmpty((String)validateTypeCValue) ? Arrays.asList(validateTypeCValue.split(",")) : new ArrayList<String>();
        }
    }

    @Override
    public void validateFile(File file) throws ServiceException {
        this.init();
        String ext = FilenameUtils.getExtension((String)file.getName());
        if (this.types.contains(ext.toLowerCase())) {
            throw new ParamException("file type error." + ext);
        }
    }
}

