/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.doc.common.docutil.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.jxdinfo.doc.common.docutil.dao.BusinessMapper;
import com.jxdinfo.doc.common.docutil.service.BusinessService;
import com.jxdinfo.doc.common.docutil.service.CacheToolService;
import com.jxdinfo.doc.common.docutil.service.impl.PdfServiceImpl;
import com.jxdinfo.doc.common.util.CommonUtil;
import com.jxdinfo.doc.common.util.ExceptionUtils;
import com.jxdinfo.doc.common.util.StringUtil;
import com.jxdinfo.doc.common.util.UserInfoUtil;
import com.jxdinfo.doc.front.docsharemanager.dao.ShareResourceMapper;
import com.jxdinfo.doc.front.groupmanager.service.FrontDocGroupService;
import com.jxdinfo.doc.front.topicmanager.service.FrontTopicService;
import com.jxdinfo.doc.manager.docintegral.dao.IntegralRuleMapper;
import com.jxdinfo.doc.manager.docmanager.service.DocInfoService;
import com.jxdinfo.doc.manager.foldermanager.model.FsFolderParams;
import com.jxdinfo.doc.manager.statistics.service.DeptStatisticsService;
import com.jxdinfo.doc.manager.statistics.service.FileStatisticsService;
import com.jxdinfo.doc.manager.topicmanager.model.SpecialTopic;
import com.jxdinfo.hussar.common.dicutil.DictionaryUtil;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CacheToolServiceImpl
implements CacheToolService {
    @Autowired
    private HussarCacheManager hussarCacheManager;
    @Autowired
    private DocInfoService docInfoService;
    @Autowired
    private FrontDocGroupService frontDocGroupService;
    @Autowired
    private FrontTopicService frontTopicService;
    @Resource
    private BusinessService businessService;
    @Autowired
    private DeptStatisticsService deptStatisticsService;
    @Resource
    private BusinessMapper businessMapper;
    @Autowired
    private FileStatisticsService fileStatisticsService;
    public static final Logger LOGGER = LoggerFactory.getLogger(PdfServiceImpl.class);
    @Resource
    private DictionaryUtil dictionaryUtil;
    @Resource
    private IntegralRuleMapper integralRuleMapper;
    @Resource
    private ShareResourceMapper shareResourceMapper;

    @Override
    public synchronized Integer getAndUpdateReadNum(String docId) {
        Integer num = 1;
        Object obj = this.hussarCacheManager.getObject("DOCVIEWNUM", "DOCVIEWNUM:" + docId);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            num = StringUtil.getInteger((Object)obj) + 1;
            this.hussarCacheManager.setObject("DOCVIEWNUM", "DOCVIEWNUM:" + docId, (Object)num);
        } else {
            num = this.docInfoService.getDocReadNum(docId) + 1;
            this.hussarCacheManager.setObject("DOCVIEWNUM", "DOCVIEWNUM:" + docId, (Object)num);
        }
        return num;
    }

    @Override
    public Integer getNum() {
        Integer num = 0;
        Object obj = this.hussarCacheManager.getObject("DOCTOTALCOUNT", "DOC_TOTAL_COUNT:");
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            num = StringUtil.getInteger((Object)obj);
        } else {
            num = this.fileStatisticsService.getFilesCount();
            this.hussarCacheManager.setObject("DOCTOTALCOUNT", "DOC_TOTAL_COUNT:", (Object)num);
        }
        return num;
    }

    @Override
    public Integer getReadNum(String docId) {
        Integer num = 0;
        Object obj = this.hussarCacheManager.getObject("DOCVIEWNUM", "DOCVIEWNUM:" + docId);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            num = StringUtil.getInteger((Object)obj);
        } else {
            num = this.docInfoService.getDocReadNum(docId);
            this.hussarCacheManager.setObject("DOCVIEWNUM", "DOCVIEWNUM:" + docId, (Object)num);
        }
        return num;
    }

    @Override
    public synchronized Integer getAndUpdateTopicReadNum(String topicId) {
        Integer num = 1;
        Object obj = this.hussarCacheManager.getObject("TOPICVIEWNUM", "TOPICVIEWNUM:" + topicId);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            num = StringUtil.getInteger((Object)obj) + 1;
            this.hussarCacheManager.setObject("TOPICVIEWNUM", "TOPICVIEWNUM:" + topicId, (Object)num);
        } else {
            num = this.docInfoService.getTopicReadNum(topicId) + 1;
            this.hussarCacheManager.setObject("TOPICVIEWNUM", "TOPICVIEWNUM:" + topicId, (Object)num);
        }
        return num;
    }

    @Override
    public Integer getTopicReadNum(String topicId) {
        Integer num = 0;
        Object obj = this.hussarCacheManager.getObject("TOPICVIEWNUM", "TOPICVIEWNUM:" + topicId);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            num = StringUtil.getInteger((Object)obj);
        } else {
            num = this.docInfoService.getTopicReadNum(topicId);
            this.hussarCacheManager.setObject("TOPICVIEWNUM", "TOPICVIEWNUM:" + topicId, (Object)num);
        }
        return num;
    }

    @Override
    public Double getDeptUsedSpace(String orgId) {
        Double usedSpace = 0.0;
        Object obj = this.hussarCacheManager.getObject("DEPTUSEDSPACE", "DEPTUSEDSPACE:" + orgId);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            usedSpace = StringUtil.getDouble((Object)obj);
        } else {
            usedSpace = this.deptStatisticsService.getUsedSpaceByOrganId(orgId);
            this.hussarCacheManager.setObject("DEPTUSEDSPACE", "DEPTUSEDSPACE:" + orgId, (Object)usedSpace);
        }
        return usedSpace;
    }

    @Override
    public void updateDeptUsedSpace(String orgId, Double usedSpace) {
        Object obj = this.hussarCacheManager.getObject("DEPTUSEDSPACE", "DEPTUSEDSPACE:" + orgId);
        Double newSpace = StringUtil.getDouble((Object)obj) + usedSpace;
        this.hussarCacheManager.setObject("DEPTUSEDSPACE", "DEPTUSEDSPACE:" + orgId, (Object)newSpace);
    }

    @Override
    public List<SpecialTopic> getTopicList() {
        List<Object> topicList = new ArrayList();
        Object obj = this.hussarCacheManager.getObject("TOPICDOCLIST", "TOPICDOCLIST:");
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            topicList = (List)obj;
        } else {
            topicList = this.frontTopicService.getTopicList(0, 5);
            String userId = UserInfoUtil.getUserInfo().get("ID").toString();
            List<String> listGroup = this.frontDocGroupService.getPremission(userId);
            if (topicList != null && topicList.size() > 0) {
                for (SpecialTopic specialTopic : topicList) {
                    String topicId = specialTopic.getTopicId();
                    String topicCover = null;
                    try {
                        topicCover = URLEncoder.encode(specialTopic.getTopicCover(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    specialTopic.setTopicCover(topicCover);
                    FsFolderParams fsFolderParams = new FsFolderParams();
                    fsFolderParams.setGroupList(listGroup);
                    fsFolderParams.setUserId(userId);
                    fsFolderParams.setType("2");
                    String levelCode = this.businessService.getLevelCodeByUserUpload(fsFolderParams);
                    List roleList = ShiroKit.getUser().getRolesList();
                    Integer adminFlag = CommonUtil.getAdminFlag((List)roleList);
                    String orgId = ShiroKit.getUser().getDeptName();
                    List docList = this.frontTopicService.getDocByTopicId(topicId, "create_time", 0, 4, userId, listGroup, levelCode, adminFlag, orgId);
                    specialTopic.setDocList(docList);
                }
            }
            this.hussarCacheManager.setObject("TOPICDOCLIST", "TOPICDOCLIST:", topicList);
        }
        return topicList;
    }

    @Override
    public List<Map> getHotDoc(Page<T> page, String opType) {
        List<Object> hotDocList = new ArrayList();
        Object obj = this.hussarCacheManager.getObject("HOTDOCLIST", "HOTDOCLIST:");
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            hotDocList = (List)obj;
        } else {
            hotDocList = this.fileStatisticsService.getFileListDataAllPerson(page, opType);
            this.hussarCacheManager.setObject("HOTDOCLIST", "HOTDOCLIST:", hotDocList);
        }
        return hotDocList;
    }

    @Override
    public List<Map> getUploadData(String type) {
        List<Object> uploadDataList = new ArrayList();
        Object obj = this.hussarCacheManager.getObject("UPLOADDATALIST", "UPLOADDATALIST:");
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            uploadDataList = (List)obj;
        } else {
            uploadDataList = this.fileStatisticsService.getUploadData(type);
            this.hussarCacheManager.setObject("UPLOADDATALIST", "UPLOADDATALIST:", uploadDataList);
        }
        return uploadDataList;
    }

    @Override
    public String getFileUpLevelCodeCache(String groupIds, String userId, String levelCode, String orgId, String type) {
        String fileUpLevelCode = "";
        if (levelCode.equals("001")) {
            Object obj = this.hussarCacheManager.getObject("FILELEVELCODE" + userId + type, "FILELEVELCODE:" + userId + type);
            if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
                fileUpLevelCode = (String)obj;
            } else {
                fileUpLevelCode = this.businessMapper.getFileUpLeveCode(groupIds, userId, levelCode, orgId, type);
                this.hussarCacheManager.setObject("FILELEVELCODE" + userId + type, "FILELEVELCODE:" + userId + type, (Object)fileUpLevelCode);
            }
        } else {
            fileUpLevelCode = this.businessMapper.getFileUpLeveCode(groupIds, userId, levelCode, orgId, type);
        }
        return fileUpLevelCode;
    }

    @Override
    public String getLevelCodeByUserCache(String groupIds, String userId, String type, String orgId) {
        String UserLevelCode = "";
        Object obj = this.hussarCacheManager.getObject("USERLEVELCODE" + userId + type, "USERLEVELCODE:" + userId + type);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            UserLevelCode = (String)obj;
        } else {
            try {
                UserLevelCode = this.businessMapper.getLevelCodeByUser(groupIds, userId, type, orgId);
                this.hussarCacheManager.setObject("USERLEVELCODE" + userId + type, "USERLEVELCODE:" + userId + type, (Object)UserLevelCode);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("" + ExceptionUtils.getErrorInfo((Exception)e));
            }
        }
        return UserLevelCode;
    }

    @Override
    public String getLevelCodeByUserByUploadCache(String groupIds, String userId, String type, String orgId) {
        String UserLevelCode = "";
        Object obj = this.hussarCacheManager.getObject("USERLEVELCODEUPLOAD" + userId + type, "USERLEVELCODEUPLOAD:" + userId + type);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            UserLevelCode = (String)obj;
        } else {
            UserLevelCode = this.businessMapper.getLevelCodeByUserByUpload(groupIds, userId, type, orgId);
            this.hussarCacheManager.setObject("USERLEVELCODEUPLOAD" + userId + type, "USERLEVELCODEUPLOAD:" + userId + type, (Object)UserLevelCode);
        }
        return UserLevelCode;
    }

    @Override
    public String getUpLevelCodeByUserCache(String groupIds, String userId, String type, String orgId) {
        String UpLevelCode = "";
        Object obj = this.hussarCacheManager.getObject("UPLEVELCODE" + userId + type, "UPLEVELCODE:" + userId + type);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            UpLevelCode = (String)obj;
        } else {
            UpLevelCode = this.businessMapper.getUpLevelCodeByUser(groupIds, userId, type, orgId);
            this.hussarCacheManager.setObject("UPLEVELCODE" + userId + type, "UPLEVELCODE:" + userId + type, (Object)UpLevelCode);
        }
        return UpLevelCode;
    }

    @Override
    public String getUpLevelCodeByUserByUploadCache(String groupIds, String userId, String type, String orgId) {
        String UpLevelCode = "";
        Object obj = this.hussarCacheManager.getObject("UPLEVELCODEUPLOAD" + userId + type, "UPLEVELCODEUPLOAD:" + userId + type);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            UpLevelCode = (String)obj;
        } else {
            UpLevelCode = this.businessMapper.getUpLevelCodeByUserByUpload(groupIds, userId, type, orgId);
            this.hussarCacheManager.setObject("UPLEVELCODEUPLOAD" + userId + type, "UPLEVELCODEUPLOAD:" + userId + type, (Object)UpLevelCode);
        }
        return UpLevelCode;
    }

    @Override
    public void updateLevelCodeCache(String userId) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{this.hussarCacheManager.getObject("UPLEVELCODE" + userId + "1", "UPLEVELCODE:" + userId + "1")})) {
            this.hussarCacheManager.delete("UPLEVELCODE" + userId + "1", "UPLEVELCODE:" + userId + "1");
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{this.hussarCacheManager.getObject("UPLEVELCODEUPLOAD" + userId + "1", "UPLEVELCODEUPLOAD:" + userId + "1")})) {
            this.hussarCacheManager.delete("UPLEVELCODEUPLOAD" + userId + "1", "UPLEVELCODEUPLOAD:" + userId + "1");
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{this.hussarCacheManager.getObject("FILELEVELCODE" + userId + "front", "FILELEVELCODE:" + userId + "front")})) {
            this.hussarCacheManager.delete("FILELEVELCODE" + userId + "front", "FILELEVELCODE:" + userId + "front");
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{this.hussarCacheManager.getObject("FILELEVELCODE" + userId + "", "FILELEVELCODE:" + userId + "")})) {
            this.hussarCacheManager.delete("FILELEVELCODE" + userId + "", "FILELEVELCODE:" + userId + "");
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{this.hussarCacheManager.getObject("USERLEVELCODE" + userId + "2", "USERLEVELCODE:" + userId + "2")})) {
            this.hussarCacheManager.delete("USERLEVELCODE" + userId + "2", "USERLEVELCODE:" + userId + "2");
        }
        if (ObjectUtils.allNotNull((Object[])new Object[]{this.hussarCacheManager.getObject("USERLEVELCODEUPLOAD" + userId + "2", "USERLEVELCODEUPLOAD:" + userId + "2")})) {
            this.hussarCacheManager.delete("USERLEVELCODEUPLOAD" + userId + "2", "USERLEVELCODEUPLOAD:" + userId + "2");
        }
    }

    @Override
    public List<Map<String, Object>> getDictListByType(String dicType) {
        List dicDataList = new ArrayList();
        Object obj = this.hussarCacheManager.getObject("DICDATALIST", "DICDATALIST" + dicType);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            dicDataList = (List)obj;
        } else {
            dicDataList = this.dictionaryUtil.getDictListByType(dicType);
            this.hussarCacheManager.setObject("DICDATALIST", "DICDATALIST" + dicType, dicDataList);
        }
        return dicDataList;
    }

    @Override
    public List<Map<String, Object>> getRuleByCode(String code) {
        List<Object> ruleCodeList = new ArrayList();
        Object obj = this.hussarCacheManager.getObject("RULECODELIST", "RULECODELIST" + code);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            ruleCodeList = (List)obj;
        } else {
            ruleCodeList = this.integralRuleMapper.getRuleByCode(code);
            this.hussarCacheManager.setObject("RULECODELIST", "RULECODELIST" + code, ruleCodeList);
        }
        return ruleCodeList;
    }

    @Override
    public Map getServerAddress() {
        Map serverAddress = new HashMap();
        Object obj = this.hussarCacheManager.getObject("SERVERADDRESS", "SERVERADDRESS");
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            serverAddress = (Map)obj;
        } else {
            serverAddress = this.shareResourceMapper.getServerAddress();
            this.hussarCacheManager.setObject("SERVERADDRESS", "SERVERADDRESS", serverAddress);
        }
        return serverAddress;
    }

    @Override
    public List<Map<String, String>> getReadyToChangePdf(String address) {
        ArrayList<Map<String, String>> readys = new ArrayList();
        Object obj = this.hussarCacheManager.getObject("READYTOPDFLIST", "READYTOPDFLIST" + address);
        if (!ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            return null;
        }
        readys = (List)obj;
        return readys;
    }

    @Override
    public void setReadyToChangePdf(Map<String, String> map, String address) {
        List<Map<String, String>> readys = new ArrayList<Map<String, String>>();
        Object obj = this.hussarCacheManager.getObject("READYTOPDFLIST", "READYTOPDFLIST" + address);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            readys = (List)obj;
        }
        readys.add(map);
        this.hussarCacheManager.setObject("READYTOPDFLIST", "READYTOPDFLIST" + address, readys);
    }

    @Override
    public void setReadyToChangePdf(List<Map<String, String>> readys, String address) {
        this.hussarCacheManager.setObject("READYTOPDFLIST", "READYTOPDFLIST" + address, readys);
    }

    @Override
    public void updateChangePdf(Map<String, String> uploadState, String address) {
        List<Map<String, String>> readys = new ArrayList<Map<String, String>>();
        Object obj = this.hussarCacheManager.getObject("READYTOPDFLIST", "READYTOPDFLIST" + address);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            readys = (List)obj;
            for (Map map : readys) {
                if (!((String)map.get("docId")).equals(uploadState.get("docId"))) continue;
                readys.set(readys.indexOf(map), uploadState);
            }
        } else {
            readys.add(uploadState);
        }
        this.hussarCacheManager.setObject("READYTOPDFLIST", "READYTOPDFLIST" + address, readys);
    }

    @Override
    public void removeFromChangePdfById(String docId, String address) {
        List readys = new ArrayList();
        Object obj = this.hussarCacheManager.getObject("READYTOPDFLIST", "READYTOPDFLIST" + address);
        readys = (List)obj;
        Map toRemove = null;
        if (readys != null) {
            for (Map map : readys) {
                if (!((String)map.get("docId")).equals(docId)) continue;
                toRemove = map;
            }
            if (null != toRemove) {
                readys.remove(toRemove);
            }
            this.hussarCacheManager.setObject("READYTOPDFLIST", "READYTOPDFLIST" + address, readys);
        }
    }

    @Override
    public List<Map<String, String>> getReadyToCreateEs(String address) {
        ArrayList<Map<String, String>> toEs = new ArrayList();
        Object obj = this.hussarCacheManager.getObject("READYTOESLIST", "READYTOESLIST" + address);
        if (!ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            return null;
        }
        toEs = (List)obj;
        return toEs;
    }

    @Override
    public void setReadyToCreateEs(List<Map<String, String>> toEsLists, String address) {
        this.hussarCacheManager.setObject("READYTOESLIST", "READYTOESLIST" + address, toEsLists);
    }

    @Override
    public void updateReadyToCreateEs(Map<String, String> uploadState, String address) {
        List<Map<String, String>> readys = new ArrayList<Map<String, String>>();
        Object obj = this.hussarCacheManager.getObject("READYTOESLIST", "READYTOESLIST" + address);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            readys = (List)obj;
            for (Map map : readys) {
                if (!((String)map.get("docId")).equals(uploadState.get("docId"))) continue;
                readys.set(readys.indexOf(map), uploadState);
            }
        } else {
            readys.add(uploadState);
        }
        this.hussarCacheManager.setObject("READYTOESLIST", "READYTOESLIST" + address, readys);
    }

    @Override
    public void setReadyToCreateEs(Map<String, String> map, String address) {
        List<Map<String, String>> readys = new ArrayList<Map<String, String>>();
        Object obj = this.hussarCacheManager.getObject("READYTOESLIST", "READYTOESLIST" + address);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            readys = (List)obj;
        }
        readys.add(map);
        this.hussarCacheManager.setObject("READYTOESLIST", "READYTOESLIST" + address, readys);
    }

    @Override
    public void removeFromCreateEsById(String docId, String address) {
        List readys = new ArrayList();
        Object obj = this.hussarCacheManager.getObject("READYTOESLIST", "READYTOESLIST" + address);
        readys = (List)obj;
        Map toRemove = null;
        for (Map map : readys) {
            if (!((String)map.get("docId")).equals(docId)) continue;
            toRemove = map;
        }
        if (null != toRemove) {
            readys.remove(toRemove);
        }
        this.hussarCacheManager.setObject("READYTOESLIST", "READYTOESLIST" + address, readys);
    }

    @Override
    public void setIsNullToChange(boolean flag) {
        this.hussarCacheManager.setObject("ISNULLTOCHANGE", "ISNULLTOCHANGE", (Object)flag);
    }

    @Override
    public boolean getIsNullToChange() {
        Object obj = this.hussarCacheManager.getObject("ISNULLTOCHANGE", "ISNULLTOCHANGE");
        if (!ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            return false;
        }
        boolean flag = (Boolean)obj;
        return flag;
    }

    @Override
    public void setFastDFSUsingFlag(boolean flag) {
        this.hussarCacheManager.setObject("FASTDFSUSINGFLAG", "FASTDFSUSINGFLAG", (Object)flag);
    }

    @Override
    public boolean getFastDFSUsingFlag() {
        Object obj = this.hussarCacheManager.getObject("FASTDFSUSINGFLAG", "FASTDFSUSINGFLAG");
        if (!ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            return false;
        }
        boolean flag = (Boolean)obj;
        return flag;
    }

    @Override
    public void setReadyDeleteList(Map<String, String> map, String address) {
        List<Map<String, String>> readys = new ArrayList<Map<String, String>>();
        Object obj = this.hussarCacheManager.getObject("READYDELETELIST", "READYDELETELIST" + address);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            readys = (List)obj;
        }
        readys.add(map);
        this.hussarCacheManager.setObject("READYDELETELIST", "READYDELETELIST" + address, readys);
    }

    @Override
    public void setReadyToFastChange(Map<String, String> map, String address) {
        List<Map<String, String>> readys = new ArrayList();
        Object obj = this.hussarCacheManager.getObject("FASTCHANGELIST", "FASTCHANGELIST" + address);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            readys = (List)obj;
        }
        if (!readys.contains(map)) {
            readys.add(map);
            this.hussarCacheManager.setObject("FASTCHANGELIST", "FASTCHANGELIST" + address, readys);
        }
    }

    @Override
    public List<Map<String, String>> getFastChangeList(String address) {
        ArrayList<Map<String, String>> fastChangeList = new ArrayList();
        Object obj = this.hussarCacheManager.getObject("FASTCHANGELIST", "FASTCHANGELIST" + address);
        if (!ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            return null;
        }
        fastChangeList = (List)obj;
        return fastChangeList;
    }

    @Override
    public void setReadyToFastChange(List<Map<String, String>> readys, String address) {
        this.hussarCacheManager.setObject("FASTCHANGELIST", "FASTCHANGELIST" + address, readys);
    }

    @Override
    public void removeFromFastChange(String docId, String address) {
        List readys = new ArrayList();
        Object obj = this.hussarCacheManager.getObject("FASTCHANGELIST", "FASTCHANGELIST" + address);
        readys = (List)obj;
        Map toRemove = null;
        for (Map map : readys) {
            if (!((String)map.get("docId")).equals(docId)) continue;
            toRemove = map;
        }
        if (null != toRemove) {
            readys.remove(toRemove);
        }
        this.hussarCacheManager.setObject("FASTCHANGELIST", "FASTCHANGELIST" + address, readys);
    }

    @Override
    public void updateFastChange(Map<String, String> uploadState, String address) {
        List<Map<String, String>> readys = new ArrayList<Map<String, String>>();
        Object obj = this.hussarCacheManager.getObject("FASTCHANGELIST", "FASTCHANGELIST" + address);
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            readys = (List)obj;
            for (Map map : readys) {
                if (!((String)map.get("docId")).equals(uploadState.get("docId"))) continue;
                readys.set(readys.indexOf(map), uploadState);
            }
        } else {
            readys.add(uploadState);
        }
        this.hussarCacheManager.setObject("FASTCHANGELIST", "FASTCHANGELIST" + address, readys);
    }

    @Override
    public void setUploadState(Map<String, String> uploadState) {
        List<Map<String, String>> readys = new ArrayList<Map<String, String>>();
        Object obj = this.hussarCacheManager.getObject("UPLOADSTATELIST", "UPLOADSTATELIST");
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            readys = (List)obj;
        }
        readys.add(uploadState);
        this.hussarCacheManager.setObject("UPLOADSTATELIST", "UPLOADSTATELIST", readys);
    }

    @Override
    public void updateUploadState(Map<String, String> uploadState) {
        List<Map<String, String>> readys = new ArrayList<Map<String, String>>();
        Object obj = this.hussarCacheManager.getObject("UPLOADSTATELIST", "UPLOADSTATELIST");
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            readys = (List)obj;
            for (Map map : readys) {
                if (!((String)map.get("docId")).equals(uploadState.get("docId"))) continue;
                readys.set(readys.indexOf(map), uploadState);
            }
        } else {
            readys.add(uploadState);
        }
        this.hussarCacheManager.setObject("UPLOADSTATELIST", "UPLOADSTATELIST", readys);
    }

    @Override
    public List<Map<String, String>> getUploadStateList() {
        ArrayList<Map<String, String>> fastChangeList = new ArrayList();
        Object obj = this.hussarCacheManager.getObject("UPLOADSTATELIST", "UPLOADSTATELIST");
        if (!ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            return null;
        }
        fastChangeList = (List)obj;
        return fastChangeList;
    }

    @Override
    public void removeFromUploadStateListById(String docId) {
        List readys = new ArrayList();
        Object obj = this.hussarCacheManager.getObject("UPLOADSTATELIST", "UPLOADSTATELIST");
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            readys = (List)obj;
            Map toRemove = null;
            for (Map map : readys) {
                if (!((String)map.get("docId")).equals(docId)) continue;
                toRemove = map;
            }
            if (null != toRemove) {
                readys.remove(toRemove);
            }
            this.hussarCacheManager.setObject("UPLOADSTATELIST", "UPLOADSTATELIST", readys);
        }
    }

    @Override
    public void setPdfFileDir(String path) {
        this.hussarCacheManager.setObject("PDFPATHDIR", "PDFPATHDIR", (Object)path);
    }

    @Override
    public String getPdfFileDir() {
        String dir = "";
        Object obj = this.hussarCacheManager.getObject("PDFPATHDIR", "PDFPATHDIR");
        if (!ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            return null;
        }
        dir = (String)obj;
        return dir;
    }

    @Override
    public void setPdfKeyFileDir(String path) {
        this.hussarCacheManager.setObject("PDFKEYPATHDIR", "PDFKEYPATHDIR", (Object)path);
    }

    @Override
    public String getPdfKeyFileDir() {
        String dir = "";
        Object obj = this.hussarCacheManager.getObject("PDFKEYPATHDIR", "PDFKEYPATHDIR");
        if (!ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            return null;
        }
        dir = (String)obj;
        return dir;
    }
}

